/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.card;

import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.target.card.domain.CardRuntimeDomain;
import com.kingdee.bos.qing.publish.target.card.exception.CardException;
import com.kingdee.bos.qing.publish.target.card.model.CardVO;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schema.exception.NoDefaultSchemeDefined;
import com.kingdee.bos.qing.schema.model.SchemaContentVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CardRuntimeService
implements IQingContextable,
IDBAccessable {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private CardRuntimeDomain cardRuntimeDomain;
    private CommonPublishDomain commonPublishDomain;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private CardRuntimeDomain getCardRuntimeDomain() {
        if (this.cardRuntimeDomain == null) {
            this.cardRuntimeDomain = new CardRuntimeDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.cardRuntimeDomain;
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    public byte[] loadSquareSchema(Map<String, String> params) {
        String publishId = params.get("publishId");
        String bizTag = params.get("bizTag");
        String schemaAdditionalTag = params.get("schemaAdditionalTag");
        try {
            SchemaContentVO vo = this.getCardRuntimeDomain().loadSquareSchema(publishId, bizTag, schemaAdditionalTag);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)vo));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadSquareSchemaWithOper(Map<String, String> params) {
        String publishId = params.get("publishId");
        String bizTag = params.get("bizTag");
        String schemaAdditionalTag = params.get("schemaAdditionalTag");
        try {
            SchemaContentVO vo = this.getCardRuntimeDomain().loadSquareSchema(publishId, bizTag, schemaAdditionalTag);
            HashMap<String, Object> result = new HashMap<String, Object>(4);
            result.put("schemaContentVo", vo);
            result.put("operation", this.getCommonPublishDomain().loadPublishOperList(publishId, null, true, false));
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(result));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadDefaultSquareSchema(Map<String, String> params) {
        String bizTagId = params.get("bizTagId");
        try {
            SchemaContentVO vo = this.getCardRuntimeDomain().loadDefaultSchemaContent(bizTagId, this.qingContext.getUserId(), 1);
            if (null != vo) {
                return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)vo));
            }
            throw new NoDefaultSchemeDefined("no default subject found");
        }
        catch (AbstractQingException e) {
            return ResponseUtil.output((Exception)((Object)e));
        }
    }

    public byte[] loadCardInfo(Map<String, String> params) {
        String publishId = params.get("publishId");
        try {
            Map<String, String> cardInfo = this.getCardRuntimeDomain().loadCardInfo(publishId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(cardInfo));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadCardInfoByName(Map<String, String> params) {
        String cardName = params.get("cardName");
        HashMap<String, String> nameIdPair = new HashMap<String, String>();
        List<Object> cardVOs = new ArrayList();
        try {
            cardVOs = this.getCardRuntimeDomain().loadAllPermCardBaseInfoByCardName(cardName);
            for (CardVO cardVO : cardVOs) {
                nameIdPair.put(cardVO.getId(), cardVO.getName());
            }
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(nameIdPair));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public void removeCardFromHomepage(Map<String, String> params) throws CardException {
        String userId = this.qingContext.getUserId();
        this.getCardRuntimeDomain().removeCardFromHomepage(userId, params);
    }

    public byte[] resetCustomSquare(Map<String, String> params) {
        String bizTag = params.get("bizTag");
        try {
            this.getCardRuntimeDomain().resetCustomSquare(bizTag);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

