/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.email.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.brief.WarningRuleDefinition;
import com.kingdee.bos.qing.exceptionlog.dao.ExceptionLogDao;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLogBizTypeEnum;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.domain.PublishSourceDomainFactory;
import com.kingdee.bos.qing.publish.exception.MismatchSourceTypeException;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishNoPermissionException;
import com.kingdee.bos.qing.publish.exception.PublishSourcePublishNotExistException;
import com.kingdee.bos.qing.publish.model.OperCodeEnum;
import com.kingdee.bos.qing.publish.model.PublishOperModelVO;
import com.kingdee.bos.qing.publish.model.PublishOperPermissionsPO;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PushRecordConfig;
import com.kingdee.bos.qing.publish.model.PushRecordSavingStrategy;
import com.kingdee.bos.qing.publish.model.SceneType;
import com.kingdee.bos.qing.publish.model.TimeUnit;
import com.kingdee.bos.qing.publish.oplog.PublishOpLog;
import com.kingdee.bos.qing.publish.target.email.dao.EmailSchemaContentDao;
import com.kingdee.bos.qing.publish.target.email.dao.EmailSenderDao;
import com.kingdee.bos.qing.publish.target.email.domain.AbstractEmailConfigDomain;
import com.kingdee.bos.qing.publish.target.email.exception.EmailException;
import com.kingdee.bos.qing.publish.target.email.exception.EmailUpdateScheduleSwitchException;
import com.kingdee.bos.qing.publish.target.email.exception.NotFoundEmailConfigException;
import com.kingdee.bos.qing.publish.target.email.model.EmailConfig;
import com.kingdee.bos.qing.publish.target.email.model.EmailSendLog;
import com.kingdee.bos.qing.publish.target.email.model.EmailSenderVO;
import com.kingdee.bos.qing.publish.target.email.source.AbstractQingModelSchemaConfigSourceDomain;
import com.kingdee.bos.qing.publish.target.email.source.IEmailConfigSourceDomain;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import com.kingdee.bos.qing.schedule.exception.ScheduleModelParseException;
import com.kingdee.bos.qing.schedule.model.AbstractJobParam;
import com.kingdee.bos.qing.schedule.model.Schedule;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.jdom2.JDOMException;

public class EmailConfigManageDomain
extends AbstractEmailConfigDomain {
    private EmailSenderDao emailSenderDao;
    private ExceptionLogDao exceptionLogDao;
    private CommonPublishDomain commonPublishDomain;
    private EmailSchemaContentDao emailSchemaContentDao;
    private static ScheduledFuture<?> scheduleWithFixedDelay = null;
    private static final int DELAY_SUBMIT_TIME = 1;

    public EmailConfigManageDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    private EmailSenderDao getEmailSenderDao() {
        if (this.emailSenderDao == null) {
            this.emailSenderDao = new EmailSenderDao(this.dbExcuter);
        }
        return this.emailSenderDao;
    }

    private ExceptionLogDao getExceptionLogDao() {
        if (this.exceptionLogDao == null) {
            this.exceptionLogDao = new ExceptionLogDao(this.dbExcuter);
        }
        return this.exceptionLogDao;
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    private EmailSchemaContentDao getEmailSchemaContentDao() {
        if (this.emailSchemaContentDao == null) {
            this.emailSchemaContentDao = new EmailSchemaContentDao(this.dbExcuter);
        }
        return this.emailSchemaContentDao;
    }

    public void saveEmailConfig(String tag, EmailConfig emailConfig, String sceneModelJson, String publishedRuntimeUrl, String dsbPublishId, String scene) throws AbstractQingIntegratedException, PublishException {
        if (emailConfig.getTagId() != null && PublishUtil.isPublish((String)emailConfig.getTagId())) {
            try {
                if (SceneType.Longer.name().equals(scene)) {
                    this.getCommonPublishDomain().judgePublishOperAuth(emailConfig.getTagId(), dsbPublishId, OperCodeEnum.analysis_timepush);
                }
                if (SceneType.Square.name().equals(scene)) {
                    this.getCommonPublishDomain().judgePublishOperAuth(emailConfig.getTagId(), dsbPublishId, OperCodeEnum.card_timepush);
                }
            }
            catch (SQLException e) {
                throw new EmailException(e);
            }
        }
        try {
            EmailSenderVO e = this.getEmailSenderDao().getEmailSenderById(emailConfig.getSenderId(), this.qingContext.getUserId());
        }
        catch (SQLException e) {
            throw new EmailException(e);
        }
        try {
            this.tx.beginRequired();
            String id = this.getEmailConfigDao().createEmailConfPKId();
            emailConfig.setId(id);
            IEmailConfigSourceDomain emailConfigSourceDomain = this.getSourceDomain(emailConfig.getPublishSourceType());
            emailConfigSourceDomain.insert(tag, emailConfig, sceneModelJson);
            this.getEmailConfigDao().insert(emailConfig);
            if (emailConfig.getNoOperValueMap() != null && emailConfig.getNoOperValueMap().size() > 0) {
                this.getEmailConfigDao().insertUserSetPermissionInfo(emailConfig);
            }
            this.adjustScheduleRelate(emailConfig, publishedRuntimeUrl, false);
        }
        catch (ScheduleEngineException e) {
            this.tx.markRollback();
            throw new EmailException(e);
        }
        catch (ScheduleModelParseException e) {
            this.tx.markRollback();
            throw new EmailException(e);
        }
        catch (IOException e) {
            this.tx.markRollback();
            throw new EmailException(e);
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new EmailException(e);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishNoPermissionException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishSourcePublishNotExistException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(emailConfig.getNameRule().getName());
        PublishOpLog emptyDir = PublishOpLog.EMPTY_DIR;
        emptyDir.setLogScene("\u90ae\u4ef6\u5b9a\u65f6\u63a8\u9001\u914d\u7f6e");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.NEW, (IOpLogConstant)emptyDir, params));
    }

    public void deleteEmailConfigById(String id) throws AbstractQingIntegratedException, EmailException {
        EmailConfig emailConfig;
        try {
            this.tx.beginRequired();
            emailConfig = this.getEmailConfigDao().getEmailConfigById(id);
            if (emailConfig != null) {
                IEmailConfigSourceDomain emailConfigSourceDomain = this.getSourceDomain(emailConfig.getPublishSourceType());
                emailConfigSourceDomain.delete(id);
                this.getEmailConfigDao().deleteEmailConfigById(id);
                List<EmailSendLog> list = this.getEmailConfigDao().loadPublishInfos(id);
                for (EmailSendLog emailSendLog : list) {
                    this.deletePublishInfoNoTx(emailSendLog.getPublishId());
                    this.getExceptionLogDao().delete(emailSendLog.getId(), ExceptionLogBizTypeEnum.EMAIL_TIMING_PUSH);
                }
                this.getEmailConfigDao().deleteSendEmailsLogByConfigId(id);
                Schedule schedule = emailConfig.getSchedule();
                if (emailConfig.getScheduleSwitch() && schedule != null && schedule.getPeriod() != null) {
                    this.scheduleEngine.deleteJob(this.qingContext, null, id);
                }
                this.getEmailConfigDao().deleteUserSetPermissionInfo(emailConfig);
            }
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new EmailException(e);
        }
        catch (ScheduleEngineException e) {
            this.tx.markRollback();
            throw new EmailException(e);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishException e) {
            this.tx.markRollback();
            throw new EmailException(e);
        }
        finally {
            this.tx.end();
        }
        if (emailConfig != null) {
            ArrayList<String> params = new ArrayList<String>(1);
            params.add(emailConfig.getNameRule().getName());
            PublishOpLog emptyDir = PublishOpLog.EMPTY_DIR;
            emptyDir.setLogScene("\u90ae\u4ef6\u5b9a\u65f6\u63a8\u9001\u914d\u7f6e");
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.DELETE, (IOpLogConstant)emptyDir, params));
        }
    }

    public EmailConfig checkEmailConfigsExist(String configID) throws AbstractQingIntegratedException, SQLException, NotFoundEmailConfigException {
        EmailConfig emailConfigById = this.getEmailConfigDao().getEmailConfigById(configID);
        if (null == emailConfigById || null == emailConfigById.getId()) {
            throw new NotFoundEmailConfigException();
        }
        return emailConfigById;
    }

    public List<EmailConfig> loadEmailConfigs() throws AbstractQingIntegratedException, EmailException {
        try {
            Map<String, Map<String, Integer>> cancelPermissionInfo;
            List<EmailConfig> emailConfigList = this.getEmailConfigDao().loadEmailConfigs();
            if (emailConfigList.size() > 0 && (cancelPermissionInfo = this.getEmailConfigDao().loadCancelPermissionInfo(emailConfigList)).size() > 0) {
                for (int i = 0; i < emailConfigList.size(); ++i) {
                    EmailConfig emailConfig = emailConfigList.get(i);
                    emailConfig.setNoOperValueMap(cancelPermissionInfo.get(emailConfig.getId()));
                }
            }
            for (EmailConfig emailConfigVO : emailConfigList) {
                List<EmailSendLog> emailSendLogList = this.loadPublishInfos(emailConfigVO.getId());
                this.setEachPushDetailFileSize(emailConfigVO, emailSendLogList);
                String bizTag = emailConfigVO.getTagId();
                if (PublishUtil.isPublish((String)bizTag)) {
                    PublishPO originalPublishInfo = this.loadPublishInfo(bizTag);
                    if (originalPublishInfo != null) {
                        bizTag = originalPublishInfo.getTagId();
                        try {
                            this.checkRightAndReturnIsAnonymous(originalPublishInfo);
                        }
                        catch (PublishNoPermissionException e) {
                            this.updateAndSetToNoPermission(emailConfigVO);
                        }
                    } else {
                        this.updateAndSetToNoPermission(emailConfigVO);
                        continue;
                    }
                }
                String sourceName = PublishSourceDomainFactory.getPublishSourceName((QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (String)bizTag, (PublishSourceEnum)emailConfigVO.getPublishSourceType());
                emailConfigVO.setPublishSourceName(sourceName);
                String sourGroupName = PublishSourceDomainFactory.getPublishSourceGroupName((QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (String)bizTag, (PublishSourceEnum)emailConfigVO.getPublishSourceType());
                emailConfigVO.setPublishSourceGroupName(sourGroupName);
                if (!StringUtils.isBlank((CharSequence)sourceName)) continue;
                this.updateAndSetToNoPermission(emailConfigVO);
                emailConfigVO.setSourceNameNotFound(true);
            }
            return emailConfigList;
        }
        catch (SQLException e) {
            throw new EmailException(e);
        }
        catch (MismatchSourceTypeException e) {
            throw new EmailException(e);
        }
    }

    public static boolean checkWarningRuleStatus(EmailConfig emailConfigVO, ModelBook currentModelBook) {
        boolean warningRuleStatus = true;
        try {
            if (null == emailConfigVO || StringUtils.isEmpty((CharSequence)emailConfigVO.getWarningRuleName())) {
                return warningRuleStatus;
            }
            ModelBook modelBook = currentModelBook;
            if (null == modelBook) {
                return warningRuleStatus;
            }
            IQingModel model = ((ModelBook.ModelPage)modelBook.getPages().get(0)).getModel();
            List warningRuleDefinitions = model.getWarningRuleDefinitions();
            ArrayList<String> warningRuleNames = new ArrayList<String>(10);
            if (CollectionUtils.isNotEmpty((Collection)warningRuleDefinitions)) {
                for (int i = 0; i < warningRuleDefinitions.size(); ++i) {
                    warningRuleNames.add(((WarningRuleDefinition)warningRuleDefinitions.get(i)).getName());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)emailConfigVO.getWarningRuleName()) && !warningRuleNames.contains(emailConfigVO.getWarningRuleName())) {
                warningRuleStatus = false;
            }
            return warningRuleStatus;
        }
        catch (Exception e) {
            LogUtil.error((String)"execute failed when checkWarningRuleInvalid", (Throwable)e);
            return warningRuleStatus;
        }
    }

    private void setEachPushDetailFileSize(EmailConfig emailConfig, List<EmailSendLog> emailSendLogList) throws AbstractQingIntegratedException, SQLException {
        if (emailSendLogList != null && emailSendLogList.size() > 0) {
            long sumFileSize = 0L;
            for (int i = 0; i < emailSendLogList.size(); ++i) {
                BigDecimal bigDecimal;
                EmailSendLog emailSendLog = emailSendLogList.get(i);
                String fileSize = emailSendLog.getFileSize();
                double fileSizeVal = Double.parseDouble(fileSize.substring(0, fileSize.length() - 2));
                String fileSizeUnit = fileSize.substring(fileSize.length() - 2, fileSize.length());
                if ("MB".equals(fileSizeUnit)) {
                    sumFileSize = (long)((double)sumFileSize + fileSizeVal * 1024.0 * 1024.0);
                } else if ("KB".equals(fileSizeUnit)) {
                    sumFileSize = (long)((double)sumFileSize + fileSizeVal * 1024.0);
                }
                if (sumFileSize <= 0x100000L) {
                    bigDecimal = new BigDecimal(sumFileSize).divide(new BigDecimal(1024), 2, 4);
                    emailConfig.setTotalPushRecordSize((sumFileSize == 0L ? Long.valueOf(sumFileSize) : bigDecimal) + "KB");
                    continue;
                }
                bigDecimal = new BigDecimal(sumFileSize).divide(new BigDecimal(0x100000), 2, 4);
                emailConfig.setTotalPushRecordSize(bigDecimal + "MB");
            }
        } else {
            emailConfig.setTotalPushRecordSize("0KB");
        }
    }

    private void updateAndSetToNoPermission(EmailConfig emailConfigVO) throws AbstractQingIntegratedException, SQLException, EmailException {
        try {
            if (emailConfigVO.getScheduleSwitch()) {
                this.closeSchedule(emailConfigVO.getId());
                emailConfigVO.setScheduleSwitch(false);
            }
            emailConfigVO.setHasPermission(false);
        }
        catch (ScheduleEngineException e) {
            throw new EmailException(e);
        }
    }

    public List<EmailSendLog> loadPublishInfos(String configId) throws AbstractQingIntegratedException, EmailException {
        try {
            List<EmailSendLog> emailSendLogList = this.getEmailConfigDao().loadPublishInfos(configId);
            if (emailSendLogList != null && emailSendLogList.size() > 0) {
                Map<String, Long> fileSizeMap = this.getEmailConfigDao().loadQingFileSizeByPublishId(emailSendLogList);
                for (int i = 0; i < emailSendLogList.size(); ++i) {
                    EmailSendLog emailSendLog = emailSendLogList.get(i);
                    if (!emailSendLog.getPublishId().isEmpty() && emailSendLog.getPublishId() != null) {
                        BigDecimal bigDecimal;
                        Long fileSize;
                        Long l = fileSize = fileSizeMap.get(emailSendLog.getPublishId()) == null ? Long.valueOf(0L) : fileSizeMap.get(emailSendLog.getPublishId());
                        if (fileSize <= 0x100000L) {
                            bigDecimal = new BigDecimal(fileSize).divide(new BigDecimal(1024), 2, 4);
                            emailSendLog.setFileSize((bigDecimal == null ? Integer.valueOf(0) : bigDecimal) + "KB");
                            continue;
                        }
                        bigDecimal = new BigDecimal(fileSize).divide(new BigDecimal(0x100000), 2, 4);
                        emailSendLog.setFileSize(bigDecimal + "MB");
                        continue;
                    }
                    emailSendLog.setFileSize("0KB");
                }
            }
            return emailSendLogList;
        }
        catch (SQLException e) {
            throw new EmailException(e);
        }
    }

    public void deleteEmailPublishInfoById(List<EmailSendLog> emailSendLogList) throws PublishException, AbstractQingIntegratedException, SQLException {
        try {
            this.tx.beginRequired();
            ArrayList<String> emailSendLogIdList = new ArrayList<String>(emailSendLogList.size());
            ArrayList<String> publishIdList = new ArrayList<String>(emailSendLogList.size());
            ArrayList<String> emailSendFailIdList = new ArrayList<String>(emailSendLogList.size());
            for (int i = 0; i < emailSendLogList.size(); ++i) {
                String id = emailSendLogList.get(i).getId();
                emailSendLogIdList.add(id);
                String publishId = emailSendLogList.get(i).getPublishId();
                if (StringUtils.isNotBlank((CharSequence)publishId)) {
                    publishIdList.add(publishId);
                }
                if (emailSendLogList.get(i).getSendEmailsStatus() != 0) continue;
                emailSendFailIdList.add(id);
            }
            if (emailSendLogIdList.size() > 0) {
                this.getEmailConfigDao().deleteSendEmailsLogById(emailSendLogIdList);
            }
            if (emailSendFailIdList.size() > 0) {
                for (String emailSendFailId : emailSendFailIdList) {
                    this.getExceptionLogDao().delete(emailSendFailId, ExceptionLogBizTypeEnum.EMAIL_TIMING_PUSH);
                }
            }
            if (publishIdList.size() > 0) {
                for (String publishId : publishIdList) {
                    this.deletePublishInfoNoTx(publishId);
                }
            }
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new EmailException(e);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishException e) {
            this.tx.markRollback();
            throw new EmailException(e);
        }
        finally {
            this.tx.end();
        }
        this.addLog(emailSendLogList);
    }

    public void addLog(List<EmailSendLog> emailSendLogList) throws NotFoundEmailConfigException, AbstractQingIntegratedException, SQLException {
        for (int i = 0; i < emailSendLogList.size(); ++i) {
            EmailSendLog emailSendLog = emailSendLogList.get(i);
            EmailConfig emailConfig = this.getEmailConfigDao().getEmailConfigById(emailSendLog.getConfigId());
            if (emailConfig == null) {
                throw new NotFoundEmailConfigException();
            }
            ArrayList<String> params = new ArrayList<String>(2);
            params.add(emailSendLog.getName());
            params.add(emailConfig.getNameRule().getName());
            PublishOpLog emailPushLogDir = PublishOpLog.EMAIL_PUSH_LOG_DIR;
            emailPushLogDir.setLogScene("\u90ae\u4ef6\u63a8\u9001\u660e\u7ec6");
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.DELETE, (IOpLogConstant)emailPushLogDir, params));
        }
    }

    public void updateEmailConfig(EmailConfig emailConfig, String publishedRuntimeUrl) throws AbstractQingException, JDOMException {
        EmailConfig oldEmailConfig;
        try {
            this.tx.beginRequired();
            ModelBook modelBook = this.loadEmailPushSchema(emailConfig.getId(), emailConfig.getPublishSourceType().toString());
            boolean warningRuleStatus = EmailConfigManageDomain.checkWarningRuleStatus(emailConfig, modelBook);
            emailConfig.setWarningRuleStatus(warningRuleStatus);
            oldEmailConfig = this.getEmailConfigDao().getEmailConfigById(emailConfig.getId());
            this.getEmailConfigDao().update(emailConfig);
            this.getEmailConfigDao().deleteUserSetPermissionInfo(emailConfig);
            if (emailConfig.getNoOperValueMap().size() > 0) {
                this.getEmailConfigDao().insertUserSetPermissionInfo(emailConfig);
            }
            this.adjustScheduleRelate(emailConfig, publishedRuntimeUrl, true);
        }
        catch (ScheduleEngineException e) {
            this.tx.markRollback();
            throw new EmailException(e);
        }
        catch (ScheduleModelParseException e) {
            this.tx.markRollback();
            throw new EmailException(e);
        }
        catch (IOException e) {
            this.tx.markRollback();
            throw new EmailException(e);
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new EmailException(e);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishNoPermissionException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishSourcePublishNotExistException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (AbstractQingException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (JDOMException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
        if (oldEmailConfig != null) {
            ArrayList<String> params = new ArrayList<String>(2);
            PublishOpLog emptyDir = PublishOpLog.EMPTY_DIR;
            emptyDir.setLogScene("\u90ae\u4ef6\u5b9a\u65f6\u63a8\u9001\u914d\u7f6e");
            if (!oldEmailConfig.getNameRule().getName().equals(emailConfig.getNameRule().getName())) {
                emptyDir.setParamsDesc("\u201c$param\u201d\u7684\u540d\u79f0\u4e3a\u201c$param\u201d");
                params.add(oldEmailConfig.getNameRule().getName());
                params.add(emailConfig.getNameRule().getName());
            } else {
                emptyDir.setParamsDesc("\u201c$param\u201d\u7684\u4fe1\u606f");
                params.add(emailConfig.getNameRule().getName());
            }
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EDIT, (IOpLogConstant)emptyDir, params));
        }
    }

    public void updateEmailPushSchema(String configId, String publishSource, String jsonModel) throws MismatchSourceTypeException, AbstractQingIntegratedException, SQLException, NotFoundEmailConfigException, ScheduleEngineException {
        IEmailConfigSourceDomain emailConfigSourceDomain = this.getSourceDomain(PublishSourceEnum.valueOf((String)publishSource));
        if (emailConfigSourceDomain instanceof AbstractQingModelSchemaConfigSourceDomain) {
            ((AbstractQingModelSchemaConfigSourceDomain)emailConfigSourceDomain).updateSchema(configId, jsonModel, this.scheduleEngine);
            try {
                EmailConfig emailConfig = this.getEmailConfigDao().getEmailConfigById(configId);
                if (emailConfig != null) {
                    ArrayList<String> params = new ArrayList<String>(1);
                    params.add(emailConfig.getNameRule().getName());
                    PublishOpLog emptyDir = PublishOpLog.EMPTY_DIR;
                    emptyDir.setLogScene("\u90ae\u4ef6\u5b9a\u65f6\u63a8\u9001\u914d\u7f6e");
                    emptyDir.setParamsDesc("\u201c$param\u201d\u7684\u63a8\u9001\u65b9\u6848");
                    OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EDIT, (IOpLogConstant)emptyDir, params));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ModelBook loadEmailPushSchema(String configId, String publishSource) throws SQLException, AbstractQingException, JDOMException, IOException {
        IEmailConfigSourceDomain emailConfigSourceDomain = this.getSourceDomain(PublishSourceEnum.valueOf((String)publishSource));
        if (emailConfigSourceDomain instanceof AbstractQingModelSchemaConfigSourceDomain) {
            return ((AbstractQingModelSchemaConfigSourceDomain)emailConfigSourceDomain).loadSchema(configId);
        }
        return null;
    }

    private void checkPermission(String bizTag) throws AbstractQingIntegratedException, SQLException, PublishNoPermissionException, PublishSourcePublishNotExistException {
        if (PublishUtil.isPublish((String)bizTag)) {
            PublishPO originalPublishInfo = this.loadPublishInfo(bizTag);
            if (originalPublishInfo != null) {
                this.checkRightAndReturnIsAnonymous(originalPublishInfo);
            } else {
                throw new PublishSourcePublishNotExistException();
            }
        }
    }

    public void updateScheduleState(boolean scheduleSwitch, String configId, String publishedRuntimeUrl) throws AbstractQingIntegratedException, EmailUpdateScheduleSwitchException, PublishNoPermissionException, PublishSourcePublishNotExistException {
        try {
            this.tx.beginRequired();
            this.getEmailConfigDao().updateScheduleSwitch(configId, scheduleSwitch);
            if (scheduleSwitch) {
                EmailConfig emailConfig = this.getEmailConfigDao().getEmailConfigById(configId);
                this.adjustScheduleRelate(emailConfig, publishedRuntimeUrl, true);
            } else {
                this.scheduleEngine.deleteJob(this.qingContext, null, configId);
            }
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new EmailUpdateScheduleSwitchException(e);
        }
        catch (ScheduleEngineException e) {
            this.tx.markRollback();
            throw new EmailUpdateScheduleSwitchException(e);
        }
        catch (ScheduleModelParseException e) {
            this.tx.markRollback();
            throw new EmailUpdateScheduleSwitchException(e);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishNoPermissionException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishSourcePublishNotExistException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public boolean isMyOwnConfig(String configId) throws AbstractQingIntegratedException, SQLException {
        boolean myOwnConfig = false;
        String userId = this.qingContext.getUserId();
        EmailConfig emailConfig = this.getEmailConfigDao().getEmailConfigById(configId);
        if (emailConfig != null && userId.equals(emailConfig.getUserId())) {
            myOwnConfig = true;
        }
        return myOwnConfig;
    }

    private void adjustScheduleRelate(EmailConfig emailConfig, String publishedRuntimeUrl, boolean isUpdate) throws AbstractQingIntegratedException, ScheduleEngineException, ScheduleModelParseException, PublishNoPermissionException, SQLException, PublishSourcePublishNotExistException {
        if (emailConfig.getScheduleSwitch() && isUpdate) {
            this.scheduleEngine.deleteJob(this.qingContext, null, emailConfig.getId());
        }
        Schedule schedule = emailConfig.getSchedule();
        if (emailConfig.getScheduleSwitch() && schedule != null && schedule.getPeriod() != null) {
            this.checkPermission(emailConfig.getTagId());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("JobType", "emailPublishExecute");
            params.put("pkId", emailConfig.getId());
            params.put("sourceName", emailConfig.getNameRule().getName());
            params.put("sourceId", emailConfig.getId());
            params.put("publishedRuntimeUrl", publishedRuntimeUrl);
            AbstractJobParam jobParams = this.scheduleEngine.createJobParam(params);
            this.scheduleEngine.saveJob(this.qingContext, this.qingContext.getUserId(), this.qingContext.getSystemVarStringValue(SystemVarType.ORG_ID), this.qingContext.getTenantId(), emailConfig.getNameRule().getName(), schedule, jobParams);
        }
    }

    public List<EmailConfig> loadEmailConfigsByBizId(String bizId, String userId) throws AbstractQingIntegratedException, SQLException {
        return this.getEmailConfigDao().loadEmailConfigsByBizId(bizId, userId);
    }

    public PushRecordConfig loadPushRecordConfigInfo(String userId, int pushTargetType) throws AbstractQingIntegratedException, SQLException {
        return this.getEmailConfigDao().loadPushRecordConfigInfo(userId, pushTargetType);
    }

    public void saveEmailPushRecordConfig(PushRecordConfig emailPushRecordConfig) throws SQLException, AbstractQingIntegratedException, PublishException {
        try {
            this.tx.beginRequired();
            PushRecordConfig existEmailStorageSetVO = this.getEmailConfigDao().loadPushRecordConfigInfo(emailPushRecordConfig.getUserId(), emailPushRecordConfig.getPushTargetType());
            if (existEmailStorageSetVO != null) {
                if (PushRecordSavingStrategy.all.toString().equals(emailPushRecordConfig.getStrategy())) {
                    this.getEmailConfigDao().deleteEmailPushRecordConfig(emailPushRecordConfig);
                } else {
                    this.getEmailConfigDao().updateEmailPushRecordConfig(emailPushRecordConfig);
                }
            } else {
                emailPushRecordConfig.setId(this.getEmailConfigDao().createEmailPushRecordPKId());
                this.getEmailConfigDao().saveEmailPushRecordConfig(emailPushRecordConfig);
            }
            this.deletePushRecordByConfigInfo(emailPushRecordConfig, null);
            if (PushRecordSavingStrategy.time.toString().equals(emailPushRecordConfig.getStrategy())) {
                scheduleWithFixedDelay = ThreadPoolManage.scheduleAtFixRate((Runnable)new TimedClearUpTaskRunner(emailPushRecordConfig), (long)1L, (long)1L, (java.util.concurrent.TimeUnit)java.util.concurrent.TimeUnit.DAYS);
            } else if (scheduleWithFixedDelay != null) {
                scheduleWithFixedDelay.cancel(true);
            }
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public void deletePushRecordByConfigInfo(PushRecordConfig emailPushRecordConfig, String configId) throws AbstractQingIntegratedException, SQLException, PublishException {
        List<EmailConfig> emailConfigList = configId == null ? this.getEmailConfigDao().loadEmailConfigs() : this.getEmailConfigDao().loadEmailConfigsByConfigId(configId, emailPushRecordConfig.getUserId());
        ArrayList<EmailSendLog> delEmailSendLogList = new ArrayList<EmailSendLog>(20);
        if (PushRecordSavingStrategy.time.toString().equals(emailPushRecordConfig.getStrategy())) {
            String setValue = emailPushRecordConfig.getValue();
            String[] values = setValue.split(",");
            int value = Integer.parseInt(values[0]);
            int timeUnitIndex = Integer.parseInt(values[1]);
            Calendar calendar = Calendar.getInstance();
            TimeUnit timeUnit = TimeUnit.findTimeUnitByIndex(timeUnitIndex);
            calendar.add(timeUnit.getCalendarIndex(), -value);
            for (EmailConfig emailConfig : emailConfigList) {
                List<EmailSendLog> recordNotInSpecifiedTimeList = this.getEmailConfigDao().loadPushRecordNotInSpecifiedTime(emailConfig.getId(), calendar.getTime());
                delEmailSendLogList.addAll(recordNotInSpecifiedTimeList);
            }
        } else if (PushRecordSavingStrategy.number.toString().equals(emailPushRecordConfig.getStrategy())) {
            for (EmailConfig emailConfig : emailConfigList) {
                Long boundaryDate = this.findBoundaryDateByPushRecordInfo(emailPushRecordConfig, emailConfig);
                if (boundaryDate == null) continue;
                Date date = new Date(boundaryDate);
                List<EmailSendLog> recordNotNumList = this.getEmailConfigDao().loadPublishInfoByMonthLimit(emailConfig.getId(), date);
                delEmailSendLogList.addAll(recordNotNumList);
            }
        }
        if (delEmailSendLogList.size() > 0) {
            this.deleteEmailPublishInfoById(delEmailSendLogList);
        }
    }

    public Long findBoundaryDateByPushRecordInfo(PushRecordConfig emailPushRecordConfig, EmailConfig emailConfig) throws AbstractQingIntegratedException, SQLException {
        ArrayList<EmailSendLog> emailSendLogList = new ArrayList<EmailSendLog>(20);
        Integer pushRecordCount = this.getEmailConfigDao().loadPublishInfoCount(emailConfig.getId());
        int setValue = Integer.parseInt(emailPushRecordConfig.getValue());
        if (setValue < pushRecordCount) {
            ArrayList<Date> subTime = new ArrayList<Date>(2);
            Calendar calendar = Calendar.getInstance();
            subTime.add(calendar.getTime());
            while (setValue > 0) {
                calendar.add(2, -1);
                subTime.add(calendar.getTime());
                List<EmailSendLog> emailSendLogs = this.getEmailConfigDao().selectPublishInfoByMonthLimit(emailConfig.getId(), subTime, setValue);
                emailSendLogList.addAll(emailSendLogs);
                setValue -= emailSendLogs.size();
                subTime.remove(0);
            }
        }
        if (emailSendLogList.size() > 0) {
            return ((EmailSendLog)emailSendLogList.get(emailSendLogList.size() - 1)).getCreateTime();
        }
        return null;
    }

    public String loadEmailPushTagIdByBizTag(String biztag) throws AbstractQingIntegratedException, SQLException {
        return this.getEmailConfigDao().loadEmailPushTagIdByBizTag(biztag);
    }

    public PublishOperModelVO loadParentPublishPermissionInfo(String biztag) throws AbstractQingIntegratedException, SQLException {
        List publishOperPermissionsPOList = this.getPublishOperPermissionsDao().loadPubOperByPubId(biztag);
        PublishOperModelVO publishOperModelVO = new PublishOperModelVO();
        HashMap<String, Integer> parentPermissionInfo = new HashMap<String, Integer>(publishOperPermissionsPOList.size());
        if (publishOperPermissionsPOList.size() > 0) {
            for (PublishOperPermissionsPO publishOperPermissionsPO : publishOperPermissionsPOList) {
                String type = publishOperPermissionsPO.getType();
                Integer noOperAuthValue = publishOperPermissionsPO.getNoOperAuthValue();
                if (parentPermissionInfo.containsKey(type)) {
                    Integer noOperValue = (Integer)parentPermissionInfo.get(type);
                    parentPermissionInfo.put(type, noOperValue + noOperAuthValue);
                    continue;
                }
                parentPermissionInfo.put(type, noOperAuthValue);
            }
            publishOperModelVO.setNoOperValueMap(parentPermissionInfo);
        }
        return publishOperModelVO;
    }

    private class TimedClearUpTaskRunner
    implements Runnable {
        private PushRecordConfig emailPushRecordConfig;

        public TimedClearUpTaskRunner(PushRecordConfig emailPushRecordConfig) {
            this.emailPushRecordConfig = emailPushRecordConfig;
        }

        @Override
        public void run() {
            try {
                EmailConfigManageDomain.this.tx.beginRequired();
                EmailConfigManageDomain.this.deletePushRecordByConfigInfo(this.emailPushRecordConfig, null);
            }
            catch (AbstractQingIntegratedException e) {
                EmailConfigManageDomain.this.tx.markRollback();
            }
            catch (SQLException e) {
                EmailConfigManageDomain.this.tx.markRollback();
            }
            catch (PublishException e) {
                EmailConfigManageDomain.this.tx.markRollback();
            }
            finally {
                EmailConfigManageDomain.this.tx.end();
            }
        }
    }
}

