/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.publish.target.lapp.dao.LappDao;
import com.kingdee.bos.qing.publish.target.lapp.exception.ExecuteSqlException;
import com.kingdee.bos.qing.publish.target.lapp.model.DatacenterSyncModel;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class LappSyncDomain {
    private static final String LAPP_SYNC_LOCK_KEY = "qing_lapp_sync_lock_";
    public static final long EXPIRES_TIME = 300000L;
    private static Map<String, DatacenterSyncModel> SYNCED_MAP = new HashMap<String, DatacenterSyncModel>(16);
    private static Map<String, Long> SQL_VISITED_TIME_MAP = new HashMap<String, Long>(16);
    private LappDao lappDao;
    private QingContext qingContext;
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;

    public LappSyncDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter) {
        this.qingContext = qingContext;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
    }

    private LappDao getLappDao() {
        if (this.lappDao == null) {
            this.lappDao = new LappDao(this.dbExcuter);
        }
        return this.lappDao;
    }

    public String getSyncedDatacenterUUID() throws AbstractQingException {
        DatacenterSyncModel syncModel = this.getFromMemCacheSynced();
        if (syncModel == null) {
            syncModel = this.getSyncInfoFromSQL();
        }
        if (syncModel == null || syncModel.getSyncStatus() != DatacenterSyncModel.SyncStatusEnum.SYNCED) {
            return null;
        }
        return syncModel.getDatacenterUUID();
    }

    public void finishSync(String datacenterUUID) throws AbstractQingException, InterruptedException {
        DatacenterSyncModel syncModel = new DatacenterSyncModel();
        syncModel.setDatacenterUUID(datacenterUUID);
        syncModel.setSyncStatus(DatacenterSyncModel.SyncStatusEnum.SYNCED);
        syncModel.setSyncTime(System.currentTimeMillis());
        this.updateSyncInfo(syncModel);
    }

    public Map<String, Object> loadDatacenterInfoMap() throws AbstractQingException, InterruptedException {
        DatacenterSyncModel syncModel = null;
        if (this.isCanVisitSQL()) {
            this.setSQLVisitedTime();
            syncModel = this.loadSyncInfo();
        }
        return this.collectDatacenterInfoMap(syncModel);
    }

    private boolean isCanVisitSQL() {
        Long visitedTime = SQL_VISITED_TIME_MAP.get(this.qingContext.getAccountId());
        return visitedTime == null || System.currentTimeMillis() > visitedTime + 300000L;
    }

    private void setSQLVisitedTime() {
        SQL_VISITED_TIME_MAP.put(this.qingContext.getAccountId(), System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatacenterSyncModel loadSyncInfo() throws AbstractQingException, InterruptedException {
        Map<String, DatacenterSyncModel> map = SYNCED_MAP;
        synchronized (map) {
            DatacenterSyncModel syncModel = this.getFromMemCacheSynced();
            if (syncModel == null && (syncModel = this.loadSyncInfoFromSQL()) != null) {
                this.setMemCacheIfSynced(syncModel);
                if (syncModel.getSyncStatus() == DatacenterSyncModel.SyncStatusEnum.SYNCHRONIZING && System.currentTimeMillis() > syncModel.getSyncTime() + 300000L) {
                    this.updateSyncTime(syncModel.getDatacenterUUID());
                }
            }
            return syncModel;
        }
    }

    /*
     * Loose catch block
     */
    private DatacenterSyncModel loadSyncInfoFromSQL() throws AbstractQingException, InterruptedException {
        DatacenterSyncModel syncModel = this.getSyncInfoFromSQL();
        if (syncModel != null) {
            return syncModel;
        }
        ILock datacenterLock = LockFactory.createLock((String)(LAPP_SYNC_LOCK_KEY + this.qingContext.getAccountId()));
        try {
            boolean isLock = datacenterLock.tryLock();
            if (!isLock) {
                DatacenterSyncModel datacenterSyncModel = null;
                return datacenterSyncModel;
            }
            syncModel = this.getSyncInfoFromSQL();
            if (syncModel != null) {
                DatacenterSyncModel datacenterSyncModel = syncModel;
                return datacenterSyncModel;
            }
            try {
                this.tx.beginRequired();
                syncModel = new DatacenterSyncModel();
                syncModel.setDatacenterUUID(UUID.randomUUID().toString());
                syncModel.setSyncStatus(DatacenterSyncModel.SyncStatusEnum.SYNCHRONIZING);
                syncModel.setSyncTime(System.currentTimeMillis());
                syncModel.setInit(true);
                this.getLappDao().saveSyncInfo(syncModel);
                DatacenterSyncModel datacenterSyncModel = syncModel;
                return datacenterSyncModel;
            }
            catch (SQLException e) {
                this.tx.markRollback();
                throw new ExecuteSqlException("fail to load datacenter info", e);
            }
            finally {
                this.tx.end();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            datacenterLock.unlock();
        }
    }

    private DatacenterSyncModel getSyncInfoFromSQL() throws AbstractQingException {
        try {
            return this.getLappDao().getSyncInfo();
        }
        catch (SQLException e) {
            throw new ExecuteSqlException("fail to load datacenter info", e);
        }
    }

    private void updateSyncInfo(DatacenterSyncModel syncModel) throws AbstractQingException {
        try {
            this.tx.beginRequired();
            this.getLappDao().updateSyncInfo(syncModel);
            this.setMemCacheIfSynced(syncModel);
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ExecuteSqlException("fail to update datacenter info", e);
        }
        finally {
            this.tx.end();
        }
    }

    private void updateSyncTime(String datacenterUUID) throws AbstractQingException {
        try {
            this.tx.beginRequired();
            this.getLappDao().updateSyncTime(datacenterUUID);
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ExecuteSqlException("fail to update datacenter sync time", e);
        }
        finally {
            this.tx.end();
        }
    }

    private DatacenterSyncModel getFromMemCacheSynced() {
        return SYNCED_MAP.get(this.qingContext.getAccountId());
    }

    private void setMemCacheIfSynced(DatacenterSyncModel syncModel) {
        if (syncModel.getSyncStatus() == DatacenterSyncModel.SyncStatusEnum.SYNCED) {
            SYNCED_MAP.put(this.qingContext.getAccountId(), syncModel);
        }
    }

    private Map<String, Object> collectDatacenterInfoMap(DatacenterSyncModel syncModel) throws AbstractQingException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean isNeedSync = false;
        if (syncModel != null) {
            result.put("datacenterUUID", syncModel.getDatacenterUUID());
            isNeedSync = syncModel.isNeedSync();
            if (isNeedSync) {
                result.put("publishIds", this.getAllMobilePublishIds());
            }
        }
        result.put("isNeedSync", isNeedSync);
        return result;
    }

    private List<String> getAllMobilePublishIds() throws AbstractQingException {
        try {
            return this.getLappDao().getAllMobilePublishIds();
        }
        catch (SQLException e) {
            throw new ExecuteSqlException("fail to get all mobile publishIds", e);
        }
    }
}

