/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp.env;

import com.kingdee.bos.qing.publish.target.lapp.env.LappApiEnum;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.InputStream;
import java.util.Map;

public abstract class AbstractLappEnv {
    private static final String QING_LIGHTAPP_SERVERURL = "qing.lightapp.serverurl";
    private static final String QING_LIGHTAPP_APPID = "qing.lightapp.appid";
    private static final String QING_LIGHTAPP_MOBILESERVERURL = "qing.lightapp.mobileserverurl";
    private static final String QING_LIGHTAPP_PUBLISHURL = "qing.lightapp.publishurl";
    private static final String QING_LIGHTAPP_WXQYH_STANDARD_INTEGRATION = "qing.lightapp.wxqyh.standard.integration";
    private static final String QING_SCHEDULE_PUSH_LAPP_ANALYSIS_PARENT_ID = "-1";
    private static final String QING_LAPP_HOME_PAGE_URL = "index.html";
    protected static final String QING_SCHEDULE_PUSH_LEFTTOP_ICON_URL = "qing-lapp/core/resource/icon_qing.png";
    protected static final String QING_SCHEDULE_PUSH_THUMBNAIL_ICON_URL = "qing-lapp/core/resource/icon_chart.png";

    public String getServerHostUrl() {
        return System.getProperty(QING_LIGHTAPP_SERVERURL);
    }

    public String getAppId() {
        return System.getProperty(QING_LIGHTAPP_APPID);
    }

    public String getMobileServerHostUrl() {
        String mobileServerUrl = System.getProperty(QING_LIGHTAPP_MOBILESERVERURL);
        if (StringUtils.isBlank((CharSequence)mobileServerUrl)) {
            mobileServerUrl = this.getServerHostUrl();
        }
        return mobileServerUrl;
    }

    public String getConfiguredPublishUrlPrefix() {
        return System.getProperty(QING_LIGHTAPP_PUBLISHURL);
    }

    public static boolean isWxqyhStandardIntegration(String targetAccountId) {
        String accountIdStr = System.getProperty(QING_LIGHTAPP_WXQYH_STANDARD_INTEGRATION);
        if (accountIdStr != null) {
            String[] accountIds;
            for (String accountId : accountIds = accountIdStr.split(",")) {
                if (!accountId.equals(targetAccountId)) continue;
                return true;
            }
        }
        return false;
    }

    public String getLappAnalysisParentId() {
        return QING_SCHEDULE_PUSH_LAPP_ANALYSIS_PARENT_ID;
    }

    public String getLappHomePageUrl() {
        return this.getServerHostUrl() + QING_LAPP_HOME_PAGE_URL;
    }

    public abstract String getLeftTopIconUrl();

    public abstract String getDefaultThumbnailIconUrl();

    public abstract String getDownloadThumbnailUrl(String var1);

    public abstract byte[] getDownloadThumbnail(String var1);

    public abstract String post(LappApiEnum var1, Map<String, String> var2, String var3, Map<String, String> var4);

    public abstract String postByForm(LappApiEnum var1, Map<String, String> var2, Map<String, String> var3, Map<String, String> var4);

    public abstract String postFile(LappApiEnum var1, Map<String, String> var2, InputStream var3, String var4);

    public abstract boolean isConnAvailable();
}

