/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp.push.missioncloud;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.publish.exception.MismatchSourceTypeException;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.model.OperCodeEnum;
import com.kingdee.bos.qing.publish.model.PushTargetType;
import com.kingdee.bos.qing.publish.model.SceneType;
import com.kingdee.bos.qing.publish.target.lapp.exception.ExecuteSqlException;
import com.kingdee.bos.qing.publish.target.lapp.exception.LappException;
import com.kingdee.bos.qing.publish.target.lapp.model.PushRecord;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractLappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractLappSchedulePushDomain;
import com.kingdee.bos.qing.publish.target.lapp.push.missioncloud.MissionCloudPushConfigModel;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import org.jdom2.JDOMException;

public class MissonCloudSchedulePushDomain
extends AbstractLappSchedulePushDomain {
    public MissonCloudSchedulePushDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    @Override
    public void saveConfigInfo(String tag, AbstractLappSchedulePushConfigModel pushConfigModel, String modelBookStr, ModelBook thumbnailModelBook, String lappEntranceUrl, String dsbPublishId, String scene) throws AbstractQingIntegratedException, PublishException {
        try {
            this.tx.beginRequired();
            if (pushConfigModel.getLappSchedulePushConfigModel().getTagId() != null && PublishUtil.isPublish((String)pushConfigModel.getLappSchedulePushConfigModel().getTagId())) {
                if (SceneType.Longer.name().equals(scene)) {
                    this.judgePublishOperAuth(pushConfigModel.getLappSchedulePushConfigModel().getTagId(), dsbPublishId, OperCodeEnum.analysis_timepush);
                }
                if (SceneType.Square.name().equals(scene)) {
                    this.judgePublishOperAuth(pushConfigModel.getLappSchedulePushConfigModel().getTagId(), dsbPublishId, OperCodeEnum.card_timepush);
                }
            }
            this.getLappDomain().saveLappSchedulePushConfigInfo(tag, pushConfigModel.getLappSchedulePushConfigModel(), modelBookStr, thumbnailModelBook, lappEntranceUrl);
            MissionCloudPushConfigModel model = (MissionCloudPushConfigModel)pushConfigModel;
            this.saveMissionCloudSchedulePushConfigInfo(model);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ExecuteSqlException("fail to save chat robot push config model", e);
        }
        finally {
            this.tx.end();
        }
    }

    @Override
    public List<? extends AbstractLappSchedulePushConfigModel> loadConfigInfo(PushTargetType pushTargetType, String configId) throws AbstractQingIntegratedException, ExecuteSqlException {
        String userId = this.qingContext.getUserId();
        List<MissionCloudPushConfigModel> pushConfigModels = null;
        try {
            pushConfigModels = configId == null ? this.getLappDao().loadMissionCloudConfigInfo(userId, pushTargetType) : this.getLappDao().loadMissionCloudConfigInfoById(userId, pushTargetType, configId);
            for (MissionCloudPushConfigModel pushConfigModel : pushConfigModels) {
                List<PushRecord> pushRecordList = this.getLappDomain().loadPushRecordByStorageSetInfo(pushConfigModel.getLappSchedulePushConfigModel().getId(), this.qingContext.getUserId());
                this.setEachPushDetailFileSize(pushConfigModel, pushRecordList);
                this.getLappDomain().fillPublishSource(pushConfigModel.getLappSchedulePushConfigModel());
            }
        }
        catch (SQLException e) {
            throw new ExecuteSqlException("fail to load push config model", e);
        }
        catch (MismatchSourceTypeException e) {
            throw new ExecuteSqlException("fail to load push config model", e);
        }
        return pushConfigModels;
    }

    private void setEachPushDetailFileSize(MissionCloudPushConfigModel pushConfigModel, List<PushRecord> pushRecordList) throws AbstractQingIntegratedException, SQLException {
        if (pushRecordList != null && pushRecordList.size() > 0) {
            double sumFileSize = 0.0;
            for (int i = 0; i < pushRecordList.size(); ++i) {
                BigDecimal bigDecimal;
                PushRecord pushRecord = pushRecordList.get(i);
                String fileSize = pushRecord.getFileSize();
                double fileSizeVal = Double.parseDouble(fileSize.substring(0, fileSize.length() - 2));
                String fileSizeUnit = fileSize.substring(fileSize.length() - 2, fileSize.length());
                if ("MB".equals(fileSizeUnit)) {
                    sumFileSize += fileSizeVal * 1024.0 * 1024.0;
                } else if ("KB".equals(fileSizeUnit)) {
                    sumFileSize += fileSizeVal * 1024.0;
                }
                if (sumFileSize <= 1048576.0) {
                    bigDecimal = BigDecimal.valueOf(sumFileSize).divide(new BigDecimal(1024), 2, 4);
                    pushConfigModel.getLappSchedulePushConfigModel().setFileSize((sumFileSize == 0.0 ? Integer.valueOf(0) : bigDecimal) + "KB");
                    continue;
                }
                bigDecimal = BigDecimal.valueOf(sumFileSize).divide(new BigDecimal(0x100000), 2, 4);
                pushConfigModel.getLappSchedulePushConfigModel().setFileSize(bigDecimal + "MB");
            }
        } else {
            pushConfigModel.getLappSchedulePushConfigModel().setFileSize("0MB");
        }
    }

    @Override
    public void updateConfigInfo(AbstractLappSchedulePushConfigModel pushConfigModel, String lappEntranceUrl) throws AbstractQingIntegratedException, LappException, PersistentModelParseException, PersistentModelTooModernException, JDOMException {
        try {
            this.tx.beginRequired();
            String oldThumbnailPath = this.getLappDomain().updateConfigInfo(pushConfigModel.getLappSchedulePushConfigModel(), lappEntranceUrl);
            if (StringUtils.isNotEmpty((CharSequence)oldThumbnailPath)) {
                FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.CARD_THUMBNAIL, (String)oldThumbnailPath).delete();
            }
            MissionCloudPushConfigModel model = (MissionCloudPushConfigModel)pushConfigModel;
            this.updateMissionCloudSchedulePushConfigInfo(model);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishException e) {
            this.tx.markRollback();
            throw new LappException(e, e.getErrorCode());
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ExecuteSqlException("fail to save chat robot push config model", e);
        }
        catch (PersistentModelParseException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PersistentModelTooModernException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (JDOMException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    @Override
    public void deleteConfigInfo(String configId) throws AbstractQingIntegratedException, LappException {
        try {
            this.tx.beginRequired();
            String oldThumbnailPath = this.getLappDomain().deleteConfigInfo(configId);
            if (oldThumbnailPath != null) {
                FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.CARD_THUMBNAIL, (String)oldThumbnailPath).delete();
            }
            this.deleteMissionCloudSchedulePushConfigInfo(configId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishException e) {
            this.tx.markRollback();
            throw new LappException(e, e.getErrorCode());
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ExecuteSqlException("fail to save chat robot push config model", e);
        }
        finally {
            this.tx.end();
        }
    }

    @Override
    public AbstractLappSchedulePushConfigModel parseToModel(String modelStr) {
        MissionCloudPushConfigModel pushConfigModel = (MissionCloudPushConfigModel)JsonUtil.decodeFromString((String)modelStr, MissionCloudPushConfigModel.class);
        return pushConfigModel;
    }

    private void saveMissionCloudSchedulePushConfigInfo(MissionCloudPushConfigModel model) throws AbstractQingIntegratedException, SQLException {
        this.getLappDao().saveMissionCloudSchedulePushConfigInfo(model);
    }

    private void updateMissionCloudSchedulePushConfigInfo(MissionCloudPushConfigModel model) throws AbstractQingIntegratedException, SQLException {
        this.getLappDao().updateMissionCloudSchedulePushConfigInfo(model);
    }

    private void deleteMissionCloudSchedulePushConfigInfo(String configId) throws AbstractQingIntegratedException, SQLException {
        this.getLappDao().deleteMissionCloudSchedulePushConfigInfo(configId);
    }
}

