/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.thumbnail.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.exception.PublishScheduleModelException;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailInfo;
import com.kingdee.bos.qing.schedule.exception.ScheduleModelParseException;
import com.kingdee.bos.qing.schedule.model.Schedule;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.jdom2.Content;
import org.jdom2.Element;

public class ThumbnailInfoDao {
    private IDBExcuter dbExcuter;

    public ThumbnailInfoDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public String saveThumbnailInfo(ThumbnailInfo model, String publishId, String schemaId, String analysisId) throws AbstractQingIntegratedException, SQLException {
        byte[] scheduleModelBytes = this.createScheduleBytes(model.getSchedule());
        String sql = "INSERT into t_qing_thumbnail (FID, FPUBLISHID, FSCHEMAID, FAPEWIDTH, FAPEHEIGHT, FSCOLEFT,FSCOTOP,FAPELEFT,FAPETOP,FANAID,FISDEL,FSCHEDULE,FISSCHEDULE) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String fid = UUID.randomUUID().toString();
        Object[] params = new Object[13];
        int i = 0;
        params[i++] = fid;
        params[i++] = publishId;
        params[i++] = schemaId;
        params[i++] = model.getApertureWidth();
        params[i++] = model.getApertureHeight();
        params[i++] = model.getScrollLeft();
        params[i++] = model.getScrollTop();
        params[i++] = model.getApertureLeft();
        params[i++] = model.getApertureTop();
        params[i++] = analysisId;
        params[i++] = 1;
        params[i++] = scheduleModelBytes;
        params[i++] = model.getSchedule() == null || model.getSchedule().getPeriod() == null ? 0 : 1;
        this.dbExcuter.execute(sql, params);
        return fid;
    }

    public void updateThumbnailSchedule(Schedule schedule, String analysisId) throws AbstractQingIntegratedException, SQLException {
        char isSchedule = schedule == null || schedule.getPeriod() == null ? (char)'0' : '1';
        byte[] scheduleModelBytes = this.createScheduleBytes(schedule);
        String sql = "UPDATE T_QING_THUMBNAIL SET FSCHEDULE=?, FISSCHEDULE=? WHERE FANAID=?";
        Object[] params = new Object[]{scheduleModelBytes, Character.valueOf(isSchedule), analysisId};
        this.dbExcuter.execute(sql, params);
    }

    private byte[] createScheduleBytes(Schedule schedule) {
        if (schedule == null) {
            return null;
        }
        Element xml = new Element("Data");
        Element nodeSchedule = new Element("ThumbnailSchedule");
        schedule.toXml(nodeSchedule);
        xml.addContent((Content)nodeSchedule);
        byte[] scheduleModelBytes = XmlUtil.toByteArray((Element)xml);
        return scheduleModelBytes;
    }

    private static Schedule loadThumbnailSchedule(Element xml) throws PublishScheduleModelException {
        Element nodeSchedule = xml.getChild("ThumbnailSchedule");
        if (nodeSchedule == null) {
            nodeSchedule = xml.getChild("ExtractSchedule");
        }
        Schedule schedule = new Schedule();
        try {
            schedule.fromXml(nodeSchedule);
        }
        catch (ScheduleModelParseException e) {
            throw new PublishScheduleModelException((Throwable)e);
        }
        return schedule;
    }

    public ThumbnailInfo getThumbnailModelByAnalysisId(String analysisID) throws AbstractQingIntegratedException, SQLException, PublishScheduleModelException {
        String sql = "SELECT FANAID, FPUBLISHID, FSCHEMAID, FAPELEFT, FAPETOP, FAPEWIDTH, FAPEHEIGHT, FSCOLEFT, FSCOTOP, FSCHEDULE FROM T_QING_THUMBNAIL WHERE FANAID = ?";
        Object[] params = new Object[]{analysisID};
        final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ThumbnailInfo model = (ThumbnailInfo)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<ThumbnailInfo>(){

            public ThumbnailInfo handle(ResultSet rs) throws SQLException {
                ThumbnailInfo model = new ThumbnailInfo();
                if (rs.next()) {
                    model.setAnalysisId(rs.getString("FANAID"));
                    model.setPublishId(rs.getString("FPUBLISHID"));
                    model.setSchemaId(rs.getString("FSCHEMAID"));
                    model.setApertureLeft(rs.getInt("FAPELEFT"));
                    model.setApertureTop(rs.getInt("FAPETOP"));
                    model.setApertureWidth(rs.getInt("FAPEWIDTH"));
                    model.setApertureHeight(rs.getInt("FAPEHEIGHT"));
                    model.setScrollLeft(rs.getInt("FSCOLEFT"));
                    model.setScrollTop(rs.getInt("FSCOTOP"));
                    try {
                        if (rs.getBytes("FSCHEDULE") != null) {
                            outputStream.write(rs.getBytes("FSCHEDULE"));
                        }
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                    return model;
                }
                return null;
            }
        });
        if (outputStream.size() > 0 && model != null) {
            Element scheduleModel = null;
            try {
                scheduleModel = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
            }
            catch (Exception e) {
                throw new PublishScheduleModelException((Throwable)e);
            }
            Schedule schedule = ThumbnailInfoDao.loadThumbnailSchedule(scheduleModel);
            model.setSchedule(schedule);
        }
        return model;
    }

    public ThumbnailInfo getThumbnailModelByPublishId(String publishId) throws AbstractQingIntegratedException, SQLException, PublishScheduleModelException {
        String sql = "SELECT FANAID, FPUBLISHID, FSCHEMAID, FAPELEFT, FAPETOP, FAPEWIDTH, FAPEHEIGHT, FSCOLEFT, FSCOTOP, FSCHEDULE FROM T_QING_THUMBNAIL WHERE FPUBLISHID = ?";
        Object[] params = new Object[]{publishId};
        final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ThumbnailInfo model = (ThumbnailInfo)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<ThumbnailInfo>(){

            public ThumbnailInfo handle(ResultSet rs) throws SQLException {
                ThumbnailInfo model = new ThumbnailInfo();
                if (rs.next()) {
                    model.setAnalysisId(rs.getString("FANAID"));
                    model.setPublishId(rs.getString("FPUBLISHID"));
                    model.setSchemaId(rs.getString("FSCHEMAID"));
                    model.setApertureLeft(rs.getInt("FAPELEFT"));
                    model.setApertureTop(rs.getInt("FAPETOP"));
                    model.setApertureWidth(rs.getInt("FAPEWIDTH"));
                    model.setApertureHeight(rs.getInt("FAPEHEIGHT"));
                    model.setScrollLeft(rs.getInt("FSCOLEFT"));
                    model.setScrollTop(rs.getInt("FSCOTOP"));
                    try {
                        if (rs.getBytes("FSCHEDULE") != null) {
                            outputStream.write(rs.getBytes("FSCHEDULE"));
                        }
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                    return model;
                }
                return null;
            }
        });
        if (outputStream.size() > 0 && model != null) {
            Element scheduleModel = null;
            try {
                scheduleModel = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
            }
            catch (Exception e) {
                throw new PublishScheduleModelException((Throwable)e);
            }
            Schedule schedule = ThumbnailInfoDao.loadThumbnailSchedule(scheduleModel);
            model.setSchedule(schedule);
        }
        return model;
    }

    public void deleteThumbnailInfo(String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_THUMBNAIL WHERE FPUBLISHID = ?";
        this.dbExcuter.execute(sql, new Object[]{publishId});
    }

    public void updateThumbnailSchema(String analysisId, String schemaId) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_THUMBNAIL SET FSCHEMAID=? WHERE FANAID=?";
        this.dbExcuter.execute(sql, new Object[]{schemaId, analysisId});
    }

    public String getPublishNameByAnalysisId(String analysisId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT P.FNAME FROM T_QING_THUMBNAIL T INNER JOIN T_QING_PUBLISH P ON T.FPUBLISHID = P.FID WHERE T.FANAID = ?";
        return (String)this.dbExcuter.query(sql, new Object[]{analysisId}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("FNAME");
                }
                return null;
            }
        });
    }
}

