/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaTable;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ModelBookUtil {
    public static ModelBook fromByte(byte[] content) throws PersistentModelParseException, PersistentModelTooModernException, JDOMException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        Element xmlNode = XmlUtil.loadRootElement((InputStream)bais);
        ModelBook modelBook = new ModelBook();
        modelBook.fromXml(xmlNode);
        ModelBookUtil.fixHistoryErrorMetaTable(modelBook);
        return modelBook;
    }

    public static byte[] toByte(ModelBook modelBook) {
        Element xml = modelBook.toXml();
        return XmlUtil.toByteArray((Element)xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelBook fromFile(AbstractQingFileType qingFileType, String fileName) throws PersistentModelParseException, PersistentModelTooModernException, IOException, JDOMException {
        Element contentElement = null;
        IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)qingFileType, (String)fileName);
        QingInputStream inputStream = null;
        try {
            inputStream = fileVisitor.getInputStream();
            contentElement = XmlUtil.loadRootElement((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        ModelBook modelBook = new ModelBook();
        modelBook.fromXml(contentElement);
        ModelBookUtil.fixHistoryErrorMetaTable(modelBook);
        return modelBook;
    }

    public static void fixHistoryErrorMetaTable(ModelBook modelBook) {
        Meta meta = modelBook.getMeta();
        if (null == meta) {
            return;
        }
        List metaTables = meta.getTables();
        for (MetaTable metaTable : metaTables) {
            List subViews = metaTable.getSubViews();
            if (subViews != null && !subViews.isEmpty()) continue;
            metaTable.setViewItems(null);
        }
    }
}

