/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.service.job.core.Configuration;
import java.io.Serializable;
import java.util.HashMap;

public abstract class JobIsolationLevel
implements Serializable {
    private static final long serialVersionUID = 3407526784544140665L;
    private static HashMap objects = new HashMap();
    private String name;
    public static final JobIsolationLevel None = new None();
    public static final JobIsolationLevel Server = new Server();
    public static final JobIsolationLevel Instance = new Instance();
    public static final JobIsolationLevel FLR = new FLR();
    public static final JobIsolationLevel Cluster = new Cluster();

    protected JobIsolationLevel(String name) {
        this.name = name;
        objects.put(name, this);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JobIsolationLevel)) {
            return false;
        }
        return this.name.equals(((JobIsolationLevel)o).name);
    }

    public static JobIsolationLevel valueOf(String name) {
        if (name != null) {
            name = name.trim().toLowerCase();
        }
        return (JobIsolationLevel)objects.get(name);
    }

    public static JobIsolationLevel[] values() {
        return objects.values().toArray(new JobIsolationLevel[0]);
    }

    public static String allValues() {
        JobIsolationLevel[] levels = JobIsolationLevel.values();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < levels.length; ++i) {
            JobIsolationLevel l = levels[i];
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(l.toString());
        }
        return sb.toString();
    }

    public abstract String getJobIsolationBoundary();

    abstract String hashWhere(String var1);

    public static String sqlWhere(String dc) {
        String loadLevel = Configuration.loadJobIsolationLevel();
        String[] levels = loadLevel.split("\\|");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < levels.length; ++i) {
            JobIsolationLevel l = JobIsolationLevel.valueOf(levels[i]);
            if (sb.length() > 0) {
                sb.append(" or ");
            }
            sb.append("(");
            sb.append("fisolationboundary='").append(l.getJobIsolationBoundary()).append("'");
            String tmp = l.hashWhere(dc);
            if (tmp != null) {
                sb.append(" and ").append(tmp);
            }
            sb.append(")");
        }
        if (loadLevel.contains(Server.toString()) && Configuration.isUseNewServerId()) {
            sb.append(" or ");
            sb.append("(");
            sb.append("fisolationboundary='").append(Configuration.serviceInstanceIdGenerator().getServerId()).append("'");
            sb.append(")");
        } else {
            sb.append(" or ");
            sb.append("(");
            sb.append("fisolationboundary='").append(Configuration.serviceInstanceIdGenerator().getNewServerId()).append("'");
            sb.append(")");
        }
        return sb.toString();
    }

    private static class Instance
    extends JobIsolationLevel {
        private static final long serialVersionUID = 11499422042428680L;

        Instance() {
            super("instance");
        }

        @Override
        public String getJobIsolationBoundary() {
            return Configuration.serviceInstanceIdGenerator().getInstanceId();
        }

        @Override
        String hashWhere(String dc) {
            return null;
        }
    }

    private static class Server
    extends JobIsolationLevel {
        private static final long serialVersionUID = 4929261272989768951L;

        Server() {
            super("server");
        }

        @Override
        public String getJobIsolationBoundary() {
            if (Configuration.isUseNewServerId()) {
                return Configuration.serviceInstanceIdGenerator().getNewServerId();
            }
            return Configuration.serviceInstanceIdGenerator().getServerId();
        }

        @Override
        String hashWhere(String dc) {
            return null;
        }
    }

    private static class None
    extends JobIsolationLevel {
        private static final long serialVersionUID = 3414117828297317714L;

        None() {
            super("none");
        }

        @Override
        public String getJobIsolationBoundary() {
            return "none";
        }

        @Override
        String hashWhere(String dc) {
            return null;
        }
    }

    private static class FLR
    extends JobIsolationLevel {
        private static final long serialVersionUID = 3414117828297317714L;

        FLR() {
            super("flr");
        }

        @Override
        public String getJobIsolationBoundary() {
            return "flr";
        }

        @Override
        String hashWhere(String dc) {
            return null;
        }
    }

    private static class Cluster
    extends JobIsolationLevel {
        private static final long serialVersionUID = 3414117828297317714L;

        Cluster() {
            super("cluster");
        }

        @Override
        public String getJobIsolationBoundary() {
            String clusterName = Configuration.clusterName();
            if (clusterName.equals("default")) {
                return Configuration.serviceInstanceIdGenerator().getServerId();
            }
            return clusterName;
        }

        @Override
        String hashWhere(String dc) {
            return null;
        }
    }
}

