/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.job.util.Serialization;
import com.kingdee.util.PropertyContainer;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public abstract class JobState
implements Serializable {
    public static final String OP_ABORT = "abort";
    public static final String OP_RESTART = "restart";
    public static final String OP_SUSPEND = "suspend";
    public static final String OP_RESUME = "resume";
    public static final String OP_MOVE_TO_HIS = "move";
    public static final String OP_EXCEPTION = "exception";
    public static final String OP_CHECK = "check";
    private static final long serialVersionUID = -7497796945012941555L;
    private static HashMap objects = new HashMap();
    private String name;
    private String text;
    public static final JobState Created = new Created();
    public static final JobState ReScheduled = new ReScheduled();
    public static final JobState Waiting = new Waiting();
    public static final JobState Ready = new Ready();
    public static final JobState Running = new Running();
    public static final JobState Suspended = new Suspended();
    public static final JobState Failed = new Failed();
    public static final JobState Complete = new Complete();
    public static final JobState Aborted = new Aborted();
    public static final JobState Missed = new Missed();

    protected JobState(String name, String text) {
        this.name = name;
        this.text = text;
        objects.put(name, this);
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.name;
    }

    public static JobState valueOf(String name) {
        return (JobState)objects.get(name);
    }

    public static Collection all() {
        return objects.values();
    }

    public static JobState find(String name) {
        Iterator it = objects.keySet().iterator();
        String key = null;
        while (it.hasNext() && !name.equalsIgnoreCase(key = (String)it.next())) {
        }
        return JobState.valueOf(key);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JobState)) {
            return false;
        }
        return this.name.equals(((JobState)o).name);
    }

    protected abstract String getSql();

    protected abstract int[] getTypes();

    protected abstract Object[] getValues(Job var1) throws BOSException;

    public boolean isClose() {
        return false;
    }

    public abstract String[] getSupportedOperations();

    int save(Job job) throws BOSException {
        if (!job.isPersistent()) {
            return 1;
        }
        try {
            return SQL.executeUpdate(job.getContext(), this.getSql(), this.getTypes(), this.getValues(job));
        }
        catch (BOSException e) {
            return SQL.executeUpdate(job.getContext(), this.getSql(), this.getTypes(), this.getValues(job));
        }
    }

    private static byte[] getResult(Job job) {
        byte[] result = null;
        try {
            result = Serialization.toBytes(job.getResult());
        }
        catch (Exception e) {
            String description = "job " + job.toString() + "'s result couldn't be serialized!";
            String advice = "fix the corresponding job handler, ensure returns a serializable result.";
            JobState.saveMessage(job, description, advice, e);
        }
        return result;
    }

    static byte[] getParameters(Job job) {
        byte[] param = null;
        try {
            param = Serialization.toBytes(job.getParameters());
        }
        catch (Exception e) {
            String description = "job " + job.toString() + "'s parameters couldn't be serialized!";
            String advice = "fix the corresponding job handler, ensure returns a serializable parameters.";
            JobState.saveMessage(job, description, advice, e);
        }
        return param;
    }

    private static void saveMessage(Job job, String description, String advide, Exception e) {
        JobLog msg = new JobLog(JobLog.Type.Error, description, null, advide, e);
        job.saveMessage(msg);
    }

    private static class Missed
    extends JobState {
        private static final long serialVersionUID = 7242253574736738623L;

        public Missed() {
            super("Missed", "\u5df2\u9519\u8fc7");
        }

        @Override
        protected String getSql() {
            return "update T_JOB_INST set fpriorstate=?, fstatechangedtime=?,fstate=? where fjobinstid=? and fstate=?";
        }

        @Override
        protected int[] getTypes() {
            return new int[]{12, 93, 12, 12, 12};
        }

        @Override
        protected Object[] getValues(Job job) {
            return new Object[]{job.getPriorState().toString(), new Timestamp(System.currentTimeMillis()), job.getState().toString(), job.getId(), job.getPriorState().toString()};
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_RESTART, JobState.OP_MOVE_TO_HIS};
        }
    }

    private static class Aborted
    extends JobState {
        private static final long serialVersionUID = 7190088098239744848L;

        public Aborted() {
            super("Aborted", "\u5df2\u64a4\u6d88");
        }

        @Override
        protected String getSql() {
            return "update T_JOB_INST set fpriorstate=?,fstatechangedtime=?, fstate=?, fresult=?, fexception=?, fprogress=null, ffinishtime=?  where fjobinstid=? and fstate=?";
        }

        @Override
        protected int[] getTypes() {
            return new int[]{12, 93, 12, -3, 12, 93, 12, 12};
        }

        @Override
        protected Object[] getValues(Job job) {
            return new Object[]{job.getPriorState().toString(), new Timestamp(System.currentTimeMillis()), job.getState().toString(), null, job.getException(), job.getFinishTime(), job.getId(), job.getPriorState().toString()};
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_MOVE_TO_HIS};
        }

        @Override
        public boolean isClose() {
            return true;
        }
    }

    private static class Complete
    extends JobState {
        private static final long serialVersionUID = 1792376812113695955L;

        public Complete() {
            super("Complete", "\u5df2\u5b8c\u6210");
        }

        @Override
        protected String getSql() {
            return "update T_JOB_INST set fpriorstate=?,fstatechangedtime=?, fstate=?, fresult=?, fexception=?,fprogress=null, ffinishtime=?, fcostTime=? where fjobinstid=? and fstate=?";
        }

        @Override
        protected int[] getTypes() {
            return new int[]{12, 93, 12, -3, 12, 93, 4, 12, 12};
        }

        @Override
        protected Object[] getValues(Job job) {
            return new Object[]{job.getPriorState().toString(), new Timestamp(System.currentTimeMillis()), job.getState().toString(), JobState.getResult(job), null, job.getFinishTime(), job.getFinishTime().getTime() - job.getStartedTime().getTime(), job.getId(), job.getPriorState().toString()};
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_MOVE_TO_HIS};
        }

        @Override
        public boolean isClose() {
            return true;
        }
    }

    private static class Failed
    extends JobState {
        private static final long serialVersionUID = -1960253852627137383L;

        public Failed() {
            super("Failed", "\u5df2\u5931\u8d25");
        }

        @Override
        protected String getSql() {
            return "update T_JOB_INST set fparameters=?, fpriorstate=?,fstatechangedtime=?, fstate=?, fresult=?, fexception=?,fprogress=null, ffinishtime=?, fcostTime=? where fjobinstid=? and fstate=?";
        }

        @Override
        protected int[] getTypes() {
            return new int[]{-3, 12, 93, 12, -3, 12, 93, 4, 12, 12};
        }

        @Override
        protected Object[] getValues(Job job) {
            return new Object[]{com.kingdee.bos.service.job.core.JobState$Failed.getParameters(job), job.getPriorState().toString(), new Timestamp(System.currentTimeMillis()), job.getState().toString(), null, job.getException(), job.getFinishTime(), job.getFinishTime().getTime() - job.getStartedTime().getTime(), job.getId(), job.getPriorState().toString()};
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_RESTART, JobState.OP_MOVE_TO_HIS, JobState.OP_EXCEPTION};
        }

        @Override
        public boolean isClose() {
            return true;
        }
    }

    private static class Suspended
    extends JobState {
        private static final long serialVersionUID = -6663650364110878697L;

        public Suspended() {
            super("Suspended", "\u5df2\u6302\u8d77");
        }

        @Override
        protected String getSql() {
            return "update T_JOB_INST set fpriorstate=?,fstatechangedtime=?, fstate=?,fparameters=?,fresult=?, fexception=?, ffinishtime=?  where fjobinstid=? and fstate=?";
        }

        @Override
        protected int[] getTypes() {
            return new int[]{12, 93, 12, -3, -3, 12, 93, 12, 12};
        }

        @Override
        protected Object[] getValues(Job job) {
            return new Object[]{job.getPriorState().toString(), new Timestamp(System.currentTimeMillis()), job.getState().toString(), com.kingdee.bos.service.job.core.JobState$Suspended.getParameters(job), null, null, job.getFinishTime(), job.getId(), job.getPriorState().toString()};
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_RESUME};
        }
    }

    private static class Running
    extends JobState {
        private static final long serialVersionUID = -2428699051058453611L;

        public Running() {
            super("Running", "\u6267\u884c\u4e2d");
        }

        @Override
        protected String getSql() {
            return "update T_JOB_INST set fpriorstate=?,fstatechangedtime=?,fstate=?,fstartedtime=?, ffinishtime=null  where fjobinstid=? and fstate=?";
        }

        @Override
        protected int[] getTypes() {
            return new int[]{12, 93, 12, 93, 12, 12};
        }

        @Override
        protected Object[] getValues(Job job) {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            return new Object[]{job.getPriorState().toString(), now, job.getState().toString(), now, job.getId(), job.getPriorState().toString()};
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_CHECK};
        }
    }

    private static class Ready
    extends JobState {
        private static final long serialVersionUID = 4360212803794658727L;

        public Ready() {
            super("Ready", "\u5df2\u5c31\u7eea");
        }

        @Override
        protected String getSql() {
            return "update T_JOB_INST set fpriorstate=?,fstatechangedtime=?,fstate=?, fholderid=?  where fjobinstid=? and fstate=?";
        }

        @Override
        protected int[] getTypes() {
            return new int[]{12, 93, 12, 12, 12, 12};
        }

        @Override
        protected Object[] getValues(Job job) {
            return new Object[]{job.getPriorState().toString(), new Timestamp(System.currentTimeMillis()), job.getState().toString(), job.getHolderId(), job.getId(), job.getPriorState().toString()};
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_ABORT, JobState.OP_SUSPEND, JobState.OP_CHECK};
        }
    }

    private static class Waiting
    extends JobState {
        private static final long serialVersionUID = -4353760578200748988L;

        public Waiting() {
            super("Waiting", "\u7b49\u5f85\u4e2d");
        }

        @Override
        protected String getSql() {
            return "update T_JOB_INST set fscheduledtime=?, fpriorstate=?,fstatechangedtime=?,fstate=?,fholderid=?  where fjobinstid=? and fstate=?";
        }

        @Override
        protected int[] getTypes() {
            return new int[]{93, 12, 93, 12, 12, 12, 12};
        }

        @Override
        protected Object[] getValues(Job job) {
            return new Object[]{job.getScheduledTime(), job.getPriorState().toString(), new Timestamp(System.currentTimeMillis()), job.getState().toString(), job.getHolderId(), job.getId(), job.getPriorState().toString()};
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_ABORT, JobState.OP_SUSPEND, JobState.OP_CHECK};
        }
    }

    private static class ReScheduled
    extends JobState {
        private static final long serialVersionUID = -8997328492312143185L;

        public ReScheduled() {
            super("ReScheduled", "\u5df2\u63a5\u6536");
        }

        @Override
        protected String getSql() {
            return "update T_JOB_INST set fpriorstate=?, fstatechangedtime=?, fisolationboundary=?, fstate=?,fparameters=?,fscheduledtime=?, fholderid=null, fprogress=?, finstanceconfig=?  where fjobinstid=? and fstate=?";
        }

        @Override
        protected int[] getTypes() {
            return new int[]{12, 93, 12, 12, -3, 93, 12, -3, 12, 12};
        }

        @Override
        protected Object[] getValues(Job job) throws BOSException {
            String progress = job.getProgress();
            if (progress == null) {
                progress = "\u7b49\u5f85\u91cd\u65b0\u8c03\u5ea6...";
            }
            Object[] values = new Object[]{job.getPriorState().toString(), new Timestamp(System.currentTimeMillis()), job.getIsolationBoundary(), job.getState().toString(), com.kingdee.bos.service.job.core.JobState$ReScheduled.getParameters(job), job.getScheduledTime(), progress + "\uff1b\u4e0a\u6b21\u6267\u884c\u670d\u52a1\u5668: " + job.getHolderId(), Serialization.toBytes(job.getInstanceConfig()), job.getId(), job.getPriorState().toString()};
            return values;
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_ABORT, JobState.OP_SUSPEND, JobState.OP_CHECK};
        }
    }

    private static class Created
    extends JobState {
        private static final long serialVersionUID = -2484118897782438172L;

        public Created() {
            super("Created", "\u5df2\u63a5\u6536");
        }

        @Override
        protected String getSql() {
            String sql = "insert into T_JOB_INST(fjobinstid , ftitle , fuserid , forgid , fclientip , fcreatedtime, fscheduledtime, fexpiredtime, fstate, fparameters, fjobdefid, finstanceconfig, fisolationboundary, fhashCode,fpriorJobId,fcluster,FMUTEX,FJOBTYPE)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            return sql;
        }

        @Override
        protected int[] getTypes() {
            int[] types = new int[]{12, 12, 12, 12, 12, 93, 93, 93, 12, -3, 12, -3, 12, 4, 12, 12, 12, 12};
            return types;
        }

        @Override
        protected Object[] getValues(Job job) throws BOSException {
            String mutex;
            String orgid = null;
            PropertyContainer pc = (PropertyContainer)job.getContext().get((Object)"CurOU");
            if (pc != null) {
                orgid = pc.getString("id");
            }
            String userId = job.getContext().getCaller().toString();
            String userIp = job.getContext().getClientHostIP();
            int max = 31;
            if (userIp != null && userIp.length() > 31) {
                userIp = userIp.substring(userIp.length() - 31);
            }
            if ((mutex = job.getMutex()) != null && mutex.length() > 100) {
                mutex = mutex.substring(0, 100);
            }
            Object[] values = new Object[]{job.getId(), job.getTitle(), userId, orgid, userIp, job.getCreatedTime(), job.getScheduledTime(), job.getExpiredTime(), job.getState().toString(), Serialization.toBytes(job.getParameters()), job.getJobDefID(), Serialization.toBytes(job.getInstanceConfig()), job.getIsolationBoundary(), new Integer(job.getHashCode()), job.getPriorJobId(), Configuration.clusterIsolation(), mutex, job.getJobType()};
            return values;
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_ABORT, JobState.OP_SUSPEND, JobState.OP_CHECK};
        }
    }
}

