/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.Configuration;
import java.io.Serializable;
import java.util.HashMap;

public abstract class TriggerIsolationLevel
implements Serializable {
    private static final long serialVersionUID = -8426838506017004582L;
    private static HashMap objects = new HashMap();
    private String name;
    public static final TriggerIsolationLevel None = new None();
    public static final TriggerIsolationLevel Server = new Server();
    public static final TriggerIsolationLevel Cluster = new Cluster();

    protected TriggerIsolationLevel(String name) {
        this.name = name;
        objects.put(name, this);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TriggerIsolationLevel)) {
            return false;
        }
        return this.name.equals(((TriggerIsolationLevel)o).name);
    }

    public static TriggerIsolationLevel valueOf(String name) {
        if (name != null) {
            name = name.trim().toLowerCase();
        }
        return (TriggerIsolationLevel)objects.get(name);
    }

    public static TriggerIsolationLevel[] values() {
        return objects.values().toArray(new TriggerIsolationLevel[0]);
    }

    public abstract String getTriggerIsolationBoundary();

    abstract String hashWhere(String var1);

    public static String sqlWhere(String dc) {
        String hashStr;
        TriggerIsolationLevel[] levels = TriggerIsolationLevel.values();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < levels.length; ++i) {
            TriggerIsolationLevel l = levels[i];
            if (sb.length() > 0) {
                sb.append(" or ");
            }
            sb.append("(");
            sb.append("fisolationBoundary='").append(l.getTriggerIsolationBoundary()).append("'");
            String tmp = l.hashWhere(dc);
            if (tmp != null) {
                sb.append(" and ").append(tmp);
            }
            sb.append(")");
        }
        if (Configuration.isUseNewServerId()) {
            sb.append(" or ");
            sb.append("(");
            sb.append("fisolationboundary='").append(Configuration.serviceInstanceIdGenerator().getServerId()).append("'");
            sb.append(" and ");
            ClusterStateManager manager = ClusterStateManager.get(dc);
            hashStr = "(fhashcode>=" + manager.getSMinHash() + " and fhashcode<=" + manager.getSMaxHash() + ")";
            sb.append(hashStr);
            sb.append(")");
        } else {
            sb.append(" or ");
            sb.append("(");
            sb.append("fisolationboundary='").append(Configuration.serviceInstanceIdGenerator().getNewServerId()).append("'");
            sb.append(" and ");
            ClusterStateManager manager = ClusterStateManager.get(dc);
            hashStr = "(fhashcode>=" + manager.getSMinHash() + " and fhashcode<=" + manager.getSMaxHash() + ")";
            sb.append(hashStr);
            sb.append(")");
        }
        return sb.toString();
    }

    private static class Cluster
    extends TriggerIsolationLevel {
        private static final long serialVersionUID = 7300432603641841807L;

        Cluster() {
            super("cluster");
        }

        @Override
        public String getTriggerIsolationBoundary() {
            String clusterName = Configuration.clusterName();
            if (clusterName.equals("default")) {
                return Configuration.serviceInstanceIdGenerator().getServerId();
            }
            return clusterName;
        }

        @Override
        String hashWhere(String dc) {
            ClusterStateManager manager = ClusterStateManager.get(dc);
            return "(fhashcode>=" + manager.getCMinHash() + " and fhashcode<=" + manager.getCMaxHash() + ")";
        }
    }

    private static class Server
    extends TriggerIsolationLevel {
        private static final long serialVersionUID = 7300432603641841807L;

        Server() {
            super("server");
        }

        @Override
        public String getTriggerIsolationBoundary() {
            if (Configuration.isUseNewServerId()) {
                return Configuration.serviceInstanceIdGenerator().getNewServerId();
            }
            return Configuration.serviceInstanceIdGenerator().getServerId();
        }

        @Override
        String hashWhere(String dc) {
            ClusterStateManager manager = ClusterStateManager.get(dc);
            return "(fhashcode>=" + manager.getSMinHash() + " and fhashcode<=" + manager.getSMaxHash() + ")";
        }
    }

    private static class None
    extends TriggerIsolationLevel {
        private static final long serialVersionUID = 1057408485642526676L;

        None() {
            super("none");
        }

        @Override
        String hashWhere(String dc) {
            ClusterStateManager manager = ClusterStateManager.get(dc);
            return "(fhashcode>=" + manager.getGMinHash() + " and fhashcode<=" + manager.getGMaxHash() + ")";
        }

        @Override
        public String getTriggerIsolationBoundary() {
            return "none";
        }
    }
}

