/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud;

import com.kingdee.bos.cloud.CloudAppServerInfo;
import com.kingdee.bos.cloud.UTF8PostMethod;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.ToolSetting;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.net.ConnectException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.eclipse.core.runtime.FileLocator;

public class CloudServerInfo {
    private String user = "user";
    private String p = "";
    private boolean savePsw = false;
    private String serverUrl = "http://192.168.61.8:6888/easWebClient/BOS_CORE";
    private String homePage = "http://192.168.61.8:6888/easWebClient/index.jsp";
    private static final String CONFIG_FILE = "cloud_server.info";
    private HttpClient httpClient;
    private String path = null;
    private static long loadTime = -1L;
    private static CloudServerInfo instance = null;
    private int status = 200;
    private String messageBody = null;

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getHomePage() {
        return this.homePage;
    }

    public boolean login() throws Exception {
        this.login(this.user, this.p);
        return true;
    }

    private void login(String username, String password) throws Exception {
        this.init();
        UTF8PostMethod post = new UTF8PostMethod(this.path);
        post.getParams().setSoTimeout(10000);
        NameValuePair commandP = new NameValuePair("action", "chk");
        NameValuePair userP = new NameValuePair("username", username);
        NameValuePair pswdP = new NameValuePair("password", password);
        post.setRequestBody(new NameValuePair[]{commandP, userP, pswdP});
        try {
            int status = this.httpClient.executeMethod((HttpMethod)post);
            if (status != 200) {
                if (status == 500) {
                    throw new Exception("\u9519\u8bef\u7684\u7528\u6237\u540d\u548c\u5bc6\u7801");
                }
                throw new Exception(post.getResponseBodyAsString());
            }
        }
        catch (ConnectException ex) {
            if (ex.getMessage().indexOf("Connection refused") != -1) {
                this.status = -20001;
                throw new Exception("\u65e0\u6cd5\u8fde\u63a5\u5230\u670d\u52a1\u5668:" + this.serverUrl + ",\u53ef\u80fdcBOS\u670d\u52a1\u5668\u65e0\u542f\u52a8\u6216\u8005\u5730\u5740\u9519\u8bef!", ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            LogTool.logError(post.getResponseBodyAsString(), ex);
            throw ex;
        }
        finally {
            post.releaseConnection();
        }
    }

    private void init() throws Exception {
        if (this.httpClient == null) {
            this.httpClient = new HttpClient();
            URI uri = new URI(this.serverUrl, false);
            this.httpClient.getHostConfiguration().setHost(uri.getHost(), uri.getPort());
            this.path = uri.getPath();
        }
    }

    private CloudServerInfo() {
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getP() {
        return this.p;
    }

    public void setP(String p) {
        this.p = p;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getSessionId() {
        if (this.httpClient == null) {
            return null;
        }
        Cookie[] cookies = this.httpClient.getState().getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!"ASPSESSIONIDQSTQDBBQ".equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static CloudServerInfo getInstance() {
        if (instance != null) {
            return instance;
        }
        File file = null;
        try {
            file = new File(FileLocator.resolve((URL)ToolCommonPlugin.getPlugInURL("/")).getFile(), CONFIG_FILE);
        }
        catch (Exception e) {
            LogTool.logError("\u88c5\u8f7d\u4e91\u4fe1\u606f\u65f6\u51fa\u9519", e);
        }
        return CloudServerInfo.getInstance(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloudServerInfo getInstance(File configFile) {
        block6: {
            String homePage;
            if (instance != null && configFile != null && configFile.lastModified() == loadTime) break block6;
            instance = new CloudServerInfo();
            if (configFile == null || !configFile.exists()) break block6;
            Properties prop = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(configFile);
                prop.load(fileInputStream);
            }
            catch (Exception e) {
                try {
                    LogTool.logError("\u88c5\u8f7d\u4e91\u4fe1\u606f\u65f6\u51fa\u9519", e);
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileInputStream);
                    throw throwable;
                }
                FileUtils.close(fileInputStream);
            }
            FileUtils.close(fileInputStream);
            loadTime = configFile.lastModified();
            String serverUrl = prop.getProperty("serverUrl");
            if (!StringUtils.isEmpty((String)serverUrl)) {
                CloudServerInfo.instance.serverUrl = serverUrl;
            }
            if (!StringUtils.isEmpty((String)(homePage = prop.getProperty("homePage")))) {
                CloudServerInfo.instance.homePage = homePage;
            }
            CloudServerInfo.instance.user = ToolSetting.getCloudComUser();
            CloudServerInfo.instance.p = ToolSetting.getCloudComP();
            CloudServerInfo.instance.savePsw = !StringUtils.isEmpty((String)CloudServerInfo.instance.p);
        }
        return instance;
    }

    public void store() throws Exception {
        File file = new File(FileLocator.resolve((URL)ToolCommonPlugin.getPlugInURL("/")).getFile(), CONFIG_FILE);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        ToolSetting.setCloudComUser(this.user);
        if (this.savePsw) {
            ToolSetting.setCloudComP(this.p);
        } else {
            ToolSetting.setCloudComP("");
        }
    }

    public boolean isSavePsw() {
        return this.savePsw;
    }

    public void setSavePsw(boolean savePsw) {
        this.savePsw = savePsw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillProjectInfo(CloudAppServerInfo appInfo) throws Exception {
        this.login(appInfo.getLoginInfo().getServerUser(), appInfo.getLoginInfo().getServerP());
        boolean exists = false;
        String[] projs = this.listProjects();
        String projectName = appInfo.getProjectName();
        for (int i = 0; i < projs.length; ++i) {
            if (!projs[i].startsWith(projectName + ":")) continue;
            exists = true;
            break;
        }
        if (!exists) {
            throw new Exception("\u5f53\u524d\u7528\u6237[" + appInfo.getLoginInfo().getServerUser() + "]\u6ca1\u6709\u9879\u76ee\u6743\u9650[" + projectName + "]");
        }
        GetMethod get = new GetMethod(this.path + "?action=getProjectInfo&projid=" + URIUtil.encodeAll((String)appInfo.getProjectName()));
        get.getParams().setSoTimeout(10000);
        try {
            this.status = this.httpClient.executeMethod((HttpMethod)get);
            if (this.status != 200) {
                this.messageBody = get.getResponseBodyAsString();
                throw new Exception(this.messageBody);
            }
            String ip = get.getResponseBodyAsString();
            appInfo.setServerUrl(ip);
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listProjects() throws Exception {
        GetMethod get = new GetMethod(this.path + "?action=listProjects");
        get.getParams().setSoTimeout(10000);
        try {
            this.status = this.httpClient.executeMethod((HttpMethod)get);
            if (this.status != 200) {
                this.messageBody = get.getResponseBodyAsString();
                throw new Exception(this.messageBody);
            }
            String body = get.getResponseBodyAsString();
            String[] stringArray = StringUtils.split((String)body, (String)"\n");
            return stringArray;
        }
        finally {
            get.releaseConnection();
        }
    }

    public String getToolUpdateUrl() throws Exception {
        this.init();
        GetMethod get = new GetMethod(this.path + "?action=getToolUpdateUrl");
        get.getParams().setSoTimeout(10000);
        try {
            String body;
            this.status = this.httpClient.executeMethod((HttpMethod)get);
            if (this.status != 200) {
                this.messageBody = get.getResponseBodyAsString();
                throw new Exception(this.messageBody);
            }
            String string = body = get.getResponseBodyAsString();
            return string;
        }
        catch (ConnectException ex) {
            throw new Exception("\u670d\u52a1\u5668\u8fde\u63a5\u4e0d\u4e0a,\u53ef\u80fd\u662fCBOS\u6682\u65f6\u4e0d\u53ef\u7528\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", ex);
        }
        finally {
            get.releaseConnection();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessageBody() {
        return this.messageBody;
    }
}

