/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud;

import com.kingdee.bos.cloud.CloudAppServerInfo;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Properties;

public class ServerExceptionHelper {
    public static final String KEY_MSG_CONTENT = "MSG_CONTENT";
    public static final String MSG_CONTENT_PREFIX = "<MSG>";
    public static final String MSG_CONTENT_SUFFIX = "</MSG>";
    private static final String CONFIG_FILE = "configs/error_code.lst";
    private Properties prop = new Properties();
    private static ServerExceptionHelper instance;
    private static final String VAR_PREFIX = "#{";
    private static final String VAR_SUFFIX = "}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerExceptionHelper getInstance() {
        Class<ServerExceptionHelper> clazz = ServerExceptionHelper.class;
        synchronized (ServerExceptionHelper.class) {
            if (instance == null) {
                instance = new ServerExceptionHelper();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ServerExceptionHelper() {
        InputStream resourceAsStream = null;
        try {
            resourceAsStream = ServerExceptionHelper.class.getResourceAsStream(CONFIG_FILE);
            this.prop.load(resourceAsStream);
        }
        catch (IOException e) {
            LogTool.logError("\u52a0\u8f7d\u5f02\u5e38\u4fe1\u606f\u65f6\u51fa\u9519", e);
        }
        finally {
            FileUtils.close(resourceAsStream);
        }
    }

    public Exception wrapException(CloudAppServerInfo info, String oper, Throwable t) {
        String status = String.valueOf(info.getStatus());
        String value = this.prop.getProperty(status);
        if (value != null) {
            return new Exception(this.parseMessage(info, value), t);
        }
        if (t != null && t.getMessage() != null) {
            String msg = t.getMessage();
            if (msg.indexOf("Connection refused") != -1) {
                return new Exception("\u670d\u52a1\u5668\u62d2\u7edd\u8fde\u63a5\uff0c\u53ef\u80fd\u670d\u52a1\u5668\u672a\u542f\u52a8!", t);
            }
            if (msg.indexOf("Connection reset") != -1) {
                return new Exception("\u8fde\u63a5\u88ab\u91cd\u7f6e\uff0c\u53ef\u80fd\u7f51\u7edc\u670d\u52a1\u6682\u65f6\u4e0d\u53ef\u7528\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!", t);
            }
            String m = this.getMessageSegment(msg, MSG_CONTENT_PREFIX, MSG_CONTENT_SUFFIX);
            if (StringUtils.isEmpty((String)m)) {
                m = this.getMessageSegment(msg, "<P>", "</P>");
            }
            return new Exception("\u6267\u884c[" + oper + "]\u65f6\u53d1\u751f\u9519\u8bef:" + m, t);
        }
        String messageBody = info.getMessageBody();
        if (StringUtils.isEmpty((String)messageBody)) {
            messageBody = "\u9519\u8bef\u7801\uff1a" + status;
        }
        return new Exception("\u6267\u884c[" + oper + "]\u65f6\u53d1\u751f\u9519\u8bef," + messageBody, t);
    }

    private String parseMessage(CloudAppServerInfo info, String value) {
        int eIndex;
        assert (value != null);
        StringBuffer sb = new StringBuffer();
        sb.append(value);
        int sIndex = sb.indexOf(VAR_PREFIX);
        while (sIndex != -1 && (eIndex = sb.indexOf(VAR_SUFFIX, sIndex + 2)) != -1) {
            String key = sb.substring(sIndex + 2, eIndex);
            String str = null;
            str = KEY_MSG_CONTENT.equals(key) ? this.getMessageSegment(info.getMessageBody(), MSG_CONTENT_PREFIX, MSG_CONTENT_SUFFIX) : this.getExpressionValue(info, key);
            if (str == null) {
                str = "";
            }
            sb.replace(sIndex, eIndex + 1, str);
            sIndex = sb.indexOf(VAR_PREFIX);
        }
        return sb.toString();
    }

    private String getExpressionValue(CloudAppServerInfo info, String expression) {
        String[] exps = StringUtils.split((String)expression, (String)".");
        Object obj = info;
        for (int i = 0; i < exps.length; ++i) {
            Method m = ServerExceptionHelper.findMethodByProperty(obj, exps[i]);
            if (m == null) {
                return "";
            }
            try {
                obj = m.invoke(obj, null);
                continue;
            }
            catch (Throwable t) {
                return "";
            }
        }
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }

    private static Method findMethodByProperty(Object obj, String propertyName) {
        if (StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        if (obj == null) {
            return null;
        }
        propertyName = propertyName.toLowerCase(Locale.ENGLISH);
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String mName;
            int index;
            Method m = methods[i];
            if (m.getParameterTypes() != null && m.getParameterTypes().length > 0 || (index = (mName = m.getName().toLowerCase(Locale.ENGLISH)).indexOf(propertyName)) == -1) continue;
            if (propertyName.equalsIgnoreCase(mName)) {
                return m;
            }
            if (index == 3 && mName.startsWith("get")) {
                return m;
            }
            if (index != 2 || !mName.startsWith("is")) continue;
            return m;
        }
        return null;
    }

    private String getMessageSegment(String message, String prefix, String suffix) {
        if (StringUtils.isEmpty((String)message)) {
            return "";
        }
        int sIndex = message.indexOf(prefix);
        if (sIndex == -1) {
            return message;
        }
        sIndex += prefix.length();
        int eIndex = message.indexOf(suffix);
        if (eIndex == -1) {
            return message;
        }
        return message.substring(sIndex, eIndex);
    }

    public static void main(String[] args) throws Exception {
        String s = "test";
        Method m = ServerExceptionHelper.findMethodByProperty(s, "length");
        m = ServerExceptionHelper.findMethodByProperty(s, "bytes");
    }
}

