/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.adapter;

import com.kingdee.bos.cloud.CloudAppServerInfo;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.IMDResource;
import com.kingdee.bos.md.mdfs.RemoteFSInfo;
import com.kingdee.bos.md.mdfs.RemoteFSInfoCollection;
import com.kingdee.bos.tool.LogTool;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class MDPropertySource
implements IPropertySource {
    private IMDObject mdObject = null;
    private static final String INFO_CATEGORY = "\u4fe1\u606f";
    private static final String DESCRIPTION_ID_NAME = "DESCRIPTION_ID_NAME";
    private static final String DESCRIPTION_ID_PATH = "DESCRIPTION_ID_PATH";
    private static final String DESCRIPTION_ID_LOCATION = "DESCRIPTION_ID_LOCATION";
    private static final String DESCRIPTION_ID_FILEPATH = "DESCRIPTION_ID_FILEPATH";
    private static final String DESCRIPTION_ID_MODIFIED = "DESCRIPTION_ID_MODIFIED";
    private static final String DESCRIPTION_ID_MODIFYTIME = "DESCRIPTION_ID_MODIFYTIME";
    private static final String DESCRIPTION_ID_LOGINUSER = "DESCRIPTION_ID_LOGINUSER";
    private static final String DESCRIPTION_ID_MODIFYUSER = "DESCRIPTION_ID_MODIFYUSER";
    private static final String DESCRIPTION_ID_DEPLOYTIME = "DESCRIPTION_ID_DEPLOYTIME";
    private static final String DESCRIPTION_ID_CREATOR = "DESCRIPTION_ID_CREATOR";
    private static final String DESCRIPTION_ID_CREATETIME = "DESCRIPTION_ID_CREATETIME";
    PropertyDescriptor[] descriptors = new PropertyDescriptor[]{new TextPropertyDescriptor((Object)"DESCRIPTION_ID_NAME", "\u540d\u79f0"), new TextPropertyDescriptor((Object)"DESCRIPTION_ID_PATH", "\u5305\u540d"), null, new PropertyDescriptor((Object)"DESCRIPTION_ID_MODIFIED", "\u4fee\u6539\u7c7b\u578b"), new PropertyDescriptor((Object)"DESCRIPTION_ID_MODIFYTIME", "\u4e0a\u6b21\u4fee\u6539\u65f6\u95f4"), new PropertyDescriptor((Object)"DESCRIPTION_ID_LOCATION", "\u4f4d\u7f6e")};
    private static final TextPropertyDescriptor TPD_NAME = new TextPropertyDescriptor((Object)"DESCRIPTION_ID_NAME", "\u540d\u79f0");
    private static final PropertyDescriptor CPD_LOCATION = new PropertyDescriptor((Object)"DESCRIPTION_ID_LOCATION", "\u4f4d\u7f6e");
    private static final PropertyDescriptor CPD_LOGINUSER = new PropertyDescriptor((Object)"DESCRIPTION_ID_LOGINUSER", "\u5f53\u524d\u7528\u6237");
    private static final TextPropertyDescriptor TPD_FILEPATH = new TextPropertyDescriptor((Object)"DESCRIPTION_ID_FILEPATH", "\u8def\u5f84");
    private static final TextPropertyDescriptor TPD_PATH = new TextPropertyDescriptor((Object)"DESCRIPTION_ID_PATH", "\u5305\u540d");
    private static final PropertyDescriptor CPD_MODIFIED = new PropertyDescriptor((Object)"DESCRIPTION_ID_MODIFIED", "\u4fee\u6539\u7c7b\u578b");
    private static final PropertyDescriptor CPD_MODIFYTIME = new PropertyDescriptor((Object)"DESCRIPTION_ID_MODIFYTIME", "\u4e0a\u6b21\u4fee\u6539\u65f6\u95f4");
    private static final PropertyDescriptor CPD_MODIFYUSER = new PropertyDescriptor((Object)"DESCRIPTION_ID_MODIFYUSER", "\u5f53\u524d\u9501\u5b9a\u4eba");
    private static final PropertyDescriptor CPD_DEPLOYTIME = new PropertyDescriptor((Object)"DESCRIPTION_ID_DEPLOYTIME", "\u53d1\u5e03\u65f6\u95f4");
    private static final PropertyDescriptor CPD_CREATOR = new PropertyDescriptor((Object)"DESCRIPTION_ID_CREATOR", "\u521b\u5efa\u4eba");
    private static final PropertyDescriptor CPD_CREATETIME = new PropertyDescriptor((Object)"DESCRIPTION_ID_CREATETIME", "\u521b\u5efa\u65f6\u95f4");
    private SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2");

    public MDPropertySource(IMDObject object) {
        this.mdObject = object;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.mdObject instanceof IMDProject) {
            list.add(TPD_NAME);
            list.add(CPD_LOCATION);
        } else {
            list.add(TPD_NAME);
            list.add(TPD_PATH);
            list.add(CPD_MODIFIED);
            list.add(CPD_MODIFYTIME);
            list.add(CPD_LOCATION);
            IMDResource resource = (IMDResource)this.mdObject;
            IMDProject project = resource.getMDProject();
            File[] libs = project.getLibFiles(resource.getPath());
            TextPropertyDescriptor desc = null;
            if (libs == null) {
                desc = new TextPropertyDescriptor((Object)DESCRIPTION_ID_FILEPATH, "\u8def\u5f84");
            } else if (libs.length == 1 && !resource.toFile().exists()) {
                desc = new TextPropertyDescriptor((Object)DESCRIPTION_ID_FILEPATH, "\u8def\u5f84");
            } else {
                String[] paths = null;
                if (!resource.toFile().exists()) {
                    paths = new String[libs.length];
                    for (int i = 0; i < paths.length; ++i) {
                        paths[i] = libs[i].getName();
                    }
                } else {
                    paths = new String[libs.length + 1];
                    paths[0] = resource.toFile().getAbsolutePath();
                    for (int i = 1; i < paths.length; ++i) {
                        paths[i] = libs[i - 1].getName();
                    }
                }
                desc = new ComboBoxPropertyDescriptor((Object)DESCRIPTION_ID_FILEPATH, "\u8def\u5f84", paths);
            }
            desc.setCategory(INFO_CATEGORY);
            list.add(1, desc);
        }
        return list.toArray(new IPropertyDescriptor[list.size()]);
    }

    public Object getPropertyValue(Object id) {
        if (this.mdObject instanceof IMDProject) {
            IMDProject project = (IMDProject)this.mdObject;
            if (id.equals(DESCRIPTION_ID_NAME)) {
                return project.getName();
            }
            if (id.equals(DESCRIPTION_ID_LOCATION)) {
                return project.toFile().getAbsolutePath();
            }
            if (id.equals(DESCRIPTION_ID_LOGINUSER)) {
                try {
                    return CloudAppServerInfo.getInstance(project).getLoginInfo().getServerUser();
                }
                catch (Exception e) {
                    LogTool.debug("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u65f6\u51fa\u9519", e);
                    return "ERROR";
                }
            }
        } else {
            IMDResource resource = (IMDResource)this.mdObject;
            if (id.equals(DESCRIPTION_ID_NAME)) {
                return resource.getName();
            }
            if (id.equals(DESCRIPTION_ID_PATH)) {
                if (resource instanceof IMDFolder) {
                    return ((IMDFolder)resource).getPackageName();
                }
                return ((IMDFile)resource).getMetaDataPK().getFullName();
            }
            if (id.equals(DESCRIPTION_ID_MODIFIED)) {
                String type = null;
                type = resource.isInLib() && resource.toFile().exists() ? "\u4eceLIB\u4e2d\u4fee\u6539" : (!resource.isInLib() && resource.toFile().exists() ? "\u7528\u6237\u65b0\u589e" : "\u65e0\u4fee\u6539");
                return type;
            }
            if (id.equals(DESCRIPTION_ID_MODIFYTIME)) {
                if (resource.lastModified() == -1L) {
                    return "\u672a\u4fee\u6539";
                }
                return this.df.format(new Date(resource.lastModified()));
            }
            if (id.equals(DESCRIPTION_ID_LOCATION)) {
                String s = "";
                File[] libs = resource.getMDProject().getLibFiles(resource.getPath());
                if (libs != null) {
                    s = "JAR\u5305";
                    if (libs.length > 1) {
                        s = s + "(\u591a\u4e2a)";
                    }
                }
                if (resource.toFile().exists()) {
                    if (s.length() > 0) {
                        s = s + "\uff0c";
                    }
                    s = s + "\u6587\u4ef6";
                }
                return s;
            }
            if (id.equals(DESCRIPTION_ID_FILEPATH)) {
                File[] libs = resource.getMDProject().getLibFiles(resource.getPath());
                if (libs == null) {
                    return resource.toFile().getAbsolutePath();
                }
                if (libs.length == 1 && !resource.toFile().exists()) {
                    return libs[0].getName();
                }
                return new Integer(0);
            }
            if (id.equals(DESCRIPTION_ID_MODIFYUSER)) {
                RemoteFSInfo info = RemoteFSInfoCollection.get(this.mdObject.getMDProject()).getRemoteFSInfo(((IMDFile)this.mdObject).getPath());
                return info == null ? "" : info.getCheckOutUser();
            }
            if (id.equals(DESCRIPTION_ID_DEPLOYTIME)) {
                RemoteFSInfo info = RemoteFSInfoCollection.get(this.mdObject.getMDProject()).getRemoteFSInfo(((IMDFile)this.mdObject).getPath());
                long time = info == null ? 0L : info.getDeployTime();
                return this.df.format(new Date(time));
            }
            if (id.equals(DESCRIPTION_ID_CREATOR)) {
                RemoteFSInfo info = RemoteFSInfoCollection.get(this.mdObject.getMDProject()).getRemoteFSInfo(((IMDFile)this.mdObject).getPath());
                return info == null ? "" : info.getCreator();
            }
            if (id.equals(DESCRIPTION_ID_CREATETIME)) {
                RemoteFSInfo info = RemoteFSInfoCollection.get(this.mdObject.getMDProject()).getRemoteFSInfo(((IMDFile)this.mdObject).getPath());
                long time = info == null ? 0L : info.getCreateTime();
                return this.df.format(new Date(time));
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public Object getEditableValue() {
        return null;
    }

    public String toString() {
        return this.mdObject.getName();
    }

    static {
        TPD_NAME.setCategory(INFO_CATEGORY);
        CPD_LOCATION.setCategory(INFO_CATEGORY);
        CPD_LOGINUSER.setCategory(INFO_CATEGORY);
        TPD_FILEPATH.setCategory(INFO_CATEGORY);
        TPD_PATH.setCategory(INFO_CATEGORY);
        CPD_MODIFIED.setCategory(INFO_CATEGORY);
        CPD_MODIFYTIME.setCategory(INFO_CATEGORY);
    }
}

