/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.cache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ZipChildInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String path;
    private boolean isDirectory = false;
    private ZipChildInfo root = null;
    private Map rootMap = null;
    private ZipChildInfo[] children;

    public ZipChildInfo(ZipChildInfo root, String path, boolean isDirectory) {
        this.root = root;
        this.path = path;
        this.isDirectory = isDirectory;
        if (root == null) {
            this.rootMap = new HashMap();
        } else {
            root.register(this);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void addChild(ZipChildInfo child) {
        if (this.children == null) {
            this.children = new ZipChildInfo[]{child};
        } else {
            ZipChildInfo[] n = new ZipChildInfo[this.children.length + 1];
            System.arraycopy(this.children, 0, n, 0, this.children.length);
            n[n.length - 1] = child;
            this.children = n;
        }
    }

    public ZipChildInfo getRootChild(String path) {
        Map map = this.root == null ? this.rootMap : this.root.rootMap;
        return (ZipChildInfo)map.get(path);
    }

    public ZipChildInfo[] listChildren(String path) {
        ZipChildInfo[] cc = null;
        if (path.equals(this.path)) {
            cc = this.children;
        } else {
            ZipChildInfo info = this.getRootChild(path);
            if (info != null) {
                cc = info.children;
            }
        }
        if (cc != null) {
            ZipChildInfo[] n = new ZipChildInfo[cc.length];
            System.arraycopy(cc, 0, n, 0, cc.length);
            return n;
        }
        return new ZipChildInfo[0];
    }

    private void register(ZipChildInfo info) {
        this.rootMap.put(info.getPath(), info);
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }
}

