/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.mdfs;

import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.IMDResource;
import com.kingdee.bos.md.mdfs.MDFolder;
import com.kingdee.bos.md.mdfs.MDObject;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.Iterator;

public abstract class MDResource
extends MDObject
implements IMDResource,
Comparable {
    protected final String path;
    protected IMDProject project;
    private String name = "";

    protected MDResource(IMDProject project, String path) {
        this(project, path, null);
    }

    protected MDResource(IMDProject project, String path, Iterator zipIter) {
        this.project = project;
        this.path = path;
        String[] parts = path.split("/");
        this.name = parts[parts.length - 1];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IMDFolder getParent() {
        int index;
        if (StringUtils.isEmpty((String)this.path)) {
            return null;
        }
        String pPath = this.path;
        if (pPath.endsWith("/")) {
            pPath = pPath.substring(0, pPath.length() - 1);
        }
        if ((index = pPath.lastIndexOf(47)) == -1) {
            return this.project.getRoot();
        }
        pPath = pPath.substring(0, index);
        MDFolder parent = new MDFolder(this.project, pPath + "/");
        return parent;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public IMDProject getMDProject() {
        return this.project;
    }

    @Override
    public boolean exists() {
        return !this.project.isDisposed() && this.project.exists(this.path);
    }

    public int compareTo(Object o) {
        MDResource obj = (MDResource)o;
        if (this instanceof IMDFolder && obj instanceof IMDFile) {
            return -1;
        }
        if (this instanceof IMDFile && obj instanceof IMDFolder) {
            return 1;
        }
        if (this instanceof IMDFile && obj instanceof IMDFile) {
            if (((IMDFile)((Object)this)).getExtension().equals(((IMDFile)((Object)obj)).getExtension())) {
                return this.path.compareTo(obj.path);
            }
            return ((IMDFile)((Object)this)).getExtension().compareTo(((IMDFile)((Object)obj)).getExtension());
        }
        return this.path.compareTo(obj.path);
    }

    @Override
    public File toFile() {
        return this.project.getMDFile(this.path);
    }

    @Override
    public boolean isModified() {
        return this.project.isModified(this.path);
    }

    @Override
    public long lastModified() {
        File file = this.toFile();
        if (file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MDResource)) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        MDResource o = (MDResource)other;
        return this.project.equals(o.project) && this.getPath().equals(o.getPath());
    }

    @Override
    public boolean isInLib() {
        return !this.project.isDisposed() && this.project.getLibFiles(this.path) != null;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.getPath();
    }

    @Override
    public boolean isRemote() {
        return false;
    }
}

