/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.mdfs;

import com.kingdee.bos.tool.LogTool;
import com.kingdee.util.StringUtils;
import java.util.Properties;
import org.jdom2.Element;

public class RemoteFSInfo {
    private String path;
    private String md5;
    private String checkOutUser;
    private String lastModifyUser;
    private String creator;
    private long lastModifyTime;
    private long deployTime;
    private long createTime;
    private String alias;
    public static String DEF_ALIAS_KEY = "alias_l2";

    public static RemoteFSInfo newDir(String path) {
        RemoteFSInfo info = new RemoteFSInfo(path);
        return info;
    }

    public void loadFromDOM(Element el) {
        this.path = el.getAttributeValue("path");
        this.md5 = el.getAttributeValue("md5");
        this.alias = el.getAttributeValue("alias");
        this.checkOutUser = el.getAttributeValue("checkoutuser");
        this.creator = el.getAttributeValue("creator");
        this.lastModifyUser = el.getAttributeValue("lastmodifyuser");
        try {
            this.createTime = Long.parseLong(el.getAttributeValue("createtime"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.deployTime = Long.parseLong(el.getAttributeValue("deploytime"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.lastModifyTime = Long.parseLong(el.getAttributeValue("lastmodifytime"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    RemoteFSInfo(String path) {
        this.path = path;
    }

    public RemoteFSInfo(String path, Properties prop) {
        this.path = path;
        this.md5 = prop.getProperty("md5");
        this.checkOutUser = prop.getProperty("checkoutuser");
        this.lastModifyUser = prop.getProperty("lastmodifyuser");
        this.creator = prop.getProperty("creator");
        this.alias = prop.getProperty("alias");
        String time = prop.getProperty("lastmodifytime");
        try {
            this.lastModifyTime = Long.parseLong(time);
        }
        catch (Exception ex) {
            LogTool.logError("error", ex);
        }
        time = prop.getProperty("deploytime");
        try {
            this.deployTime = Long.parseLong(time);
        }
        catch (Exception ex) {
            LogTool.logError("error", ex);
        }
        time = prop.getProperty("createtime");
        try {
            this.createTime = Long.parseLong(time);
        }
        catch (Exception ex) {
            LogTool.logError("error", ex);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public boolean isDirecotry() {
        return StringUtils.isEmpty((String)this.path) || this.path.endsWith("/");
    }

    public String getCheckOutUser() {
        return this.checkOutUser;
    }

    public void setCheckOutUser(String checkOutUser) {
        this.checkOutUser = checkOutUser;
    }

    public String getLastModifyUser() {
        return this.lastModifyUser;
    }

    public void setLastModifyUser(String lastModifyUser) {
        this.lastModifyUser = lastModifyUser;
    }

    public long getLastModifyTime() {
        return this.lastModifyTime;
    }

    public void setLastModifyTime(long lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    public long getDeployTime() {
        return this.deployTime;
    }

    public void setDeployTime(long deployTime) {
        this.deployTime = deployTime;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RemoteFSInfo)) {
            return false;
        }
        RemoteFSInfo other = (RemoteFSInfo)obj;
        if (!this.path.equals(other.path)) {
            return false;
        }
        if (this.getAlias() != null ? !this.getAlias().equals(other.getAlias()) : other.getAlias() != null) {
            return false;
        }
        if (this.md5 != null) {
            return this.md5.equals(other.md5);
        }
        return other.md5 == null;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.path.hashCode();
        return result;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }
}

