/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.tools;

import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.md.cache.MDSimpleObject;
import com.kingdee.bos.md.dao.MDORMUtil;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.code.CodeFactory;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BizMetadataUtil {
    public static final int FLAG_EXCLUDE_RESOURCE = 1;
    public static final int FLAG_EXCLUDE_ENUM = 2;
    public static final int FLAG_EXCLUDE_LIB = 4;
    public static final int FLAG_INCLUDE_ALL_RELATE = 8;

    public static IMDFile[] getRelateMetas(IMDObject[] objects, boolean fordel, boolean onlySrc) {
        int flag = 0;
        if (fordel) {
            flag = flag | 1 | 2;
        }
        if (onlySrc) {
            flag |= 4;
        }
        return BizMetadataUtil.getRelateMetas(objects, flag);
    }

    public static IMDFile[] getBizRelateMetas(IMDFile bizFile, boolean fordel) {
        ArrayList list = new ArrayList();
        BizMetadataUtil.getBizRelateMetas(bizFile, list, fordel);
        return list.toArray(new IMDFile[list.size()]);
    }

    public static IMDFile[] getRelateMetas(IMDObject[] objects, int flag) {
        int i;
        IMDFile[] mdFiles = MDResourceUtil.listChildFiles(objects);
        ArrayList<IMDFile> list = new ArrayList<IMDFile>();
        list.addAll(Arrays.asList(mdFiles));
        for (i = 0; i < mdFiles.length; ++i) {
            BizMetadataUtil.getBizRelateMetas(mdFiles[i], list, flag);
        }
        if ((flag & 4) != 0) {
            for (i = list.size() - 1; i >= 0; --i) {
                IMDFile file = (IMDFile)list.get(i);
                if (file.toFile().exists()) continue;
                list.remove(i);
            }
        }
        return list.toArray(new IMDFile[list.size()]);
    }

    public static void getBizRelateMetas(IMDFile bizFile, List list, int flag) {
        String[] pks;
        IMDFolder folder;
        if (bizFile == null || !bizFile.exists()) {
            return;
        }
        if (!list.contains(bizFile)) {
            list.add(bizFile);
        }
        if (!"bizunit".equals(bizFile.getExtension()) && !"biztemplate".equals(bizFile.getExtension())) {
            return;
        }
        if ("entity".equals(bizFile.getExtension())) {
            BizMetadataUtil.getEntityRelateFiles(bizFile, list, flag);
            return;
        }
        if ("ui".equals(bizFile.getExtension())) {
            BizMetadataUtil.getUIRelateFiles(bizFile, list, flag);
            return;
        }
        MDSimpleObject info = MDORMUtil.getSimpleObject(bizFile);
        IMDFile file = null;
        IMDProject project = bizFile.getMDProject();
        file = BizMetadataUtil.addRelateFile(list, project, info.getPK("entityPK"), MetaDataTypeList.ENTITY);
        BizMetadataUtil.getEntityRelateFiles(file, list, flag);
        file = BizMetadataUtil.addRelateFile(list, project, info.getPK("relatedEntityPK"), MetaDataTypeList.ENTITY);
        BizMetadataUtil.getEntityRelateFiles(file, list, flag);
        String[] extPks = info.getPKS("extendEntityPKs");
        if (extPks != null) {
            for (int i = 0; i < extPks.length; ++i) {
                file = BizMetadataUtil.addRelateFile(list, project, extPks[i], MetaDataTypeList.ENTITY);
                BizMetadataUtil.getEntityRelateFiles(file, list, flag);
            }
        }
        BizMetadataUtil.addRelateFile(list, project, info.getPK("relatedTablePK"), MetaDataTypeList.ABSTRACTTABLE);
        if ((flag & 1) == 0 && !list.contains(file = (folder = bizFile.getParent()).getChildFile("client/" + StringUtils.headCharUpperCase((String)bizFile.getParent().getName()) + "Resource.resource"))) {
            list.add(file);
        }
        file = BizMetadataUtil.addRelateFile(list, project, info.getPK("relatedTreeUI"), MetaDataTypeList.UIOBJECT);
        BizMetadataUtil.getUIRelateFiles(file, list, flag);
        if ("bizunit".equals(bizFile.getExtension())) {
            file = BizMetadataUtil.addRelateFile(list, project, info.getPK("relatedEditUIPK"), MetaDataTypeList.UIOBJECT);
        }
        BizMetadataUtil.getUIRelateFiles(file, list, flag);
        file = BizMetadataUtil.addRelateFile(list, project, info.getPK("tableEditUIPK"), MetaDataTypeList.UIOBJECT);
        BizMetadataUtil.getUIRelateFiles(file, list, flag);
        file = BizMetadataUtil.addRelateFile(list, project, info.getPK("listUIPK"), MetaDataTypeList.UIOBJECT);
        BizMetadataUtil.getUIRelateFiles(file, list, flag);
        file = BizMetadataUtil.addRelateFile(list, project, info.getPK("editUIPK"), MetaDataTypeList.UIOBJECT);
        BizMetadataUtil.getUIRelateFiles(file, list, flag);
        file = BizMetadataUtil.addRelateFile(list, project, info.getPK("webListUIPK"), MetaDataTypeList.WEBUIOBJECT);
        BizMetadataUtil.getUIRelateFiles(file, list, flag);
        file = BizMetadataUtil.addRelateFile(list, project, info.getPK("webEditUIPK"), MetaDataTypeList.WEBUIOBJECT);
        BizMetadataUtil.getUIRelateFiles(file, list, flag);
        BizMetadataUtil.addRelateFile(list, project, info.getPK("entityFunctionPK"), MetaDataTypeList.FUNCTION);
        BizMetadataUtil.addRelateFile(list, project, info.getPK("editUIFunctionPK"), MetaDataTypeList.FUNCTION);
        BizMetadataUtil.addRelateFile(list, project, info.getPK("listUIFunctionPK"), MetaDataTypeList.FUNCTION);
        file = BizMetadataUtil.addRelateFile(list, project, info.getPK("queryPK"), MetaDataTypeList.JOINQUERY);
        if (file != null && (flag & 8) != 0 && (pks = (info = MDORMUtil.getSimpleObject(file)).getPKS("queryEntityRef")) != null) {
            for (int i = 0; i < pks.length; ++i) {
                file = BizMetadataUtil.addRelateFile(list, project, pks[i], MetaDataTypeList.ENTITY);
            }
        }
    }

    public static void getBizRelateMetas(IMDFile bizFile, List list, boolean fordel) {
        int flag = 0;
        if (fordel) {
            flag = 3;
        }
        BizMetadataUtil.getBizRelateMetas(bizFile, list, flag);
    }

    private static void getUIRelateFiles(IMDFile uiFile, List list, int flag) {
        if (uiFile == null || !uiFile.exists()) {
            return;
        }
        if (!list.contains(uiFile)) {
            list.add(uiFile);
        }
        IMDProject project = uiFile.getMDProject();
        MDSimpleObject uiSo = MDORMUtil.getSimpleObject(uiFile);
        BizMetadataUtil.addRelateFile(list, project, uiSo.getPK("ruleSetPK"), MetaDataTypeList.BIZRULESET);
    }

    private static void getEntityRelateFiles(IMDFile entityFile, List list, int flag) {
        int i;
        if (entityFile == null || !entityFile.exists()) {
            return;
        }
        IMDProject project = entityFile.getMDProject();
        MDSimpleObject entitySo = MDORMUtil.getSimpleObject(entityFile);
        if (!list.contains(entityFile)) {
            list.add(entityFile);
        }
        IMDFile file = BizMetadataUtil.addRelateFile(list, project, entitySo.getProperty("tablePK"), MetaDataTypeList.ABSTRACTTABLE);
        if ((2 & flag) == 0) {
            BizMetadataUtil.addRelateFile(list, project, entitySo.getExtendProperty("MutiPageEnumPK"), MetaDataTypeList.BIZENUM);
        }
        String[] pks = entitySo.getPKS("linkprpoertyPKs");
        for (i = 0; i < pks.length; ++i) {
            file = BizMetadataUtil.addRelateFile(list, project, pks[i], MetaDataTypeList.RELATIONSHIP);
            if (file == null) continue;
            MDSimpleObject relateSo = MDORMUtil.getSimpleObject(file);
            if ((8 & flag) == 0 && !"Composition".equalsIgnoreCase(relateSo.getProperty("type"))) continue;
            file = BizMetadataUtil.addRelateFile(list, project, relateSo.getPK("supplierObjectPK"), MetaDataTypeList.ENTITY);
            BizMetadataUtil.getEntityRelateFiles(file, list, flag);
        }
        if ((2 & flag) == 0) {
            pks = entitySo.getPKS("metadataRefs");
            for (i = 0; i < pks.length; ++i) {
                BizMetadataUtil.addRelateFile(list, project, pks[i], MetaDataTypeList.BIZENUM);
            }
            pks = entitySo.getPKS("exceptionPKs");
            for (i = 0; i < pks.length; ++i) {
                BizMetadataUtil.addRelateFile(list, project, pks[i], MetaDataTypeList.BIZEXCEPTION);
            }
        }
    }

    private static IMDFile addRelateFile(List list, IMDProject project, String pk, BOSObjectType type) {
        if (StringUtils.isEmpty((String)pk)) {
            return null;
        }
        String path = StringUtils.replace((String)pk, (String)".", (String)"/");
        path = path + Utils.getMetaDataSuffix((BOSObjectType)type);
        IMDFile file = project.getRoot().getChildFile(path);
        if (!list.contains(file)) {
            list.add(file);
            if (file.exists()) {
                return file;
            }
        }
        return null;
    }

    public static void getGeneratedCodeFiles(List files, IMDFile file) {
        String ext = file.getExtension();
        if ("entity".equalsIgnoreCase(ext)) {
            BizMetadataUtil.getGeneratedCodeFiles4Entity(files, file);
        } else if ("ui".equalsIgnoreCase(ext)) {
            BizMetadataUtil.getGeneratedCodeFiles4UI(files, file);
        } else if ("webui".equalsIgnoreCase(ext)) {
            BizMetadataUtil.getGeneratedCodeFiles4WebUI(files, file);
        }
    }

    private static void getGeneratedCodeFiles4Entity(List files, IMDFile entityFile) {
        if (entityFile == null || !entityFile.exists()) {
            return;
        }
        MDSimpleObject so = MDORMUtil.getSimpleObject(entityFile);
        String bizImplName = so.getProperty("businessImplName");
        String bizControllerName = so.getProperty("businessControllerName");
        if (!StringUtils.isEmpty((String)bizImplName) && !StringUtils.isEmpty((String)bizControllerName)) {
            String packageName = MetaDataUtils.getPackageName((String)bizImplName);
            String className = MetaDataUtils.getClassName((String)bizImplName);
            if (StringUtils.isEmpty((String)packageName)) {
                files.add(new SrcInfo("Abstract" + className + "Info.java", 2));
                files.add(new SrcInfo("" + className + "Info.java", 2));
                files.add(new SrcInfo("I" + className + ".java", 2));
                files.add(new SrcInfo("" + className + ".java", 2));
                files.add(new SrcInfo("" + className + "Agent.java", 2));
                files.add(new SrcInfo("" + className + "Collection.java", 2));
                files.add(new SrcInfo("" + className + "CollectionAgent.java", 2));
                files.add(new SrcInfo("" + className + "Factory.java", 2));
            } else {
                packageName = StringUtils.replace((String)packageName, (String)".", (String)"\\");
                files.add(new SrcInfo(packageName + "\\Abstract" + className + "Info.java", 2));
                files.add(new SrcInfo(packageName + "\\" + className + "Info.java", 2));
                files.add(new SrcInfo(packageName + "\\I" + className + ".java", 2));
                files.add(new SrcInfo(packageName + "\\" + className + ".java", 2));
                files.add(new SrcInfo(packageName + "\\" + className + "Agent.java", 2));
                files.add(new SrcInfo(packageName + "\\" + className + "Collection.java", 2));
                files.add(new SrcInfo(packageName + "\\" + className + "CollectionAgent.java", 2));
                files.add(new SrcInfo(packageName + "\\" + className + "Factory.java", 2));
            }
            packageName = MetaDataUtils.getPackageName((String)bizControllerName);
            className = MetaDataUtils.getClassName((String)bizControllerName);
            if (StringUtils.isEmpty((String)packageName)) {
                files.add(new SrcInfo("Abstract" + className + "Bean.java", 2));
                files.add(new SrcInfo("" + className + "Bean.java", 2));
                files.add(new SrcInfo("" + className + ".java", 2));
                files.add(new SrcInfo("" + className + "Local.java", 2));
                files.add(new SrcInfo("" + className + "LocalHome.java", 2));
                files.add(new SrcInfo("" + className + "Remote.java", 2));
                files.add(new SrcInfo("" + className + "RemoteHome.java", 2));
            } else {
                packageName = StringUtils.replace((String)packageName, (String)".", (String)"\\");
                files.add(new SrcInfo(packageName + "\\Abstract" + className + "Bean.java", 2));
                files.add(new SrcInfo(packageName + "\\" + className + "Bean.java", 2));
                files.add(new SrcInfo(packageName + "\\" + className + ".java", 2));
                files.add(new SrcInfo(packageName + "\\" + className + "Local.java", 2));
                files.add(new SrcInfo(packageName + "\\" + className + "LocalHome.java", 2));
                files.add(new SrcInfo(packageName + "\\" + className + "Remote.java", 2));
                files.add(new SrcInfo(packageName + "\\" + className + "RemoteHome.java", 2));
            }
            packageName = MetaDataUtils.getPackageName((String)bizImplName);
            className = MetaDataUtils.getClassName((String)bizImplName);
            if (!StringUtils.isEmpty((String)packageName)) {
                packageName = StringUtils.replace((String)(packageName + ".web"), (String)".", (String)"\\");
                files.add(new SrcInfo(packageName + "\\Abstract" + className + "Bean.java", 4));
                files.add(new SrcInfo(packageName + "\\" + className + "Bean.java", 4));
            }
        }
    }

    private static void getGeneratedCodeFiles4UI(List files, IMDFile uiFile) {
        if (uiFile == null || !uiFile.exists()) {
            return;
        }
        MDSimpleObject so = MDORMUtil.getSimpleObject(uiFile);
        String packageName = so.getProperty("releasePackage");
        String className = so.getProperty("releaseClass");
        if (!StringUtils.isEmpty((String)className)) {
            className = StringUtils.headCharUpperCase((String)className);
            SolutionInfo solution = uiFile.getMDProject().getSolutionInfo();
            List languageList = BizMetadataUtil.getlanguageList(solution);
            if (StringUtils.isEmpty((String)packageName)) {
                files.add(new SrcInfo("Abstract" + className + ".java", 2));
                files.add(new SrcInfo("" + className + ".java", 2));
                files.add(new SrcInfo("Abstract" + className + ".properties", 2));
                if (languageList != null) {
                    int n = languageList.size();
                    for (int i = 0; i < n; ++i) {
                        files.add(new SrcInfo("Abstract" + className + "_" + languageList.get(i) + ".properties", 2));
                        files.add(new SrcInfo("" + className + "_" + languageList.get(i) + ".properties", 2));
                    }
                }
            } else {
                packageName = StringUtils.replace((String)packageName, (String)".", (String)"\\");
                files.add(new SrcInfo(packageName + "\\Abstract" + className + ".java", 2));
                files.add(new SrcInfo(packageName + "\\" + className + ".java", 2));
                files.add(new SrcInfo(packageName + "\\Abstract" + className + ".properties", 2));
                if (languageList != null) {
                    int n = languageList.size();
                    for (int i = 0; i < n; ++i) {
                        files.add(new SrcInfo(packageName + "\\Abstract" + className + "_" + languageList.get(i) + ".properties", 2));
                        files.add(new SrcInfo(packageName + "\\" + className + "_" + languageList.get(i) + ".properties", 2));
                    }
                }
                if (packageName.endsWith("\\client")) {
                    String appPackageName = packageName.substring(0, packageName.length() - 7) + "\\app";
                    files.add(new SrcInfo(appPackageName + "\\Abstract" + className + "Handler.java", 2));
                    files.add(new SrcInfo(appPackageName + "\\" + className + "Handler.java", 2));
                }
            }
        }
    }

    private static void getGeneratedCodeFiles4WebUI(List files, IMDFile uiFile) {
        block6: {
            List languageList;
            String className;
            String packageName;
            block7: {
                if (uiFile == null || !uiFile.exists()) {
                    return;
                }
                MDSimpleObject so = MDORMUtil.getSimpleObject(uiFile);
                packageName = so.getProperty("releasePackage");
                className = so.getProperty("releaseClass");
                if (StringUtils.isEmpty((String)className)) break block6;
                String fileName = StringUtils.headCharLowerCase((String)className) + ".xhtml";
                String xhtmlPath = CodeFactory.getWebUIShortPackage((String)packageName);
                if (StringUtils.isEmpty((String)xhtmlPath)) {
                    files.add(new SrcInfo(fileName, 8));
                } else {
                    xhtmlPath = StringUtils.replace((String)xhtmlPath, (String)".", (String)"\\");
                    files.add(new SrcInfo(xhtmlPath + "\\" + fileName, 8));
                }
                className = StringUtils.headCharUpperCase((String)className) + "Bean";
                SolutionInfo solution = uiFile.getMDProject().getSolutionInfo();
                languageList = BizMetadataUtil.getlanguageList(solution);
                if (!StringUtils.isEmpty((String)packageName)) break block7;
                files.add(new SrcInfo("Abstract" + className + ".java", 4));
                files.add(new SrcInfo("" + className + ".java", 4));
                if (languageList == null) break block6;
                int n = languageList.size();
                for (int i = 0; i < n; ++i) {
                    files.add(new SrcInfo("Abstract" + className + "_" + languageList.get(i) + ".properties", 4));
                    files.add(new SrcInfo("" + className + "_" + languageList.get(i) + ".properties", 4));
                    files.add(new SrcInfo("" + className + "_User_" + languageList.get(i) + ".properties", 4));
                }
                break block6;
            }
            packageName = StringUtils.replace((String)packageName, (String)".", (String)"\\");
            files.add(new SrcInfo(packageName + "\\Abstract" + className + ".java", 4));
            files.add(new SrcInfo(packageName + "\\" + className + ".java", 4));
            files.add(new SrcInfo(packageName + "\\Abstract" + className + ".properties", 4));
            if (languageList != null) {
                int n = languageList.size();
                for (int i = 0; i < n; ++i) {
                    files.add(new SrcInfo(packageName + "\\Abstract" + className + "_" + languageList.get(i) + ".properties", 4));
                    files.add(new SrcInfo(packageName + "\\" + className + "_" + languageList.get(i) + ".properties", 4));
                    files.add(new SrcInfo(packageName + "\\" + className + "_User_" + languageList.get(i) + ".properties", 4));
                }
            }
        }
    }

    private static List getlanguageList(SolutionInfo solution) {
        if (solution == null) {
            return null;
        }
        ArrayList<String> languageList = new ArrayList<String>();
        LanguageCollection lanCol = solution.getLanguages();
        if (lanCol != null) {
            int n = lanCol.size();
            for (int i = 0; i < n; ++i) {
                languageList.add(StringUtils.headCharLowerCase((String)lanCol.get(i).getPostfix()));
            }
        }
        return languageList;
    }

    public static class SrcInfo {
        public static final int GUI_SRC = 2;
        public static final int WEB_SRC = 4;
        public static final int WEB_ROOT = 8;
        public static final int ALL = 14;
        private int srcType;
        private String file;

        public SrcInfo(String file, int srcType) {
            assert ((0xE & srcType) != 0);
            this.srcType = srcType;
            this.file = file;
        }

        public int getSrcType() {
            return this.srcType;
        }

        public String getFile() {
            return this.file;
        }
    }
}

