/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.ui;

import com.kingdee.bos.md.ui.MDTypeImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class MDImageDescriptor
extends CompositeImageDescriptor {
    public static final int MODEIFIED = 1;
    public static final int LIB = 2;
    public static final int LOCK = 4;
    public static final int EDIT = 8;
    private Image fBaseImage;
    private int fFlags;
    private Point fSize;

    public MDImageDescriptor(Image baseImage, int flags) {
        this.fBaseImage = baseImage;
        this.fFlags = flags;
        Rectangle bounds = baseImage.getBounds();
        this.fSize = new Point(bounds.width, bounds.height);
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.fBaseImage.getImageData();
        this.drawImage(bg, 0, 0);
        Point size = this.getSize();
        if ((this.fFlags & 1) != 0) {
            ImageData data = MDTypeImages.getImage("_modified").getImageData();
            this.drawImage(data, 0, size.y - data.height);
        } else if ((this.fFlags & 2) != 0) {
            ImageData data = MDTypeImages.getImage("_lib").getImageData();
            this.drawImage(data, 0, size.y - data.height);
        } else if ((this.fFlags & 4) != 0) {
            ImageData data = MDTypeImages.getImage("_lock").getImageData();
            this.drawImage(data, size.x - data.width, size.y - data.height);
        } else if ((this.fFlags & 8) != 0) {
            ImageData data = MDTypeImages.getImage("_edit").getImageData();
            this.drawImage(data, size.x - data.width, size.y - data.height);
        }
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (object == null || !MDImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        MDImageDescriptor other = (MDImageDescriptor)((Object)object);
        return this.fBaseImage.equals((Object)other.fBaseImage) && this.fFlags == other.fFlags && this.fSize.equals((Object)other.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }
}

