/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.server.module;

import com.kingdee.bos.tool.function.DynamicBindContext;
import com.kingdee.bos.tool.function.Files;
import com.kingdee.bos.tool.function.Functions;
import java.io.File;
import java.util.HashMap;

public class DownloadConfig
extends HashMap<String, String> {
    private static final long serialVersionUID = 1L;
    public static final String LOCAL_PASSIVE_MODE = "local_passive_mode";
    public static final String SERVER_IP = "server_ip";
    public static final String SERVER_PORT = "server_port";
    public static final String USER_NAME = "user_name";
    public static final String P = "password";
    public static final String TYPE = "type";
    public static final String SOLUTION = "solution";
    public static final String TOOL = "tool";

    public static DownloadConfig newDownloadConfig(String ip, String port, String user, String password, String mode) {
        DownloadConfig config = new DownloadConfig();
        config.put(SERVER_IP, ip);
        config.put(SERVER_PORT, Functions.ifelse(port == null, "10168", port));
        config.put(USER_NAME, user);
        config.put(P, password);
        config.put(LOCAL_PASSIVE_MODE, mode);
        return config;
    }

    public File getLocalSavePath() {
        return Files.ofFile(DownloadConfig.getDownloadCacheDir(), (String)this.get(SERVER_IP), this.getType());
    }

    public static File getDownloadCacheDir() {
        return Files.ofFile(DynamicBindContext.getBindContextVariable("bim_download_cache").toString());
    }

    public String getType() {
        return Functions.nullAsDefault(this.get(TYPE), SOLUTION);
    }
}

