/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public abstract class UIHelper {
    public static Button createButton(Composite parent, int style, String text, int layoutStyle) {
        Button btn = new Button(parent, style);
        if (text != null) {
            btn.setText(text);
        }
        btn.setLayoutData((Object)new GridData(layoutStyle));
        return btn;
    }

    public static Combo createCombo(Composite parent, int style, int gridDataStyle) {
        Combo combo = new Combo(parent, style);
        combo.setLayoutData((Object)new GridData(gridDataStyle));
        return combo;
    }

    public static Button createButton(Composite parent, String text) {
        return UIHelper.createButton(parent, 8, text, 2);
    }

    public static Button createCheckBox(Composite parent, String text) {
        return UIHelper.createButton(parent, 32, text, 6);
    }

    public static Button createRadioBox(Composite parent, String text) {
        return UIHelper.createButton(parent, 16, text, 2);
    }

    public static Text createText(Composite parent) {
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    public static Text createText(Composite parent, int style, int gridDataStyle) {
        Text text = new Text(parent, style);
        text.setLayoutData((Object)new GridData(gridDataStyle));
        return text;
    }

    public static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 3;
        gd.verticalAlignment = 2;
        label.setLayoutData((Object)gd);
        if (text != null) {
            label.setText(text);
        }
        return label;
    }

    public static Label createSeparator(Composite parent, int hSpan) {
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = hSpan;
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)gridData);
        return separator;
    }

    public static Label createLabelLeft(Composite parent, String text) {
        Label label = new Label(parent, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.verticalAlignment = 2;
        label.setLayoutData((Object)gd);
        if (text != null) {
            label.setText(text);
        }
        return label;
    }

    public static Label createLabel(Composite parent, String text, int gridDataStyle) {
        Label label = new Label(parent, 0);
        GridData gd = new GridData(gridDataStyle);
        label.setLayoutData((Object)gd);
        if (text != null) {
            label.setText(text);
        }
        return label;
    }

    public static List createList(Composite parent, int style, int gridDataStyle) {
        List list = new List(parent, style);
        GridData gd = new GridData(gridDataStyle);
        list.setLayoutData((Object)gd);
        return list;
    }

    public static Group createGroup(Composite parent, String text, int gridDataStyle, int horizontalSpan, int columnSize) {
        return UIHelper.createGroup(parent, text, gridDataStyle, horizontalSpan, columnSize, false);
    }

    public static Group createGroup(Composite parent, String text, int gridDataStyle, int horizontalSpan, int columnSize, boolean equalColumns) {
        Group group = new Group(parent, 0);
        if (text != null) {
            group.setText(text);
        }
        GridData data = new GridData(gridDataStyle);
        data.horizontalSpan = horizontalSpan;
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new GridLayout(columnSize, equalColumns));
        return group;
    }

    public static Composite createPanel(Composite parent, int gridDataStyle, int horizontalSpan, int columnSize) {
        return UIHelper.createPanel(parent, gridDataStyle, horizontalSpan, columnSize, false);
    }

    public static Composite createPanel(Composite parent, int gridDataStyle, int horizontalSpan, int columnSize, boolean equlasColumn) {
        Composite comp = new Composite(parent, 0);
        GridData data = new GridData(gridDataStyle);
        data.horizontalSpan = horizontalSpan;
        comp.setLayoutData((Object)data);
        comp.setLayout((Layout)new GridLayout(columnSize, equlasColumn));
        return comp;
    }

    public static void setHSpan(Control comp, int hspan) {
        if (comp.getLayoutData() instanceof GridData) {
            GridData data = (GridData)comp.getLayoutData();
            data.horizontalSpan = hspan;
            comp.setLayoutData((Object)data);
        }
    }

    public static void setWidth(Control comp, int width) {
        if (comp.getLayoutData() instanceof GridData) {
            GridData data = (GridData)comp.getLayoutData();
            data.widthHint = width;
            comp.setLayoutData((Object)data);
        }
    }

    public static void setHeight(Control comp, int height) {
        if (comp.getLayoutData() instanceof GridData) {
            GridData data = (GridData)comp.getLayoutData();
            data.heightHint = height;
            comp.setLayoutData((Object)data);
        }
    }

    public static void setLayoutSpacing(Composite comp, int vSpacing, int hSpacing, int marginWidht, int marginHeight) {
        GridLayout layout = (GridLayout)comp.getLayout();
        layout.verticalSpacing = vSpacing;
        layout.horizontalSpacing = hSpacing;
        layout.marginHeight = marginHeight;
        layout.marginWidth = marginWidht;
        comp.setLayout((Layout)layout);
    }
}

