/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.actions;

import com.kingdee.bos.engine.DevMDException;
import com.kingdee.bos.engine.MDSaveException;
import com.kingdee.bos.md.actions.base.BaseMDResourceAction;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.IMDResource;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.actions.Messages;
import com.kingdee.bos.tool.actions.WorkbenchRunnableAdapter;
import com.kingdee.bos.tool.utils.EditorHelper;
import com.kingdee.bos.tool.utils.ToolCommonImages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.undo.DeleteResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class DeleteAction
extends BaseMDResourceAction {
    public DeleteAction() {
        super(15);
        this.setText(Messages.DeleteAction_ShanChu);
        this.setAccelerator(127);
        this.setImageDescriptor(ToolCommonImages.getImageDescriptor("delete.gif"));
    }

    @Override
    protected boolean checkBiz(IMDObject[] resources) {
        if (resources.length > 1) {
            for (IMDObject obj : resources) {
                if (!(obj instanceof IMDProject)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void run(final IMDObject[] res) {
        if (!this.confirmDelete(res)) {
            return;
        }
        IMDFile[] files = MDResourceUtil.listChildFiles(res);
        IWorkbenchPage page = this.getSite().getPage();
        for (int i = 0; i < files.length; ++i) {
            IEditorPart part = EditorHelper.findEditor(files[i]);
            if (part == null) continue;
            page.closeEditor(part, false);
        }
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    IMDObject[] rs = MDResourceUtil.getTopResources(res);
                    for (int i = 0; i < rs.length; ++i) {
                        DeleteAction.this.deleteSelectedResource(rs[i], monitor);
                    }
                    MDResourceUtil.fireResourceDeleted(rs);
                }
                catch (Exception ex) {
                    LogTool.logError("\u5220\u9664\u9519\u8bef", ex);
                    MessageDialog.openConfirm((Shell)DeleteAction.this.getShell(), (String)"\u5220\u9664\u9519\u8bef", (String)"\u5220\u9664\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u4ee5\u83b7\u5f97\u8fdb\u4e00\u6b65\u4fe1\u606f");
                }
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, monitor);
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation));
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.DeleteAction_ShanChuCuoWu, (String)Messages.DeleteAction_CuoWuChanShengZaiShanChuDeGuoChengZhongQingJianChaRiZhi);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean confirmDelete(IMDObject[] resources) {
        String title = Messages.DeleteAction_QueRenShanChu;
        String label = Messages.DeleteAction_QueRenYaoShanChu + resources.length + Messages.DeleteAction_GeXuanZeDeZiYuanMa;
        String warnLabel = "\u786e\u8ba4\u8981\u5220\u9664\u89e3\u51b3\u65b9\u6848 ";
        boolean isDeleteSolution = false;
        for (IMDObject obj : resources) {
            if (!(obj instanceof IMDProject)) continue;
            warnLabel = warnLabel + obj.getMDProject().getName();
            isDeleteSolution = true;
        }
        warnLabel = warnLabel + " \u5417?\n\u6ce8\u610f,\u8be5\u64cd\u4f5c\u5c06\u540c\u65f6\u5220\u9664\u89e3\u51b3\u65b9\u6848\u4e2d\u7684\u6587\u4ef6\u53ca\u76ee\u5f55.";
        MessageDialog deleteDialog = new MessageDialog(this.getShell(), title, null, isDeleteSolution ? warnLabel : label, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
        return deleteDialog.open() == 0;
    }

    private void deleteSelectedResource(IMDObject res, IProgressMonitor monitor) throws MDSaveException, DevMDException, CoreException {
        IMDFile file;
        IMDProject project;
        if (!res.toFile().exists()) {
            return;
        }
        if (res instanceof IMDFile && (project = (file = (IMDFile)res).getMDProject()).isContextInited()) {
            project.getMetadataLoader().deleteMetadata(file.getBOSType(), (IMetaDataPK)file.getMetaDataPK());
        }
        if (res instanceof IMDFolder) {
            IMDFolder fol = (IMDFolder)res;
            IMDResource[] ress = fol.listChildren();
            for (int i = 0; i < ress.length; ++i) {
                this.deleteSelectedResource(ress[i], monitor);
            }
        }
        if (res instanceof IMDProject) {
            IMDProject project2 = (IMDProject)res;
            if (project2.isContextInited()) {
                project2.getMetadataLoader().close();
            }
            try {
                project2.clearCache();
            }
            catch (Exception ress) {
                // empty catch block
            }
            MDResourceUtil.removeMDProject(project2.toFile());
            IProject proj = MDResourceUtil.toIProject(project2);
            String filename = proj.getLocation().toOSString();
            try {
                proj.delete(true, monitor);
            }
            catch (Exception e) {
                LogTool.logError("", e);
            }
            try {
                if (proj != null) {
                    IResource[] resourcesToDelete = new IResource[]{proj};
                    DeleteResourcesOperation op = new DeleteResourcesOperation(resourcesToDelete, "\u5220\u9664\u89e3\u51b3\u65b9\u6848", true);
                    op.setModelProviderIds(new String[]{""});
                    op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
                }
                FileUtils.deleteFile(filename);
            }
            catch (Exception e) {
                LogTool.logError("", e);
            }
        }
        if (res.toFile().exists()) {
            res.toFile().delete();
        }
    }
}

