/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.actions;

import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.md.actions.base.BaseMDResourceAction;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.actions.Messages;
import com.kingdee.bos.tool.actions.WorkbenchRunnableAdapter;
import com.kingdee.bos.tool.utils.ToolCommonImages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class RefreshAction
extends BaseMDResourceAction {
    public RefreshAction() {
        super(63);
        this.setText(Messages.RefreshAction_ShuaXin);
        this.setAccelerator(0x100000E);
        this.setImageDescriptor(ToolCommonImages.getImageDescriptor("refresh.gif"));
    }

    @Override
    protected void run(final IMDObject[] res) {
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMDObject[] ress = MDResourceUtil.getTopResources(res);
                if (ress.length == 0) {
                    ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, monitor);
                    MDResourceUtil.fireWorkspaceUpdate();
                    return;
                }
                monitor.beginTask("Refreshing...", ress.length * 2);
                monitor.subTask("");
                for (int r = 0; r < ress.length; ++r) {
                    IMDFolder folder;
                    IMDObject resource = ress[r];
                    if (resource instanceof IMDProject) {
                        IMDProject project = (IMDProject)resource;
                        IProject proj = MDResourceUtil.toIProject(project);
                        RefreshAction.this.checkLocationDeleted(proj);
                        proj.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        project.reset();
                        continue;
                    }
                    if (!(resource instanceof IMDFolder) || !(folder = (IMDFolder)resource).toFile().exists()) continue;
                    MDResourceUtil.toIFolder(folder).refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (!folder.getMDProject().isContextInited()) continue;
                    IDevMetadataLoader loader = folder.getMDProject().getMetadataLoader();
                    loader.refresh(folder.toFile());
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation));
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Refresh Problems", (String)"Problems occurred refreshing the selected resources.");
            LogTool.logError("", e);
        }
        catch (InterruptedException e) {
            LogTool.logError("", e);
        }
    }

    private void checkLocationDeleted(IProject project) throws CoreException {
        if (!project.exists()) {
            return;
        }
        File location = project.getLocation().toFile();
        if (!location.exists()) {
            final String message = "The location for project " + project.getName() + " has been deleted.\n Delete " + project.getName() + " from the workspace?";
            final boolean[] result = new boolean[1];
            this.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = MessageDialog.openQuestion((Shell)RefreshAction.this.getShell(), (String)"Project location has been deleted", (String)message);
                }
            });
            if (result[0]) {
                project.delete(true, true, null);
            }
        }
    }
}

