/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.check;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.tool.check.IVerify;
import com.kingdee.bos.tool.check.VerifyExtensionPointProcess;
import com.kingdee.bos.tool.check.VerifyItem;
import com.kingdee.bos.tool.check.VerifyReport;
import com.kingdee.bos.tool.check.VerifySuite;
import com.kingdee.bos.tool.check.VerifyTargetType;
import com.kingdee.bos.tool.check.VerifyUnit;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;

public class VerifyOperator
implements Serializable {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.check.VerifyOperator");
    private VerifyReport report = new VerifyReport();

    public VerifyOperator() {
    }

    public VerifyOperator(VerifyReport report) {
        if (report != null) {
            this.report = report;
        }
    }

    public VerifyReport getVerifyReport() {
        return this.report;
    }

    public boolean check(IObjectValue target, int scene) {
        assert (target != null);
        assert (scene > 0);
        if (target == null) {
            return false;
        }
        VerifyTargetType type = VerifyTargetType.getTargetType(target.getBOSType());
        if (type == null) {
            logger.debug((Object)("No support type:" + target.toString()));
            return true;
        }
        List list = this.getCheckItemList(type, scene);
        VerifySuite otherSuite = new VerifySuite(type.getName());
        for (int i = 0; i < list.size(); ++i) {
            VerifyItem item = (VerifyItem)list.get(i);
            IVerify v = this.newInstance(item);
            if (v == null) continue;
            if (v instanceof VerifyUnit) {
                ((VerifyUnit)v).setName(item.getName());
                ((VerifyUnit)v).setTarget(target);
            }
            if (item.getCategory().equals("BOS")) continue;
            otherSuite.addVerify(v);
        }
        return otherSuite.check(this.report);
    }

    private IVerify newInstance(final VerifyItem item) {
        assert (item.getClassName() != null);
        final IVerify[] verifies = new IVerify[1];
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                try {
                    verifies[0] = (IVerify)item.getElement().createExecutableExtension("class");
                }
                catch (CoreException e) {
                    logger.error((Object)"instance IVerify failed", (Throwable)e);
                }
            }
        });
        return verifies[0];
    }

    private List getCheckItemList(VerifyTargetType obj, int scene) {
        return VerifyExtensionPointProcess.getVerifyItems().getItems(obj, scene);
    }
}

