/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dao;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizExceptionInfo;
import com.kingdee.bos.metadata.resource.I18nResourceInfo;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.StatusCollection;
import com.kingdee.bos.metadata.ui.StatusInfo;
import com.kingdee.bos.metadata.ui.StatusItemCollection;
import com.kingdee.bos.metadata.ui.StatusItemInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.dao.ICommand;
import com.kingdee.bos.tool.dao.ORMStudioBridger;
import com.kingdee.bos.tool.dao.ORMUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class CopyCommand
implements ICommand {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.dao.CopyCommand");
    private IFile oldFile;
    private String name;
    private String pkName;
    private boolean needDelteOldFile;

    CopyCommand(IFile oldFile, String packageName, String name) {
        this.oldFile = oldFile;
        this.name = name;
        this.pkName = packageName;
    }

    @Override
    public void exec(IProgressMonitor monitor) {
        try {
            int i;
            AbstractMetaDataValue model = null;
            if (this.oldFile.getFileExtension().equalsIgnoreCase("ui")) {
                IFolder folder = ORMStudioBridger.getFolder((IResource)this.oldFile);
                IDevMetadataLoader loader = ToolContextManager.getMetadataLoader(folder);
                IMetaDataPK pk = ORMStudioBridger.getFilePK((IResource)this.oldFile);
                model = loader.loadAssmebledUIObject(pk);
            } else {
                model = (AbstractMetaDataValue)ORMUtil.load(this.oldFile);
            }
            String oldFullName = model.getFullName();
            model.setPackage(this.pkName);
            model.setName(this.name);
            String fullName = this.getFullName(this.pkName, this.name);
            if (model instanceof BusinessObjectInfo) {
                ((BusinessObjectInfo)model).setBusinessImplName(this.genBizImplName(this.pkName, this.name));
                ((BusinessObjectInfo)model).setBusinessControllerName(this.genControllerName(this.pkName, this.name));
                BusinessObjectInfo bo = (BusinessObjectInfo)model;
                bo.remove("bosType");
                int n = bo.getMethods().size();
                MethodInfo method = null;
                for (i = 0; i < n; ++i) {
                    method = bo.getMethods().get(i);
                    if (method.getString("innerID") == null) continue;
                    method.setString("innerID", null);
                }
            } else if (model instanceof BizEnumInfo) {
                ((BizEnumInfo)model).setClassName(fullName);
            } else if (model instanceof BizExceptionInfo) {
                ((BizExceptionInfo)model).setClassName(fullName);
            } else if (model instanceof I18nResourceInfo) {
                ((I18nResourceInfo)model).setClassName(fullName);
            } else if (model instanceof UIObjectInfo) {
                ((UIObjectInfo)model).setReleaseClass(this.name);
                ((UIObjectInfo)model).setReleasePackage(this.pkName);
            }
            IFolder folder = ORMStudioBridger.getFolder((IResource)this.oldFile);
            IFile newFile = ORMUtil.getFile(folder, (IObjectValue)model);
            ORMUtil.createFile((IObjectValue)model, newFile, monitor);
            if (model instanceof BusinessObjectInfo) {
                this.updateMethodRef((BusinessObjectInfo)model, oldFullName);
            }
            if (!ToolCommonPlugin.isDevelopVersion()) {
                model.setUserDefined(true);
                if (model instanceof UIObjectInfo) {
                    ActionCollection ac = ((UIObjectInfo)model).getActions();
                    int size = ac.size();
                    for (i = 0; i < size; ++i) {
                        ActionInfo ai = ac.get(i);
                        ai.setUserDefined(true);
                    }
                    ComponentCollection cc = ((UIObjectInfo)model).getComponents();
                    int size2 = cc.size();
                    for (int i2 = 0; i2 < size2; ++i2) {
                        ComponentInfo ci = cc.get(i2);
                        PropertyBindingCollection pbc = ci.getPropertyBindings();
                        int pbSize = pbc.size();
                        for (int j = 0; j < pbSize; ++j) {
                            PropertyBindingInfo pbi = pbc.get(j);
                            pbi.setUserDefined(true);
                        }
                        ci.setUserDefined(true);
                    }
                    DataObjectCollection dc = ((UIObjectInfo)model).getDataObjects();
                    int size3 = dc.size();
                    for (int i3 = 0; i3 < size3; ++i3) {
                        DataObjectInfo di = dc.get(i3);
                        di.setUserDefined(true);
                    }
                    StatusCollection sc = ((UIObjectInfo)model).getStatuses();
                    int size4 = sc.size();
                    for (int i4 = 0; i4 < size4; ++i4) {
                        StatusInfo si = sc.get(i4);
                        StatusItemCollection sic = si.getStatusItems();
                        int siSize = sic.size();
                        for (int j = 0; j < siSize; ++j) {
                            StatusItemInfo sii = sic.get(j);
                            sii.setUserDefined(true);
                        }
                        si.setUserDefined(true);
                    }
                }
            }
            ORMUtil.store((IObjectValue)model, newFile, monitor);
            if (this.needDelteOldFile) {
                this.oldFile.delete(true, true, null);
            }
        }
        catch (Exception e) {
            logger.error((Object)"copy error", (Throwable)e);
        }
    }

    private void updateMethodRef(BusinessObjectInfo model, String oldFullName) {
        MethodCollection mc = model.getMethods();
        String newFullName = model.getFullName();
        for (int i = 0; i < mc.size(); ++i) {
            MethodInfo mInfo = mc.get(i);
            if (mInfo.getMetaDataRef().equals(oldFullName)) {
                mInfo.setMetadataRef(newFullName);
            }
            if (oldFullName.equals(mInfo.getReturnValueType().metaDataRef)) {
                mInfo.getReturnValueType().metaDataRef = newFullName;
            }
            ParameterCollection pc = mInfo.getParameters();
            for (int j = 0; j < pc.size(); ++j) {
                ParameterInfo pInfo = pc.get(j);
                if (!pInfo.getMetaDataRef().equals(oldFullName)) continue;
                pInfo.setMetadataRef(newFullName);
            }
        }
    }

    private String genBizImplName(String pkName, String name) {
        String s = null;
        s = s == null ? "" : s;
        if ((s = s + pkName).equals("app") || s.endsWith(".app")) {
            s = s.length() == "app".length() ? "" : s.substring(0, s.lastIndexOf("app") - 1);
        }
        if (s.length() > 0 && !StringUtils.isEmpty((String)name)) {
            s = s + ".";
        }
        s = s + name;
        return s;
    }

    private String genControllerName(String pkName, String name) {
        return this.getFullName(pkName, name) + "Controller";
    }

    private String getFullName(String pkName, String name) {
        String fName = name;
        if (!StringUtils.isEmpty((String)pkName)) {
            fName = pkName + "." + fName;
        }
        return fName;
    }

    protected IFile getOldFile() {
        return this.oldFile;
    }

    protected void setNeedDeleteOldFile(boolean deleteOldFile) {
        this.needDelteOldFile = deleteOldFile;
    }
}

