/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dao;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.dao.CreatePackageCommand;
import com.kingdee.bos.tool.dao.ICommand;
import com.kingdee.bos.tool.dao.ORMStudioBridger;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateFileCommand
implements ICommand {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.dao.CreateFileCommand");
    private IObjectValue model;
    private IFile file;

    public CreateFileCommand(IObjectValue model, IFile file) {
        this.model = model;
        this.file = file;
    }

    @Override
    public void exec(IProgressMonitor monitor) {
        try {
            this.innerCreateFile(this.model, monitor);
        }
        catch (Exception e) {
            logger.error((Object)"createFile error", (Throwable)e);
        }
    }

    private void innerCreateFile(IObjectValue model, IProgressMonitor monitor) throws IDEException {
        Context ctx = ToolContextManager.getContext(this.file.getProject()).getORMContext();
        ContextManager.setContext((Context)ctx);
        IFolder folder = ORMStudioBridger.getFolder((IResource)this.file);
        ORMStudioBridger.store(folder, model);
    }

    private void createPackage(String packageName, IProgressMonitor monitor) {
        if (!StringUtils.isEmpty((String)packageName)) {
            PackageInfo info = new PackageInfo();
            info.setPackage(packageName);
            if (packageName.lastIndexOf(46) != -1) {
                info.setName(packageName.substring(packageName.lastIndexOf(46) + 1));
            } else {
                info.setName(packageName);
            }
            info.setAlias(info.getName());
            new CreatePackageCommand(ORMStudioBridger.getFolder((IResource)this.file), info).exec(monitor);
        }
    }

    public IObjectValue getModel() {
        return this.model;
    }

    public IFile getFile() {
        return this.file;
    }
}

