/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dao;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.dao.ICommand;
import com.kingdee.bos.tool.dao.ORMStudioBridger;
import com.kingdee.bos.tool.dao.VerifyNameAndPackageBeforeSave;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class UpdateFileCommand
implements ICommand {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.dao.UpdateFileCommand");
    private IObjectValue model;
    private IFile file;

    public UpdateFileCommand(IObjectValue model, IFile file) {
        this.model = model;
        this.file = file;
    }

    @Override
    public void exec(IProgressMonitor monitor) {
        try {
            VerifyNameAndPackageBeforeSave.verifyModelName(MDResourceUtil.toMDFile(this.file), this.model);
            Context ctx = ToolContextManager.getContext(this.file.getProject()).getORMContext();
            ContextManager.setContext((Context)ctx);
            IFolder folder = ORMStudioBridger.getFolder((IResource)this.file);
            if (this.model instanceof SolutionInfo) {
                ORMStudioBridger.updataSolution(folder, this.model);
            } else {
                ORMStudioBridger.store(folder, this.model);
            }
        }
        catch (Exception e) {
            logger.error((Object)"update failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            this.file.refreshLocal(0, null);
        }
        catch (CoreException e) {
            logger.error((Object)"refresh file failed:", (Throwable)e);
        }
    }

    public IObjectValue getModel() {
        return this.model;
    }

    public IFile getFile() {
        return this.file;
    }
}

