/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dao.tableimpexp;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;

class DBTableLoader {
    private static int maxDataLength = 0x40000000;

    DBTableLoader() {
    }

    public static DataTableInfo getTable(Connection cn, String packageName, String tableName) throws SQLException {
        return DBTableLoader.innerGetTable(cn, packageName, tableName);
    }

    private static DataTableInfo innerGetTable(Connection cn, String packageName, String tableName) throws SQLException {
        DataTableInfo dataTableInfo;
        ResultSet rs = null;
        DataTableInfo table = new DataTableInfo();
        table.setName(tableName);
        try {
            rs = cn.getMetaData().getTables(null, null, tableName, new String[]{"TABLE"});
            if (!rs.next()) {
                throw new SQLException("hasn't this table:" + tableName);
            }
            SQLUtils.cleanup((ResultSet)rs);
            rs = cn.getMetaData().getColumns(null, null, tableName, null);
            while (rs.next()) {
                ColumnInfo col = new ColumnInfo();
                col.setName(rs.getString("COLUMN_NAME"));
                short dataType = rs.getShort("DATA_TYPE");
                SQLType sqlType = DBTableLoader.getSQLType(dataType);
                if (sqlType == null) {
                    throw new SQLException("unexcept data type:" + rs.getString("TYPE_NAME") + " in col:" + col.getName());
                }
                col.setTypeName(sqlType);
                String def = rs.getString("COLUMN_DEF");
                if (def != null && def.startsWith("(") && def.endsWith(")")) {
                    def = def.substring(1, def.length() - 1);
                }
                col.setDefaultValue(def);
                col.setLength(rs.getInt("COLUMN_SIZE"));
                col.setNullable(rs.getInt("NULLABLE") == 1);
                col.setPrecision(rs.getInt("COLUMN_SIZE"));
                col.setScale(rs.getInt("DECIMAL_DIGITS"));
                table.getColumns().add(col);
            }
            SQLUtils.cleanup((ResultSet)rs);
            rs = cn.getMetaData().getPrimaryKeys(null, null, tableName);
            PKColumnInfo[] tempInfos = new PKColumnInfo[30];
            int tempSeq = -1;
            String pkName = null;
            while (rs.next()) {
                pkName = rs.getString("PK_NAME");
                ColumnInfo col = DBTableLoader.getColumnByName(table, rs.getString("COLUMN_NAME"));
                PKColumnInfo pkcol = new PKColumnInfo();
                pkcol.setColumn(col);
                tempSeq = rs.getInt("KEY_SEQ");
                if (tempSeq > tempInfos.length) {
                    PKColumnInfo[] tempArray = new PKColumnInfo[2 * tempSeq];
                    System.arraycopy(tempInfos, 0, tempArray, 0, tempInfos.length);
                    tempInfos = tempArray;
                }
                tempInfos[tempSeq - 1] = pkcol;
            }
            if (tempSeq >= 0) {
                PrimaryKeyInfo pk = new PrimaryKeyInfo();
                pk.setName(pkName);
                table.setPrimaryKey(pk);
                for (int i = 0; i < tempInfos.length; ++i) {
                    if (tempInfos[i] == null) continue;
                    pk.getPKColumns().add(tempInfos[i]);
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            rs = cn.getMetaData().getIndexInfo(null, null, tableName, true, true);
            DBTableLoader.fillIndex(rs, table);
            SQLUtils.cleanup((ResultSet)rs);
            rs = cn.getMetaData().getImportedKeys(null, null, tableName);
            while (rs.next()) {
                String fkName = rs.getString("FK_NAME");
                ForeignKeyInfo fk = null;
                for (int i = 0; i < table.getForeignKeys().size(); ++i) {
                    if (!table.getForeignKeys().get(i).getName().equals(fkName)) continue;
                    fk = table.getForeignKeys().get(i);
                    break;
                }
                if (fk == null) {
                    fk = new ForeignKeyInfo();
                    DataTableInfo refTable = new DataTableInfo();
                    refTable.setName(rs.getString("PKTABLE_NAME"));
                    refTable.setPackage(packageName);
                    fk.setRefTable((AbstractTableInfo)refTable);
                    fk.setName(fkName);
                    table.getForeignKeys().add(fk);
                }
                FKColumnPairInfo fkcol = new FKColumnPairInfo();
                fkcol.setForeignKeyColumn(DBTableLoader.getColumnByName(table, rs.getString("FKCOLUMN_NAME")));
                ColumnInfo pkcolumn = new ColumnInfo();
                pkcolumn.setName(rs.getString("PKCOLUMN_NAME"));
                fkcol.setPrimaryKeyColumn(pkcolumn);
                fk.getFKColumnPairs().add(fkcol);
            }
            SQLUtils.cleanup((ResultSet)rs);
            dataTableInfo = table;
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return dataTableInfo;
    }

    private static void fillIndex(ResultSet rs, DataTableInfo table) throws SQLException {
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            if (indexName == null || table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
            IndexInfo index = null;
            for (int i = 0; i < table.getIndexes().size(); ++i) {
                if (!table.getIndexes().get(i).getName().equals(indexName)) continue;
                index = table.getIndexes().get(i);
                break;
            }
            if (index == null) {
                index = new IndexInfo();
                index.setName(rs.getString("INDEX_NAME"));
                index.setUnique(!rs.getBoolean("NON_UNIQUE"));
                table.getIndexes().add(index);
            }
            IndexColumnInfo indexColumn = new IndexColumnInfo();
            indexColumn.setColumn(DBTableLoader.getColumnByName(table, rs.getString("COLUMN_NAME")));
            indexColumn.setSortType(rs.getString("ASC_OR_DESC").equals("A") ? SortType.ASCEND : SortType.DESCEND);
            index.getIndexColumns().add(indexColumn);
        }
    }

    private static DataTableInfo getOracleTable(Connection cn, String tableName) throws SQLException {
        ResultSet subrs2;
        ResultSet subrs;
        ResultSet rs;
        PreparedStatement substmt2;
        PreparedStatement substmt;
        PreparedStatement stmt;
        block16: {
            stmt = null;
            substmt = null;
            substmt2 = null;
            rs = null;
            subrs = null;
            subrs2 = null;
            String sql = "Select TABLE_NAME FROM USER_TABLES WHERE TABLE_NAME =?";
            stmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase(Locale.ENGLISH));
            rs = stmt.executeQuery();
            if (!rs.next()) break block16;
            DataTableInfo table = new DataTableInfo();
            table.setName(tableName);
            sql = "SELECT * FROM USER_TAB_COLUMNS WHERE TABLE_NAME=?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase(Locale.ENGLISH));
            subrs = substmt.executeQuery();
            while (subrs.next()) {
                SQLType dataType;
                ColumnInfo col = new ColumnInfo();
                col.setName(subrs.getString("COLUMN_NAME"));
                String typeName = subrs.getString("DATA_TYPE");
                if (typeName.equals("NUMBER") && subrs.getInt("DATA_SCALE") == 0) {
                    typeName = "LONG";
                }
                if ((dataType = DBTableLoader.getSQLType(typeName)) == null) {
                    throw new SQLException("unexcept data type:" + typeName + " in col:" + col.getName());
                }
                col.setTypeName(dataType);
                String strDef = subrs.getString("DATA_DEFAULT");
                if (strDef != null && strDef.length() != 0 && (strDef = strDef.trim()).startsWith("( ") && strDef.endsWith(" )")) {
                    strDef = "(" + strDef.substring(2, strDef.length() - 4) + ")";
                }
                col.setDefaultValue(strDef);
                col.setLength(subrs.getInt("DATA_LENGTH"));
                col.setNullable(subrs.getString("NULLABLE").equals("Y"));
                col.setPrecision(subrs.getInt("DATA_PRECISION"));
                col.setScale(subrs.getInt("DATA_SCALE"));
                table.getColumns().add(col);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "SELECT t1.* FROM USER_CONS_COLUMNS t1,USER_CONSTRAINTS t2  WHERE t1.CONSTRAINT_NAME=t2.CONSTRAINT_NAME  AND t1.TABLE_NAME=t2.TABLE_NAME  AND t2.CONSTRAINT_TYPE ='P' AND t1.TABLE_NAME=? ORDER BY t1.POSITION ";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase(Locale.ENGLISH));
            subrs = substmt.executeQuery();
            if (subrs.next()) {
                PrimaryKeyInfo pk = new PrimaryKeyInfo();
                pk.setName(subrs.getString("CONSTRAINT_NAME"));
                table.setPrimaryKey(pk);
                ColumnInfo col = DBTableLoader.getColumnByName(table, subrs.getString("COLUMN_NAME"));
                PKColumnInfo pkcol = new PKColumnInfo();
                pkcol.setColumn(col);
                pk.getPKColumns().add(pkcol);
                while (subrs.next()) {
                    col = DBTableLoader.getColumnByName(table, subrs.getString("COLUMN_NAME"));
                    pkcol = new PKColumnInfo();
                    pkcol.setColumn(col);
                    pk.getPKColumns().add(pkcol);
                }
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "SELECT INDEX_NAME,UNIQUENESS FROM USER_INDEXES WHERE INDEX_TYPE<>'LOB' AND TABLE_NAME=?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase(Locale.ENGLISH));
            subrs = substmt.executeQuery();
            while (subrs.next()) {
                String indexName = subrs.getString("INDEX_NAME");
                if (table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
                IndexInfo index = new IndexInfo();
                index.setName(subrs.getString("INDEX_NAME"));
                index.setUnique(subrs.getString("UNIQUENESS").equals("UNIQUE"));
                sql = "SELECT COLUMN_NAME,DESCEND FROM USER_IND_COLUMNS WHERE TABLE_NAME=? AND INDEX_NAME=?";
                substmt2 = DBUtils.createPreparedStatement(cn, sql, new String[]{tableName.toUpperCase(Locale.ENGLISH), index.getName().toUpperCase(Locale.ENGLISH)});
                subrs2 = substmt2.executeQuery();
                while (subrs2.next()) {
                    IndexColumnInfo indexColumn = new IndexColumnInfo();
                    indexColumn.setColumn(DBTableLoader.getColumnByName(table, subrs2.getString("COLUMN_NAME")));
                    if (subrs.getString("DESCEND").equals("DESC")) {
                        indexColumn.setSortType(SortType.DESCEND);
                    }
                    index.getIndexColumns().add(indexColumn);
                }
                table.getIndexes().add(index);
                SQLUtils.cleanup((ResultSet)subrs2, (Statement)substmt2);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "SELECT t1.CONSTRAINT_NAME AS FK_Name,t2.TABLE_NAME AS PKTable_Name,t3.COLUMN_NAME AS FKColumn_Name,t4.COLUMN_NAME AS PKColumn_Name  FROM USER_CONSTRAINTS t1,USER_CONSTRAINTS t2,USER_CONS_COLUMNS t3,USER_CONS_COLUMNS t4  WHERE t1.CONSTRAINT_TYPE='R' AND t2.CONSTRAINT_TYPE='P' AND t1.R_CONSTRAINT_NAME=t2.CONSTRAINT_NAME  AND t1.CONSTRAINT_NAME=t3.CONSTRAINT_NAME AND t2.CONSTRAINT_NAME=t4.CONSTRAINT_NAME  AND t3.POSITION=t4.POSITION AND t1.TABLE_NAME=?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase(Locale.ENGLISH));
            subrs = substmt.executeQuery();
            ForeignKeyInfo prevFK = null;
            while (subrs.next()) {
                String fkName = subrs.getString("FK_Name");
                FKColumnPairInfo fkcol = new FKColumnPairInfo();
                fkcol.setForeignKeyColumn(DBTableLoader.getColumnByName(table, subrs.getString("FKColumn_Name")));
                ColumnInfo pkcolumn = new ColumnInfo();
                pkcolumn.setName(subrs.getString("PKColumn_Name"));
                fkcol.setPrimaryKeyColumn(pkcolumn);
                if (prevFK != null && prevFK.getName().equals(fkName)) {
                    prevFK.getFKColumnPairs().add(fkcol);
                    continue;
                }
                prevFK = new ForeignKeyInfo();
                DataTableInfo refTable = new DataTableInfo();
                refTable.setName(subrs.getString("PKTable_Name"));
                prevFK.setRefTable((AbstractTableInfo)refTable);
                prevFK.setName(fkName);
                prevFK.getFKColumnPairs().add(fkcol);
                table.getForeignKeys().add(prevFK);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            DataTableInfo dataTableInfo = table;
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            SQLUtils.cleanup(subrs2, substmt2);
            return dataTableInfo;
        }
        try {
            throw new SQLException("hasn't this table:" + tableName);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt);
            SQLUtils.cleanup(subrs, substmt);
            SQLUtils.cleanup(subrs2, substmt2);
            throw throwable;
        }
    }

    private static DataTableInfo getSQLTable(Connection cn, String tableName) throws SQLException {
        ResultSet subrs2;
        ResultSet subrs;
        ResultSet rs;
        PreparedStatement substmt2;
        PreparedStatement substmt;
        PreparedStatement stmt;
        block20: {
            stmt = null;
            substmt = null;
            substmt2 = null;
            rs = null;
            subrs = null;
            subrs2 = null;
            String sql = "sp_tables ?";
            stmt = DBUtils.createPreparedStatement(cn, sql, tableName);
            rs = stmt.executeQuery();
            if (!rs.next()) break block20;
            String tbowner = rs.getString("TABLE_OWNER");
            DataTableInfo table = new DataTableInfo();
            table.setName(tableName);
            sql = "sp_columns ?,?";
            substmt = DBUtils.createPreparedStatement(cn, sql, new String[]{tableName, tbowner});
            subrs = substmt.executeQuery();
            while (subrs.next()) {
                ColumnInfo col = new ColumnInfo();
                col.setName(subrs.getString("Column_Name"));
                String typeName = subrs.getString("Type_Name");
                typeName = StringUtils.replace((String)typeName, (String)"identity", (String)"");
                SQLType dataType = DBTableLoader.getSQLType(typeName);
                if (dataType == null) {
                    sql = "select t1.name from systypes t1,systypes t2 where t1.xusertype = t2.xtype and t2.name = ?";
                    substmt2 = DBUtils.createPreparedStatement(cn, sql, typeName);
                    subrs2 = substmt2.executeQuery();
                    if (subrs2.next()) {
                        typeName = subrs2.getString("name");
                        dataType = DBTableLoader.getSQLType(typeName);
                        if (dataType == null) {
                            throw new SQLException("unexcept data type:" + typeName + " in col:" + col.getName());
                        }
                    } else {
                        throw new SQLException("unexcept data type:" + typeName + " in col:" + col.getName());
                    }
                    SQLUtils.cleanup((ResultSet)subrs2, (Statement)substmt2);
                }
                col.setTypeName(dataType);
                col.setDefaultValue(subrs.getString("Column_Def"));
                if (typeName.toLowerCase(Locale.ENGLISH).equals("nchar") || typeName.toLowerCase(Locale.ENGLISH).equals("nvarchar")) {
                    col.setLength(subrs.getInt("Precision"));
                } else {
                    col.setLength(subrs.getInt("Length"));
                }
                if (col.getLength() > maxDataLength) {
                    col.setLength(maxDataLength);
                }
                col.setNullable(subrs.getInt("Nullable") == 1);
                col.setPrecision(subrs.getInt("Precision"));
                col.setScale(subrs.getInt("Scale"));
                table.getColumns().add(col);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "sp_pkeys ?,?";
            substmt = DBUtils.createPreparedStatement(cn, sql, new String[]{tableName, tbowner});
            subrs = substmt.executeQuery();
            if (subrs.next()) {
                PrimaryKeyInfo pk = new PrimaryKeyInfo();
                pk.setName(subrs.getString("PK_Name"));
                table.setPrimaryKey(pk);
                ColumnInfo col = DBTableLoader.getColumnByName(table, subrs.getString("Column_Name"));
                PKColumnInfo pkcol = new PKColumnInfo();
                pkcol.setColumn(col);
                pk.getPKColumns().add(pkcol);
                while (subrs.next()) {
                    col = DBTableLoader.getColumnByName(table, subrs.getString("Column_Name"));
                    pkcol = new PKColumnInfo();
                    pkcol.setColumn(col);
                    pk.getPKColumns().add(pkcol);
                }
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "sp_helpindex ?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tbowner + "." + tableName);
            subrs = substmt.executeQuery();
            while (subrs.next()) {
                String indexName = subrs.getString("Index_Name");
                if (table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
                IndexInfo index = new IndexInfo();
                index.setName(subrs.getString("Index_Name"));
                index.setUnique(subrs.getString("index_description").toUpperCase(Locale.ENGLISH).indexOf("UNIQUE") > 0);
                String[] indexColumns = StringUtils.split((String)subrs.getString("Index_Keys"), (String)",");
                for (int i = 0; i < indexColumns.length; ++i) {
                    IndexColumnInfo indexColumn = new IndexColumnInfo();
                    String columnName = StringUtils.replace((String)indexColumns[i], (String)"(-)", (String)"");
                    indexColumn.setColumn(DBTableLoader.getColumnByName(table, columnName.trim()));
                    if (!columnName.equals(indexColumns[i])) {
                        indexColumn.setSortType(SortType.DESCEND);
                    }
                    index.getIndexColumns().add(indexColumn);
                }
                table.getIndexes().add(index);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "sp_fkeys @fktable_name = ?',@fktable_owner=?";
            substmt = DBUtils.createPreparedStatement(cn, sql, new String[]{tableName, tbowner});
            subrs = substmt.executeQuery();
            ForeignKeyInfo prevFK = null;
            while (subrs.next()) {
                String fkName = subrs.getString("FK_Name");
                FKColumnPairInfo fkcol = new FKColumnPairInfo();
                fkcol.setForeignKeyColumn(DBTableLoader.getColumnByName(table, subrs.getString("FKColumn_Name")));
                ColumnInfo pkcolumn = new ColumnInfo();
                pkcolumn.setName(subrs.getString("PKColumn_Name"));
                fkcol.setPrimaryKeyColumn(pkcolumn);
                if (prevFK != null && prevFK.getName().equals(fkName)) {
                    prevFK.getFKColumnPairs().add(fkcol);
                    continue;
                }
                prevFK = new ForeignKeyInfo();
                DataTableInfo refTable = new DataTableInfo();
                refTable.setName(subrs.getString("PKTable_Name"));
                prevFK.setRefTable((AbstractTableInfo)refTable);
                prevFK.setName(fkName);
                prevFK.getFKColumnPairs().add(fkcol);
                table.getForeignKeys().add(prevFK);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            DataTableInfo dataTableInfo = table;
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            SQLUtils.cleanup((ResultSet)subrs2, (Statement)substmt2);
            return dataTableInfo;
        }
        try {
            throw new SQLException("hasn't this table:" + tableName);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt);
            SQLUtils.cleanup(subrs, substmt);
            SQLUtils.cleanup(subrs2, substmt2);
            throw throwable;
        }
    }

    private static DataTableInfo getDB2Table(Connection cn, String tableName) throws SQLException {
        ResultSet subrs;
        ResultSet rs;
        PreparedStatement substmt;
        PreparedStatement stmt;
        block22: {
            stmt = null;
            substmt = null;
            rs = null;
            subrs = null;
            String sql = "SELECT NAME FROM SYSIBM.SYSTABLES WHERE TYPE='T' AND NAME=?";
            stmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase(Locale.ENGLISH));
            rs = stmt.executeQuery();
            if (!rs.next()) break block22;
            DataTableInfo table = new DataTableInfo();
            table.setName(tableName);
            sql = "SELECT * FROM SYSIBM.SYSCOLUMNS WHERE TBNAME=?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase(Locale.ENGLISH));
            subrs = substmt.executeQuery();
            while (subrs.next()) {
                ColumnInfo col = new ColumnInfo();
                col.setName(subrs.getString("NAME").trim());
                String typeName = subrs.getString("COLTYPE").trim();
                SQLType sqlType = DBTableLoader.getSQLType(typeName);
                if (sqlType == null) {
                    throw new SQLException("unexcept data type:" + typeName + " in col:" + col.getName());
                }
                col.setTypeName(sqlType);
                if (subrs.getInt("CODEPAGE") == 0) {
                    if (col.getTypeName().equals((Object)SQLType.CHAR) || col.getTypeName().equals((Object)SQLType.NCHAR)) {
                        col.setTypeName(SQLType.BINARY);
                    } else if (col.getTypeName().equals((Object)SQLType.VARCHAR) || col.getTypeName().equals((Object)SQLType.NVARCHAR)) {
                        col.setTypeName(SQLType.VARBINARY);
                    }
                }
                col.setDefaultValue(subrs.getString("DEFAULT"));
                col.setLength(subrs.getInt("LONGLENGTH"));
                col.setNullable(subrs.getString("NULLS").equals("Y"));
                col.setPrecision(subrs.getInt("LONGLENGTH"));
                col.setScale(subrs.getInt("SCALE"));
                table.getColumns().add(col);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "SELECT NAME,COLNAMES FROM SYSIBM.SYSINDEXES WHERE UNIQUERULE ='P' AND NAME NOT LIKE 'SQL%' AND TBNAME=?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase(Locale.ENGLISH));
            subrs = substmt.executeQuery();
            if (subrs.next()) {
                PrimaryKeyInfo pk = new PrimaryKeyInfo();
                pk.setName(subrs.getString("NAME"));
                table.setPrimaryKey(pk);
                String strPK = subrs.getString("COLNAMES");
                strPK = StringUtils.replace((String)strPK, (String)"+", (String)",");
                strPK = StringUtils.replace((String)strPK, (String)"-", (String)",");
                strPK = strPK.substring(1);
                String[] PKColumns = StringUtils.split((String)strPK, (String)",");
                for (int i = 0; i < PKColumns.length; ++i) {
                    ColumnInfo col = DBTableLoader.getColumnByName(table, PKColumns[i]);
                    PKColumnInfo pkcol = new PKColumnInfo();
                    pkcol.setColumn(col);
                    pk.getPKColumns().add(pkcol);
                }
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "SELECT NAME,COLNAMES,UNIQUERULE FROM SYSIBM.SYSINDEXES WHERE NAME NOT LIKE 'SQL%' AND TBNAME=?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase(Locale.ENGLISH));
            subrs = substmt.executeQuery();
            while (subrs.next()) {
                String indexName = subrs.getString("NAME");
                if (table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
                IndexInfo index = new IndexInfo();
                index.setName(subrs.getString("NAME"));
                index.setUnique(subrs.getString("UNIQUERULE").equals("U"));
                String strIdx = subrs.getString("COLNAMES");
                strIdx = StringUtils.replace((String)strIdx, (String)"+", (String)",+");
                strIdx = StringUtils.replace((String)strIdx, (String)"-", (String)",-");
                strIdx = strIdx.substring(1);
                String[] idxColumns = StringUtils.split((String)strIdx, (String)",");
                for (int i = 0; i < idxColumns.length; ++i) {
                    IndexColumnInfo indexColumn = new IndexColumnInfo();
                    String columnName = idxColumns[i].substring(1).trim();
                    indexColumn.setColumn(DBTableLoader.getColumnByName(table, columnName.trim()));
                    if (idxColumns[i].substring(0, 1).equals("-")) {
                        indexColumn.setSortType(SortType.DESCEND);
                    }
                    index.getIndexColumns().add(indexColumn);
                }
                table.getIndexes().add(index);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "SELECT * FROM SYSIBM.SYSRELS WHERE RELNAME NOT LIKE 'SQL%' AND TBNAME=?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase(Locale.ENGLISH));
            subrs = substmt.executeQuery();
            ForeignKeyInfo prevFK = null;
            while (subrs.next()) {
                prevFK = new ForeignKeyInfo();
                DataTableInfo refTable = new DataTableInfo();
                refTable.setName(subrs.getString("REFTBNAME"));
                prevFK.setRefTable((AbstractTableInfo)refTable);
                prevFK.setName(subrs.getString("RELNAME"));
                String fkcolumns = subrs.getString("FKCOLNAMES").trim();
                String pkcolumns = subrs.getString("PKCOLNAMES").trim();
                while (!StringUtils.isEmpty((String)fkcolumns) && !StringUtils.isEmpty((String)pkcolumns)) {
                    ColumnInfo pkcolumn;
                    String colname;
                    FKColumnPairInfo fkcol = new FKColumnPairInfo();
                    int spaceindex = fkcolumns.indexOf(" ");
                    if (spaceindex > 0) {
                        colname = fkcolumns.substring(0, spaceindex);
                        fkcol.setForeignKeyColumn(DBTableLoader.getColumnByName(table, colname));
                        fkcolumns = fkcolumns.substring(spaceindex).trim();
                    } else {
                        colname = fkcolumns;
                        fkcol.setForeignKeyColumn(DBTableLoader.getColumnByName(table, colname));
                        fkcolumns = "";
                    }
                    spaceindex = pkcolumns.indexOf(" ");
                    if (spaceindex > 0) {
                        colname = pkcolumns.substring(0, spaceindex);
                        pkcolumn = new ColumnInfo();
                        pkcolumn.setName(colname);
                        fkcol.setPrimaryKeyColumn(pkcolumn);
                        pkcolumns = pkcolumns.substring(spaceindex).trim();
                    } else {
                        colname = pkcolumns;
                        pkcolumn = new ColumnInfo();
                        pkcolumn.setName(colname);
                        fkcol.setPrimaryKeyColumn(pkcolumn);
                        pkcolumns = "";
                    }
                    prevFK.getFKColumnPairs().add(fkcol);
                }
                table.getForeignKeys().add(prevFK);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            DataTableInfo dataTableInfo = table;
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            return dataTableInfo;
        }
        try {
            throw new SQLException("hasn't this table:" + tableName);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt);
            SQLUtils.cleanup(subrs, substmt);
            throw throwable;
        }
    }

    private static DataTableInfo getSybaseTable(Connection cn, String tableName) throws SQLException {
        ResultSet subrs2;
        ResultSet subrs;
        ResultSet rs;
        PreparedStatement substmt2;
        PreparedStatement substmt;
        PreparedStatement stmt;
        block16: {
            stmt = null;
            substmt = null;
            substmt2 = null;
            rs = null;
            subrs = null;
            subrs2 = null;
            String sql = "sp_tables ?";
            stmt = DBUtils.createPreparedStatement(cn, sql, tableName);
            rs = stmt.executeQuery();
            if (!rs.next()) break block16;
            DataTableInfo table = new DataTableInfo();
            table.setName(tableName);
            sql = "sp_columns ?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName);
            subrs = substmt.executeQuery();
            while (subrs.next()) {
                ColumnInfo col = new ColumnInfo();
                col.setName(subrs.getString("Column_Name"));
                String typeName = subrs.getString("Type_Name");
                typeName = StringUtils.replace((String)typeName, (String)"identity", (String)"").trim();
                SQLType sqlType = DBTableLoader.getSQLType(typeName);
                if (sqlType == null) {
                    throw new SQLException("unexcept data type:" + typeName + " in col:" + col.getName());
                }
                col.setTypeName(sqlType);
                sql = "select t2.text as Column_Def from syscolumns t1,syscomments t2,sysobjects t3  where t1.cdefault=t2.id and t1.id=t3.id  and t3.name=? and t1.name=?";
                substmt2 = DBUtils.createPreparedStatement(cn, sql, new String[]{tableName, col.getName()});
                subrs2 = substmt2.executeQuery();
                if (subrs2.next()) {
                    col.setDefaultValue(StringUtils.replace((String)subrs2.getString("Column_Def"), (String)"DEFAULT", (String)"").trim());
                } else {
                    col.setDefaultValue("");
                }
                SQLUtils.cleanup((ResultSet)subrs2, (Statement)substmt2);
                if (typeName.toLowerCase(Locale.ENGLISH).equals("nchar") || typeName.toLowerCase(Locale.ENGLISH).equals("nvarchar")) {
                    col.setLength(subrs.getInt("Precision"));
                } else {
                    col.setLength(subrs.getInt("Length"));
                }
                col.setNullable(subrs.getInt("Nullable") == 1);
                col.setPrecision(subrs.getInt("Precision"));
                col.setScale(subrs.getInt("Scale"));
                table.getColumns().add(col);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "sp_pkeys ?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName);
            subrs = substmt.executeQuery();
            if (subrs.next()) {
                PrimaryKeyInfo pk = new PrimaryKeyInfo();
                table.setPrimaryKey(pk);
                sql = "select t1.name as PK_Name from sysindexes t1, sysobjects t2  where t1.id=t2.id and t1.status2=2 and t2.name=?";
                substmt2 = DBUtils.createPreparedStatement(cn, sql, tableName);
                subrs2 = substmt2.executeQuery();
                pk.setName(subrs2.getString("PK_Name").trim());
                SQLUtils.cleanup((ResultSet)subrs2, (Statement)substmt2);
                ColumnInfo col = DBTableLoader.getColumnByName(table, subrs.getString("Column_Name"));
                PKColumnInfo pkcol = new PKColumnInfo();
                pkcol.setColumn(col);
                pk.getPKColumns().add(pkcol);
                while (subrs.next()) {
                    col = DBTableLoader.getColumnByName(table, subrs.getString("Column_Name"));
                    pkcol = new PKColumnInfo();
                    pkcol.setColumn(col);
                    pk.getPKColumns().add(pkcol);
                }
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "sp_helpindex ?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName);
            subrs = substmt.executeQuery();
            while (subrs.next()) {
                String indexName = subrs.getString("Index_Name").trim();
                if (table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
                IndexInfo index = new IndexInfo();
                index.setName(subrs.getString("Index_Name").trim());
                String[] indexColumns = StringUtils.split((String)subrs.getString("Index_Keys"), (String)",");
                for (int i = 0; i < indexColumns.length; ++i) {
                    IndexColumnInfo indexColumn = new IndexColumnInfo();
                    String columnName = StringUtils.replace((String)indexColumns[i], (String)" DESC", (String)"");
                    indexColumn.setColumn(DBTableLoader.getColumnByName(table, columnName.trim()));
                    if (!columnName.equals(indexColumns[i])) {
                        indexColumn.setSortType(SortType.DESCEND);
                    }
                    index.getIndexColumns().add(indexColumn);
                }
                table.getIndexes().add(index);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            DataTableInfo dataTableInfo = table;
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            SQLUtils.cleanup((ResultSet)subrs2, (Statement)substmt2);
            return dataTableInfo;
        }
        try {
            throw new SQLException("hasn't this table:" + tableName);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt);
            SQLUtils.cleanup(subrs, substmt);
            SQLUtils.cleanup(subrs2, substmt2);
            throw throwable;
        }
    }

    private static SQLType getSQLType(short dataType) {
        switch (dataType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return SQLType.INT;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return SQLType.NUMERIC;
            }
            case 1: {
                return SQLType.CHAR;
            }
            case 12: {
                return SQLType.VARCHAR;
            }
            case -1: {
                return SQLType.CLOB;
            }
            case 91: 
            case 92: 
            case 93: {
                return SQLType.DATETIME;
            }
            case -2: {
                return SQLType.BINARY;
            }
            case -3: {
                return SQLType.VARBINARY;
            }
            case -4: {
                return SQLType.BLOB;
            }
            case 2004: {
                return SQLType.BLOB;
            }
            case 2005: {
                return SQLType.CLOB;
            }
        }
        return null;
    }

    private static SQLType getSQLType(String typeName) {
        if (typeName.equals("char")) {
            return SQLType.CHAR;
        }
        if (typeName.equals("nchar")) {
            return SQLType.NCHAR;
        }
        if (typeName.equals("varchar")) {
            return SQLType.VARCHAR;
        }
        if (typeName.equals("nvarchar")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("text")) {
            return SQLType.CLOB;
        }
        if (typeName.equals("ntext")) {
            return SQLType.NCLOB;
        }
        if (typeName.equals("sysname")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("binary")) {
            return SQLType.BINARY;
        }
        if (typeName.equals("varbinary")) {
            return SQLType.VARBINARY;
        }
        if (typeName.equals("image")) {
            return SQLType.BLOB;
        }
        if (typeName.equals("bigint")) {
            return SQLType.INT;
        }
        if (typeName.equals("int")) {
            return SQLType.INT;
        }
        if (typeName.equals("smallint")) {
            return SQLType.INT;
        }
        if (typeName.equals("tinyint")) {
            return SQLType.INT;
        }
        if (typeName.equals("bit")) {
            return SQLType.INT;
        }
        if (typeName.equals("real")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("float")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("money")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("smallmoney")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("numeric")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("decimal")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("datetime")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("smalldatetime")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("timestamp")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("GUID")) {
            return SQLType.CHAR;
        }
        if (typeName.equals("uniqueidentifier")) {
            return SQLType.CHAR;
        }
        if (typeName.equals("VARCHAR2")) {
            return SQLType.VARCHAR;
        }
        if (typeName.equals("NVARCHAR2")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("NUMBER")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("LONG")) {
            return SQLType.INT;
        }
        if (typeName.equals("DATE")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("CHAR")) {
            return SQLType.CHAR;
        }
        if (typeName.equals("NCHAR")) {
            return SQLType.NCHAR;
        }
        if (typeName.equals("CLOB")) {
            return SQLType.CLOB;
        }
        if (typeName.equals("NCLOB")) {
            return SQLType.NCLOB;
        }
        if (typeName.equals("BLOB")) {
            return SQLType.BLOB;
        }
        if (typeName.equals("RAW")) {
            return SQLType.VARBINARY;
        }
        if (typeName.equals("LONG RAW")) {
            return SQLType.VARBINARY;
        }
        if (typeName.equals("TIME")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("TIMESTMP")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("INTEGER")) {
            return SQLType.INT;
        }
        if (typeName.equals("SMALLINT")) {
            return SQLType.INT;
        }
        if (typeName.equals("FLOAT")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("VARCHAR")) {
            return SQLType.VARCHAR;
        }
        if (typeName.equals("LONGVAR")) {
            return SQLType.CLOB;
        }
        if (typeName.equals("DECIMAL")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("GRAPHIC")) {
            return SQLType.NCHAR;
        }
        if (typeName.equals("VARGRAPH")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("VARG")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("LONGVARG")) {
            return SQLType.NCLOB;
        }
        if (typeName.equals("BIGINT")) {
            return SQLType.INT;
        }
        if (typeName.equals("DOUBLE")) {
            return SQLType.NUMERIC;
        }
        return null;
    }

    private static ColumnInfo getColumnByName(DataTableInfo table, String columnName) {
        for (int i = 0; i < table.getColumns().size(); ++i) {
            ColumnInfo col = table.getColumns().get(i);
            if (!col.getName().toUpperCase(Locale.ENGLISH).equals(columnName.toUpperCase(Locale.ENGLISH))) continue;
            return col;
        }
        return null;
    }
}

