/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate;

import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.dbupdate.DBCreateXml;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateInfo;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateList;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DBCreateIndexSql {
    private static final String SEPARATOR = System.getProperty("file.separator");
    private DBCreateXml createXml = null;
    private String packageName;
    private DBUpdateList updateList = new DBUpdateList();
    private DBCreateIndexSql mssqlIndexSql = null;
    private DBCreateIndexSql oracleIndexSql = null;
    private DBCreateIndexSql db2IndexSql = null;
    private DBCreateIndexSql sybaseIndexSql = null;
    private int forDBType = 0;

    public DBCreateIndexSql(DBCreateXml createXml, PackageInfo pInfo) {
        this.createXml = createXml;
        this.packageName = pInfo.getPackage();
    }

    public DBCreateIndexSql(DBCreateXml createXml, String packageName) {
        this.createXml = createXml;
        this.packageName = packageName;
    }

    public DBCreateIndexSql(DBCreateXml createXml, PackageInfo pInfo, int forDBType) {
        this.createXml = createXml;
        this.packageName = pInfo.getPackage();
        this.forDBType = forDBType;
    }

    public DBCreateIndexSql(DBCreateXml createXml, String packageName, int forDBType) {
        this.createXml = createXml;
        this.packageName = packageName;
        this.forDBType = forDBType;
    }

    public DBUpdateList getUpdateList() {
        return this.updateList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File create(String scriptPath) throws IOException {
        File file = null;
        if (this.updateList.size() > 0) {
            File path = new File(this.getFilePath(scriptPath));
            if (!path.exists()) {
                path.mkdirs();
            }
            file = this.forDBType == 0 ? new File(this.getFilePath(scriptPath) + SEPARATOR + "createindex.sql") : (DBUtils.isMSSQL(this.forDBType) ? new File(this.getFilePath(scriptPath) + SEPARATOR + "createindex_sqlserver.sql") : (DBUtils.isOracle(this.forDBType) ? new File(this.getFilePath(scriptPath) + SEPARATOR + "createindex_oracle.sql") : (DBUtils.isDB2(this.forDBType) ? new File(this.getFilePath(scriptPath) + SEPARATOR + "createindex_db2.sql") : (DBUtils.isSybase(this.forDBType) ? new File(this.getFilePath(scriptPath) + SEPARATOR + "createindex_sybase.sql") : new File(this.getFilePath(scriptPath) + SEPARATOR + "createindex.sql")))));
            FileOutputStream fileOutputStream = null;
            BufferedOutputStream bfs = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                bfs = new BufferedOutputStream(fileOutputStream);
                int n = this.updateList.size();
                for (int i = 0; i < n; ++i) {
                    DBUpdateInfo updateInfo = this.updateList.getInfo(i);
                    String statement = DBCreateIndexSql.createStatement4Update(updateInfo);
                    bfs.write(statement.getBytes("UTF-8"));
                }
                bfs.flush();
            }
            catch (Throwable throwable) {
                FileUtils.close(bfs);
                FileUtils.close(fileOutputStream);
                throw throwable;
            }
            FileUtils.close(bfs);
            FileUtils.close(fileOutputStream);
        }
        return file;
    }

    public String getFilePath(String scriptPath) {
        return scriptPath + SEPARATOR + this.getRelativePath();
    }

    public String getRelativePath() {
        String path = StringUtils.replace((String)this.packageName, (String)".app", (String)"");
        path = path.equalsIgnoreCase(this.createXml.getPackageName()) ? "" : StringUtils.replace((String)path, (String)(this.createXml.getPackageName() + "."), (String)"");
        path = StringUtils.replace((String)path, (String)".", (String)SEPARATOR);
        path = StringUtils.isEmpty((String)path) ? this.createXml.getRelativePath() : this.createXml.getRelativePath() + SEPARATOR + path;
        return path;
    }

    private static String createStatement4Update(DBUpdateInfo updateInfo) {
        return updateInfo.getSql() + ";\n";
    }

    public DBCreateIndexSql getMssqlIndexSql() {
        return this.mssqlIndexSql;
    }

    public void setMssqlIndexSql(DBCreateIndexSql mssqlIndexSql) {
        this.mssqlIndexSql = mssqlIndexSql;
    }

    public DBCreateIndexSql getOracleIndexSql() {
        return this.oracleIndexSql;
    }

    public void setOracleIndexSql(DBCreateIndexSql oracleIndexSql) {
        this.oracleIndexSql = oracleIndexSql;
    }

    public DBCreateIndexSql getDb2IndexSql() {
        return this.db2IndexSql;
    }

    public void setDb2IndexSql(DBCreateIndexSql db2IndexSql) {
        this.db2IndexSql = db2IndexSql;
    }

    public DBCreateIndexSql getSybaseIndexSql() {
        return this.sybaseIndexSql;
    }

    public void setSybaseIndexSql(DBCreateIndexSql sybaseIndexSql) {
        this.sybaseIndexSql = sybaseIndexSql;
    }
}

