/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.ui;

import com.kingdee.bos.metadata.management.DataSource;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.dbupdate.data.DBCompareInfo;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateList;
import com.kingdee.bos.tool.dbupdate.data.LogRecord;
import com.kingdee.bos.tool.dbupdate.data.SyncSolutionInfo;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.bos.tool.dbupdate.engine.DBUpdateEngineImpl;
import com.kingdee.bos.tool.dbupdate.report.Report;
import com.kingdee.bos.tool.dbupdate.report.TableReportCollection;
import com.kingdee.bos.tool.dbupdate.report.TableReportItem;
import com.kingdee.bos.tool.dbupdate.ui.DBSynchronizerMessages;
import com.kingdee.bos.tool.dbupdate.ui.IMenuManager;
import com.kingdee.bos.tool.dbupdate.ui.IToolBarManager;
import com.kingdee.bos.tool.dbupdate.ui.LogElementDialog;
import com.kingdee.bos.tool.dbupdate.ui.LogTableCellModifier;
import com.kingdee.bos.tool.dbupdate.ui.LogTableLabelProvider;
import com.kingdee.bos.tool.dbupdate.ui.MenuManagerImpl;
import com.kingdee.bos.tool.dbupdate.ui.PreferencesDialog;
import com.kingdee.bos.tool.dbupdate.ui.ResourceManager;
import com.kingdee.bos.tool.dbupdate.ui.TableCellModifier;
import com.kingdee.bos.tool.dbupdate.ui.TableDiffDialog;
import com.kingdee.bos.tool.dbupdate.ui.TableLabelProvider;
import com.kingdee.bos.tool.dbupdate.ui.ToolBarManagerImpl;
import com.kingdee.bos.tool.dbupdate.ui.wizard.DBSynchronizeAction;
import com.kingdee.bos.tool.dbupdate.ui.wizard.FileProcess;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class DBSynchronizer
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.studio.dbupdate.ui.DBSynchronizer");
    public static final String[] columnNames = new String[]{DBSynchronizerMessages.Selected, DBSynchronizerMessages.MasterTable, DBSynchronizerMessages.Compare, DBSynchronizerMessages.TargetTable};
    public static final String[] logColumnNames = new String[]{DBSynchronizerMessages.Status, DBSynchronizerMessages.Time, DBSynchronizerMessages.Message, DBSynchronizerMessages.ErrorInfo};
    public static final String[] compareStateList = new String[]{"<", ">", "<>", "=", "?"};
    private static DBSynchronizer self;
    private String url;
    private File currentFile;
    private DBCompareInfo compareInfo;
    private Connection masterConnection;
    private Connection targetConnection;
    private Report report;
    private static Shell lastOpenShell;
    private SashForm sashForm;
    private Table table;
    private CheckboxTableViewer tableViewer;
    private TableReportCollection elements;
    private Table logTable;
    private TableViewer logTableViewer;
    private LogRecord[] logElements;
    private IMenuManager menuManager;
    private IToolBarManager toolBarManager;
    public static final String NAME = "Name";
    public static final String MENU_FILE = "File";
    public static final String MENU_FILE_NEW_WIZARD = "New";
    public static final String MENU_FILE_OPEN = "Open";
    public static final String MENU_FILE_SAVE = "Save";
    public static final String MENU_FILE_SAVEAS = "SaveAs";
    public static final String MENU_FILE_EXIT = "Exit";
    public static final String MENU_EDIT = "Edit";
    public static final String MENU_EDIT_CLEAR = "Clear";
    public static final String MENU_EDIT_SELECTALL = "SelectAll";
    public static final String MENU_EDIT_UNSELECTALL = "UnselectAll";
    public static final String MENU_TOOL = "Tool";
    public static final String MENU_TOOL_GENERATE_SCRIPT = "GenerateScript";
    public static final String MENU_TOOL_EXECUTE = "Execute";
    public static final String MENU_TOOL_SAVE_SCRIPT = "SaveScript";
    public static final String MENU_TOOL_PREFERENCES = "Preferences";
    public static final String MENU_HELP = "Help";
    public static final String MENU_HELP_ABOUT = "About";
    public static final String TOOLITEM_NEW_WIZARD = "New";
    public static final String TOOLITEM_OPEN = "Open";
    public static final String TOOLITEM_SAVE = "Save";
    public static final String TOOLITEM_SAVEAS = "SaveAs";
    public static final String TOOLITEM_SELECT = "SelectAll";
    public static final String TOOLITEM_UNSELECT = "UnselectAll";
    public static final String TOOLITEM_CLEAR = "Clear";
    public static final String TOOLITEM_GENERATE_SCRIPT = "GenerateScript";
    public static final String TOOLITEM_EXECUTE = "Execute";
    public static final String TOOLITEM_SAVE_SCRIPT = "SaveScript";
    public static final String EXPORT_SELECTPATH = "SelectPath";
    public static final String EXPORT_SELECTPATHMSG = "SelectPathMsg";
    public static final String EXPORT_EXPORTFILENAME = "ExportFileName";
    public static final String SOLUTION_MSG_TEXT = "SolutionMsgText";
    public static final String SOLUTION_MSG_OVERWRITE = "SolutionMsgOverwrite";

    public static DBSynchronizer getInstance() {
        if (self == null) {
            self = new DBSynchronizer();
        }
        return self;
    }

    public static Shell getShell() {
        return lastOpenShell;
    }

    public static void main(String[] args) {
        Display display = new Display();
        lastOpenShell = DBSynchronizer.getInstance().open(display);
        while (!lastOpenShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void setLastOpenShell(Shell s) {
        lastOpenShell = s;
    }

    public Shell open(Display display) {
        DBSynchronizer.setLastOpenShell(new Shell(display));
        lastOpenShell.setText(DBSynchronizerMessages.Name);
        lastOpenShell.setImage(ResourceManager.getInstance().applyImage("icons/main.gif", (Widget)lastOpenShell));
        lastOpenShell.setSize(800, 600);
        lastOpenShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = DBSynchronizer.this.closeDBSynchronizer();
            }
        });
        this.menuManager = new MenuManagerImpl();
        this.menuManager.createMenuBar(lastOpenShell);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        lastOpenShell.setLayout((Layout)gl);
        Label lab = new Label((Composite)lastOpenShell, 258);
        GridData data = new GridData(768);
        data.verticalAlignment = 4;
        data.horizontalIndent = -5;
        lab.setLayoutData((Object)data);
        this.toolBarManager = new ToolBarManagerImpl();
        this.toolBarManager.createToolBar(lastOpenShell);
        lab = new Label((Composite)lastOpenShell, 258);
        data = new GridData(768);
        data.verticalAlignment = 4;
        data.horizontalIndent = -5;
        lab.setLayoutData((Object)data);
        this.sashForm = new SashForm((Composite)lastOpenShell, 512);
        data = new GridData(1808);
        this.sashForm.setLayoutData((Object)data);
        this.createDialogArea((Composite)this.sashForm);
        this.createLogArea((Composite)this.sashForm);
        this.registerListeners();
        lastOpenShell.open();
        return lastOpenShell;
    }

    private void registerListeners() {
        MenuItem menuItem = this.menuManager.getMenuItem("New");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.newWizard(null);
            }
        });
        menuItem = this.menuManager.getMenuItem("Open");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.openSoluntion(null);
            }
        });
        menuItem = this.menuManager.getMenuItem("Save");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.saveSolution();
            }
        });
        menuItem = this.menuManager.getMenuItem("SaveAs");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.saveasSolution();
            }
        });
        menuItem = this.menuManager.getMenuItem(MENU_FILE_EXIT);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                lastOpenShell.close();
            }
        });
        menuItem = this.menuManager.getMenuItem("GenerateScript");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.generateScript();
            }
        });
        menuItem = this.menuManager.getMenuItem("Execute");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.execute();
            }
        });
        menuItem = this.menuManager.getMenuItem("SaveScript");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.saveScript();
            }
        });
        menuItem = this.menuManager.getMenuItem(MENU_TOOL_PREFERENCES);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.preferences();
            }
        });
        menuItem = this.menuManager.getMenuItem(MENU_HELP_ABOUT);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.showHelpAbout();
            }
        });
        ToolItem toolItem = this.toolBarManager.getToolItem("New");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.newWizard(null);
            }
        });
        toolItem = this.toolBarManager.getToolItem("Clear");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.clear();
            }
        });
        toolItem = this.toolBarManager.getToolItem("Open");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.openSoluntion(null);
            }
        });
        toolItem = this.toolBarManager.getToolItem("Save");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.saveSolution();
            }
        });
        toolItem = this.toolBarManager.getToolItem("SaveAs");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.saveasSolution();
            }
        });
        toolItem = this.toolBarManager.getToolItem("SelectAll");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.selectAll();
            }
        });
        toolItem = this.toolBarManager.getToolItem("UnselectAll");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.unselectAll();
            }
        });
        toolItem = this.toolBarManager.getToolItem("GenerateScript");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.generateScript();
            }
        });
        toolItem = this.toolBarManager.getToolItem("Execute");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.execute();
            }
        });
        toolItem = this.toolBarManager.getToolItem("SaveScript");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSynchronizer.this.saveScript();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DBSynchronizer.this.showTableDiffDialog();
            }
        });
    }

    private void showTableDiffDialog() {
        int selectIndex = this.table.getSelectionIndex();
        if (this.table.getItem(selectIndex) != null && this.table.getItem(selectIndex).getData() != null) {
            TableReportItem item = (TableReportItem)this.table.getItem(selectIndex).getData();
            TableDiffDialog dlg = new TableDiffDialog(lastOpenShell, item);
            dlg.create();
        }
    }

    private void preferences() {
        PreferencesDialog dlg = new PreferencesDialog(lastOpenShell);
        dlg.create();
        dlg.open();
    }

    private boolean closeDBSynchronizer() {
        MessageBox box = new MessageBox(lastOpenShell, 200);
        box.setText(lastOpenShell.getText());
        box.setMessage(DBSynchronizerMessages.Close);
        int choice = box.open();
        if (choice == 128) {
            return false;
        }
        if (choice == 64) {
            // empty if block
        }
        return true;
    }

    private void createLogArea(Composite composite) {
        this.createLogTable(composite);
        this.createLogTableViewer();
    }

    private void createDialogArea(Composite composite) {
        this.createTable(composite);
        this.createTableViewer();
    }

    private void createLogTable(Composite parent) {
        int style = 101124;
        this.logTable = new Table(parent, style);
        this.logTable.setLinesVisible(true);
        this.logTable.setHeaderVisible(true);
        this.createLogColumns();
    }

    private void createTable(Composite parent) {
        int style = 101156;
        this.table = new Table(parent, style);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.createColumns();
    }

    private void createLogColumns() {
        TableColumn column = new TableColumn(this.logTable, 16384, 0);
        column.setText(logColumnNames[0]);
        column.setWidth(60);
        column = new TableColumn(this.logTable, 16384, 1);
        column.setText(logColumnNames[1]);
        column.setWidth(100);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        column = new TableColumn(this.logTable, 16384, 2);
        column.setText(logColumnNames[2]);
        column.setWidth(200);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        column = new TableColumn(this.logTable, 16384, 3);
        column.setText(logColumnNames[3]);
        column.setWidth(200);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
    }

    private void createColumns() {
        TableColumn column = new TableColumn(this.table, 16384, 0);
        column.setText(columnNames[0]);
        column.setWidth(60);
        column = new TableColumn(this.table, 16384, 1);
        column.setText(columnNames[1]);
        column.setWidth(200);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        column = new TableColumn(this.table, 0x1000000, 2);
        column.setText(columnNames[2]);
        column.setWidth(100);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        column = new TableColumn(this.table, 16384, 3);
        column.setText(columnNames[3]);
        column.setWidth(200);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
    }

    private void createLogTableViewer() {
        this.logTableViewer = new TableViewer(this.logTable);
        this.logTableViewer.setUseHashlookup(true);
        this.logTableViewer.setColumnProperties(logColumnNames);
        CellEditor[] editors = new CellEditor[logColumnNames.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this.logTable);
        editors[0] = textEditor;
        textEditor = new TextCellEditor((Composite)this.logTable);
        editors[1] = textEditor;
        editors[2] = new TextCellEditor((Composite)this.logTable);
        textEditor = new TextCellEditor((Composite)this.logTable);
        editors[3] = textEditor;
        this.logTableViewer.setCellEditors(editors);
        this.logTableViewer.setLabelProvider((IBaseLabelProvider)new LogTableLabelProvider());
        this.logTableViewer.setContentProvider((IContentProvider)new LogTableContentProvider());
        this.logTableViewer.setCellModifier((ICellModifier)new LogTableCellModifier(this.logTableViewer));
        this.logTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LogRecord record = (LogRecord)((StructuredSelection)DBSynchronizer.this.logTableViewer.getSelection()).getFirstElement();
                LogElementDialog dlg = new LogElementDialog(lastOpenShell, record);
                dlg.create();
                if (dlg.open() == 0) {
                    // empty if block
                }
            }
        });
    }

    private void createTableViewer() {
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columnNames);
        CellEditor[] editors = new CellEditor[columnNames.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this.table);
        editors[0] = textEditor;
        textEditor = new TextCellEditor((Composite)this.table);
        editors[1] = textEditor;
        editors[2] = new ComboBoxCellEditor((Composite)this.table, compareStateList, 8);
        textEditor = new TextCellEditor((Composite)this.table);
        editors[3] = textEditor;
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setCellModifier((ICellModifier)new TableCellModifier((TableViewer)this.tableViewer));
    }

    private void newWizard(IProgressMonitor monitor) {
        this.runWizard(monitor);
    }

    private void refresh(IProgressMonitor monitor) {
        this.getCompareReport(monitor);
        this.table.removeAll();
        this.fieldsLoad();
    }

    private void runWizard(IProgressMonitor monitor) {
        DBSynchronizeAction dbSynchronizeAction = new DBSynchronizeAction();
        dbSynchronizeAction.shell = lastOpenShell;
        dbSynchronizeAction.compareInfo = this.compareInfo;
        dbSynchronizeAction.run();
        this.compareInfo = dbSynchronizeAction.getDBCompareInfo();
        if (this.compareInfo != null) {
            try {
                this.masterConnection = new DataSource(this.compareInfo.getMasterDB()).getConnection();
                this.targetConnection = new DataSource(this.compareInfo.getTargetDB()).getConnection();
            }
            catch (SQLException e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
        this.getCompareReport(monitor);
        this.fieldsLoad();
    }

    private void getCompareReport(IProgressMonitor monitor) {
        if (this.masterConnection != null && this.targetConnection != null) {
            DBUpdateEngineImpl dbUpdateEngine = new DBUpdateEngineImpl();
            this.report = dbUpdateEngine.getDifferenceReport(this.targetConnection, this.masterConnection);
        }
    }

    private void fieldsLoad() {
        if (this.report == null || this.report.getTableReportCollection() == null) {
            return;
        }
        this.clear();
        this.elements = this.report.getTableReportCollection();
        this.tableViewer.setInput((Object)this.elements);
        this.selectAll();
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            if (this.elements.get(i).getReportState() != 4) continue;
            this.tableViewer.setChecked((Object)this.elements.get(i), false);
        }
    }

    private void selectAll() {
        this.tableViewer.setAllChecked(true);
    }

    private void unselectAll() {
        this.tableViewer.setAllChecked(false);
    }

    private void execute() {
        ProgressMonitorDialog dlg = new ProgressMonitorDialog(lastOpenShell);
        try {
            dlg.run(false, true, (IRunnableWithProgress)this);
        }
        catch (Exception ex) {
            logger.error((Object)"error", (Throwable)ex);
        }
    }

    private void generateScript() {
        this.logTable.removeAll();
        this.getGenerateSql();
        if (this.logElements == null) {
            this.showSqlErrorWarning();
            return;
        }
        this.logTableViewer.setInput((Object)this.logElements);
    }

    private void getGenerateSql() {
        Report filtedReport = new Report();
        Object[] items = this.tableViewer.getCheckedElements();
        if (items == null || items.length == 0) {
            this.logElements = null;
            return;
        }
        int n = items.length;
        for (int i = 0; i < n; ++i) {
            TableReportItem item = (TableReportItem)items[i];
            filtedReport.getTableReportCollection().add(item);
        }
        DBUpdateEngineImpl dbUpdateEngine = new DBUpdateEngineImpl();
        DBUpdateList dbUpdateList = dbUpdateEngine.generateUpdateScript(this.targetConnection, filtedReport);
        this.logElements = new LogRecord[dbUpdateList.size()];
        int n2 = this.logElements.length;
        for (int i = 0; i < n2; ++i) {
            this.logElements[i] = new LogRecord();
            this.logElements[i].msg = dbUpdateList.getInfo(i).getSql();
            this.logElements[i].status = 0;
        }
    }

    private void saveScript() {
        DirectoryDialog fDialog = new DirectoryDialog(lastOpenShell, 73728);
        fDialog.setText(DBSynchronizerMessages.SelectPath);
        fDialog.setMessage(DBSynchronizerMessages.SelectPathMsg);
        if (this.url != null && new File(this.url).exists()) {
            fDialog.setFilterPath(this.url);
        }
        this.url = fDialog.open();
        if (this.logElements == null) {
            this.showFileErrotWarning();
            return;
        }
        StringBuffer sb = new StringBuffer();
        int n = this.logElements.length;
        for (int i = 0; i < this.logElements.length; ++i) {
            sb.append(this.logElements[i].msg);
        }
        this.exportToFile(DBSynchronizerMessages.ExportFileName, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToFile(String fileName, String sql) {
        try {
            File file = new File(this.url + "/" + fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = null;
            try {
                fw = new FileWriter(file);
                fw.write(sql);
                fw.flush();
            }
            catch (Throwable throwable) {
                FileUtils.close(fw);
                throw throwable;
            }
            FileUtils.close(fw);
        }
        catch (IOException e) {
            this.showFileErrotWarning();
        }
    }

    private void clear() {
        this.table.removeAll();
        this.logTableViewer.getTable().removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveasSolution() {
        File file;
        if (this.compareInfo == null || this.masterConnection == null || this.targetConnection == null) {
            this.showInfoNotAllWarning();
            return;
        }
        SyncSolutionInfo sync = new SyncSolutionInfo();
        sync.setMasterDs(this.compareInfo.getMasterDB());
        sync.setTargetDs(this.compareInfo.getTargetDB());
        FileDialog saveDialog = new FileDialog(lastOpenShell, 8192);
        saveDialog.setFilterExtensions(new String[]{"*.xml;", "*.*"});
        saveDialog.setFilterNames(new String[]{"Solution Info (*.xml)", "All Files (*.*)"});
        saveDialog.open();
        String name = saveDialog.getFileName();
        if (name.equals("")) {
            return;
        }
        if (name.indexOf(".xml") != name.length() - 4) {
            name = name + ".xml";
        }
        if ((file = new File(saveDialog.getFilterPath(), name)).exists()) {
            MessageBox box = new MessageBox(lastOpenShell, 200);
            box.setText(DBSynchronizerMessages.SolutionMsgText);
            box.setMessage(DBSynchronizerMessages.SolutionMsgText + " " + file.getName() + " " + DBSynchronizerMessages.SolutionMsgOverwrite);
            if (box.open() != 64) {
                return;
            }
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            FileProcess.store(sync, fileOutputStream);
        }
        catch (IOException ioe) {
            try {
                this.showFileErrotWarning();
            }
            catch (Throwable throwable) {
                FileUtils.close(fileOutputStream);
                throw throwable;
            }
            FileUtils.close(fileOutputStream);
        }
        FileUtils.close(fileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSolution() {
        if (this.currentFile == null) {
            this.saveasSolution();
            return;
        }
        if (this.compareInfo == null || this.masterConnection == null || this.targetConnection == null) {
            this.showInfoNotAllWarning();
            return;
        }
        SyncSolutionInfo sync = new SyncSolutionInfo();
        sync.setMasterDs(this.compareInfo.getMasterDB());
        sync.setTargetDs(this.compareInfo.getTargetDB());
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.currentFile);
            FileProcess.store(sync, fileOutputStream);
        }
        catch (IOException ioe) {
            try {
                this.showFileErrotWarning();
            }
            catch (Throwable throwable) {
                FileUtils.close(fileOutputStream);
                throw throwable;
            }
            FileUtils.close(fileOutputStream);
        }
        FileUtils.close(fileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSoluntion(IProgressMonitor monitor) {
        SyncSolutionInfo sync = null;
        FileDialog fileDialog = new FileDialog(lastOpenShell, 4096);
        fileDialog.setFilterExtensions(new String[]{"*.xml;", "*.*"});
        fileDialog.setFilterNames(new String[]{"Solution Info (*.xml)", "All Files (*.*)"});
        String name = fileDialog.open();
        if (name == null) {
            return;
        }
        File file = new File(name);
        if (!file.exists()) {
            this.showFileErrotWarning();
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            sync = FileProcess.load(fileInputStream);
        }
        catch (Exception e) {
            try {
                this.showFileErrotWarning();
            }
            catch (Throwable throwable) {
                FileUtils.close(fileInputStream);
                throw throwable;
            }
            FileUtils.close(fileInputStream);
        }
        FileUtils.close(fileInputStream);
        if (sync != null) {
            this.currentFile = file;
            this.compareInfo = new DBCompareInfo();
            this.compareInfo.setMasterDB(sync.getMasterDs());
            this.compareInfo.setTargetDB(sync.getTargetDs());
            this.runWizard(monitor);
        }
    }

    private void showHelpAbout() {
        MessageBox box = new MessageBox(lastOpenShell, 0);
        box.setText(DBSynchronizerMessages.About_1 + lastOpenShell.getText());
        box.setMessage(lastOpenShell.getText() + DBSynchronizerMessages.About_2);
        box.open();
    }

    private void showFileErrotWarning() {
        MessageDialog dlg = new MessageDialog(DBSynchronizer.getShell(), "warning", null, DBSynchronizerMessages.FileErrorWarning, 2, new String[]{"OK"}, 0);
        dlg.create();
        dlg.open();
    }

    private void showSqlErrorWarning() {
        MessageDialog dlg = new MessageDialog(DBSynchronizer.getShell(), "warning", null, DBSynchronizerMessages.SqlNullWarning, 2, new String[]{"OK"}, 0);
        dlg.create();
        dlg.open();
    }

    private void showInfoNotAllWarning() {
        MessageDialog dlg = new MessageDialog(DBSynchronizer.getShell(), "warning", null, DBSynchronizerMessages.InfoNotAllWarning, 2, new String[]{"OK"}, 0);
        dlg.create();
        dlg.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) {
        try {
            if (this.logElements == null) {
                this.showSqlErrorWarning();
                return;
            }
            monitor.beginTask("Execute SQL", this.logElements.length);
            int n = this.logElements.length;
            for (int i = 0; i < n; ++i) {
                Timestamp time;
                this.logElements[i].time = time = new Timestamp(System.currentTimeMillis());
                String sql = this.logElements[i].msg;
                try {
                    DBUtils.excuteUpdateSQL(this.targetConnection, sql);
                    this.logElements[i].status = 2;
                    monitor.worked(1);
                    continue;
                }
                catch (SQLException e) {
                    logger.error((Object)"error", (Throwable)e);
                    this.logElements[i].status = 4;
                    this.logElements[i].errorInfo = e.getMessage();
                    MessageBox box = new MessageBox(lastOpenShell, 200);
                    box.setText(DBSynchronizerMessages.Execute);
                    box.setMessage(DBSynchronizerMessages.SqlExecuteError);
                    if (box.open() == 64) continue;
                    break;
                }
                finally {
                    this.logTableViewer.refresh((Object)this.logElements[i]);
                }
            }
        }
        finally {
            try {
                if (this.masterConnection != null) {
                    this.masterConnection.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (this.targetConnection != null) {
                    this.targetConnection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        monitor.done();
    }

    private class LogTableContentProvider
    implements IStructuredContentProvider {
        private LogTableContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return DBSynchronizer.this.logElements;
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return DBSynchronizer.this.elements.toArray();
        }
    }
}

