/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dialog.mutillang;

import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.tool.dialog.mutillang.IMultiLangUnit;
import com.kingdee.bos.tool.dialog.mutillang.Messages;
import com.kingdee.bos.tool.dialog.mutillang.MultiLangContainer;
import com.kingdee.bos.tool.dialog.mutillang.MultiLangUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;

public class MultiLangPanel
extends Composite {
    private TableTreeViewer viewer;
    private String[] columnProperties;
    private LanguageCollection languages;
    private static final String FIRST_COLUMN_NAME = Messages.MultiLangPanel_MingCheng;

    public MultiLangPanel(Composite parent, int style, LanguageCollection languages) {
        super(parent, style);
        this.languages = languages;
        this.getColumnNames();
        this.createPanel();
    }

    public void setInput(Map input) {
        assert (input instanceof Map);
        MultiLangContainer container = new MultiLangContainer();
        container.setName("");
        Map map = input;
        for (String key : map.keySet()) {
            if (key.indexOf("extendedProperty") != -1) continue;
            Map value = (Map)map.get(key);
            this.parserKey(container, key.substring(key.indexOf("].") + 1), value);
        }
        this.viewer.setInput((Object)container);
    }

    public TableTreeViewer getViewer() {
        return this.viewer;
    }

    public void setDefaultProviderAndCellModifier() {
        this.viewer.setContentProvider((IContentProvider)new InnerContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new InnerLabelProvider());
        this.viewer.setCellModifier((ICellModifier)new InnerTableCellModifier());
    }

    public void setDefaultViewerSorter() {
        this.viewer.setSorter((ViewerSorter)new MultiLangUnitViewerSorter());
    }

    protected void createPanel() {
        this.setLayout((Layout)new FillLayout());
        int style = 68352;
        this.viewer = new TableTreeViewer((Composite)this, style);
        this.viewer.setUseHashlookup(true);
        this.viewer.getTableTree().getTable().setLinesVisible(true);
        this.viewer.getTableTree().getTable().setHeaderVisible(true);
        this.viewer.getTableTree().setBackground(this.getDisplay().getSystemColor(15));
        this.viewer.setColumnProperties(this.columnProperties);
        for (int i = 0; i < this.columnProperties.length; ++i) {
            TableColumn column = new TableColumn(this.viewer.getTableTree().getTable(), 16384, i);
            if (i == 0) {
                column.setWidth(250);
            } else {
                column.setWidth(150);
            }
            column.setText(this.columnProperties[i]);
            column.setResizable(true);
        }
        CellEditor[] editors = new CellEditor[this.columnProperties.length];
        for (int i = 0; i < editors.length; ++i) {
            editors[i] = new TextCellEditor((Composite)this.viewer.getTableTree().getTable());
        }
        this.viewer.setCellEditors(editors);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new DobleClickListener());
        this.viewer.getTableTree().setFocus();
    }

    private void parserKey(MultiLangContainer contianer, String key, Map value) {
        MultiLangContainer current = contianer;
        List list = this.getLabels(key);
        for (int i = 0; i < list.size(); ++i) {
            String token = (String)list.get(i);
            if (i < list.size() - 1) {
                if (current.containts(token)) {
                    current = (MultiLangContainer)current.getChild(token);
                    continue;
                }
                MultiLangContainer newContainer = new MultiLangContainer();
                newContainer.setName(token);
                current.add(newContainer);
                current = newContainer;
                continue;
            }
            MultiLangUnit unit = new MultiLangUnit(token);
            unit.setParent(current);
            unit.setValues(value);
            current.add(unit);
        }
    }

    private void getColumnNames() {
        this.columnProperties = new String[this.languages.size() + 1];
        this.columnProperties[0] = FIRST_COLUMN_NAME;
        for (int i = 0; i < this.languages.size(); ++i) {
            LanguageInfo info = this.languages.get(i);
            this.columnProperties[i + 1] = info.getName();
        }
    }

    private List getLabels(String key) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(key, ".");
        while (tokenizer.hasMoreElements()) {
            String token = (String)tokenizer.nextElement();
            int left = token.indexOf("[");
            int right = token.indexOf("]");
            if (right > left + 1 && left > 0) {
                token = token.substring(left + 1, right);
            }
            list.add(token);
        }
        return list;
    }

    private class InnerTableCellModifier
    implements ICellModifier {
        private InnerTableCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (element instanceof MultiLangContainer) {
                return false;
            }
            return !property.equals(MultiLangPanel.this.columnProperties[0]);
        }

        public Object getValue(Object element, String property) {
            IMultiLangUnit unit = (IMultiLangUnit)element;
            if (property.equals(MultiLangPanel.this.columnProperties[0])) {
                return unit.getName();
            }
            if (unit instanceof MultiLangUnit) {
                String locale = this.getLocale(property);
                Map value = ((MultiLangUnit)unit).getValues();
                if (locale != null) {
                    return value.get(locale) == null ? "" : value.get(locale);
                }
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            Object obj = ((TableTreeItem)element).getData();
            if (obj instanceof MultiLangUnit) {
                MultiLangUnit unit = (MultiLangUnit)obj;
                if (!property.equals(MultiLangPanel.this.columnProperties[0])) {
                    String locale = this.getLocale(property);
                    Map v = unit.getValues();
                    if (locale != null && !value.equals(v.get(locale))) {
                        v.put(locale, value);
                        MultiLangPanel.this.viewer.refresh();
                    }
                }
            }
        }

        private String getLocale(String property) {
            if (property == null) {
                return null;
            }
            for (int i = 0; i < MultiLangPanel.this.languages.size(); ++i) {
                LanguageInfo info = MultiLangPanel.this.languages.get(i);
                if (!property.equals(info.getName()) && !property.equals(info.getPostfix())) continue;
                return info.getLocaleString();
            }
            return null;
        }
    }

    private class InnerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private InnerLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IMultiLangUnit) {
                if (columnIndex == 0) {
                    return ((IMultiLangUnit)element).getName();
                }
                if (element instanceof MultiLangUnit) {
                    MultiLangUnit unit = (MultiLangUnit)element;
                    String local = MultiLangPanel.this.languages.get(columnIndex - 1).getLocaleString();
                    String text = (String)unit.getValues().get(local);
                    if (text != null) {
                        return text;
                    }
                }
            }
            return "";
        }
    }

    private class InnerContentProvider
    implements ITreeContentProvider {
        private InnerContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IMultiLangUnit) {
                return ((IMultiLangUnit)parentElement).getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IMultiLangUnit) {
                return ((IMultiLangUnit)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class MultiLangUnitViewerSorter
    extends ViewerSorter {
        private static final int UNIT = 1;
        private static final int CONTAINER = 2;
        private static final int OTHERS = 31;

        private MultiLangUnitViewerSorter() {
        }

        public int category(Object element) {
            assert (element instanceof IMultiLangUnit);
            return this.getCatagory((IMultiLangUnit)element);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            return super.compare(viewer, e1, e2);
        }

        public int getCatagory(IMultiLangUnit unit) {
            if (unit instanceof MultiLangContainer) {
                return 2;
            }
            if (unit instanceof MultiLangUnit) {
                return 1;
            }
            return 31;
        }
    }

    private class DobleClickListener
    implements IDoubleClickListener {
        private DobleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            TableTreeItem[] items = MultiLangPanel.this.viewer.getTableTree().getSelection();
            if (items.length == 0) {
                return;
            }
            int count = MultiLangPanel.this.viewer.getExpandedElements().length;
            MultiLangPanel.this.viewer.expandToLevel(items[0].getData(), -1);
            if (count == MultiLangPanel.this.viewer.getExpandedElements().length) {
                MultiLangPanel.this.viewer.collapseToLevel(items[0].getData(), -1);
            }
        }
    }
}

