/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.function;

import com.kingdee.bos.tool.function.DynamicBindContext;
import com.kingdee.bos.tool.function.Func;
import com.kingdee.bos.tool.function.Func1;
import com.kingdee.bos.tool.function.Func1V;
import com.kingdee.bos.tool.function.Func2;
import com.kingdee.bos.tool.function.FuncV;
import com.kingdee.bos.tool.function.Lists;
import com.kingdee.bos.tool.function.Preconditions;
import com.kingdee.bos.tool.function.Predicate;
import com.kingdee.bos.tool.function.ToolRuntimeException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class Functions {
    public static Func2<Integer, Integer, Integer> add = new Func2<Integer, Integer, Integer>(){

        @Override
        public Integer invoke(Integer a, Integer b) {
            return a + b;
        }
    };
    public static Func2<Integer, Integer, Integer> max = new Func2<Integer, Integer, Integer>(){

        @Override
        public Integer invoke(Integer a, Integer b) {
            return Math.max(a, b);
        }
    };
    public static Func2<Integer, Integer, Integer> min = new Func2<Integer, Integer, Integer>(){

        @Override
        public Integer invoke(Integer a, Integer b) {
            return Math.min(a, b);
        }
    };

    public static void debug(Object info) {
        if (Boolean.parseBoolean(DynamicBindContext.getBindContextVariable("debug").toString())) {
            System.out.println("debug: " + info);
        }
    }

    public static void println(Object ... args) {
        for (Object obj : args) {
            System.out.print(obj);
        }
        System.out.println();
    }

    public static <T, F> F convertObject(T source, Func1<F, T> convert, F defaultValue) {
        Preconditions.checkNotNull(convert, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "convert");
        if (source == null) {
            return defaultValue;
        }
        return convert.invoke(source);
    }

    public static <T> T nullAsDefault(T source, T defaultValue) {
        return source == null ? defaultValue : source;
    }

    public static <T> T ifelse(boolean condition, T trueObj, T falseObj) {
        return condition ? trueObj : falseObj;
    }

    public static <T, F> F invokeWithNoNull(T obj, Func<F> callback) {
        return Functions.invokeWithNoNull(obj, callback, null);
    }

    public static <T, F> F invokeWithNoNull(T obj, Func<F> callback, F defaultValue) {
        return obj == null ? defaultValue : callback.invoke();
    }

    public static <T, F> F invokeWithNoNull(T obj, Predicate<T> filter, Func<F> callback) {
        if (obj != null && filter.apply(obj)) {
            return callback.invoke();
        }
        return null;
    }

    public static <T, F> F invokeAsParam(T obj, Func1<F, T> callback) {
        Preconditions.checkNotNull(callback, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "callback");
        return callback.invoke(obj);
    }

    public static <T, F> F withParam(T obj, Func1<F, T> callback) {
        return Functions.invokeAsParam(obj, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R invokeWithTryCatchfinally(Func<R> run, Func1V<Exception> errorHandler, FuncV finallyFunc) {
        block13: {
            R r;
            Preconditions.checkNotNull(run, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "run");
            try {
                r = run.invoke();
            }
            catch (Exception ex) {
                if (errorHandler != null) {
                    errorHandler.invoke(ex);
                    break block13;
                }
                throw ToolRuntimeException.createToolRuntimeException(ex);
            }
            finally {
                if (finallyFunc != null) {
                    try {
                        finallyFunc.invoke();
                    }
                    catch (Exception exception) {}
                }
            }
            return r;
        }
        return null;
    }

    public static Func2<String, String, String> createJoin(final String joinStr) {
        return new Func2<String, String, String>(){

            @Override
            public String invoke(String a, String b) {
                return a + joinStr + b;
            }
        };
    }

    public static <T> T reduce(Func2<T, T, T> sum, List<T> list) {
        if (list.isEmpty()) {
            return sum.invoke(null, null);
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        T value = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            value = sum.invoke(value, list.get(i));
        }
        return value;
    }

    public static <T> T reduce(Func2<T, T, T> sum, T[] array) {
        return Functions.reduce(sum, Lists.ofList(array));
    }

    public static <T> T reduce(Func2<T, T, T> sum, T value, List<T> list) {
        if (list.isEmpty()) {
            return value;
        }
        for (T t : list) {
            value = sum.invoke(value, t);
        }
        return value;
    }

    public static <T> T reduce(Func2<T, T, T> sum, T value, T[] array) {
        if (array.length == 0) {
            return value;
        }
        for (T t : array) {
            value = sum.invoke(value, t);
        }
        return value;
    }

    public static <T, F> F apply(FuncAny<F, T> func, List<T> list) {
        if (list.size() == 0) {
            return func.invoke(new Object[]{null});
        }
        return Functions.apply(func, list, list.get(0).getClass());
    }

    public static <T, F> F apply(FuncAny<F, T> func, List<T> list, Class type) {
        if (list.size() == 0) {
            return func.invoke(new Object[]{null});
        }
        T[] array = Functions.createArray(type, list.size());
        System.arraycopy(list.toArray(), 0, array, 0, list.size());
        return func.invoke(array);
    }

    public static <F> F applyWithObject(FuncAny<F, Object> func, List<Object> list) {
        if (list.size() == 0) {
            return func.invoke((Object[])new Object[]{null});
        }
        return func.invoke((Object[])list.toArray());
    }

    public static <F> F applyWithObject(FuncAny<F, Object> func, Object value, List<Object> list) {
        if (list.size() == 0) {
            return func.invoke((Object[])new Object[]{value});
        }
        T[] array = Functions.createArray(Object.class, list.size() + 1);
        array[0] = value;
        if (list.size() > 0) {
            System.arraycopy(list.toArray(), 0, array, 1, list.size());
        }
        return func.invoke(array);
    }

    public static <T, F> F apply(FuncAny<F, T> func, T value, List<T> list, Class type) {
        Preconditions.checkNotNull(value, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "value");
        Preconditions.checkNotNull(list, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "list");
        T[] array = Functions.createArray(type, list.size() + 1);
        array[0] = value;
        if (array.length > 1) {
            System.arraycopy(list.toArray(), 0, array, 1, list.size());
        }
        return func.invoke(array);
    }

    public static <T, F> F apply(FuncAny<F, T> func, T[] array) {
        if (array.length == 0) {
            return null;
        }
        return func.invoke(array);
    }

    public static <T, F> F apply(FuncAny<F, T> func, T value, T[] array, Class type) {
        Preconditions.checkNotNull(value, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "value");
        Preconditions.checkNotNull(array, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "array");
        T[] newArray = Functions.createArray(type, array.length + 1);
        newArray[0] = value;
        if (newArray.length > 1) {
            System.arraycopy(array, 0, array, 1, newArray.length);
        }
        return func.invoke(newArray);
    }

    public static <T> T[] createArray(Class type, int size) {
        return (Object[])Array.newInstance(type, size);
    }

    public static void main(String[] args) {
        ArrayList<Integer> intDataList = new ArrayList<Integer>();
        for (int i = 0; i <= 100; ++i) {
            intDataList.add(i);
        }
        Functions.println("total=", Functions.reduce(add, intDataList));
        Functions.println("max=", Functions.reduce(max, intDataList));
        System.out.println(Functions.reduce(Functions.createJoin("/"), "d:", Lists.ofList("a", "b", "c")));
        System.out.println(Functions.reduce(Functions.createJoin("/"), Lists.ofList("a", "b", "c")));
        System.out.println(Functions.apply(new FuncAny<Integer, Integer>(){

            public Integer invoke(Integer ... params) {
                return Functions.reduce(add, params);
            }
        }, intDataList));
        Integer o = Functions.applyWithObject(new FuncAny<Integer, Object>(){

            @Override
            public Integer invoke(Object ... params) {
                int n = 0;
                for (Object obj : params) {
                    n = (Integer)obj + n;
                }
                return n;
            }
        }, 100, new ArrayList<Object>(Lists.ofList(1, 2, 3, 4)));
        System.out.println(o);
    }

    public static interface FuncAny<R, T> {
        public R invoke(T ... var1);
    }
}

