/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.CheckReportItem;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.md.multipageeditor.IMDFileEditorInput;
import com.kingdee.bos.md.multipageeditor.IMDSourceEditor;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.DynamicMetaDataContainer;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.metadata.validate.ValidateItem;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.ToolBasePlugin;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.check.ConsoleVerifyListener;
import com.kingdee.bos.tool.check.VerifyOperator;
import com.kingdee.bos.tool.check.VerifyReport;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.common.TranslateUtil;
import com.kingdee.bos.tool.console.IUserStream;
import com.kingdee.bos.tool.context.IToolContext;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.dao.ORMStudioBridger;
import com.kingdee.bos.tool.dao.ORMUtil;
import com.kingdee.bos.tool.multipageeditor.AbstractEditor;
import com.kingdee.bos.tool.multipageeditor.ExceptionHandler;
import com.kingdee.bos.tool.multipageeditor.MEditorDocumentProvider;
import com.kingdee.bos.tool.multipageeditor.Messages;
import com.kingdee.bos.tool.multipageeditor.SetTCWhenSaveHelper;
import com.kingdee.bos.tool.multipageeditor.ToolEditorContributor;
import com.kingdee.bos.tool.multipageeditor.common.CommonPage;
import com.kingdee.bos.tool.multipageeditor.common.ICommonPage;
import com.kingdee.bos.tool.utils.EditorHelper;
import com.kingdee.bos.tool.views.verify.CheckReport;
import com.kingdee.bos.tool.wizard.saveas.SaveAsWizard;
import com.kingdee.bos.tool.xmleditor.XMLEditor;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.DateTimeUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class BaseSourceEditor
extends AbstractEditor
implements IMDSourceEditor {
    private boolean reloadResult = true;
    private int sourceIndex;
    private XMLEditor xeditor;
    private IDocumentListener listener;
    private boolean documentDirty = false;
    protected HashSet readOnlyKeys = new HashSet();
    protected IObjectValue model = null;
    protected BOSObjectType modelType = null;
    protected MEditorDocumentProvider documentProvider;
    protected IUserStream us;
    private IEditorSite aSite;
    private boolean changeByPage = false;
    private boolean opened = false;

    protected XMLEditor getXMLEditor() {
        return this.xeditor;
    }

    @Override
    public IObjectValue getModel() {
        return this.model;
    }

    public BOSObjectType getModelType() {
        return this.modelType;
    }

    @Override
    public IDocumentListener getDocumentListener() {
        return this.listener;
    }

    @Override
    protected void createTabPages() {
        this.createSourcePage();
    }

    private void createSourcePage() {
        this.xeditor = new XMLEditor();
        this.xeditor.setDocumentProvider((IDocumentProvider)this.documentProvider);
        try {
            this.sourceIndex = this.addPage((IEditorPart)this.xeditor, this.getEditorInput());
            this.setPageText(this.sourceIndex, TranslateUtil.MUTILPAGEEDITOR_SOURCEPAGE_TITLE);
        }
        catch (Exception e) {
            ExceptionHandler.showException(e);
        }
        this.unregisterGlobalActions();
    }

    private void unregisterGlobalActions() {
        IKeyBindingService service = this.getSite().getKeyBindingService();
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.DELETE));
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.UNDO));
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.REDO));
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.CUT));
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.COPY));
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.PASTE));
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.SELECT_ALL));
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.FIND));
        service.unregisterAction(this.xeditor.getAction(IDEActionFactory.BOOKMARK.getId()));
    }

    public ToolEditorContributor getContributor() {
        return (ToolEditorContributor)this.getEditorSite().getActionBarContributor();
    }

    protected void refreshSourcePage() {
        this.documentProvider.refresh();
        this.documentDirty = false;
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        ToolCommonPlugin.startWatch();
        this.changeByPage = true;
        this.aSite = site;
        super.init(site, input);
        try {
            if (this.file != null) {
                this.modelType = ORMUtil.getType(this.file.getName());
                this.model = ORMUtil.load(this.file);
                ((AbstractMetaDataValue)this.model).setDirty(true);
            }
            this.listener = new InnerDocumentListener();
            this.documentProvider = new MEditorDocumentProvider(this);
            this.setReadOnlyKey("package");
            this.setReadOnlyKey("name");
        }
        catch (Exception e) {
            ExceptionHandler.showException(e);
        }
        AbstractMetaDataValue model = (AbstractMetaDataValue)this.getModel();
        if (!ToolCommonPlugin.isDevelopVersion() && !model.isUserDefined()) {
            Context ctx = ToolContextManager.getContext(this.getFile().getProject()).getORMContext();
            BOSObjectType bosType = model.getBOSType();
            try {
                XMLLoader xmlLoader = MDResourceUtil.getXMLLoader(ctx);
                EntityObjectInfo entity = xmlLoader.loadMeta(bosType);
                LogicalKeyInfo lkInfo = entity.getLogicalKey();
                PropertyCollection pc = lkInfo.getKeyPropertys();
                int size = pc.size();
                for (int i = 0; i < size; ++i) {
                    PropertyInfo pi = pc.get(i);
                    String lkName = pi.getName();
                    this.setReadOnlyKey(lkName);
                }
            }
            catch (DataAccessException e) {
                LogTool.logError("", e);
            }
        }
        ToolCommonPlugin.stopWatch();
    }

    @Override
    public void reLoad() {
        ToolCommonPlugin.startWatch();
        try {
            if (this.file != null) {
                this.model = ORMUtil.load(this.file);
                this.modelType = ORMUtil.getType(this.file.getName());
            }
        }
        catch (Exception e) {
            ExceptionHandler.showException(e);
        }
        ToolCommonPlugin.stopWatch();
    }

    public IUserStream getUserStream() {
        if (this.us == null) {
            String consoleName = ((AbstractMetaDataValue)this.getModel()).getFullName();
            consoleName = consoleName + " (" + DateTimeUtils.format((Date)new Date(System.currentTimeMillis())) + ")";
            this.us = ToolBasePlugin.getDefault().getUserStream(consoleName);
            this.us.setColor(Display.getCurrent().getSystemColor(3));
        }
        return this.us;
    }

    @Override
    protected void pageChange(int newPageIndex) {
        ToolCommonPlugin.startWatch();
        this.changeByPage = true;
        if (this.currentPage == this.sourceIndex && this.documentDirty) {
            this.refreshModel();
        }
        if (this.isNeedSync()) {
            this.refreshSourcePage();
        }
        super.pageChange(newPageIndex);
        this.getContributor().setActiveEditor(this);
        this.changeByPage = false;
        ToolCommonPlugin.startWatch();
    }

    protected void sourcePageAboutToBeChanged(DocumentEvent event) {
    }

    protected void sourcePageChanged(DocumentEvent event) {
        if (this.getCurrentPage() == this.sourceIndex) {
            this.documentDirty = true;
            this.setNeedSync(true);
            this.setModify(true);
        }
    }

    protected boolean refreshModel() {
        ToolCommonPlugin.startWatch();
        IDocument doc = this.documentProvider.getDocument();
        boolean invalid = false;
        String k2 = "";
        try {
            String pkg = (String)this.model.get("package");
            String name = (String)this.model.get("name");
            MetaDataPK pk = new MetaDataPK(pkg, name);
            IObjectValue newmodel = ORMUtil.getObjectValue(this.getParentFolder(), (IMetaDataPK)pk, this.modelType, doc.get());
            for (String k2 : this.readOnlyKeys) {
                Object newobj = newmodel.get(k2);
                Object oldobj = this.model.get(k2);
                if (newobj == null || oldobj == null || newobj.equals(oldobj)) continue;
                invalid = true;
                break;
            }
            if (invalid) {
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)"", (String)(Messages.BaseSourceEditor_ShuXing + k2 + Messages.BaseSourceEditor_BuNengBeiXiuGai));
            } else {
                this.model = newmodel;
            }
        }
        catch (Throwable e) {
            LogTool.logError("", e);
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.BaseSourceEditor_CuoWu, (String)Messages.BaseSourceEditor_JinXingLiaoFeiFaDeCaoZuoBianJiQiJiangHuiFuDaoYiQianBanBen);
            ToolCommonPlugin.stopWatch();
            return false;
        }
        ToolCommonPlugin.stopWatch();
        return !invalid;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        ToolCommonPlugin.startWatch();
        this.changeByPage = true;
        IToolContext ctx = ToolContextManager.getContext(this.file.getProject());
        if (ctx.isExtSolution()) {
            IFolder folder = ORMStudioBridger.getFolder((IResource)this.file);
            if (folder == null) {
                return;
            }
            if ("basetemp".equals(folder.getName())) {
                MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)"\u4e0d\u80fd\u4fdd\u5b58", (String)"\u4e0d\u5141\u8bb8\u4fdd\u5b58\u6807\u51c6\u5143\u6570\u636e!");
                this.documentDirty = false;
                ToolCommonPlugin.stopWatch();
                return;
            }
        }
        if (this.documentDirty) {
            if (!this.refreshModel()) {
                ToolCommonPlugin.stopWatch();
                return;
            }
            this.documentDirty = false;
        }
        this.check();
        this.checkPackageAndName();
        try {
            ORMUtil.store(this.getModel(), this.file, monitor);
        }
        catch (IDEException e) {
            ExceptionHandler.showException(e);
        }
        this.documentProvider.refresh();
        super.doSave(monitor);
        boolean flag = SetTCWhenSaveHelper.setTChineseAuto(this.file, this.getModel());
        if (flag) {
            EditorHelper.refreshOpenedEditor(MDResourceUtil.toMDFile(this.file));
        }
        this.reloadResult = true;
        ToolCommonPlugin.stopWatch();
    }

    private IPath getSaveAsPath() {
        IFile file = ORMUtil.getFile(this.getParentFolder(), this.model);
        return file.getFullPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSaveAs() {
        ToolCommonPlugin.startWatch();
        IToolContext ctx = ToolContextManager.getContext(this.file.getProject());
        if (ctx.isExtSolution()) {
            IFolder folder = ORMStudioBridger.getFolder((IResource)this.file);
            if (folder == null) {
                ToolCommonPlugin.stopWatch();
                return;
            }
            if ("basetemp".equals(folder.getName())) {
                MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)"\u4e0d\u80fd\u4fdd\u5b58", (String)"\u4e0d\u5141\u8bb8\u4fdd\u5b58\u6807\u51c6\u5143\u6570\u636e!");
                this.documentDirty = false;
                ToolCommonPlugin.stopWatch();
                return;
            }
        }
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        Shell shell = this.getSite().getShell();
        IEditorInput input = this.getEditorInput();
        IFile original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        WizardDialog dialog = new WizardDialog(shell, (IWizard)new SaveAsWizard((IWorkbenchSite)this.getSite(), this.getModel()));
        dialog.create();
        MEditorDocumentProvider provider = this.documentProvider;
        if (provider == null) {
            ToolCommonPlugin.stopWatch();
            return;
        }
        if (provider.isDeleted(input) && original != null) {
            String message = MessageFormat.format("Editor.warning.save.delete", original.getName());
            dialog.setErrorMessage(null);
            dialog.setMessage(message, 2);
        }
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            ToolCommonPlugin.stopWatch();
            return;
        }
        IPath filePath = this.getSaveAsPath();
        if (filePath == null) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            ToolCommonPlugin.stopWatch();
            return;
        }
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart aEditor = workbenchPage.findEditor(input);
        workbenchPage.closeEditor(aEditor, false);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        FileEditorInput newInput = new FileEditorInput(file);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation((IEditorInput)newInput){
            final /* synthetic */ IEditorInput val$newInput;
            {
                this.val$newInput = iEditorInput;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(IProgressMonitor monitor) throws CoreException {
                IFileEditorInput input;
                IFile file;
                if (BaseSourceEditor.this.documentDirty) {
                    if (!BaseSourceEditor.this.refreshModel()) {
                        ToolCommonPlugin.stopWatch();
                        return;
                    }
                    BaseSourceEditor.this.documentDirty = false;
                }
                if (BaseSourceEditor.this.getModel() instanceof AbstractMetaDataValue) {
                    ValidateList vldList = ((AbstractMetaDataValue)BaseSourceEditor.this.getModel()).validate();
                    BaseSourceEditor.showConsole();
                    if (vldList != null && BaseSourceEditor.this.getUserStream() != null) {
                        ValidateItem[] items = vldList.getItems();
                        for (int i = 0; i < items.length; ++i) {
                            BaseSourceEditor.this.getUserStream().println(items[i].getMessage());
                        }
                    }
                }
                if (!(file = (input = (IFileEditorInput)this.val$newInput).getFile()).exists()) {
                    InputStream stream = null;
                    try {
                        String encoding = BaseSourceEditor.this.documentProvider.getEncoding(input);
                        if (encoding == null) {
                            encoding = BaseSourceEditor.this.documentProvider.getDefaultEncoding();
                        }
                        String content = "";
                        stream = new ByteArrayInputStream(content.getBytes(encoding));
                        monitor.beginTask("FileDocumentProvider.task.saving", 2000);
                        ContainerGenerator generator = new ContainerGenerator(file.getParent().getFullPath());
                        generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                        file.create(stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    }
                    catch (Exception e) {
                        ExceptionHandler.showException(e);
                    }
                    finally {
                        monitor.done();
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                ExceptionHandler.showException(e);
                            }
                        }
                    }
                }
                try {
                    ORMUtil.store(BaseSourceEditor.this.getModel(), file, monitor);
                }
                catch (IDEException e) {
                    ExceptionHandler.showException(e);
                }
            }
        };
        boolean success = false;
        try {
            provider.aboutToChange(newInput);
            new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
            success = true;
        }
        catch (InterruptedException e) {
            ExceptionHandler.showException(e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            String title = "Editor.error.save.title";
            String msg = MessageFormat.format("Editor.error.save.message", targetException.getMessage());
            if (targetException instanceof CoreException) {
                CoreException coreException = (CoreException)targetException;
                IStatus status = coreException.getStatus();
                if (status != null) {
                    switch (status.getSeverity()) {
                        case 1: {
                            MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                        case 2: {
                            MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                        default: {
                            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                    }
                } else {
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                }
            }
        }
        finally {
            provider.changed(newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
                try {
                    this.init(this.aSite, (IEditorInput)newInput);
                }
                catch (Exception e) {
                    ExceptionHandler.showException(e);
                }
                aEditor = workbenchPage.findEditor((IEditorInput)newInput);
                workbenchPage.closeEditor(aEditor, false);
                if (newInput instanceof IMDFileEditorInput) {
                    EditorHelper.openFile(((IMDFileEditorInput)newInput).getFile());
                } else {
                    IMDFile f = MDResourceUtil.toMDFile(((IFileEditorInput)newInput).getFile());
                    EditorHelper.openFile(f);
                }
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
        ToolCommonPlugin.stopWatch();
    }

    @Override
    public void refreshPages() {
        ToolCommonPlugin.startWatch();
        super.refreshPages();
        ToolCommonPlugin.stopWatch();
    }

    @Override
    public void performGlobalAction(String id) {
        IAction action;
        ToolCommonPlugin.startWatch();
        ICommonPage ipage = this.getCurrPage();
        CommonPage page = null;
        if (ipage instanceof CommonPage) {
            page = (CommonPage)ipage;
        }
        boolean handled = false;
        if (page != null) {
            handled = page.doGlobalAction(id);
        }
        if (!handled && (action = this.xeditor.getAction(id)) != null) {
            action.run();
        }
        ToolCommonPlugin.stopWatch();
    }

    private void check() {
        ToolCommonPlugin.startWatch();
        try {
            CheckReport checkReport = ToolCommonPlugin.getCheckReport();
            BaseSourceEditor.showConsole();
            IUserStream userStream = this.getUserStream();
            ConsoleVerifyListener verifyListener = new ConsoleVerifyListener(userStream);
            Context ctx = ToolContextManager.getContext(this.getFile().getProject()).getORMContext();
            DynamicMetaDataContainer container = new DynamicMetaDataContainer(ctx);
            MetaDataInfo meta = new MetaDataInfo();
            meta.setName(this.model.getString("name"));
            meta.setPackage(this.model.getString("package"));
            meta.setMetaDataType(this.model.getBOSType().toString());
            container.addMetaData(meta);
            container.check(null, (ICheckReport)checkReport, null);
            Collection items = checkReport.getItems();
            for (CheckReportItem item : items) {
                checkReport.addItemFolder(item, this.getMDProject());
            }
            VerifyReport report = new VerifyReport();
            report.registerListener(verifyListener);
            VerifyOperator operator = new VerifyOperator(report);
            operator.check(this.getModel(), 1);
        }
        catch (DataAccessException e) {
            LogTool.logError("\u6570\u636e\u6821\u9a8c\u51fa\u9519", e);
        }
        ToolCommonPlugin.stopWatch();
    }

    @Override
    public void setReadOnlyKey(String key) {
        this.readOnlyKeys.add(key);
    }

    @Override
    public void dispose() {
        if (this.us != null) {
            this.us.close();
        }
        super.dispose();
    }

    private boolean checkPackageAndName() {
        String message;
        ToolCommonPlugin.startWatch();
        AbstractMetaDataValue value = (AbstractMetaDataValue)this.getModel();
        String name = value.getName();
        String pkg = value.getPackage();
        String fileName = this.file.getName();
        String rPkg = ORMStudioBridger.getFilePK((IResource)this.file).getPackage();
        if (fileName != null && fileName.indexOf(46) > -1) {
            fileName = fileName.substring(0, fileName.indexOf(46));
        }
        if (name != null && fileName != null && !name.equals(fileName)) {
            message = Messages.BaseSourceEditor_YuanShuJuZhongDeNAMEYuWenJianMingChengBuYiZhiQingQueRen;
            this.printConsoleMsg(message);
        }
        if (pkg != null && rPkg != null && !pkg.equals(rPkg)) {
            message = Messages.BaseSourceEditor_YuanShuJuZhongDePACKAGEYuWenJianLuJingBaoMingBuYiZhiQingQueRen;
            this.printConsoleMsg(message);
        }
        ToolCommonPlugin.stopWatch();
        return false;
    }

    private void printConsoleMsg(String message) {
        MetaDataInfo meta = new MetaDataInfo();
        meta.setName(this.model.getString("name"));
        meta.setPackage(this.model.getString("package"));
        meta.setMetaDataType(this.model.getBOSType().toString());
        BaseSourceEditor.showConsole();
        ConsoleVerifyListener listener = new ConsoleVerifyListener(this.getUserStream());
        listener.addWarning(meta, message);
    }

    public static void showConsole() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("com.kingdee.bos.tool.console.Console").setFocus();
        }
        catch (PartInitException e) {
            LogTool.logError("", e);
        }
    }

    public static void showVerifyView() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("com.kingdee.bos.tool.views.VerifyMessageView").setFocus();
        }
        catch (PartInitException e) {
            LogTool.logError("", e);
        }
    }

    protected IFolder getParentFolder() {
        IFile file = this.getFile();
        IFolder parentFolder = null;
        String path = file.getFullPath().toOSString();
        StringTokenizer st = new StringTokenizer(path, "\\");
        IProject prj = file.getProject();
        int i = 0;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (i == 1) {
                parentFolder = prj.getFolder(t);
                break;
            }
            ++i;
        }
        return parentFolder;
    }

    @Override
    public boolean isDirty() {
        IToolContext ctx = ToolContextManager.getContext(this.getFile().getProject());
        if (ctx == null) {
            return false;
        }
        if (ctx.isExtSolution()) {
            IFolder folder = ORMStudioBridger.getFolder((IResource)this.getFile());
            if (folder == null) {
                return false;
            }
            String fName = folder.getName();
            Vector stdV = ctx.getStdDirs();
            if ("basetemp".equals(fName) || stdV.contains(fName)) {
                return false;
            }
        }
        return super.isDirty();
    }

    @Override
    public boolean isSaveAsAllowed() {
        return this.isDirty();
    }

    @Override
    public void setActive() {
        block8: {
            if (!this.changeByPage) {
                if (this.opened) {
                    IDevMetadataLoader loader = ToolContextManager.getMetadataLoader(ORMStudioBridger.getFolder((IResource)this.getFile()));
                    try {
                        if (this.reloadResult && loader.lastModifiedChanged((AbstractMetaDataValue)this.model)) {
                            this.reloadResult = MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"\u7cfb\u7edf\u63d0\u793a", (String)"\u5916\u90e8\u4fee\u6539\u4e86\u76f8\u5173\u5143\u6570\u636e\uff0c\u662f\u5426\u91cd\u65b0\u88c5\u8f7d\uff1f");
                            if (this.reloadResult) {
                                this.model = MetaDataTypeList.UIOBJECT.equals((Object)this.model.getBOSType()) ? loader.loadAssmebledUIObject((IMetaDataPK)new MetaDataPK(((AbstractMetaDataValue)this.model).getFullName())) : (MetaDataTypeList.WEBUIOBJECT.equals((Object)this.model.getBOSType()) ? loader.loadAssmebledWebUIObject((IMetaDataPK)new MetaDataPK(((AbstractMetaDataValue)this.model).getFullName())) : loader.loadMetadata(this.model.getBOSType(), (IMetaDataPK)new MetaDataPK(((AbstractMetaDataValue)this.model).getFullName())));
                                ((AbstractMetaDataValue)this.model).setDirty(true);
                                this.refreshPages();
                            }
                            break block8;
                        }
                        this.model = loader.refreshMetadata((AbstractMetaDataValue)this.getModel());
                        this.refreshPages();
                    }
                    catch (Exception e1) {
                        LogTool.logError("", e1);
                    }
                } else {
                    this.opened = true;
                }
            } else {
                this.changeByPage = false;
            }
        }
    }

    @Override
    public IMDFile getMDFile() {
        return MDResourceUtil.toMDFile(this.getFile());
    }

    @Override
    public IMDProject getMDProject() {
        return this.getMDFile().getMDProject();
    }

    private class InnerDocumentListener
    implements IDocumentListener {
        private InnerDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            BaseSourceEditor.this.sourcePageAboutToBeChanged(event);
        }

        public void documentChanged(DocumentEvent event) {
            BaseSourceEditor.this.sourcePageChanged(event);
        }
    }
}

