/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor;

import com.kingdee.bos.md.multipageeditor.IMDSourceEditor;
import com.kingdee.bos.tool.multipageeditor.Messages;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class ToolEditorContributor
extends EditorActionBarContributor {
    private SubMenuManager subMenuManager;
    private SubStatusLineManager subStatusManager;
    private SubToolBarManager subToolbarManager;
    private IMDSourceEditor editor;
    private SaveAction saveAction;
    private ClipboardAction cutAction;
    private ClipboardAction copyAction;
    private ClipboardAction pasteAction;
    private Hashtable globalActions = new Hashtable();
    private BasicTextEditorActionContributor sourceContributor = new BasicTextEditorActionContributor();

    public ToolEditorContributor() {
        this.makeActions();
    }

    private void addGlobalAction(String id) {
        GlobalAction action = new GlobalAction(id);
        this.addGlobalAction(id, action);
    }

    private void addGlobalAction(String id, Action action) {
        this.globalActions.put(id, action);
    }

    public void addClipboardActions(IMenuManager mng) {
        mng.add((IAction)this.cutAction);
        mng.add((IAction)this.copyAction);
        mng.add((IAction)this.pasteAction);
    }

    public void contextMenuAboutToShow(IMenuManager mng) {
        this.contextMenuAboutToShow(mng, true);
    }

    public void contextMenuAboutToShow(IMenuManager mng, boolean addClipboard) {
        if (this.editor != null) {
            this.updateSelectableActions(this.editor.getSelection());
        }
        if (addClipboard) {
            this.addClipboardActions(mng);
        }
        mng.add((IAction)this.saveAction);
    }

    public void contributeToMenu(IMenuManager mm) {
        this.subMenuManager = new SubMenuManager(mm);
        this.sourceContributor.contributeToMenu((IMenuManager)this.subMenuManager);
    }

    public void contributeToStatusLine(IStatusLineManager slm) {
        this.subStatusManager = new SubStatusLineManager(slm);
        this.sourceContributor.contributeToStatusLine((IStatusLineManager)this.subStatusManager);
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        this.subToolbarManager = new SubToolBarManager(tbm);
        this.sourceContributor.contributeToToolBar((IToolBarManager)this.subToolbarManager);
    }

    public IMDSourceEditor getEditor() {
        return this.editor;
    }

    public IAction getGlobalAction(String id) {
        return (IAction)this.globalActions.get(id);
    }

    public IAction getSaveAction() {
        return this.saveAction;
    }

    public IStatusLineManager getStatusLineManager() {
        return this.getActionBars().getStatusLineManager();
    }

    protected void makeActions() {
        this.cutAction = new CutAction();
        this.copyAction = new CopyAction();
        this.pasteAction = new PasteAction();
        this.addGlobalAction(ITextEditorActionConstants.CUT, this.cutAction);
        this.addGlobalAction(ITextEditorActionConstants.COPY, this.copyAction);
        this.addGlobalAction(ITextEditorActionConstants.PASTE, this.pasteAction);
        this.addGlobalAction(ITextEditorActionConstants.UNDO);
        this.addGlobalAction(ITextEditorActionConstants.REDO);
        this.addGlobalAction(ITextEditorActionConstants.SELECT_ALL);
        this.addGlobalAction(ITextEditorActionConstants.FIND);
        this.saveAction = new SaveAction();
        this.saveAction.setText(Messages.ToolEditorContributor_BaoCun);
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (!(targetEditor instanceof IMDSourceEditor)) {
            return;
        }
        this.editor = (IMDSourceEditor)targetEditor;
        IActionBars bars = this.getActionBars();
        if (this.editor.getCurrPage() == null) {
            bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getGlobalAction(ITextEditorActionConstants.UNDO));
            bars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.getGlobalAction(ITextEditorActionConstants.REDO));
            bars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.getGlobalAction(ITextEditorActionConstants.FIND));
        }
        bars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.getGlobalAction(ITextEditorActionConstants.CUT));
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.getGlobalAction(ITextEditorActionConstants.COPY));
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.getGlobalAction(ITextEditorActionConstants.PASTE));
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getGlobalAction(ITextEditorActionConstants.SELECT_ALL));
        bars.updateActionBars();
        this.updateSelectableActions(this.editor.getSelection());
        this.editor.setActive();
    }

    public void updateSelectableActions(ISelection selection) {
        if (this.editor != null) {
            this.cutAction.selectionChanged(selection);
            this.copyAction.selectionChanged(selection);
            this.pasteAction.selectionChanged(selection);
        }
    }

    class SaveAction
    extends Action
    implements IUpdate {
        public void run() {
            if (ToolEditorContributor.this.editor != null) {
                ToolEditorContributor.this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        }

        public void update() {
            if (ToolEditorContributor.this.editor != null) {
                this.setEnabled(ToolEditorContributor.this.editor.isDirty());
            } else {
                this.setEnabled(false);
            }
        }
    }

    class PasteAction
    extends ClipboardAction {
        public PasteAction() {
            super(ITextEditorActionConstants.PASTE);
            this.setText(Messages.ToolEditorContributor_ZhanTie);
        }

        @Override
        public void selectionChanged(ISelection selection) {
            this.setEnabled(this.isEditable());
        }
    }

    class CopyAction
    extends ClipboardAction {
        public CopyAction() {
            super(ITextEditorActionConstants.COPY);
            this.setText(Messages.ToolEditorContributor_KaoBei);
        }

        @Override
        public void selectionChanged(ISelection selection) {
            this.setEnabled(true);
        }
    }

    class CutAction
    extends ClipboardAction {
        public CutAction() {
            super(ITextEditorActionConstants.CUT);
            this.setText(Messages.ToolEditorContributor_JianQie);
        }

        @Override
        public void selectionChanged(ISelection selection) {
            this.setEnabled(this.isEditable());
        }
    }

    class ClipboardAction
    extends GlobalAction {
        public ClipboardAction(String id) {
            super(id);
            this.setEnabled(false);
        }

        public void selectionChanged(ISelection selection) {
        }

        public boolean isEditable() {
            if (ToolEditorContributor.this.editor == null) {
                return false;
            }
            return !ToolEditorContributor.this.editor.isReadOnly();
        }
    }

    class GlobalAction
    extends Action
    implements IUpdate {
        private String id;

        public GlobalAction(String id) {
            this.id = id;
        }

        public void run() {
            ToolEditorContributor.this.editor.performGlobalAction(this.id);
            ToolEditorContributor.this.updateSelectableActions(ToolEditorContributor.this.editor.getSelection());
        }

        public void update() {
            ToolEditorContributor.this.getActionBars().updateActionBars();
        }
    }
}

