/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor.common;

import com.kingdee.bos.tool.multipageeditor.common.SingleColumnResizer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MultiColumnResizer
extends SingleColumnResizer {
    private TableColumn[] fTableColumns;
    private int fTableColumnCount;
    private final Table fTable;
    private int fOldTableWidth;
    int fTotalColumnWidth = 0;
    int[] fProportions;
    int[] fRatios;
    private int[] fOldColumnWidths;
    private boolean fFirstTime = true;
    private boolean fFirstFlatTable = true;
    private boolean fIsFlatColumnsResize = false;
    private boolean fIconColumn = false;
    private boolean fHasFlatHeader = false;
    private boolean fMouseDown = false;
    private Label[] fHeaderLabels;
    private Composite fHeaderContainer;
    private Composite[] fHeaderLabelBoxes;
    private int fNumHeaders;
    private int fNumTextLabels;
    private int fNumSeparators;
    private int[] fFlatTableRatios;
    private float[] fFlatTablePpts;
    private int[] fOrigXCoord;
    private int[] fOrigYCoord;

    public MultiColumnResizer(Table table) {
        super(table);
        this.fTable = table;
        this.initialize(this.fTable, null);
    }

    public MultiColumnResizer(Table table, Label[] alabel, int[] ai) {
        super(table);
        this.fTable = table;
        if (alabel != null) {
            int i;
            this.fHeaderLabels = alabel;
            this.fHeaderLabelBoxes = new Composite[this.fHeaderLabels.length];
            if (this.fHeaderLabels != null) {
                for (i = 0; i < this.fHeaderLabels.length; ++i) {
                    this.fHeaderLabelBoxes[i] = this.fHeaderLabels[i].getParent();
                }
                this.fHeaderContainer = this.fHeaderLabelBoxes[0].getParent();
            }
            this.fHasFlatHeader = true;
            this.fNumHeaders = this.fHeaderLabels.length;
            this.fNumTextLabels = (this.fNumHeaders - 1) / 2;
            this.fNumSeparators = this.fNumHeaders - 1 - this.fNumTextLabels;
            this.fFlatTableRatios = new int[this.fNumTextLabels];
            this.fFlatTableRatios = (int[])(ai != null ? ai : null);
            this.fFlatTablePpts = new float[this.fNumTextLabels];
            for (i = 1; i < this.fHeaderLabels.length; i += 2) {
                this.fHeaderLabels[i].addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseEnter(MouseEvent mouseevent) {
                        MultiColumnResizer.this.mouseEnterEvent(mouseevent);
                    }
                });
                this.fHeaderLabels[i].addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent mouseevent) {
                        MultiColumnResizer.this.setMouseDown(true);
                    }

                    public void mouseUp(MouseEvent mouseevent) {
                        MultiColumnResizer.this.setMouseDown(false);
                    }
                });
                final int i1 = i;
                this.fHeaderLabels[i].addMouseMoveListener(new MouseMoveListener(){

                    public void mouseMove(MouseEvent mouseevent) {
                        if (MultiColumnResizer.this.getMouseDown()) {
                            MultiColumnResizer.this.mouseUpEvent(mouseevent, i1);
                        }
                    }
                });
            }
            this.fTableColumnCount = this.fTable.getColumnCount();
            this.fTableColumns = new TableColumn[this.fTableColumnCount];
            for (int j = 0; j < this.fTableColumnCount; ++j) {
                this.fTableColumns[j] = this.fTable.getColumn(j);
            }
            Display.getDefault().syncExec((Runnable)new Thread(){

                @Override
                public void run() {
                    MultiColumnResizer.this.flatTableResized();
                }
            });
            this.fTable.getHorizontalBar().addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    MultiColumnResizer.this.handleHorizontalScroll(event);
                }
            });
        } else {
            this.initialize(this.fTable, this.fRatios);
        }
    }

    public MultiColumnResizer(Table table, boolean flag) {
        super(table);
        this.fTable = table;
        this.fIconColumn = flag;
        if (this.fIconColumn) {
            this.fTable.getColumn(0).setWidth(19);
            this.fTable.getColumn(1).setWidth(this.fTable.getClientArea().width - 19);
            for (int i = 0; i < this.fTable.getColumnCount(); ++i) {
                this.fTable.getColumn(i).setResizable(true);
            }
        } else {
            this.initialize(this.fTable, null);
        }
    }

    public MultiColumnResizer(Table table, int[] ai) {
        super(table);
        this.fTable = table;
        this.initialize(this.fTable, ai);
    }

    private void handleDoubleClick(int i) {
    }

    @Override
    public void handleEvent(Event event) {
        if (this.fTable != null && !this.fTable.isDisposed()) {
            if (!this.fIconColumn) {
                if (this.fTable.getClientArea().width != this.fOldTableWidth) {
                    this.saveOldTableWidth();
                    if (this.fHasFlatHeader) {
                        Display.getDefault().asyncExec((Runnable)new Thread(){

                            @Override
                            public void run() {
                                MultiColumnResizer.this.flatTableResized();
                            }
                        });
                    } else if (this.fFirstTime) {
                        Display.getDefault().asyncExec((Runnable)new Thread(){

                            @Override
                            public void run() {
                                MultiColumnResizer.this.resizeColumnsToFit(((MultiColumnResizer)MultiColumnResizer.this).fTable.getClientArea().width);
                                MultiColumnResizer.this.fFirstTime = false;
                            }
                        });
                    } else {
                        Display.getDefault().asyncExec((Runnable)new Thread(){

                            @Override
                            public void run() {
                                MultiColumnResizer.this.resizeColumnsToFit(((MultiColumnResizer)MultiColumnResizer.this).fTable.getClientArea().width);
                            }
                        });
                    }
                } else if (this.fHasFlatHeader) {
                    Display.getDefault().asyncExec((Runnable)new Thread(){

                        @Override
                        public void run() {
                            MultiColumnResizer.this.flatTableResized();
                        }
                    });
                }
            } else {
                Display.getDefault().asyncExec((Runnable)new Thread(){

                    @Override
                    public void run() {
                        if (!MultiColumnResizer.this.fTable.isDisposed()) {
                            MultiColumnResizer.this.fTable.getColumn(0).setWidth(19);
                            MultiColumnResizer.this.fTable.getColumn(1).setWidth(((MultiColumnResizer)MultiColumnResizer.this).fTable.getClientArea().width - 19);
                        }
                    }
                });
            }
            final ScrollBar hSB = this.fTable.getHorizontalBar();
            Display.getDefault().asyncExec((Runnable)new Thread(){

                @Override
                public void run() {
                    if (!MultiColumnResizer.this.fTable.isDisposed() && hSB != null && MultiColumnResizer.this.fHasFlatHeader) {
                        hSB.setEnabled(true);
                    }
                }
            });
        }
    }

    private void columnsResized() {
        if (!this.fFirstTime) {
            int[] ai = new int[this.fTableColumnCount];
            int i = this.fTable.getClientArea().width;
            ai[0] = this.fTable.getColumn(0).getWidth();
            ai[1] = i - ai[0];
            this.fTable.getColumn(this.fTableColumnCount - 1).setWidth(ai[1]);
            if (!ai.equals(this.fOldColumnWidths)) {
                this.saveOldColumnWidths();
                this.fRatios = new int[this.fTableColumnCount];
                boolean flag = false;
                for (int j = 0; j < this.fTableColumnCount; ++j) {
                    this.fRatios[j] = ai[j];
                }
                this.setProportions(this.fRatios);
            }
        }
    }

    private void initialize(Table table, int[] ai) {
        this.fTableColumnCount = table.getColumnCount();
        this.fTableColumns = new TableColumn[this.fTableColumnCount];
        for (int i = 0; i < this.fTableColumnCount; ++i) {
            this.fTableColumns[i] = table.getColumn(i);
            if (i != this.fTableColumnCount - 1) continue;
            table.getColumn(i).setResizable(false);
        }
        table.getColumn(0).addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlevent) {
                Display.getDefault().asyncExec((Runnable)new Thread(){

                    @Override
                    public void run() {
                        MultiColumnResizer.this.columnsResized();
                    }
                });
            }
        });
        this.setProportions(ai);
        this.saveOldTableWidth();
        this.saveOldColumnWidths();
        Display.getDefault().asyncExec((Runnable)new Thread(){

            @Override
            public void run() {
                MultiColumnResizer.this.resizeColumnsToFit(MultiColumnResizer.this.fOldTableWidth);
            }
        });
    }

    private void resizeColumnsToFit(int i) {
        int j = 0;
        if (!this.fTable.isDisposed()) {
            for (int k = 0; k < this.fTableColumnCount; ++k) {
                j += this.fProportions[k];
            }
            if (j != 0) {
                for (int l = 0; l < this.fTableColumnCount; ++l) {
                    int i1 = i * this.fProportions[l] / j;
                    this.fTableColumns[l].setWidth(i1);
                    this.fTotalColumnWidth += i1;
                }
                int j1 = i - this.fTotalColumnWidth;
                int k1 = this.fTableColumns[this.fTableColumnCount - 1].getWidth();
                this.fTableColumns[this.fTableColumnCount - 1].setWidth(k1 + j1);
                j = 0;
                this.fTotalColumnWidth = 0;
            }
        }
    }

    private void saveOldTableWidth() {
        this.fOldTableWidth = this.fTable.getClientArea().width;
    }

    private void saveOldColumnWidths() {
        this.fOldColumnWidths = new int[this.fTableColumnCount];
        this.fOldColumnWidths[0] = this.fTable.getColumn(0).getWidth();
        this.fOldColumnWidths[1] = this.fTable.getClientArea().width - this.fOldColumnWidths[1];
    }

    private void setProportions(int[] ai) {
        this.fProportions = new int[this.fTableColumnCount];
        if (ai != null) {
            for (int i = 0; i < this.fTableColumnCount; ++i) {
                if (ai[i] == 0) continue;
                this.fProportions[i] = ai[i];
            }
            ai = null;
        } else {
            for (int j = 0; j < this.fTableColumnCount; ++j) {
                int k = this.fTableColumns[j].getWidth();
                this.fProportions[j] = k <= 0 ? this.fTableColumns[j].getText().length() : k;
            }
        }
    }

    private void mouseUpEvent(MouseEvent mouseevent, final int separatorIndex) {
        final int eX = mouseevent.x;
        Display.getDefault().asyncExec((Runnable)new Thread(){

            @Override
            public void run() {
                MultiColumnResizer.this.fHeaderContainer.setSize(((MultiColumnResizer)MultiColumnResizer.this).fTable.getClientArea().width, ((MultiColumnResizer)MultiColumnResizer.this).fHeaderContainer.getSize().y);
                int i = MultiColumnResizer.this.fTable.getHorizontalBar().getMaximum();
                int j = MultiColumnResizer.this.fTable.getHorizontalBar().getThumb();
                int k = MultiColumnResizer.this.fTable.getHorizontalBar().getSelection();
                int l = ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[separatorIndex - 1].getSize().x + eX;
                if (l <= 0) {
                    l = 0;
                }
                MultiColumnResizer.this.fHeaderLabelBoxes[separatorIndex - 1].setBounds(((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[separatorIndex - 1].getBounds().x, ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[separatorIndex - 1].getBounds().y, l, ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[separatorIndex - 1].getSize().y);
                MultiColumnResizer.this.fHeaderLabels[separatorIndex - 1].setSize(((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[separatorIndex - 1].getBounds().width - 1, ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[separatorIndex - 1].getSize().y - 2);
                int j1 = ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[separatorIndex - 1].getBounds().y;
                for (int k1 = separatorIndex; k1 < MultiColumnResizer.this.fHeaderLabels.length; ++k1) {
                    if (k1 == MultiColumnResizer.this.fHeaderLabels.length - 1) {
                        int l1 = ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabels.length - 2].getBounds().x + ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabels.length - 2].getBounds().width;
                        if (l1 >= ((MultiColumnResizer)MultiColumnResizer.this).fTable.getClientArea().width) continue;
                        MultiColumnResizer.this.fHeaderLabelBoxes[k1].setBounds(l1, 0, ((MultiColumnResizer)MultiColumnResizer.this).fTable.getClientArea().width - l1, ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k1].getSize().y);
                        MultiColumnResizer.this.fHeaderLabels[k1].setSize(((MultiColumnResizer)MultiColumnResizer.this).fTable.getClientArea().width - l1, ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k1].getSize().y - 2);
                        continue;
                    }
                    if (k1 % 2 == 0) {
                        MultiColumnResizer.this.fHeaderLabelBoxes[k1].setBounds(((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k1 - 1].getBounds().x + 4, j1, ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k1].getSize().x, ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k1].getSize().y);
                        MultiColumnResizer.this.fHeaderLabels[k1].setSize(((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k1].getSize().x - 1, ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k1].getSize().y - 2);
                        continue;
                    }
                    MultiColumnResizer.this.fHeaderLabelBoxes[k1].setBounds(((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k1 - 1].getBounds().x + ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k1 - 1].getBounds().width, j1, 4, ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k1].getSize().y);
                    MultiColumnResizer.this.fHeaderLabels[k1].setSize(3, ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k1].getSize().y - 2);
                }
            }
        });
        this.fIsFlatColumnsResize = true;
        Display.getDefault().asyncExec((Runnable)new Thread(){

            @Override
            public void run() {
                MultiColumnResizer.this.flatTableResized();
            }
        });
    }

    private void flatTableResized() {
        if (!this.fTable.isDisposed()) {
            int i = this.fTable.getClientArea().width;
            int j = i - this.fNumSeparators * 4;
            int k = this.fOldTableWidth - this.fNumSeparators * 4;
            this.fHeaderContainer.setSize(j + this.fNumSeparators * 4, this.fHeaderContainer.getSize().y);
            if (this.fFirstFlatTable) {
                int l = 0;
                if (this.fFlatTableRatios != null) {
                    for (int k1 = 0; k1 < this.fFlatTableRatios.length; ++k1) {
                        l += this.fFlatTableRatios[k1];
                    }
                    for (int i2 = 0; i2 < this.fFlatTableRatios.length; ++i2) {
                        if (l == 0) continue;
                        this.fFlatTablePpts[i2] = (float)this.fFlatTableRatios[i2] / (float)l;
                    }
                } else {
                    int i1 = this.fNumTextLabels;
                    for (int l1 = 0; l1 < this.fNumTextLabels; ++l1) {
                        if (i1 == 0) continue;
                        this.fFlatTablePpts[l1] = 1.0f / (float)i1;
                    }
                }
                this.fFirstFlatTable = false;
            } else if (this.fIsFlatColumnsResize) {
                for (int j1 = 0; j1 < this.fNumTextLabels; ++j1) {
                    if (k == 0) continue;
                    this.fFlatTablePpts[j1] = (float)this.fHeaderLabelBoxes[j1 * 2].getBounds().width / (float)k;
                }
                this.fIsFlatColumnsResize = false;
            }
            this.resizeFlatTableColumns(j);
        }
    }

    private void resizeFlatTableColumns(int i) {
        int j = 0;
        int k = 0;
        boolean flag = false;
        int i1 = i + 4 * this.fNumSeparators;
        int j1 = this.fTable.getHorizontalBar().getMaximum();
        int k1 = this.fTable.getHorizontalBar().getThumb();
        int l1 = this.fTable.getHorizontalBar().getSelection();
        for (int i2 = 0; i2 < this.fNumHeaders; ++i2) {
            if (i2 == this.fNumHeaders - 1) {
                this.fHeaderLabelBoxes[i2].setBounds(j, 0, this.fTable.getClientArea().width - j, this.fHeaderLabelBoxes[i2].getSize().y);
                this.fHeaderLabels[i2].setSize(this.fHeaderLabelBoxes[i2].getBounds().width - 1, this.fHeaderLabelBoxes[i2].getSize().y - 2);
                continue;
            }
            if (i2 % 2 == 0) {
                int j2 = 0;
                if (i2 != 0) {
                    j2 = i2 / 2;
                }
                int l = (int)(this.fFlatTablePpts[j2] * (float)i);
                int l2 = 0;
                if (i2 == 0) {
                    l2 = l1 != 0 ? -l1 : 0;
                    this.fHeaderLabelBoxes[0].setBounds(l2, 0, l, this.fHeaderLabelBoxes[i2].getSize().y);
                } else {
                    this.fHeaderLabelBoxes[i2].setBounds(j, k, l, this.fHeaderLabelBoxes[i2].getSize().y);
                }
                this.fHeaderLabels[i2].setSize(l - 1, this.fHeaderLabelBoxes[i2].getSize().y - 2);
                if (j2 == 0) {
                    this.fTableColumns[0].setWidth(l + 2);
                    j += l + l2;
                    continue;
                }
                this.fTableColumns[j2].setWidth(l + 4);
                j += l;
                continue;
            }
            this.fHeaderLabelBoxes[i2].setBounds(j, k, 4, this.fHeaderLabelBoxes[i2].getSize().y);
            this.fHeaderLabels[i2].setSize(3, this.fHeaderLabelBoxes[i2].getSize().y - 2);
            j += 4;
        }
        if (l1 == 0) {
            this.saveHeaderCoordinates();
        } else {
            for (int k2 = 1; k2 < this.fHeaderLabels.length - 1; ++k2) {
                this.fOrigXCoord[k2] = this.fHeaderLabelBoxes[k2].getBounds().x + l1;
            }
        }
    }

    private void mouseEnterEvent(MouseEvent mouseevent) {
        Cursor cursor = new Cursor((Device)Display.getCurrent(), 9);
        Control control = (Control)mouseevent.widget;
        control.setCursor(cursor);
    }

    private void handleHorizontalScroll(Event event) {
        ScrollBar scrollbar = (ScrollBar)event.widget;
        final int newOriginX = scrollbar.getSelection();
        Display.getDefault().syncExec((Runnable)new Thread(){

            @Override
            public void run() {
                int i = MultiColumnResizer.this.fTable.getHorizontalBar().getMaximum();
                int j = MultiColumnResizer.this.fTable.getHorizontalBar().getThumb();
                for (int k = 0; k < MultiColumnResizer.this.fNumHeaders - 1; ++k) {
                    MultiColumnResizer.this.fHeaderLabelBoxes[k].setBounds(MultiColumnResizer.this.fOrigXCoord[k] - newOriginX, MultiColumnResizer.this.fOrigYCoord[k], ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k].getBounds().width, ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k].getSize().y);
                    if (k == MultiColumnResizer.this.fHeaderLabels.length - 1) {
                        MultiColumnResizer.this.fHeaderLabels[k].setSize(3, ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k].getSize().y - 2);
                        continue;
                    }
                    MultiColumnResizer.this.fHeaderLabels[k].setSize(((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k].getBounds().width - 1, ((MultiColumnResizer)MultiColumnResizer.this).fHeaderLabelBoxes[k].getSize().y - 2);
                }
            }
        });
    }

    private void saveHeaderCoordinates() {
        this.fOrigXCoord = new int[this.fHeaderLabels.length];
        this.fOrigYCoord = new int[this.fHeaderLabels.length];
        for (int i = 0; i < this.fHeaderLabels.length - 1; ++i) {
            this.fOrigXCoord[i] = this.fHeaderLabelBoxes[i].getBounds().x;
            this.fOrigYCoord[i] = this.fHeaderLabelBoxes[i].getBounds().y;
        }
    }

    private void setMouseDown(boolean flag) {
        this.fMouseDown = flag;
    }

    private boolean getMouseDown() {
        return this.fMouseDown;
    }
}

