/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.properties.packages;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.dao.ORMUtil;
import com.kingdee.bos.tool.properties.packages.Messages;
import com.kingdee.bos.tool.utils.CheckUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.IProgressService;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class PackageInfoPropertyPage
extends PropertyPage {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.properties.solution.SolutionBaseInfoPropertyPage");
    private String basicCode;
    private String alias;
    private String description;
    private String name;
    private Text basicCodeTxt;
    private Text nameTxt;
    private Text aliasTxt;
    private Text descTxt;
    private IFolder folder;
    private PackageInfo pk;
    private TextModifyListener textModifyListener;
    private boolean validPacakge;

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 20;
        container.setLayout((Layout)layout);
        this.validPacakge = this.isValidPacakge();
        if (!this.validPacakge) {
            new Label(container, 0).setText(Messages.PackageInfoPropertyPage_GongChengBuShiJieJueFangAnMeiYouBaoXinXi);
            return container;
        }
        if (this.isPackageRoot()) {
            new Label(container, 0).setText(Messages.PackageInfoPropertyPage_BuShiBaoMeiYouBaoXinXi);
            return container;
        }
        this.initPackageInfo();
        new Label(container, 0).setText(Messages.PackageInfoPropertyPage_MingCheng);
        this.nameTxt = new Text(container, 2060);
        this.nameTxt.setLayoutData((Object)new GridData(256));
        new Label(container, 0).setText(Messages.PackageInfoPropertyPage_ZiXiTongJianMaB);
        this.basicCodeTxt = new Text(container, 2052);
        this.basicCodeTxt.setTextLimit(3);
        this.basicCodeTxt.setLayoutData((Object)new GridData(256));
        new Label(container, 0).setText(Messages.PackageInfoPropertyPage_BieMing);
        this.aliasTxt = new Text(container, 2052);
        this.aliasTxt.setLayoutData((Object)new GridData(256));
        new Label(container, 0).setText(Messages.PackageInfoPropertyPage_MiaoShu);
        this.descTxt = new Text(container, 2882);
        GridData gridData = new GridData(256);
        gridData.widthHint = 300;
        gridData.heightHint = 120;
        gridData.verticalSpan = 5;
        this.descTxt.setLayoutData((Object)gridData);
        this.initializeDialogUnits((Control)container);
        this.initControlContent();
        this.textModifyListener = new TextModifyListener();
        this.basicCodeTxt.addModifyListener((ModifyListener)this.textModifyListener);
        this.aliasTxt.addModifyListener((ModifyListener)this.textModifyListener);
        this.descTxt.addModifyListener((ModifyListener)this.textModifyListener);
        return container;
    }

    public boolean performOk() {
        if (this.folder == null || !this.validPacakge || this.isPackageRoot()) {
            return false;
        }
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.runInUI((IRunnableContext)progressService, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.setCanceled(false);
                    monitor.beginTask(Messages.PackageInfoPropertyPage_BaoCunJieJueFangAnDeJiBenXinXi, 100);
                    monitor.setTaskName(Messages.PackageInfoPropertyPage_ZhengZaiBaoCunJieJueFangAnDeJiBenXinXiQingShaoDeng);
                    monitor.subTask(Messages.PackageInfoPropertyPage_ZhengZaiBaoCun);
                    monitor.worked(10);
                    try {
                        monitor.worked(50);
                        PackageInfoPropertyPage.this.pk.setAlias(PackageInfoPropertyPage.this.alias == null ? "" : PackageInfoPropertyPage.this.alias);
                        PackageInfoPropertyPage.this.pk.setBasicCode(PackageInfoPropertyPage.this.basicCode == null ? "" : PackageInfoPropertyPage.this.basicCode);
                        PackageInfoPropertyPage.this.pk.setDescription(PackageInfoPropertyPage.this.description == null ? "" : PackageInfoPropertyPage.this.description);
                        IFile file = PackageInfoPropertyPage.this.folder.getFile(PackageInfoPropertyPage.this.folder.getName() + "." + "package");
                        ORMUtil.store((IObjectValue)PackageInfoPropertyPage.this.pk, file, monitor);
                    }
                    catch (Exception e) {
                        PackageInfoPropertyPage.this.setErrorMessage(Messages.PackageInfoPropertyPage_BaoCunBaoXinXiChuCuoQingYuGuanLiYuanLianXi);
                        logger.error((Object)"error", (Throwable)e);
                        throw new InvocationTargetException(e);
                    }
                }
            }, null);
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(Messages.PackageInfoPropertyPage_BaoCunBaoXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"error", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            this.setErrorMessage(Messages.PackageInfoPropertyPage_BaoCunBaoXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"error", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            this.setErrorMessage(Messages.PackageInfoPropertyPage_BaoCunBaoXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"error", (Throwable)e);
            return false;
        }
        return super.performOk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPKGFile(IFile file) throws IOException {
        String pkg = "";
        String prefix = "package[" + pkg + "]";
        Document doc = new Document();
        Element root = new Element("package");
        doc.setRootElement(root);
        root.addContent((Content)new Element("package").setText(pkg));
        root.addContent((Content)new Element("name").setText(this.folder.getName()));
        root.addContent((Content)new Element("alias").setText(prefix + ".alias"));
        root.addContent((Content)new Element("description").setText(prefix + ".description"));
        root.addContent((Content)new Element("basicCode").setText(this.pk.getBasicCode()));
        Element resourceEl = new Element("resource");
        root.addContent((Content)resourceEl);
        Element rsEl = new Element("rs");
        rsEl.setAttribute("key", prefix + ".alias");
        rsEl.addContent((Content)new Element("lang").setAttribute("locale", "en_US").setAttribute("value", this.pk.getAlias()));
        rsEl.addContent((Content)new Element("lang").setAttribute("locale", "zh_CN").setAttribute("value", this.pk.getAlias()));
        rsEl.addContent((Content)new Element("lang").setAttribute("locale", "zh_TW").setAttribute("value", this.pk.getAlias()));
        resourceEl.addContent((Content)rsEl);
        rsEl = new Element("rs");
        rsEl.setAttribute("key", prefix + ".description");
        rsEl.addContent((Content)new Element("lang").setAttribute("locale", "en_US").setAttribute("value", this.pk.getDescription()));
        rsEl.addContent((Content)new Element("lang").setAttribute("locale", "zh_CN").setAttribute("value", this.pk.getDescription()));
        rsEl.addContent((Content)new Element("lang").setAttribute("locale", "zh_TW").setAttribute("value", this.pk.getDescription()));
        resourceEl.addContent((Content)rsEl);
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(file.getLocation().toOSString());
            Format format = Format.getRawFormat();
            format.setIndent("  ");
            XMLOutputter out = new XMLOutputter(format);
            out.output(doc, (OutputStream)output);
            output.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(output);
            throw throwable;
        }
        FileUtils.close(output);
    }

    private void initControlContent() {
        this.basicCodeTxt.setText(this.basicCode == null ? "" : this.basicCode);
        this.nameTxt.setText(this.name == null ? "" : this.name);
        this.aliasTxt.setText(this.alias == null ? "" : this.alias);
        this.descTxt.setText(this.description == null ? "" : this.description);
        IFile file = this.folder.getFile(this.folder.getName() + "." + "package");
        if (!file.exists()) {
            this.basicCodeTxt.setEnabled(false);
            this.nameTxt.setEnabled(false);
            this.aliasTxt.setEnabled(false);
            this.descTxt.setEnabled(false);
            this.setMessage("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + file.toString(), 1);
        }
    }

    public boolean isPackageRoot() {
        IAdaptable adapter = this.getElement();
        if (adapter != null) {
            this.folder = (IFolder)adapter.getAdapter(IResource.class);
            IProject project = this.folder.getProject();
            return this.folder.getParent().equals(project);
        }
        return false;
    }

    private boolean isValidPacakge() {
        IAdaptable adapter = this.getElement();
        if (adapter != null) {
            this.folder = (IFolder)adapter.getAdapter(IResource.class);
            IProject project = this.folder.getProject();
            IProjectNature natrue = null;
            try {
                natrue = project.getNature("com.kingdee.bos.tool.toolcommon.SolutionNature");
            }
            catch (CoreException e) {
                logger.debug((Object)"", (Throwable)e);
            }
            return natrue != null;
        }
        return false;
    }

    private void initPackageInfo() {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.runInUI((IRunnableContext)progressService, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.setCanceled(false);
                    monitor.beginTask(Messages.PackageInfoPropertyPage_ZhuangZaiJieJueFangAnDeJiBenXinXi, 100);
                    monitor.setTaskName(Messages.PackageInfoPropertyPage_ZhengZaiZhuangZaiJieJueFangAnDeJiBenXinXiQingShaoDeng);
                    monitor.subTask(Messages.PackageInfoPropertyPage_ZhengZaiDuQuGongChengXiangMu);
                    IAdaptable adapter = PackageInfoPropertyPage.this.getElement();
                    monitor.worked(10);
                    if (adapter != null) {
                        PackageInfoPropertyPage.this.folder = (IFolder)adapter.getAdapter(IResource.class);
                        if (PackageInfoPropertyPage.this.folder != null) {
                            try {
                                monitor.subTask(Messages.PackageInfoPropertyPage_ZhengZaiDuQuBaoXinXi);
                                IFile file = PackageInfoPropertyPage.this.folder.getFile(PackageInfoPropertyPage.this.folder.getName() + "." + "package");
                                if (file.exists()) {
                                    PackageInfoPropertyPage.this.pk = (PackageInfo)ORMUtil.load(file);
                                } else {
                                    PackageInfoPropertyPage.this.pk = new PackageInfo();
                                    PackageInfoPropertyPage.this.pk.setName(PackageInfoPropertyPage.this.folder.getName());
                                    ORMUtil.createFile((IObjectValue)PackageInfoPropertyPage.this.pk, file, monitor);
                                }
                                monitor.worked(50);
                                if (PackageInfoPropertyPage.this.pk != null) {
                                    monitor.subTask(Messages.PackageInfoPropertyPage_ZhengZaiDuQuBaoXinXi);
                                    PackageInfoPropertyPage.this.name = PackageInfoPropertyPage.this.pk.getName();
                                    PackageInfoPropertyPage.this.alias = PackageInfoPropertyPage.this.pk.getAlias();
                                    PackageInfoPropertyPage.this.basicCode = PackageInfoPropertyPage.this.pk.getBasicCode();
                                    PackageInfoPropertyPage.this.description = PackageInfoPropertyPage.this.pk.getDescription();
                                    monitor.subTask(Messages.PackageInfoPropertyPage_ZhengZaiGouJianBaoXinXiBianJiJieMian);
                                }
                            }
                            catch (Exception e) {
                                PackageInfoPropertyPage.this.setErrorMessage(Messages.PackageInfoPropertyPage_ZaiZhuangBaoXinXiChuCuoQingYuGuanLiYuanLianXi);
                                logger.error((Object)"error", (Throwable)e);
                            }
                        }
                    }
                }
            }, null);
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(Messages.PackageInfoPropertyPage_ZaiZhuangBaoXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"error", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.setErrorMessage(Messages.PackageInfoPropertyPage_ZaiZhuangBaoXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"error", (Throwable)e);
        }
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (e.getSource().equals(PackageInfoPropertyPage.this.aliasTxt)) {
                PackageInfoPropertyPage.this.alias = PackageInfoPropertyPage.this.aliasTxt.getText();
            } else if (e.getSource().equals(PackageInfoPropertyPage.this.descTxt)) {
                PackageInfoPropertyPage.this.description = PackageInfoPropertyPage.this.descTxt.getText();
            } else if (e.getSource().equals(PackageInfoPropertyPage.this.basicCodeTxt)) {
                PackageInfoPropertyPage.this.basicCodeTxt.removeModifyListener((ModifyListener)PackageInfoPropertyPage.this.textModifyListener);
                PackageInfoPropertyPage.this.basicCodeTxt.setText(PackageInfoPropertyPage.this.basicCodeTxt.getText().toUpperCase());
                PackageInfoPropertyPage.this.basicCodeTxt.setSelection(PackageInfoPropertyPage.this.basicCodeTxt.getText().length());
                PackageInfoPropertyPage.this.basicCodeTxt.addModifyListener((ModifyListener)PackageInfoPropertyPage.this.textModifyListener);
                if (!CheckUtils.isValidBasicCode(PackageInfoPropertyPage.this.basicCodeTxt.getText())) {
                    PackageInfoPropertyPage.this.setErrorMessage(Messages.PackageInfoPropertyPage_BuHeFaDeJianMaBiXuShiYouDaXieZiMuZuChengBingQieChangDuDengYu2DeZiFuChuan);
                    return;
                }
                PackageInfoPropertyPage.this.setErrorMessage(null);
                PackageInfoPropertyPage.this.basicCode = PackageInfoPropertyPage.this.basicCodeTxt.getText();
            }
        }
    }
}

