/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.solution;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.management.application.AppViewInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.common.TranslateUtil;
import com.kingdee.bos.tool.context.IToolContext;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.dao.CreateFileCommand;
import com.kingdee.bos.tool.dao.ORMUtil;
import com.kingdee.bos.tool.solution.Messages;
import com.kingdee.bos.tool.solution.SolutionDelegate;
import com.kingdee.bos.tool.utils.XMLResourceManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.jdom2.Content;
import org.jdom2.Element;

public class SolutionHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.solution.SolutionHelper");
    public static final String SOLUTION_NATURE = "com.kingdee.bos.tool.toolcommon.SolutionNature";

    public static void newSolution(SolutionInfo info, String projectName, String projectPath, SolutionDelegate solDele) throws IDEException {
        if (info == null) {
            return;
        }
        String path = projectPath;
        String projectname = StringUtils.isEmpty((String)projectName) ? info.getName() : projectName;
        if (SolutionHelper.create(info, path, solDele, projectname) == -1) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectname);
        IToolContext ctx = ToolContextManager.getContext(project);
        IFolder folder = project.getFolder(ctx.getSrcName());
        ORMUtil.createServices(folder, null);
    }

    public static boolean validSolutionProject(IProject project) {
        IProjectDescription projectDesc;
        if (!MDResourceUtil.isValidMDProject(project)) {
            return false;
        }
        try {
            projectDesc = project.getDescription();
        }
        catch (CoreException e) {
            logger.error((Object)Messages.SolutionHelper_CuoWuDeGongChengWuFaHuoDeGongChengDeNATURE, (Throwable)e);
            return false;
        }
        String[] natureIds = projectDesc.getNatureIds();
        for (int i = 0; i < natureIds.length; ++i) {
            if (!SOLUTION_NATURE.equals(natureIds[i])) continue;
            return true;
        }
        return false;
    }

    public static int newSolutionXML(String projectpath, SolutionDelegate solDele) {
        Element solutionroot = new Element("solution");
        String solutionName = solDele.getName();
        Element nameEle = new Element("name");
        nameEle.setText(solutionName);
        solutionroot.addContent((Content)nameEle);
        Element isExtSolEle = new Element("isExtendSolution");
        isExtSolEle.setText(String.valueOf(solDele.isExtSolution()));
        solutionroot.addContent((Content)isExtSolEle);
        Element isNewSolutionEle = new Element("isNewSolution");
        isNewSolutionEle.setText(String.valueOf(solDele.isNewSolution()));
        solutionroot.addContent((Content)isNewSolutionEle);
        Element sourceEle = new Element("source");
        String source = solDele.getSource();
        sourceEle.setText(source);
        solutionroot.addContent((Content)sourceEle);
        Element resourceEle = new Element("resource");
        resourceEle.setText(solDele.getResource());
        solutionroot.addContent((Content)resourceEle);
        Element stdDirsEle = new Element("stdDirs");
        solutionroot.addContent((Content)stdDirsEle);
        Vector stdDirs = solDele.getStdDirs();
        int j = stdDirs.size();
        for (int i = 0; i < j; ++i) {
            String stdDir = (String)stdDirs.get(i);
            Element stdDirEle = new Element("stdDir");
            stdDirEle.setText(stdDir);
            stdDirsEle.addContent((Content)stdDirEle);
        }
        Element extDirsEle = new Element("extDirs");
        solutionroot.addContent((Content)extDirsEle);
        Vector extDirs = solDele.getExtDirs();
        int j2 = extDirs.size();
        for (int i = 0; i < j2; ++i) {
            String extDir = (String)extDirs.get(i);
            Element extDirEle = new Element("extDir");
            extDirEle.setText(extDir);
            extDirsEle.addContent((Content)extDirEle);
        }
        String filename = new StringBuffer(projectpath).append("/").append(".solution.xml").toString();
        int issuccess = XMLResourceManager.saveToXML((Element)solutionroot, (String)filename);
        return issuccess;
    }

    private static void createFolder(IProject project, String projectospath, SolutionDelegate solDele) throws CoreException {
        IFolder easfolder = null;
        IFolder resfolder = null;
        IFile lockfile = project.getFile(".lock");
        String src = solDele.getSource();
        String res = solDele.getResource();
        if (src != null && src.length() != 0) {
            easfolder = project.getFolder(src);
        }
        resfolder = project.getFolder(res);
        IProjectDescription pdesc = project.getWorkspace().newProjectDescription(project.getName());
        pdesc.setNatureIds(new String[]{SOLUTION_NATURE});
        Path path = null;
        if (projectospath != null && projectospath.length() != 0) {
            String wpath = Platform.getLocation().toOSString();
            path = new Path(projectospath);
            if (projectospath.indexOf(wpath) != -1) {
                path = null;
            }
        }
        pdesc.setLocation(path);
        if (!project.exists()) {
            project.create(pdesc, null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        if (!solDele.isExtSolution()) {
            if (easfolder != null && !easfolder.exists()) {
                easfolder.create(false, true, null);
            }
        } else {
            Vector stdDirs = solDele.getStdDirs();
            int j = stdDirs.size();
            for (int i = 0; i < j; ++i) {
                String stdDir = (String)stdDirs.get(i);
                IFolder stdFolder = project.getFolder(stdDir);
                if (stdFolder == null || stdFolder.exists()) continue;
                stdFolder.create(false, true, null);
            }
            Vector extDirs = solDele.getExtDirs();
            int j2 = extDirs.size();
            for (int i = 0; i < j2; ++i) {
                String extDir = (String)extDirs.get(i);
                IFolder extFolder = project.getFolder(extDir);
                if (extFolder == null || extFolder.exists()) continue;
                extFolder.create(false, true, null);
            }
            IFolder baseTempFolder = project.getFolder("basetemp");
            if (baseTempFolder != null && !baseTempFolder.exists()) {
                baseTempFolder.create(false, true, null);
            }
        }
        if (resfolder != null && !resfolder.exists()) {
            resfolder.create(false, true, null);
        }
        if (!lockfile.exists()) {
            lockfile.create((InputStream)new ByteArrayInputStream("".getBytes()), 0, null);
        }
    }

    public static void createBimExtendFolder(IProject project, String projectospath, SolutionDelegate solDele) throws CoreException {
        SolutionHelper.createFolder(project, projectospath, solDele);
        SolutionHelper.newSolutionXML(projectospath, solDele);
    }

    private static int create(final SolutionInfo solution, final String projectospath, final SolutionDelegate solDele, String projectname) {
        final int[] issuccess = new int[]{0};
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(projectname);
        if (project.exists()) {
            MessageDialog.openInformation(null, (String)TranslateUtil.DIALOG_ERROR_INFO, (String)TranslateUtil.DIALOG_ERROR_EXIST_SOLUTION);
            return -1;
        }
        try {
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    SolutionHelper.createFolder(project, projectospath, solDele);
                    issuccess[0] = SolutionHelper.newSolutionXML(projectospath, solDele);
                    SolutionHelper.createMetaData(project, solution);
                }
            };
            workspace.run(operation, null);
        }
        catch (Exception e) {
            LogTool.logError("\u521b\u5efa\u5143\u6570\u636e\u76f8\u5173\u76ee\u5f55\u65f6\u51fa\u9519", e);
            issuccess[0] = -1;
        }
        return issuccess[0];
    }

    private static void createMetaData(IProject project, SolutionInfo info) {
        logger.info((Object)"create solution");
        assert (info != null);
        LanguageInfo langInfo = new LanguageInfo();
        langInfo.setOriginalLocale(Locale.getDefault());
        langInfo.setName(Locale.getDefault().getDisplayName());
        langInfo.setPostfix("L1");
        info.addLanguage(langInfo);
        info.setDefaultLanguage(langInfo);
        IToolContext toolCtx = ToolContextManager.getContext(project);
        Context ctx = toolCtx.getORMContext();
        ContextManager.setContext((Context)ctx);
        IFolder metaFolder = project.getFolder(toolCtx.getSrcName());
        String fileName = toolCtx.getSolutionName() + Utils.getMetaDataSuffix((BOSObjectType)MetaDataTypeList.SOLUTION);
        IFile solutionFile = metaFolder.getFile(fileName);
        new CreateFileCommand((IObjectValue)info, solutionFile).exec(null);
        AppViewInfo appView = new AppViewInfo();
        fileName = appView.getName() + Utils.getMetaDataSuffix((BOSObjectType)MetaDataTypeList.APPVIEW);
        IFile appViewFile = metaFolder.getFile(fileName);
        new CreateFileCommand((IObjectValue)appView, appViewFile).exec(null);
    }
}

