/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.solution;

import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.solution.StudioConfigurationException;
import com.kingdee.bos.tool.solution.StudioConfigurationItem;
import com.kingdee.util.SAXBuilderFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPath;

public class StudioConfiguration
implements Serializable {
    private Document doc;
    private Element root;
    private File file;
    private static StudioConfiguration myself;
    private static final Logger logger;

    private StudioConfiguration(String fileName) {
        this.file = new File(fileName);
    }

    public static synchronized StudioConfiguration getInstance() throws StudioConfigurationException {
        if (myself == null) {
            String fileName = ToolCommonPlugin.getDefault().getStateLocation().append("configuration.xml").toOSString();
            myself = new StudioConfiguration(fileName);
            myself.load();
        }
        return myself;
    }

    public synchronized void addConfigItem(StudioConfigurationItem item) {
        this.root.addContent((Content)item.el);
    }

    public synchronized StudioConfigurationItem getConfigItem(String name) {
        Element _el = StudioConfiguration.getConfigItemElement(this.root, name);
        if (_el != null) {
            return new StudioConfigurationItem(_el);
        }
        return null;
    }

    public synchronized StudioConfigurationItem getConfigItemByPath(String path) {
        Element _el = StudioConfiguration.getConfigItemElementByPath(this.root, path);
        if (_el != null) {
            return new StudioConfigurationItem(_el);
        }
        return null;
    }

    public synchronized void removeConfigItem(String name) {
        Element _el = StudioConfiguration.getConfigItemElement(this.root, name);
        if (_el != null) {
            this.root.removeContent((Content)_el);
        }
    }

    public synchronized void removeAll() {
        this.root.removeChildren("configitem");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store() throws StudioConfigurationException {
        try {
            Format format = Format.getRawFormat();
            format.setIndent("    ");
            format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
            XMLOutputter outputter = new XMLOutputter(format);
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(this.file);
                outputter.output(this.doc, (OutputStream)os);
            }
            catch (Throwable throwable) {
                FileUtils.close(os);
                throw throwable;
            }
            FileUtils.close(os);
        }
        catch (Exception e) {
            throw new StudioConfigurationException("store config information failed: " + e.getMessage());
        }
    }

    private void load() throws StudioConfigurationException {
        block8: {
            try {
                if (!this.file.exists()) {
                    if (this.file.createNewFile()) {
                        this.doc = new Document();
                        this.root = new Element("config");
                        this.doc.setRootElement(this.root);
                        XMLOutputter outputter = new XMLOutputter();
                        FileOutputStream os = null;
                        try {
                            os = new FileOutputStream(this.file);
                            outputter.output(this.doc, (OutputStream)os);
                        }
                        catch (Throwable throwable) {
                            FileUtils.close(os);
                            throw throwable;
                        }
                        FileUtils.close(os);
                        break block8;
                    }
                    throw new StudioConfigurationException("can not create configuration file");
                }
                logger.debug((Object)("read config file: " + this.file.getAbsolutePath()));
                SAXBuilder builder = SAXBuilderFactory.create();
                this.doc = builder.build(this.file);
                this.root = this.doc.getRootElement();
                if (!this.root.getName().equals("config")) {
                    throw new StudioConfigurationException("not a config file,root tag must be 'config'");
                }
            }
            catch (IOException ie) {
                throw new StudioConfigurationException("read file " + this.file.getAbsolutePath() + " error: " + ie.getMessage());
            }
            catch (JDOMException de) {
                throw new StudioConfigurationException("parse file " + this.file.getAbsolutePath() + " error: " + de.getMessage());
            }
        }
    }

    protected void dump(PrintStream ps) {
        StudioConfiguration.dumpItem(ps, "", this.root);
    }

    static void dumpItem(PrintStream ps, String space, Element _el) {
        if (!_el.getName().equals("config")) {
            ps.println(space + "[configitem]:" + _el.getAttributeValue("name"));
        }
        List _listAttr = _el.getChildren("attribute");
        for (int i = 0; i < _listAttr.size(); ++i) {
            Element __el = (Element)_listAttr.get(i);
            ps.println(space + "  attribute " + __el.getAttributeValue("key") + " = " + __el.getAttributeValue("value"));
        }
        List _listConfigItem = _el.getChildren("configitem");
        for (int i = 0; i < _listConfigItem.size(); ++i) {
            Element __el = (Element)_listConfigItem.get(i);
            StudioConfiguration.dumpItem(ps, space + "    ", __el);
        }
    }

    public static Element getAttributeElement(Element el, String key) {
        Element _el = null;
        try {
            _el = (Element)XPath.selectSingleNode((Object)el, (String)("attribute[attribute::key='" + key + "']"));
        }
        catch (JDOMException _e) {
            logger.error((Object)"XPath error", (Throwable)_e);
        }
        return _el;
    }

    public static Element getConfigItemElement(Element el, String name) {
        Element _el = null;
        try {
            _el = (Element)XPath.selectSingleNode((Object)el, (String)("configitem[attribute::name='" + name + "']"));
        }
        catch (JDOMException _e) {
            logger.error((Object)"XPath error", (Throwable)_e);
        }
        return _el;
    }

    public static Element getConfigItemElementByPath(Element el, String path) {
        String _name;
        Element _el = null;
        String _path = "";
        StringTokenizer st = new StringTokenizer(path, "/");
        if (st.hasMoreTokens()) {
            _name = st.nextToken();
            _path = _path + "configitem[attribute::name='" + _name + "']";
        }
        while (st.hasMoreTokens()) {
            _name = st.nextToken();
            _path = _path + "/configitem[attribute::name='" + _name + "']";
        }
        try {
            _el = (Element)XPath.selectSingleNode((Object)el, (String)_path);
        }
        catch (JDOMException _e) {
            logger.error((Object)"XPath error", (Throwable)_e);
        }
        return _el;
    }

    static {
        logger = Logger.getLogger((String)"com.kingdee.bos.tool.solution.StudioConfiguration");
    }
}

