/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.views;

import com.kingdee.bos.tool.ToolBasePlugin;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.connection.ConnectionManager;
import com.kingdee.bos.tool.connection.DBConnection;
import com.kingdee.bos.tool.connection.GroupExtensionPointProcess;
import com.kingdee.bos.tool.connection.IConnection;
import com.kingdee.bos.tool.connection.IGroup;
import com.kingdee.bos.tool.console.IUserStream;
import com.kingdee.bos.tool.utils.ToolCommonImages;
import com.kingdee.bos.tool.views.CreateConnectionDialog;
import com.kingdee.bos.tool.views.Messages;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class ConnectionManagerView
extends ViewPart
implements ISelectionProvider {
    private TreeViewer treeViewer;
    private IPartListener partListener;
    private IUserStream stream;
    private Action addAction;
    private Action removeAction;
    private Action connectAction;
    private Action importAction;
    private Action exportAction;

    public void setFocus() {
        if (this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.getTree().setFocus();
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.partListener = new PartListener();
        site.getWorkbenchWindow().getPartService().addPartListener(this.partListener);
    }

    public void createPartControl(Composite parent) {
        Tree tree = new Tree(parent, 4);
        tree.setLayoutData((Object)new GridData(1808));
        this.createViewer(tree);
        this.createPopupMenuManager(tree);
        this.makeActions();
        this.fillToolBar();
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.treeViewer.getTree().setToolTipText("");
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
    }

    private void fillToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = bars.getToolBarManager();
        toolBarManager.add((IAction)this.addAction);
        toolBarManager.add((IAction)this.removeAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.connectAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.importAction);
        toolBarManager.add((IAction)this.exportAction);
    }

    private void createViewer(Tree tree) {
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)new ConnectionManagerContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConnectionManagerLabelProvider());
        this.treeViewer.setInput((Object)ConnectionManager.getConnections());
        this.treeViewer.expandAll();
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ConnectionManagerView.this.addConnection(false);
            }
        });
    }

    private void createPopupMenuManager(Tree tree) {
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                ConnectionManagerView.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Menu menu = popupMenuManager.createContextMenu((Control)tree);
        tree.setMenu(menu);
    }

    private void makeActions() {
        String strAdd = Messages.ConnectionManagerView_ZengJiaLianJie;
        this.addAction = new Action(strAdd){

            public void run() {
                ConnectionManagerView.this.addConnection(true);
            }
        };
        this.addAction.setText(strAdd);
        this.addAction.setToolTipText(strAdd);
        this.addAction.setImageDescriptor(ToolCommonImages.getImageDescriptor("add.gif"));
        String strRemove = Messages.ConnectionManagerView_ShanChuLianJie;
        this.removeAction = new Action(strRemove){

            public void run() {
                ConnectionManagerView.this.removeConnection();
            }
        };
        this.removeAction.setText(strRemove);
        this.removeAction.setToolTipText(strRemove);
        this.removeAction.setImageDescriptor(ToolCommonImages.getImageDescriptor("delete.gif"));
        String strTest = Messages.ConnectionManagerView_CeShiLianJie;
        this.connectAction = new Action(strTest){

            public void run() {
                ConnectionManagerView.this.connect();
            }
        };
        this.connectAction.setText(strTest);
        this.connectAction.setToolTipText(strTest);
        this.connectAction.setImageDescriptor(ToolCommonImages.getImageDescriptor("connect.gif"));
        String strImport = Messages.ConnectionManagerView_DaoRuLianJie;
        this.importAction = new Action(strTest){

            public void run() {
                ConnectionManagerView.this.importConnection();
            }
        };
        this.importAction.setText(strImport);
        this.importAction.setToolTipText(strImport);
        this.importAction.setImageDescriptor(ToolCommonImages.getImageDescriptor("importConnection.gif"));
        String strExport = Messages.ConnectionManagerView_DaoChuLianJie;
        this.exportAction = new Action(strExport){

            public void run() {
                ConnectionManagerView.this.exportConnection();
            }
        };
        this.exportAction.setText(strExport);
        this.exportAction.setToolTipText(strExport);
        this.exportAction.setImageDescriptor(ToolCommonImages.getImageDescriptor("exportConnection.gif"));
    }

    public void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addAction);
        manager.add((IAction)this.removeAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.connectAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.importAction);
        manager.add((IAction)this.exportAction);
    }

    protected void addConnection(boolean isAdd) {
        ISelection selection = this.treeViewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (!isAdd && !(obj instanceof IConnection)) {
            return;
        }
        Map connections = ConnectionManager.getConnections();
        String groupId = null;
        Map groups = null;
        if (obj instanceof IConnection) {
            for (String id : connections.keySet()) {
                groups = (Map)connections.get(id);
                if (!groups.containsValue(obj)) continue;
                groupId = id;
                break;
            }
        } else {
            for (String id : connections.keySet()) {
                groups = (Map)connections.get(id);
                if (!groups.equals(obj)) continue;
                groupId = id;
                break;
            }
        }
        if (groupId == null) {
            return;
        }
        IGroup group = (IGroup)GroupExtensionPointProcess.getGroups().get(groupId);
        IConnection con = ConnectionManager.makeConnection(group);
        if (!isAdd) {
            con = (IConnection)obj;
        }
        CreateConnectionDialog dlg = new CreateConnectionDialog(this.treeViewer.getTree().getShell(), isAdd, con);
        if (con instanceof DBConnection) {
            dlg.setDBConnection(true);
        }
        dlg.create();
        if (dlg.open() == 0 && groups != null) {
            con.setName(dlg.getName());
            groups.put(dlg.getName(), con);
        }
        this.treeViewer.refresh();
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)con));
    }

    protected void removeConnection() {
        ISelection selection = this.treeViewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof IConnection) {
            Map connections = ConnectionManager.getConnections();
            for (String id : connections.keySet()) {
                Map groups = (Map)connections.get(id);
                if (!groups.containsValue(obj)) continue;
                groups.remove(((IConnection)obj).getName());
                this.treeViewer.refresh();
                return;
            }
        }
    }

    protected void connect() {
        ISelection selection = this.treeViewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof IConnection) {
            String result = ((IConnection)obj).connect() ? Messages.ConnectionManagerView_ChengGong : Messages.ConnectionManagerView_ShiBai;
            Shell shell = this.treeViewer.getTree().getShell();
            MessageDialog.openInformation((Shell)shell, (String)Messages.ConnectionManagerView_TiShi, (String)(Messages.ConnectionManagerView_LianJie + result));
        }
    }

    protected void importConnection() {
        Shell shell = this.treeViewer.getTree().getShell();
        FileDialog fDialog = new FileDialog(shell, 65536);
        fDialog.setText(Messages.ConnectionManagerView_DaoRuLianJie);
        String absolutePath = fDialog.open();
        if (StringUtils.isEmpty((String)absolutePath)) {
            return;
        }
        Map connections = ConnectionManager.getConnections();
        Map impConnections = ConnectionManager.load(absolutePath);
        ToolCommonPlugin.showConsole();
        for (String group : impConnections.keySet()) {
            if (!connections.containsKey(group)) {
                connections.put(group, new HashMap());
            }
            Object value = impConnections.get(group);
            Map connectionsByGroup = (Map)connections.get(group);
            for (String connectionName : ((Map)value).keySet()) {
                IConnection con = (IConnection)((Map)value).get(connectionName);
                if (connectionsByGroup.containsKey(connectionName)) {
                    this.getUserStream().println(Messages.ConnectionManagerView_LianJie + connectionName + Messages.ConnectionManagerView_YiCunZaiMeiYouDaoRu);
                    continue;
                }
                connectionsByGroup.put(connectionName, con);
                this.getUserStream().println(Messages.ConnectionManagerView_LianJie + connectionName + Messages.ConnectionManagerView_ChengGongDaoRu);
            }
        }
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
    }

    protected void exportConnection() {
        Shell shell = this.treeViewer.getTree().getShell();
        FileDialog fDialog = new FileDialog(shell, 65536);
        fDialog.setText(Messages.ConnectionManagerView_DaoChuLianJie);
        fDialog.setFilterExtensions(new String[]{"*.*", "*.xml"});
        String absolutePath = fDialog.open();
        if (StringUtils.isEmpty((String)absolutePath)) {
            return;
        }
        ConnectionManager.store(absolutePath);
        ToolCommonPlugin.showConsole();
        this.getUserStream().println(Messages.ConnectionManagerView_LianJieChengGongDaoChu);
    }

    private IUserStream getUserStream() {
        if (this.stream == null) {
            this.stream = ToolBasePlugin.getDefault().getUserStream("Connection Manage");
        }
        return this.stream;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.treeViewer.setSelection(selection);
    }

    class PartListener
    implements IPartListener {
        PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part.equals((Object)ConnectionManagerView.this)) {
                ConnectionManager.store();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    class ConnectionManagerLabelProvider
    extends LabelProvider {
        ConnectionManagerLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IConnection) {
                return ToolCommonImages.getImage("connection2.gif");
            }
            if (element instanceof Map) {
                return ToolCommonImages.getImage("group.gif");
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IConnection) {
                return ((IConnection)element).getName();
            }
            if (element instanceof Map) {
                Map map = ConnectionManager.getConnections();
                for (String groupId : map.keySet()) {
                    if (!map.get(groupId).equals(element)) continue;
                    Map groups = GroupExtensionPointProcess.getGroups();
                    return ((IGroup)groups.get(groupId)).getName();
                }
            }
            return "";
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }
    }

    class ConnectionManagerContentProvider
    implements ITreeContentProvider {
        private Object[] EMPTY_ARRAY = new Object[0];

        ConnectionManagerContentProvider() {
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object getParent(Object element) {
            if (element instanceof IConnection) {
                Map map = ConnectionManager.getConnections();
                for (Map map2 : map.values()) {
                    if (!map2.containsValue(element)) continue;
                    return map2;
                }
            } else if (element instanceof Map) {
                return ConnectionManager.getConnections();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getChildren(Object element) {
            if (element instanceof Map) {
                ArrayList list = new ArrayList(((Map)element).values());
                return list.toArray();
            }
            return this.EMPTY_ARRAY;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

