/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.views;

import com.kingdee.bos.metadata.management.JdbcDriverType;
import com.kingdee.bos.tool.connection.ConnectionManager;
import com.kingdee.bos.tool.connection.IConnection;
import com.kingdee.bos.tool.views.Messages;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateConnectionDialog
extends TitleAreaDialog {
    private Text limitText;
    private String name;
    private boolean isAdd = false;
    private IConnection con;
    private Text fHost;
    private Text fPort;
    private Text fDBName;
    private Text fUser;
    private Text fPassw;
    private Combo driverType;
    private boolean isDBConnection = false;

    public String getName() {
        return this.name;
    }

    public CreateConnectionDialog(Shell parentShell, boolean isAdd, IConnection con) {
        super(parentShell);
        this.isAdd = isAdd;
        this.con = con;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(container, 0);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        Label label = new Label(composite, 0);
        label.setText(Messages.CreateConnectionDialog_LianJieMingCheng);
        this.setTitle(Messages.CreateConnectionDialog_QingShuRuXinJianLianJieDeMingCheng);
        this.limitText = new Text(composite, 2048);
        gd = new GridData(768);
        this.limitText.setLayoutData((Object)gd);
        if (!this.isAdd) {
            this.limitText.setText(this.con.getName());
            this.limitText.setEnabled(false);
        }
        this.limitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateConnectionDialog.this.name = CreateConnectionDialog.this.limitText.getText().trim();
                if (StringUtils.isEmpty((String)CreateConnectionDialog.this.name)) {
                    CreateConnectionDialog.this.getButton(0).setEnabled(false);
                    return;
                }
                Map connections = ConnectionManager.getConnections();
                Iterator i0 = connections.keySet().iterator();
                while (i0.hasNext()) {
                    Map groups = (Map)connections.get(i0.next());
                    Iterator i1 = groups.keySet().iterator();
                    while (i1.hasNext()) {
                        IConnection connection = (IConnection)groups.get(i1.next());
                        if (!CreateConnectionDialog.this.name.equals(connection.getName())) continue;
                        CreateConnectionDialog.this.setErrorMessage(Messages.CreateConnectionDialog_CunZaiTongMingDeLianJie);
                        CreateConnectionDialog.this.getButton(0).setEnabled(false);
                        return;
                    }
                }
                CreateConnectionDialog.this.getButton(0).setEnabled(true);
                CreateConnectionDialog.this.setErrorMessage(null);
            }
        });
        if (this.isDBConnection) {
            new Label(composite, 0).setText("JDBC Driver:");
            this.driverType = new Combo(composite, 2056);
            this.driverType.setItems(new String[]{JdbcDriverType.MS_SQL_SERVER_DRIVER.getName(), JdbcDriverType.ORACLE_THIN_DRIVER.getName(), JdbcDriverType.IBM_DB2_NET_DRIVER.getName()});
            this.driverType.setLayoutData((Object)new GridData(768));
        }
        new Label(composite, 0).setText(Messages.CreateConnectionDialog_FuWuQi);
        this.fHost = new Text(composite, 2048);
        this.fHost.setLayoutData((Object)new GridData(256));
        new Label(composite, 0).setText(Messages.CreateConnectionDialog_DuanKou);
        this.fPort = new Text(composite, 2048);
        this.fPort.setLayoutData((Object)new GridData(256));
        if (this.isDBConnection) {
            new Label(composite, 0).setText(Messages.CreateConnectionDialog_ShuJuKuMingCheng);
            this.fDBName = new Text(composite, 2048);
            this.fDBName.setLayoutData((Object)new GridData(256));
        }
        new Label(composite, 0).setText(Messages.CreateConnectionDialog_YongHuMing);
        this.fUser = new Text(composite, 2048);
        this.fUser.setLayoutData((Object)new GridData(256));
        new Label(composite, 0).setText(Messages.CreateConnectionDialog_MiMa);
        this.fPassw = new Text(composite, 2048);
        this.fPassw.setEchoChar('*');
        this.fPassw.setLayoutData((Object)new GridData(256));
        if (!this.isAdd) {
            this.name = this.con.getName();
            if (this.isDBConnection) {
                JdbcDriverType type = JdbcDriverType.getEnum((String)((String)this.con.getValue("jdbcdrivertype")));
                if (type.equals((Object)JdbcDriverType.ORACLE_THIN_DRIVER)) {
                    this.driverType.select(1);
                } else if (type.equals((Object)JdbcDriverType.IBM_DB2_NET_DRIVER)) {
                    this.driverType.select(2);
                } else {
                    this.driverType.select(0);
                }
                String db = (String)this.con.getValue("dbname");
                this.fDBName.setText(db);
            }
            String host = (String)this.con.getValue("host");
            int port = (Integer)this.con.getValue("port");
            String user = (String)this.con.getValue("user");
            String password = (String)this.con.getValue("password");
            this.fHost.setText(host);
            this.fPort.setText(String.valueOf(port));
            this.fUser.setText(user);
            this.fPassw.setText(password);
        }
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
        if (!this.isAdd) {
            this.getButton(0).setEnabled(true);
        }
    }

    protected void okPressed() {
        this.setReturnCode(0);
        if (this.isDBConnection) {
            this.con.setValue("jdbcdrivertype", this.driverType.getText());
            this.con.setValue("dbname", this.fDBName.getText().trim());
        }
        this.con.setValue("host", this.fHost.getText().trim());
        this.con.setValue("port", new Integer(this.fPort.getText().trim()));
        this.con.setValue("user", this.fUser.getText().trim());
        this.con.setValue("password", this.fPassw.getText());
        this.close();
    }

    public void setDBConnection(boolean isDBConnection) {
        this.isDBConnection = isDBConnection;
    }
}

