/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.wizard.i18n;

import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.stringextr.FileExtrInfo;
import com.kingdee.bos.tool.stringextr.StringResourceInfo;
import com.kingdee.bos.tool.wizard.i18n.ParseOption;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaStringParser {
    private char c;
    private int lineNum = 0;
    private int colNum = 0;
    private int pos = -1;
    private Map lineColumn = new HashMap();
    private final String FINAL_STR = "final";
    private StringBuffer sb = null;
    private ParseOption option;

    public void setParseOption(ParseOption option) {
        this.option = option;
    }

    public synchronized FileExtrInfo parse(File file) throws IOException {
        if (this.option == null) {
            this.option = new ParseOption();
        }
        this.pos = -1;
        this.lineColumn.clear();
        this.colNum = 0;
        this.lineNum = 0;
        FileExtrInfo fileExtrInfo = new FileExtrInfo();
        fileExtrInfo.setSource(file);
        this.sb = JavaStringParser.readFile(file);
        while (this.readOne()) {
            String s;
            if (this.c == '/') {
                if (!this.readOne()) {
                    return fileExtrInfo;
                }
                if (this.c == '/') {
                    this.ignoreFor("\n");
                    continue;
                }
                if (this.c == '*') {
                    this.ignoreFor("*/");
                    continue;
                }
                this.backOne();
                continue;
            }
            if (this.c == '\'') {
                this.readOne();
                if (this.c == '\\') {
                    this.readOne();
                }
                this.readOne();
                continue;
            }
            if (this.c == '\"') {
                s = this.readString();
                StringResourceInfo info = new StringResourceInfo();
                info.setValue(s);
                info.setPos(this.pos);
                info.setColumn(this.colNum);
                info.setLine(this.lineNum);
                this.fixInfo(info);
                fileExtrInfo.getStringInfos().add(info);
                continue;
            }
            if (fileExtrInfo.getPkgName() != null || !(s = this.readWord()).equals("package")) continue;
            String l = this.readLine();
            if (l.endsWith(";")) {
                l = l.substring(0, l.length() - 1);
            }
            fileExtrInfo.setPkgName(l);
        }
        String prefix = file.getName();
        int ind = prefix.lastIndexOf(46);
        if (ind > 0) {
            prefix = prefix.substring(0, ind) + "_";
        }
        fileExtrInfo.setPrefix(prefix);
        List children = fileExtrInfo.getStringInfos();
        for (int i = 0; i < children.size(); ++i) {
            StringResourceInfo strInfo = (StringResourceInfo)children.get(i);
            if (strInfo.isFinal() && this.option.isIgroneFinal()) {
                children.remove(i);
                --i;
                continue;
            }
            String str = strInfo.getValue();
            boolean isUnicode = true;
            for (int j = 0; j < str.length(); ++j) {
                char c = str.charAt(j);
                if (c >= '\u0000' && c <= '\u007f') continue;
                isUnicode = false;
                break;
            }
            strInfo.setUnicode(isUnicode);
            if (!this.option.isIgroneUnicode() || !isUnicode) continue;
            children.remove(i);
            --i;
        }
        if (fileExtrInfo.getPkgName() == null) {
            fileExtrInfo.setPkgName("");
        }
        String f = StringUtils.replace((String)fileExtrInfo.getPkgName(), (String)".", (String)"/");
        fileExtrInfo.setMessageFile(f + "/messages_zh_CN.properties");
        return fileExtrInfo;
    }

    private void fixInfo(StringResourceInfo info) {
        char cc;
        StringBuffer line = new StringBuffer();
        int p = info.getPos();
        info.setPos(p -= info.getValue().length());
        while (p > 0 && (cc = this.sb.charAt(p)) != ';' && cc != '}') {
            line.append(cc);
            --p;
        }
        String l = line.reverse().toString().trim();
        if (l.startsWith("final")) {
            info.setFinal(true);
        } else if (l.indexOf("final") != -1) {
            info.setFinal(true);
        } else {
            info.setFinal(false);
        }
    }

    private String readWord() {
        StringBuffer line = new StringBuffer();
        line.append(this.c);
        while (this.readOne() && this.c != ';' && this.c != ' ' && this.c != '\n') {
            line.append(this.c);
        }
        return line.toString().trim();
    }

    private String readString() {
        StringBuffer line = new StringBuffer();
        while (this.readOne() && this.c != '\"') {
            line.append(this.c);
            if (this.c != '\\') continue;
            if (!this.readOne()) break;
            line.append(this.c);
        }
        return line.toString();
    }

    private void ignoreFor(String str) {
        StringBuffer line = new StringBuffer();
        while (this.readOne()) {
            line.append(this.c);
            if (!line.toString().endsWith(str)) continue;
            return;
        }
    }

    private String readLine() {
        StringBuffer line = new StringBuffer();
        while (this.readOne() && this.c != '\n') {
            line.append(this.c);
        }
        return line.toString().trim();
    }

    private boolean backOne() {
        if (this.pos == 0) {
            return false;
        }
        --this.pos;
        if (this.c == '\n') {
            --this.lineNum;
            this.colNum = (Integer)this.lineColumn.get(new Integer(this.lineNum));
        } else {
            --this.colNum;
        }
        return true;
    }

    private boolean readOne() {
        ++this.pos;
        if (this.pos >= this.sb.length()) {
            return false;
        }
        this.c = this.sb.charAt(this.pos);
        if (this.c == '\n') {
            this.lineColumn.put(new Integer(this.lineNum), new Integer(this.colNum));
            ++this.lineNum;
            this.colNum = 0;
        } else {
            ++this.colNum;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer readFile(File file) throws IOException {
        BufferedReader reader = null;
        StringBuffer sb = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            char[] bs = new char[255];
            int len = reader.read(bs);
            sb = new StringBuffer();
            while (len != -1) {
                sb.append(new String(bs, 0, len));
                len = reader.read(bs);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(reader);
            throw throwable;
        }
        FileUtils.close(reader);
        return sb;
    }
}

