/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.wizard.i18n;

import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.stringextr.FileExtrInfo;
import com.kingdee.bos.tool.stringextr.StringResourceInfo;
import com.kingdee.bos.tool.wizard.i18n.ExtrOptions;
import com.kingdee.bos.tool.wizard.i18n.I18NResourceContentProvider;
import com.kingdee.bos.tool.wizard.i18n.I18NResourceLableProvider;
import com.kingdee.bos.tool.wizard.i18n.JavaStringParser;
import com.kingdee.bos.tool.wizard.i18n.ParseOption;
import com.kingdee.bos.tool.wizard.i18n.ResourceInfo;
import com.kingdee.bos.tool.wizard.i18n.StringExtrWizard;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SEViewJavaWizardPage
extends WizardPage {
    private TreeViewer treeViewer;
    private I18NResourceContentProvider contentProvider;
    private Text prefixText;
    private Text fileText;
    private TableViewer tableViewer;
    private Table table;
    private JavaStringParser parser = new JavaStringParser();
    private FileExtrInfo currentInfo = null;
    private ResourceInfo resourceInfo = null;
    Map infoMap = new HashMap();
    private Button hideEmptyBtn;

    protected SEViewJavaWizardPage(String pageName) {
        super(pageName);
        super.setTitle("\u8bbe\u7f6e\u63d0\u53d6\u8be6\u7ec6\u4fe1\u606f");
        super.setDescription("\u8bbe\u7f6eJAVA\u6587\u4ef6\u4e2d\u5b57\u7b26\u4e32\u7684\u63d0\u53d6\u4fe1\u606f");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayoutData((Object)new GridData(768));
        container.setLayout((Layout)layout);
        Composite leftPanel = new Composite(container, 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 450;
        leftPanel.setLayoutData((Object)gd);
        leftPanel.setLayout((Layout)new GridLayout(1, false));
        this.treeViewer = new TreeViewer(leftPanel, 2820);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.contentProvider = new I18NResourceContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new I18NResourceLableProvider());
        this.hideEmptyBtn = new Button(leftPanel, 32);
        this.hideEmptyBtn.setText("\u4ec5\u663e\u793a\u5305\u542b\u5b57\u7b26\u4e32\u7684\u6587\u4ef6");
        this.hideEmptyBtn.setSelection(true);
        this.hideEmptyBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SEViewJavaWizardPage.this.refresh();
            }
        });
        Composite rightPanel = new Composite(container, 0);
        rightPanel.setLayoutData((Object)new GridData(1808));
        rightPanel.setLayout((Layout)new GridLayout(2, false));
        Label l1 = new Label(rightPanel, 0);
        l1.setText("\u524d\u7f00");
        this.prefixText = new Text(rightPanel, 2052);
        this.prefixText.setLayoutData((Object)new GridData(768));
        this.prefixText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SEViewJavaWizardPage.this.currentInfo == null || StringUtils.isEmpty((String)SEViewJavaWizardPage.this.prefixText.getText())) {
                    return;
                }
                String oldPrefix = SEViewJavaWizardPage.this.currentInfo.getPrefix();
                String newPrefix = SEViewJavaWizardPage.this.prefixText.getText().trim();
                SEViewJavaWizardPage.this.currentInfo.setPrefix(newPrefix);
                List list = SEViewJavaWizardPage.this.currentInfo.getStringInfos();
                for (int i = 0; i < list.size(); ++i) {
                    StringResourceInfo sInfo = (StringResourceInfo)list.get(i);
                    if (!sInfo.getKey().startsWith(oldPrefix)) continue;
                    sInfo.setKey(newPrefix + sInfo.getKey().substring(oldPrefix.length()));
                    SEViewJavaWizardPage.this.table.getItem(i).setText(1, sInfo.getKey());
                }
            }
        });
        Label l2 = new Label(rightPanel, 0);
        l2.setText("\u8d44\u6e90\u6587\u4ef6");
        this.fileText = new Text(rightPanel, 2052);
        this.fileText.setLayoutData((Object)new GridData(768));
        this.fileText.setEditable(false);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SEViewJavaWizardPage.this.currentInfo == null || StringUtils.isEmpty((String)SEViewJavaWizardPage.this.fileText.getText())) {
                    return;
                }
                SEViewJavaWizardPage.this.currentInfo.setMessageFile(SEViewJavaWizardPage.this.fileText.getText().trim());
            }
        });
        this.tableViewer = new TableViewer(rightPanel, 68386);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)gd);
        TableColumn col1 = new TableColumn(this.table, 0);
        col1.setWidth(200);
        col1.setText("\u503c");
        TableColumn col2 = new TableColumn(this.table, 0);
        col2.setWidth(200);
        col2.setText("\u952e");
        TableColumn col3 = new TableColumn(this.table, 0);
        col3.setWidth(50);
        col3.setText("final");
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SEViewJavaWizardPage.this.prefixText.setText("");
                SEViewJavaWizardPage.this.fileText.setText("");
                for (int i = 0; i < SEViewJavaWizardPage.this.table.getItemCount(); ++i) {
                    StringResourceInfo sInfo = (StringResourceInfo)SEViewJavaWizardPage.this.table.getItem(i).getData();
                    sInfo.setCanceled(!SEViewJavaWizardPage.this.table.getItem(i).getChecked());
                }
                SEViewJavaWizardPage.this.table.removeAll();
                SEViewJavaWizardPage.this.currentInfo = null;
                if (event.getSelection().isEmpty()) {
                    return;
                }
                ResourceInfo info = (ResourceInfo)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (info.getResource() instanceof FileExtrInfo) {
                    SEViewJavaWizardPage.this.currentInfo = (FileExtrInfo)info.getResource();
                    List list = SEViewJavaWizardPage.this.currentInfo.getStringInfos();
                    for (int i = 0; i < list.size(); ++i) {
                        StringResourceInfo sInfo = (StringResourceInfo)list.get(i);
                        TableItem item = new TableItem(SEViewJavaWizardPage.this.table, 0);
                        item.setData((Object)sInfo);
                        item.setText(0, sInfo.getValue());
                        item.setText(1, sInfo.getKey() == null ? "" : sInfo.getKey());
                        item.setText(2, String.valueOf(sInfo.isFinal()));
                        item.setChecked(!sInfo.isCanceled());
                    }
                    SEViewJavaWizardPage.this.prefixText.setText(SEViewJavaWizardPage.this.currentInfo.getPrefix());
                    SEViewJavaWizardPage.this.fileText.setText(SEViewJavaWizardPage.this.currentInfo.getMessageFile());
                }
            }
        });
        TextCellEditor cellEditor = new TextCellEditor((Composite)this.table);
        this.tableViewer.setCellEditors(new CellEditor[]{null, cellEditor, null});
        this.tableViewer.setColumnProperties(new String[]{"col1", "col2", "col3"});
        this.tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return property.endsWith("col2");
            }

            public Object getValue(Object element, String property) {
                return ((StringResourceInfo)element).getKey();
            }

            public void modify(Object element, String property, Object value) {
                TableItem item = (TableItem)element;
                StringResourceInfo sInfo = (StringResourceInfo)item.getData();
                sInfo.setKey(value.toString());
                item.setText(1, value.toString());
            }
        });
        this.setControl((Control)container);
    }

    private void refresh() {
        this.resourceInfo = new ResourceInfo();
        ResourceInfo fileInfos = ((StringExtrWizard)this.getWizard()).getResourceInfo();
        ExtrOptions options = ((StringExtrWizard)this.getWizard()).getOptions();
        ParseOption parseOption = new ParseOption();
        parseOption.setIgroneFinal(options.isIgornFinal());
        parseOption.setIgroneUnicode(options.isUnUnicodeOnly());
        this.parser.setParseOption(parseOption);
        this.parseInfo(fileInfos, this.hideEmptyBtn.getSelection(), options, this.resourceInfo);
        this.trimInfo(this.resourceInfo);
        this.treeViewer.setInput((Object)this.resourceInfo);
        this.treeViewer.refresh();
        this.treeViewer.expandToLevel(2);
    }

    private void trimInfo(ResourceInfo pInfo) {
        List children = pInfo.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            ResourceInfo info = (ResourceInfo)children.remove(i);
            ResourceInfo[] oInfos = this.getInfoHasChild(info);
            --i;
            for (int j = 0; j < oInfos.length; ++j) {
                children.add(++i, oInfos[j]);
            }
        }
    }

    private ResourceInfo[] getInfoHasChild(ResourceInfo info) {
        if (info.getResource() instanceof FileExtrInfo) {
            return new ResourceInfo[]{info};
        }
        if (info.hasFileChild(FileExtrInfo.class)) {
            this.trimInfo(info);
            return new ResourceInfo[]{info};
        }
        ArrayList<ResourceInfo> list = new ArrayList<ResourceInfo>();
        for (int i = 0; i < info.getChildren().size(); ++i) {
            ResourceInfo sInfo = (ResourceInfo)info.getChildren().get(i);
            if (sInfo.getResource() instanceof FileExtrInfo) {
                list.add(sInfo);
            }
            if (sInfo.hasFileChild(FileExtrInfo.class)) {
                this.trimInfo(sInfo);
                list.add(sInfo);
                continue;
            }
            ResourceInfo[] infos = this.getInfoHasChild(sInfo);
            for (int j = 0; j < infos.length; ++j) {
                list.add(infos[j]);
            }
        }
        return list.toArray(new ResourceInfo[0]);
    }

    private void parseInfo(ResourceInfo info, boolean hideEmpty, ExtrOptions options, ResourceInfo parent) {
        if (info.getResource() instanceof IFile) {
            IFile file = (IFile)info.getResource();
            FileExtrInfo fInfo = (FileExtrInfo)this.infoMap.get(file);
            if (fInfo == null) {
                try {
                    fInfo = this.parser.parse(new File(file.getLocation().toOSString()));
                }
                catch (IOException e) {
                    LogTool.logError("\u89e3\u6790\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", e);
                }
            }
            if (fInfo != null) {
                if (!fInfo.getStringInfos().isEmpty()) {
                    this.infoMap.put(file, fInfo);
                    ResourceInfo sub = new ResourceInfo(fInfo);
                    parent.getChildren().add(sub);
                } else if (!hideEmpty) {
                    ResourceInfo sub = new ResourceInfo(fInfo);
                    parent.getChildren().add(sub);
                }
                this.fix(fInfo, options);
            }
        } else {
            ResourceInfo sub = new ResourceInfo(info.getResource());
            parent.getChildren().add(sub);
            List list = info.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                this.parseInfo((ResourceInfo)list.get(i), hideEmpty, options, sub);
            }
        }
    }

    public void fix(FileExtrInfo info, ExtrOptions options) {
        String prefix = info.getPrefix();
        List list = info.getStringInfos();
        if (options.isJoinKey()) {
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                StringResourceInfo sInfo = (StringResourceInfo)list.get(i);
                int index = values.indexOf(sInfo.getValue());
                if (index == -1) {
                    if (sInfo.getKey() == null || sInfo.getKey().startsWith(prefix)) {
                        sInfo.setKey(prefix + values.size());
                    }
                    values.add(sInfo.getValue());
                    continue;
                }
                sInfo.setKey(prefix + index);
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                StringResourceInfo sInfo = (StringResourceInfo)list.get(i);
                if (sInfo.getKey() != null && !sInfo.getKey().startsWith(prefix)) continue;
                sInfo.setKey(prefix + i);
            }
        }
    }

    public boolean isPageComplete() {
        return !this.infoMap.isEmpty();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.infoMap.clear();
            this.refresh();
            this.getWizard().getContainer().updateButtons();
        } else {
            for (int i = 0; i < this.table.getItemCount(); ++i) {
                StringResourceInfo sInfo = (StringResourceInfo)this.table.getItem(i).getData();
                sInfo.setCanceled(!this.table.getItem(i).getChecked());
            }
        }
        super.setVisible(visible);
    }
}

