/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.wizard.i18n;

import com.kingdee.bos.tool.LogTool;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.widgets.Composite;

public class SelectionTreeViewer
extends CheckboxTreeViewer {
    private IRunnableContext uiRunableContext;
    private Map topElementStateMap = new HashMap();

    public SelectionTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public SelectionTreeViewer(Composite parent) {
        super(parent, 2818);
        this.init();
    }

    public void setUIRunableContext(IRunnableContext context) {
        this.uiRunableContext = context;
    }

    private void init() {
        this.setUseHashlookup(true);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SelectionTreeViewer.this.syncCheckState(event.getElement());
                if (SelectionTreeViewer.this.topElementStateMap.containsKey(event.getElement())) {
                    SelectionTreeViewer.this.topElementStateMap.put(event.getElement(), Boolean.TRUE);
                }
            }
        });
        this.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                Boolean loaded = (Boolean)SelectionTreeViewer.this.topElementStateMap.get(element);
                if (loaded == null || loaded == Boolean.TRUE) {
                    return;
                }
                SelectionTreeViewer.this.syncCheckState(element);
                SelectionTreeViewer.this.topElementStateMap.put(element, Boolean.TRUE);
            }
        });
    }

    private void syncCheckState(final Object element) {
        if (this.uiRunableContext != null) {
            try {
                this.uiRunableContext.run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        boolean state = SelectionTreeViewer.this.getChecked(element);
                        Object[] children = ((ITreeContentProvider)SelectionTreeViewer.this.getContentProvider()).getChildren(element);
                        monitor.beginTask("\u9009\u62e9\u8d44\u6e90", children.length);
                        for (int i = 0; i < children.length; ++i) {
                            SelectionTreeViewer.this.setSubtreeChecked(children[i], state);
                            monitor.worked(1);
                        }
                        monitor.done();
                    }
                });
            }
            catch (Exception e) {
                LogTool.logError("UI\u9009\u62e9\u8d44\u6e90\u65f6\u51fa\u9519", e);
            }
        } else {
            Object[] children = ((ITreeContentProvider)this.getContentProvider()).getChildren(element);
            for (int i = 0; i < children.length; ++i) {
                this.setSubtreeChecked(children[i], true);
            }
        }
    }

    public synchronized void setTreeInput(Object obj, boolean selectAll) {
        this.setInput(obj);
        this.topElementStateMap.clear();
        if (selectAll) {
            this.setAllChecked(true);
            Object[] element = this.getCheckedElements();
            if (element != null) {
                for (int i = 0; i < element.length; ++i) {
                    this.topElementStateMap.put(element[i], Boolean.FALSE);
                }
            }
        }
    }

    public Object[] getSelectedElements(Class cls) {
        Object[] elements = super.getCheckedElements();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < elements.length; ++i) {
            Object element = elements[i];
            Boolean bool = (Boolean)this.topElementStateMap.get(element);
            if (bool == Boolean.FALSE) {
                this.parseElement(element, list, cls);
                continue;
            }
            if (cls != null && !cls.isAssignableFrom(element.getClass())) continue;
            list.add(element);
        }
        return list.toArray((Object[])Array.newInstance(cls, 0));
    }

    private void parseElement(Object element, List list, Class cls) {
        Object[] children;
        if (cls == null || cls.isAssignableFrom(element.getClass())) {
            list.add(element);
        }
        if ((children = ((ITreeContentProvider)this.getContentProvider()).getChildren(element)) != null) {
            for (int i = 0; i < children.length; ++i) {
                this.parseElement(children[i], list, cls);
            }
        }
    }

    public boolean isParsed(Object element) {
        return this.topElementStateMap.get(element) == Boolean.TRUE;
    }
}

