/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class WfRoleUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.cust.app.impl.WfRoleUtils");
    private static String NOT_SUPPORT_ORGPROP = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateProcessRoledata(Context ctx, ProcessDef def, boolean enable) throws SQLException, DataAccessException, WfException {
        PreparedStatement stmt;
        Connection conn;
        block12: {
            conn = null;
            stmt = null;
            try {
                String procDefId = def.getID();
                conn = EJBFactory.getConnection((Context)ctx);
                String sql = "delete from t_wfr_prodefRole where fprocDefId = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, procDefId);
                stmt.executeUpdate();
                if (!enable) break block12;
                sql = "insert into t_wfr_prodefRole (fid,fprocDefId,fWfRoleId,ftype) values(?,?,?,?)";
                stmt = conn.prepareStatement(sql);
                HashSet<String> wfRoleIdSet = new HashSet<String>();
                HashSet<String> wfRoleGroupIdSet = new HashSet<String>();
                String wfroleId = null;
                String wfroleGroupId = null;
                String orgWfRoleId = null;
                HashSet<String> orgWfRoleIdSet = new HashSet<String>();
                ActivityCollection activities = def.getActivitys();
                int size = activities.size();
                for (int i = 0; i < size; ++i) {
                    ActivityDef actDef = activities.get(i);
                    if (!(actDef instanceof ManpowerActivityDef)) continue;
                    ManpowerActivityDef manActDef = (ManpowerActivityDef)actDef;
                    int sizeJ = manActDef.getParticipants().size();
                    for (int j = 0; j < sizeJ; ++j) {
                        ParticipantDef partiDef = manActDef.getParticipants().get(j);
                        if (partiDef.getParticipantType().equals((Object)ParticipantType.WFROLE)) {
                            wfroleId = partiDef.getParticipantValue();
                            if (wfRoleIdSet.contains(wfroleId)) continue;
                            wfRoleIdSet.add(wfroleId);
                            stmt.setString(1, BOSUuid.create((String)"wpdr").toString());
                            stmt.setString(2, procDefId);
                            stmt.setString(3, wfroleId);
                            stmt.setInt(4, 1);
                            stmt.addBatch();
                            continue;
                        }
                        if (!partiDef.getParticipantType().equals((Object)ParticipantType.WFROLE_GROUP) || wfRoleGroupIdSet.contains(wfroleGroupId = partiDef.getParticipantValue())) continue;
                        wfRoleGroupIdSet.add(wfroleGroupId);
                        stmt.setString(1, BOSUuid.create((String)"wpdr").toString());
                        stmt.setString(2, procDefId);
                        stmt.setString(3, wfroleGroupId);
                        stmt.setInt(4, 2);
                        stmt.addBatch();
                    }
                }
                TransitionCollection transitions = def.getTransitions();
                int size2 = transitions.size();
                for (int i = 0; i < size2; ++i) {
                    TransitionDef transDef = transitions.get(i);
                    if (transDef.getCondition() != null && transDef.getCondition().getWfRoleId() != null && !wfRoleIdSet.contains(wfroleId = transDef.getCondition().getWfRoleId())) {
                        wfRoleIdSet.add(wfroleId);
                        stmt.setString(1, BOSUuid.create((String)"wpdr").toString());
                        stmt.setString(2, procDefId);
                        stmt.setString(3, wfroleId);
                        if (transDef.getCondition().isFromRole()) {
                            stmt.setInt(4, 1);
                        } else {
                            stmt.setInt(4, 2);
                        }
                        stmt.addBatch();
                    }
                    if (transDef.getCondition() == null || transDef.getCondition().getOrgWfRoleId() == null || (orgWfRoleId = transDef.getCondition().getOrgWfRoleId()) == null || orgWfRoleId.length() <= 0 || orgWfRoleIdSet.contains(orgWfRoleId)) continue;
                    orgWfRoleIdSet.add(orgWfRoleId);
                    stmt.setString(1, BOSUuid.create((String)"wpdr").toString());
                    stmt.setString(2, procDefId);
                    stmt.setString(3, orgWfRoleId);
                    if (transDef.getCondition().isOrg_isFromRole()) {
                        stmt.setInt(4, 1);
                    } else {
                        stmt.setInt(4, 2);
                    }
                    stmt.addBatch();
                }
                if (wfRoleIdSet.size() > 0 || wfRoleGroupIdSet.size() > 0 || orgWfRoleIdSet.size() > 0) {
                    stmt.executeBatch();
                }
            }
            catch (Throwable throwable) {
                SQL.close(stmt);
                SQL.close((Connection)conn);
                throw throwable;
            }
        }
        SQL.close((Statement)stmt);
        SQL.close((Connection)conn);
    }

    public static OrgUnitInfo[] findOrgInfosBillInfo(Context ctx, String billId, String orgProName, OrgType orgType) throws WfException {
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)billId, (boolean)true);
        IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        ObjectStringPK pk = new ObjectStringPK(billId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo(orgProName + ".id"));
        selector.add(new SelectorItemInfo(orgProName + ".name"));
        selector.add(new SelectorItemInfo(orgProName + ".number"));
        selector.add(new SelectorItemInfo(orgProName + ".longnumber"));
        selector.add(new SelectorItemInfo(orgProName + ".isAdminOrgUnit"));
        IObjectValue objVal = null;
        try {
            objVal = dynamicObject.getValue(bosType, (IObjectPK)pk, selector);
        }
        catch (BOSException e) {
            throw new WfException(e.getMessage(), (Throwable)e);
        }
        if (objVal == null) {
            throw new WfException("\u5355\u636e(" + billId + ")\u4e0d\u5b58\u5728.");
        }
        return WfRoleUtils.getOrgUnitInfos(ctx, billId, orgProName, orgType, objVal);
    }

    private static OrgUnitInfo[] getOrgUnitInfos(Context ctx, String billId, String orgProName, OrgType orgType, IObjectValue objVal) throws WfException {
        List<?> ret = WfRoleUtils.getBillPropInfo(ctx, objVal, orgProName);
        if (ret.size() == 0) {
            throw new WfException("\u5355\u636e(" + billId + ")\u7ec4\u7ec7\u5c5e\u6027(" + orgProName + ")\u503c\u4e3a\u7a7a.");
        }
        List<OrgUnitInfo> orgList = new ArrayList<OrgUnitInfo>();
        for (Object orgInfo : ret) {
            OrgUnitInfo[] orgs = WfRoleUtils.findAdminOrgInfos(ctx, (OrgUnitInfo)orgInfo, orgType);
            orgList.addAll(Arrays.asList(orgs));
        }
        if (orgList.size() == 0) {
            throw new WfException("\u5355\u636e(" + billId + ")\u7ec4\u7ec7\u5c5e\u6027(" + orgProName + ")\u503c\u4e3a\u7a7a.");
        }
        orgList = WfRoleUtils.distinctOrg(orgList);
        return orgList.toArray(new OrgUnitInfo[0]);
    }

    public static OrgUnitInfo[] findOrgInfosBillInfo(Context ctx, IObjectValue billInfo, String orgProName, OrgType orgType) throws WfException {
        return WfRoleUtils.getOrgUnitInfos(ctx, null, orgProName, orgType, billInfo);
    }

    public static OrgUnitInfo findOrgInfos(Context ctx, String billId, String orgProName) throws WfException {
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)billId, (boolean)true);
        IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        ObjectStringPK pk = new ObjectStringPK(billId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo(orgProName + ".id"));
        selector.add(new SelectorItemInfo(orgProName + ".name"));
        selector.add(new SelectorItemInfo(orgProName + ".number"));
        selector.add(new SelectorItemInfo(orgProName + ".longnumber"));
        selector.add(new SelectorItemInfo(orgProName + ".isAdminOrgUnit"));
        IObjectValue objVal = null;
        try {
            objVal = dynamicObject.getValue(bosType, (IObjectPK)pk, selector);
        }
        catch (BOSException e) {
            throw new WfException(e.getMessage(), (Throwable)e);
        }
        if (objVal == null) {
            throw new WfException("\u5355\u636e(" + billId + ")\u4e0d\u5b58\u5728.");
        }
        OrgUnitInfo orgInfo = (OrgUnitInfo)WfRoleUtils.getBillPropInfo(objVal, orgProName);
        return orgInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrgUnitInfo[] findAdminOrgInfos(Context ctx, OrgUnitInfo orgInfo, OrgType orgType) throws WfException {
        block33: {
            AdminOrgUnitInfo adminInfo0 = WfRoleUtils.convert2AdminOrgInfo(ctx, orgInfo.getId().toString());
            try {
                if (adminInfo0 == null) {
                    if (NOT_SUPPORT_ORGPROP != null) {
                        throw new WfException(NOT_SUPPORT_ORGPROP);
                    }
                    break block33;
                }
                if (adminInfo0.isIsSealUp()) {
                    throw new WfException("\u7ec4\u7ec7{\u7f16\u7801\uff1a" + adminInfo0.getNumber() + "}\u5df2\u5c01\u5b58\uff0c\u8bf7\u4e3a\u5f53\u524d\u89d2\u8272\u6570\u636e\u91cd\u65b0\u4fee\u6539\u7ec4\u7ec7");
                }
                OrgUnitInfo[] orgUnitInfoArray = new OrgUnitInfo[]{adminInfo0};
                return orgUnitInfoArray;
            }
            finally {
                NOT_SUPPORT_ORGPROP = null;
            }
        }
        if (orgType.getValue() == 0) {
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)orgInfo;
            if (adminInfo.getLongNumber() == null || adminInfo.getNumber() == null) {
                return new OrgUnitInfo[]{WfRoleUtils.convert2AdminOrgInfo(ctx, orgInfo.getId().toString())};
            }
            return new OrgUnitInfo[]{adminInfo};
        }
        OrgUnitCollection fromCol = null;
        if (orgType.getValue() != 1 && orgType.getValue() != 5) {
            try {
                fromCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(orgInfo.getId().toString(), orgType.getValue(), 0);
            }
            catch (EASBizException e) {
                throw new WfException(e.getMessage());
            }
            catch (BOSException e) {
                throw new WfException(e.getMessage());
            }
        }
        if (orgInfo.get("isAdminOrgUnit") == null) {
            orgInfo = WfRoleUtils.newOrgInfo(ctx, orgInfo);
        }
        if (orgInfo.isIsAdminOrgUnit()) {
            return new OrgUnitInfo[]{WfRoleUtils.convert2AdminOrgInfo(ctx, orgInfo.getId().toString())};
        }
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("longnumber"));
            fromCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getFromUnit(orgInfo.getId().toString(), orgType.getValue(), 0, selector);
        }
        catch (EASBizException e) {
            throw new WfException(e.getMessage());
        }
        catch (BOSException e) {
            throw new WfException(e.getMessage(), (Throwable)e);
        }
        if (fromCol.size() > 0) {
            int size = fromCol.size();
            OrgUnitInfo[] adminInfos = new OrgUnitInfo[size];
            for (int i = 0; i < size; ++i) {
                adminInfos[i] = fromCol.get(i);
            }
            return adminInfos;
        }
        String longNumStrParam = WfRoleUtils.longNum2ParamStr(orgInfo.getLongNumber().toString());
        String tableName = "t_org_admin";
        switch (orgType.getValue()) {
            case 1: {
                tableName = "T_ORG_COMPANY";
                break;
            }
            case 5: {
                tableName = "t_org_costcenter";
                break;
            }
            case 3: {
                tableName = "t_org_purchase";
                break;
            }
            case 2: {
                tableName = "t_org_sale";
                break;
            }
            case 4: {
                tableName = "t_org_storage";
                break;
            }
            case 6: {
                tableName = "t_org_profitcenter";
                break;
            }
            case 16: {
                tableName = "t_org_hro";
                break;
            }
            case 24: {
                tableName = "t_org_transport";
                break;
            }
            case 32: {
                tableName = "t_org_quality";
                break;
            }
            case 8: {
                tableName = "t_org_uniongroup";
                break;
            }
            case 10: {
                tableName = "t_org_ctrlunit";
                break;
            }
            default: {
                tableName = "t_org_admin";
            }
        }
        String sqlStr = "select top 1 fid,fnumber,flongnumber from " + tableName + " where FISADMINORGUNIT =1 and flongnumber in (" + longNumStrParam + ") order by flevel desc";
        List<?> list = WfRoleUtils.exectueQuery(ctx, sqlStr, null, null);
        if (list.size() > 0) {
            Map item = (Map)list.get(0);
            return new OrgUnitInfo[]{WfRoleUtils.convert2AdminOrgInfo(ctx, (String)item.get("fid"))};
        }
        throw new WfException("\u6ca1\u6709\u627e\u5355\u636e\u7ec4\u7ec7" + orgInfo.getName() + "\u5bf9\u5e94\u7684\u884c\u653f\u7ec4\u7ec7.");
    }

    public static AdminOrgUnitInfo convert2AdminOrgInfo(Context ctx, String id) throws WfException {
        String sqlStr = "select fid,fnumber,flongnumber,fissealup from  t_org_admin where fid = ?";
        List<?> list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{id});
        AdminOrgUnitInfo adminInfo = null;
        if (list.size() > 0) {
            adminInfo = new AdminOrgUnitInfo();
            Map item = (Map)list.get(0);
            adminInfo.setId(BOSUuid.read((String)((String)item.get("fid"))));
            adminInfo.setNumber((String)item.get("fnumber"));
            adminInfo.setLongNumber((String)item.get("flongnumber"));
            adminInfo.setIsSealUp(item.get("fissealup").toString().equals("1"));
        }
        return adminInfo;
    }

    public static String joinLongNumString(OrgUnitInfo[] orgInfos) {
        StringBuffer longNumStrParam = new StringBuffer();
        for (OrgUnitInfo orgInfo : orgInfos) {
            longNumStrParam.append(WfRoleUtils.longNum2ParamStr(orgInfo.getLongNumber().toString())).append(",");
        }
        longNumStrParam.setLength(longNumStrParam.length() - 1);
        return longNumStrParam.toString();
    }

    public static String joinIdString(OrgUnitInfo[] orgInfos) {
        StringBuffer sb = new StringBuffer();
        for (OrgUnitInfo orgInfo : orgInfos) {
            sb.append("'").append(orgInfo.getId().toString()).append("',");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String longNum2ParamStr(String longNum) {
        String longNumStrParam = "";
        if (longNum.indexOf("!") == -1) {
            longNumStrParam = "'" + longNum + "'";
            return longNumStrParam;
        }
        String[] longNumArray = longNum.split("!");
        String longNumStr = "";
        int size = longNumArray.length - 1;
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                longNumStrParam = longNumStrParam + "'" + longNumArray[i] + "'";
                longNumStr = longNumArray[i];
                continue;
            }
            longNumStr = longNumStr + "!" + longNumArray[i] + "";
            longNumStrParam = longNumStrParam + ",'" + longNumStr + "'";
        }
        if (longNumStrParam.length() == 0) {
            longNumStrParam = "'null'";
        }
        return longNumStrParam;
    }

    public static List<?> exectueQuery(Context ctx, String sqlStr, int[] types, String[] params) throws WfException {
        try {
            if (types == null) {
                return SQL.executeQuery((Context)ctx, (String)sqlStr);
            }
            return SQL.executeQuery((Context)ctx, (String)sqlStr, (int[])types, (Object[])params);
        }
        catch (BOSException e) {
            throw new WfException(e.getMessage(), (Throwable)e);
        }
    }

    public static OrgType getOrgType(Context ctx, String billId, String orgProName) throws WfException {
        if (orgProName == null || orgProName.length() <= 0) {
            throw new WfException("\u5355\u636e(" + billId + ")\u7ec4\u7ec7\u5c5e\u6027\u53c2\u6570orgProName\u4e3anull");
        }
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)billId, (boolean)true);
        return WfRoleUtils.getOrgType(ctx, bosType, orgProName);
    }

    public static OrgType getOrgType(Context ctx, BOSObjectType bosType, String orgProName) throws WfException {
        OrgType orgType = null;
        LinkPropertyInfo lp = WfRoleUtils.getLp(ctx, bosType, orgProName);
        String orgEntityName = lp.getRelationship().getSupplierObject().getFullName();
        orgType = WfRoleUtils.toMatchOrgType(orgEntityName);
        if (orgType == null) {
            NOT_SUPPORT_ORGPROP = "\u5355\u636e(" + bosType + ")\u4e2d\u7684\u7ec4\u7ec7\u5c5e\u6027(" + orgProName + ")\u6240\u5bf9\u5e94\u7684\u7ec4\u7ec7\u7c7b\u578b(" + orgEntityName + ")\u4e0d\u652f\u6301.";
        }
        return orgType;
    }

    protected static OrgType getOrgType(Context ctx, IObjectValue billInfo, String orgProName) throws WfException {
        OrgType orgType = null;
        LinkPropertyInfo lp = WfRoleUtils.getLp(ctx, billInfo.getBOSType(), orgProName);
        String orgEntityName = lp.getRelationship().getSupplierObject().getFullName();
        orgType = WfRoleUtils.toMatchOrgType(orgEntityName);
        if (orgType == null) {
            NOT_SUPPORT_ORGPROP = "\u5355\u636e(" + billInfo.getBOSType() + ")\u4e2d\u7684\u7ec4\u7ec7\u5c5e\u6027(" + orgProName + ")\u6240\u5bf9\u5e94\u7684\u7ec4\u7ec7\u7c7b\u578b(" + orgEntityName + ")\u4e0d\u652f\u6301.";
        }
        return orgType;
    }

    protected static LinkPropertyInfo getLp(Context ctx, BOSObjectType bosType, String PropName) throws WfException {
        String _PropName = "";
        LinkPropertyInfo lp = null;
        EntityObjectInfo entityInfo = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)bosType);
        if (PropName.contains(".")) {
            String entry = PropName.split("\\.")[0];
            _PropName = PropName.split("\\.")[1];
            lp = (LinkPropertyInfo)((LinkPropertyInfo)entityInfo.getPropertyByName(entry)).getRelationship().getSupplierObject().getPropertyByName(_PropName);
        } else {
            lp = (LinkPropertyInfo)entityInfo.getPropertyByNameRuntime(PropName);
        }
        if (lp == null) {
            throw new WfException("\u5355\u636e(" + bosType + ")\u5c5e\u6027(" + PropName + ")\u4e0d\u652f\u6301.");
        }
        return lp;
    }

    protected static Object getBillPropInfo(IObjectValue objVal, String PropName) throws WfException {
        if (PropName.contains(".")) {
            String entry = PropName.split("\\.")[0];
            String prop = PropName.split("\\.")[1];
            if (objVal.get(entry) == null) {
                throw new WfException("\u5355\u636e\u5206\u5f55\u4e3a\u7a7a.");
            }
            if (((IObjectCollection)objVal.get(entry)).getObject(0) == null) {
                throw new WfException("\u5355\u636e\u5206\u5f55\u503c\u4e3a\u7a7a.");
            }
            return ((IObjectCollection)objVal.get(entry)).getObject(0).get(prop);
        }
        return objVal.get(PropName);
    }

    protected static List<?> getBillPropInfo(Context ctx, IObjectValue objVal, String PropName) throws WfException {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (PropName.contains(".")) {
            String entry = PropName.split("\\.")[0];
            String prop = PropName.split("\\.")[1];
            if (objVal.get(entry) == null) {
                throw new WfException("\u5355\u636e\u5206\u5f55\u4e3a\u7a7a.");
            }
            List<IObjectValue> list = WfRoleUtils.getAllEntry(ctx, objVal, entry);
            for (IObjectValue v : list) {
                if (v.get(prop) == null) continue;
                ret.add(v.get(prop));
            }
        } else if (objVal.get(PropName) != null) {
            ret.add(objVal.get(PropName));
        }
        return ret;
    }

    private static OrgType toMatchOrgType(String orgEntityName) {
        OrgType orgType = null;
        if (orgEntityName.equalsIgnoreCase("com.kingdee.eas.basedata.org.app.CompanyOrgUnit")) {
            orgType = OrgType.Company;
        } else if (orgEntityName.equalsIgnoreCase("com.kingdee.eas.basedata.org.app.CostCenterOrgUnit")) {
            orgType = OrgType.CostCenter;
        } else if (orgEntityName.equalsIgnoreCase("com.kingdee.eas.basedata.org.app.ProfitCenterOrgUnit")) {
            orgType = OrgType.ProfitCenter;
        } else if (orgEntityName.equalsIgnoreCase("com.kingdee.eas.basedata.org.app.PurchaseOrgUnit")) {
            orgType = OrgType.Purchase;
        } else if (orgEntityName.equalsIgnoreCase("com.kingdee.eas.basedata.org.app.SaleOrgUnit")) {
            orgType = OrgType.Sale;
        } else if (orgEntityName.equalsIgnoreCase("com.kingdee.eas.basedata.org.app.StorageOrgUnit")) {
            orgType = OrgType.Storage;
        } else if (orgEntityName.equalsIgnoreCase("com.kingdee.eas.basedata.org.app.AdminOrgUnit") || orgEntityName.equalsIgnoreCase("com.kingdee.eas.basedata.org.app.FullOrgUnit")) {
            orgType = OrgType.Admin;
        } else if (orgEntityName.equalsIgnoreCase("com.kingdee.eas.basedata.org.app.HROrgUnit")) {
            orgType = OrgType.HRO;
        } else if (orgEntityName.equalsIgnoreCase("com.kingdee.eas.basedata.org.app.TransportOrgUnit")) {
            orgType = OrgType.Transport;
        } else if (orgEntityName.equalsIgnoreCase("com.kingdee.eas.basedata.org.app.UnionGroupOrgUnit")) {
            orgType = OrgType.UnionDebt;
        } else if (orgEntityName.equalsIgnoreCase("com.kingdee.eas.basedata.org.app.CtrlUnit")) {
            orgType = OrgType.ControlUnit;
        } else if (orgEntityName.equalsIgnoreCase("com.kingdee.eas.basedata.org.app.QualityOrgUnit")) {
            orgType = OrgType.Quality;
        }
        return orgType;
    }

    private static OrgUnitInfo newOrgInfo(Context ctx, OrgUnitInfo littleOrgInfo) throws WfException {
        String fid = littleOrgInfo.get("id").toString();
        String sqlStr = "select fid,fnumber,flongnumber,fisadminorgunit from T_ORG_BaseUnit where fid =?";
        List<?> list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{fid});
        OrgUnitInfo OrgInfo = null;
        if (list.size() > 0) {
            OrgInfo = new OrgUnitInfo();
            Map item = (Map)list.get(0);
            OrgInfo.setId(BOSUuid.read((String)((String)item.get("fid"))));
            OrgInfo.setNumber((String)item.get("fnumber"));
            OrgInfo.setLongNumber((String)item.get("flongnumber"));
            if ("1".equals(item.get("fisadminorgunit").toString())) {
                OrgInfo.setIsAdminOrgUnit(true);
            } else {
                OrgInfo.setIsAdminOrgUnit(false);
            }
        } else {
            return littleOrgInfo;
        }
        return OrgInfo;
    }

    private static List<IObjectValue> getAllEntry(Context ctx, IObjectValue objVal, String entryName) throws WfException {
        ArrayList<IObjectValue> list = new ArrayList<IObjectValue>();
        int N = WfRoleUtils.entryNum(objVal, entryName);
        if (N < 0) {
            logger.error((Object)"shocked!entry's num<0!!!");
        }
        for (int i = 0; i < N; ++i) {
            list.add(WfRoleUtils.entryObj(objVal, entryName, i));
        }
        return list;
    }

    private static IObjectValue entryObj(IObjectValue objVal, String entryName, int i) {
        return ((IObjectCollection)objVal.get(entryName)).getObject(i);
    }

    private static int entryNum(IObjectValue objVal, String entryName) {
        try {
            return ((IObjectCollection)objVal.get(entryName)).size();
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u5206\u5f55\u4e2a\u6570\u51fa\u9519,\u5c06\u8fd4\u56de-1\r\n" + e));
            return -1;
        }
    }

    protected static void appendList(List a, List b) {
        if (a == null || b == null || b.size() == 0) {
            return;
        }
        for (Object o : b) {
            a.add(o);
        }
    }

    private static List<OrgUnitInfo> distinctOrg(List<OrgUnitInfo> orgList) {
        HashSet<String> idset = new HashSet<String>();
        ArrayList<OrgUnitInfo> orgs = new ArrayList<OrgUnitInfo>();
        for (OrgUnitInfo org : orgList) {
            if (!idset.add(org.getId().toString())) continue;
            orgs.add(org);
        }
        return orgs;
    }
}

