/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.LoginUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WebBillManpowerActivityDef;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class StartProcesProgressUtil {
    public static final String CAN_NOT_START_PROCESS = "::CAN_NOT_START_PROCESS";
    public static final String NO_PROCESS_TO_START = "::NO_PROCESS_TO_START";
    public static final String NO_START_ACTIVITY = "::NO_START_ACTIVITY";
    public static final String TOO_MANY_START_ACTIVITIES = "::TOO_MANY_START_ACTIVITIES";
    public static final String IS_NOT_MANPOWER_ACTIVITY = "::IS_NOT_MANPOWER_ACTIVITY";

    public static String getURLFromProcessDef(String procDefId, Context ctx) throws BOSException, EASBizException {
        String tmp;
        String userId;
        IEnactmentService service;
        IEnactmentService iEnactmentService = service = ctx == null ? EnactmentServiceFactory.createRemoteEnactService() : EnactmentServiceFactory.createEnactService((Context)ctx);
        if (ctx == null) {
            ctx = service.getContext();
        }
        if (!service.canStartProcess(userId = ctx.getCaller().toString(), procDefId)) {
            return CAN_NOT_START_PROCESS;
        }
        ProcessDefInfo procDefInfo = service.getProcessDefInfo(procDefId);
        if (procDefInfo == null) {
            return NO_PROCESS_TO_START;
        }
        ActivityDef actDef = null;
        ProcessDef procDef = service.getProcessDefByDefineHashValue(procDefInfo.getMd5HashValue());
        ActivityCollection actDefCol = procDef.getStartupActivities();
        if (actDefCol.size() == 0) {
            return NO_START_ACTIVITY;
        }
        if (actDefCol.size() > 1) {
            return TOO_MANY_START_ACTIVITIES;
        }
        actDef = actDefCol.get(0);
        if (actDef instanceof WebBillManpowerActivityDef) {
            String tmp2 = ((WebBillManpowerActivityDef)actDef).getUrl();
            if (tmp2.length() == 0) {
                tmp2 = null;
            } else {
                if (!(tmp2 = tmp2.trim()).startsWith("/")) {
                    tmp2 = "/" + tmp2;
                }
                if (tmp2.startsWith("/servlet/BillServlet")) {
                    tmp2 = "/easweb" + tmp2;
                }
            }
            return tmp2;
        }
        if (!(actDef instanceof ManpowerActivityDef)) {
            return IS_NOT_MANPOWER_ACTIVITY;
        }
        String actId = actDef.getID();
        String uiStartClassName = service.getStartupActivityUIClass(procDefId, actId);
        MetaDataPK metaPK = new MetaDataPK(uiStartClassName);
        UIObjectCtrl ctrl = new UIObjectCtrl(service.getContext());
        Object url = ctrl.getValue((IMetaDataPK)metaPK).getExtendedProperties().get("url");
        String string = tmp = url == null ? "" : url.toString();
        if (tmp.length() == 0) {
            tmp = null;
        }
        return tmp;
    }

    public static ArrayList findAssignmentsByProcInstId(String procInstId, Context ctx) throws BOSException, EASBizException {
        IEnactmentService service;
        IEnactmentService iEnactmentService = service = ctx == null ? EnactmentServiceFactory.createRemoteEnactService() : EnactmentServiceFactory.createEnactService((Context)ctx);
        if (ctx == null) {
            ctx = service.getContext();
        }
        String userId = ctx.getCaller().toString();
        AssignmentInfo[] assignments = service.getAssignmentAllByProcInstId(procInstId);
        ArrayList list = new ArrayList();
        Locale locale = service.getContext().getLocale();
        for (int i = 0; i < assignments.length; ++i) {
            HashMap<String, String> item = new HashMap<String, String>();
            AssignmentInfo as = assignments[i];
            WfAssignmentState state = as.getState();
            if (!WfAssignmentState.ACCEPTED.equals((Object)state) && !WfAssignmentState.ASSIGNED.equals((Object)state) || !as.getUserId().equals(userId)) continue;
            item.put("assignId", as.getAssignmentId());
            item.put("actDefName", as.getActDefName(locale));
            item.put("procDefName", as.getProcDefName(locale));
            item.put("actInstId", as.getActInstId());
            list.add(item);
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        LoginUtils.login((String)"tcp://127.0.0.1:11034", (String)"007", (String)"", (String)"eas", (String)"nc02", (Locale)new Locale("L2"));
    }
}

