/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor;

import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.diagram.Coordinate;
import com.kingdee.bos.workflow.define.diagram.Line;
import com.kingdee.bos.workflow.define.diagram.LineCollection;
import com.kingdee.bos.workflow.define.diagram.Node;
import com.kingdee.bos.workflow.define.diagram.NodeCollection;
import com.kingdee.bos.workflow.define.diagram.Note;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.struct.IProcessImage;
import com.kingdee.bos.workflow.service.ormrpc.struct.WfProcessImageUtil;
import com.kingdee.util.StringUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class WfProcessImage {
    public static final int FONT_SIZE = 12;
    public static final double ARROW_ANGLE = 0.5235987755982988;
    public static final int ARROW_SIZE = 6;
    public static final double AXIS_Y = 1.5707963267948966;
    public static final Font FONT = WfProcessImage.getFont();
    private HashMap activities;
    BufferedImage image;
    private Graphics2D g;
    private FontMetrics metrics;
    private HashSet passedTransitions;
    private HashMap activityPairs;
    private ArrayList wires;
    private ProcessDef processDef;
    private Locale locale;
    private Color bgColor;
    private ActivityInstInfo[] actInstInfos;
    private ProcessInstInfo procInstInfo;
    private String[] passedTransition;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int offsetX;
    private int offsetY;
    private int width;
    private int height;

    public WfProcessImage(Locale locale, IEnactmentService service, String procInstId, Color bgColor) throws WfException {
        this.locale = locale;
        this.bgColor = bgColor;
        this.actInstInfos = service.getActInstMetaArrayByProcInstId(procInstId);
        this.sortActs();
        this.procInstInfo = service.getProcessInstInfo(procInstId);
        this.processDef = service.getProcessDefByDefineHashValue(this.procInstInfo.getProcDefHashValue());
        this.init0();
    }

    private void sortActs() {
        ArrayList<Object> actInstInfoList = new ArrayList<Object>();
        ArrayList<ActivityInstInfo> actInstInfoNotInitList = new ArrayList<ActivityInstInfo>();
        boolean hasNotInit = false;
        for (int i = 0; i < this.actInstInfos.length; ++i) {
            if (!this.actInstInfos[i].getInited()) {
                hasNotInit = true;
                actInstInfoNotInitList.add(this.actInstInfos[i]);
                continue;
            }
            actInstInfoList.add(this.actInstInfos[i]);
        }
        if (hasNotInit) {
            actInstInfoList.addAll(actInstInfoNotInitList);
            this.actInstInfos = actInstInfoList.toArray(new ActivityInstInfo[0]);
        }
    }

    public WfProcessImage(Locale locale, Color bgColor, ProcessDef processDef, ActivityInstInfo[] actInstInfos, ProcessInstInfo procInstInfo) throws WfException {
        this.actInstInfos = actInstInfos;
        this.procInstInfo = procInstInfo;
        this.processDef = processDef;
        this.locale = locale;
        this.bgColor = bgColor;
        this.init0();
    }

    private void init0() throws WfException {
        int i;
        this.activities = new HashMap();
        for (i = 0; i < this.actInstInfos.length; ++i) {
            String actDefId = this.actInstInfos[i].getActDefId();
            if (this.processDef.getActivityDef(actDefId) == null) continue;
            IProcessImage.Activity act = (IProcessImage.Activity)this.activities.get(actDefId);
            if (act == null) {
                act = new IProcessImage.Activity();
                this.activities.put(actDefId, act);
            }
            ++act.count;
            Timestamp createTime = this.actInstInfos[i].getCreatedTime();
            if (createTime.after(act.createTime) || this.actInstInfos[i].getState().startsWith("open")) {
                act.createTime = createTime;
                if (act.state == null || !act.state.startsWith("open")) {
                    act.state = this.actInstInfos[i].getState();
                    if (!this.actInstInfos[i].getInited() && act.state != "closed.completed" && !"open.not_running.blocked".equals(act.state)) {
                        act.state = null;
                    }
                    if (!this.actInstInfos[i].getInited() && "closed.completed".equals(act.state)) {
                        act.inited = this.actInstInfos[i].getInited();
                    }
                }
            }
            if (this.actInstInfos[i].getParentActInstId() == null) continue;
            act.hasAppended = true;
        }
        this.passedTransition = this.getPassedTransDefArray();
        this.passedTransitions = new HashSet(this.passedTransition.length);
        for (i = 0; i < this.passedTransition.length; ++i) {
            this.passedTransitions.add(this.passedTransition[i]);
        }
        this.init();
    }

    public ProcessInstInfo getProcInstInfo() {
        return this.procInstInfo;
    }

    public WfProcessImage(Locale locale, ProcessDef processDef, Color bgColor) throws WfException {
        this.locale = locale;
        this.bgColor = bgColor;
        this.processDef = processDef;
        this.passedTransitions = new HashSet();
        this.activities = new HashMap();
        this.init();
    }

    private int calcTrimPos(String s) {
        if (s == null) {
            return -1;
        }
        if (s.length() <= 6) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((count += c <= '\u0100' ? 1 : 2) <= 12) continue;
            return i;
        }
        return -1;
    }

    private void init() throws WfException {
        ActivityCollection actCol = this.processDef.getActivitys();
        for (int i = 0; i < actCol.size(); ++i) {
            String refId;
            ActivityDef actDef = actCol.get(i);
            String actDefId = actDef.getID();
            IProcessImage.Activity act = (IProcessImage.Activity)this.activities.get(actDefId);
            if (act == null) {
                act = new IProcessImage.Activity();
                this.activities.put(actDefId, act);
            }
            act.actDefId = actDefId;
            act.procDefId = actDef.getContainer().getID();
            act.name = actDef.getName(this.locale);
            act.type = actDef.getType().toString();
            act.actDef = actDef;
            act.actDigest = actDef.getActDigest(this.locale);
            act.isAppended = actDef.isAppended();
            act.isManpower = actDef instanceof ManpowerActivityDef;
            act.bound = new Rectangle();
            Coordinate cor = actDef.getRelatedNode().getCoordinate();
            act.bound.x = cor.x;
            act.bound.y = cor.y;
            if (!(actDef instanceof EventActivityDef) || StringUtils.isEmpty((String)(refId = ((EventActivityDef)actDef).getRefActivityId()))) continue;
            actDef = this.processDef.getActivityDef(refId);
            cor = actDef.getRelatedNode().getCoordinate();
            act.bound.x += cor.x;
            act.bound.y += cor.y;
        }
        NodeCollection nodes = this.processDef.getDiagram().getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            Coordinate cor = nodes.get(i).getCoordinate();
            if (cor.x < this.minX) {
                this.minX = cor.x;
            } else if (cor.x + cor.width > this.maxX) {
                this.maxX = cor.x + cor.width;
            }
            if (cor.y < this.minY) {
                this.minY = cor.y;
                continue;
            }
            if (cor.y + cor.heigth <= this.maxY) continue;
            this.maxY = cor.y + cor.heigth;
        }
        WfProcessImageUtil.rename(this.activities.values());
        this.image = new BufferedImage(1, 1, 1);
        this.g = (Graphics2D)this.image.getGraphics();
        if (FONT != null) {
            this.g.setFont(FONT);
        }
        this.metrics = this.g.getFontMetrics();
        Iterator it = this.activities.keySet().iterator();
        while (it.hasNext()) {
            IProcessImage.Activity act = (IProcessImage.Activity)this.activities.get(it.next());
            act.bound.height = 56;
            act.bound.width = this.metrics.stringWidth(act.name) + 10;
            if (act.bound.width <= 59) {
                act.bound.width = 54;
            } else if (act.bound.width > 82) {
                act.bound.width = 80;
                act.bound.height = 72;
                act.bound.y -= 3;
            } else if (act.bound.width >= 80) {
                act.bound.width = 80;
            }
            int tmp = act.bound.x + act.bound.width;
            if (tmp > this.maxX) {
                this.maxX = tmp;
            }
            if ((tmp = act.bound.y + act.bound.height) <= this.maxY) continue;
            this.maxY = tmp;
        }
        this.calcLines();
        this.width = this.maxX - this.minX + 300;
        this.height = this.maxY - this.minY + 100;
        this.offsetX = 100 - this.minX;
        this.offsetY = 30 - this.minY;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    private void calcLines() throws WfException {
        this.activityPairs = new HashMap();
        this.wires = new ArrayList();
        LineCollection lines = this.processDef.getDiagram().getLines();
        for (int i = 0; i < lines.size(); ++i) {
            Line line = lines.get(i);
            TransitionDef tran = line.getRefTransition();
            String desc = tran.getDescription(this.locale);
            boolean isPass = this.passedTransitions.contains(tran.getID());
            String path = line.getPath();
            IProcessImage.Activity from = (IProcessImage.Activity)this.activities.get(tran.getFrom().getID());
            IProcessImage.Activity to = (IProcessImage.Activity)this.activities.get(tran.getTo().getID());
            this.generateWires(from, to, path, isPass, desc);
        }
    }

    public void paintLines() {
        IProcessImage.Wire w;
        int i;
        for (i = 0; i < this.wires.size(); ++i) {
            w = (IProcessImage.Wire)this.wires.get(i);
            if (w.isPass) {
                this.g.setColor(new Color(1, 59, 207));
                this.g.setStroke(new BasicStroke(2.0f));
            } else {
                this.g.setColor(new Color(0, 0, 0));
                this.g.setStroke(new BasicStroke(1.0f));
            }
            this.g.drawLine(w.x1 + this.offsetX, w.y1 + this.offsetY, w.x2 + this.offsetX, w.y2 + this.offsetY);
            if (!w.hasArrow) continue;
            WfProcessImage.drawArrow(this.g, w.x1 + this.offsetX, w.y1 + this.offsetY, w.x2 + this.offsetX, w.y2 + this.offsetY);
        }
        this.g.setColor(new Color(0, 0, 0));
        this.g.setStroke(new BasicStroke(1.0f));
        for (i = 0; i < this.wires.size(); ++i) {
            w = (IProcessImage.Wire)this.wires.get(i);
            if (w.label == null || w.label.length() == 0) continue;
            int x1 = w.x1 + this.offsetX;
            int y1 = w.y1 + this.offsetY;
            int x2 = w.x2 + this.offsetX;
            int y2 = w.y2 + this.offsetY;
            FontMetrics metrics = this.g.getFontMetrics();
            int height = 12;
            int width = metrics.stringWidth(w.label);
            int x = (x1 + x2) / 2 - width / 2;
            int y = (y1 + y2) / 2 - height / 2;
            this.drawString(w.label, x, y, width, height);
        }
    }

    private void drawString(String s, int x, int y, int width, int height) {
        this.g.setColor(this.bgColor);
        this.g.fillRect(x, y, width, height);
        this.g.setColor(new Color(0, 0, 0));
        int top = y + 12 - 1;
        if (StringUtils.isEmpty((String)s)) {
            this.g.drawRect(x, y, width, height);
            return;
        }
        String[] str = s.split("\n");
        if (str.length == 1) {
            this.g.drawRect(x, y, width, height);
            this.g.drawString(s, x + 1, top);
        } else {
            int size = str.length;
            for (int i = 0; i < size; ++i) {
                this.g.drawString(str[i], x + 1, top);
                top += this.g.getFontMetrics().getHeight();
            }
            this.g.drawRect(x, y, width, top - y);
        }
    }

    public void paintNotes() {
        NodeCollection nodes = this.processDef.getDiagram().getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            int height;
            Coordinate c;
            Note note;
            String content;
            Node node = nodes.get(i);
            if (!(node instanceof Note) || (content = (note = (Note)node).getContent(this.locale)) == null || (c = node.getCoordinate()) == null) continue;
            int x = c.x + this.offsetX;
            int y = c.y + this.offsetY;
            int width = this.metrics.stringWidth(content);
            if (width < c.width) {
                width = c.width;
            }
            if ((height = c.heigth) < 12) {
                height = 12;
            }
            this.drawString(content, x, y, width, height);
        }
    }

    public void setDefaultGraphics() {
        this.image = new BufferedImage(this.width, this.height, 1);
        this.g = (Graphics2D)this.image.getGraphics();
        if (FONT != null) {
            this.g.setFont(FONT);
        }
        this.metrics = this.g.getFontMetrics();
        this.g.setColor(this.bgColor);
        this.g.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
    }

    public void setGraphics(Graphics2D g) {
        if (FONT != null) {
            g.setFont(FONT);
        }
        this.metrics = g.getFontMetrics();
        this.g = g;
    }

    public void paintActivities() {
        this.g.setStroke(new BasicStroke(1.0f));
        Iterator it = this.activities.keySet().iterator();
        while (it.hasNext()) {
            IProcessImage.Activity act = (IProcessImage.Activity)this.activities.get(it.next());
            this.g.setColor(this.bgColor);
            int x = this.offsetX + act.bound.x;
            int y = this.offsetY + act.bound.y;
            this.g.fillRect(x, y, act.bound.width, act.bound.height);
            this.g.setColor(new Color(0, 0, 0));
            String label = act.name + (act.count > 0 ? "[" + act.count + "]" : "");
            int pos = this.calcTrimPos(label);
            if (pos < 0) {
                int width = this.metrics.stringWidth(label);
                this.g.drawString(label, x + (act.bound.width - width) / 2, y + 50);
            } else {
                String s1 = label.substring(0, pos);
                String s2 = label.substring(pos);
                if ((pos = this.calcTrimPos(s2)) >= 0) {
                    s2 = s2.substring(0, pos - 1) + "\u2026";
                }
                this.g.drawString(s1, x, y + 50);
                this.g.drawString(s2, x, y + 66);
            }
            this.g.drawRect(x, y, act.bound.width, act.bound.height);
        }
    }

    private static void drawArrow(Graphics g, int x1, int y1, int x2, int y2) {
        int x = x1 - x2;
        int y = y1 - y2;
        double angle = Math.atan2(y, x);
        double angle1 = angle + 0.5235987755982988;
        double angle2 = angle - 0.5235987755982988;
        int X1 = x2 + (int)Math.round(Math.cos(angle1) * 6.0);
        int Y1 = y2 + (int)Math.round(Math.sin(angle1) * 6.0);
        int X2 = x2 + (int)Math.round(Math.cos(angle2) * 6.0);
        int Y2 = y2 + (int)Math.round(Math.sin(angle2) * 6.0);
        int[] xa = new int[]{X1, X2, x2};
        int[] ya = new int[]{Y1, Y2, y2};
        Polygon p = new Polygon(xa, ya, 3);
        g.drawPolygon(p);
        g.fillPolygon(p);
    }

    private void generateWires(IProcessImage.Activity from, IProcessImage.Activity to, String path, boolean isPass, String desc) throws WfException {
        Point[] points = WfProcessImage.pathToPoints(path);
        if (points.length == 0) {
            this.generateDirectWire(from, to, isPass, desc);
        } else {
            for (int i = 0; i < points.length; ++i) {
                points[i] = WfProcessImage.relativePoint2Absolute(from, points[i]);
            }
            Point t = points[0];
            Point relativePos = WfProcessImage.absolutePoint2Relative(from, t);
            Point f = WfProcessImage.generateEndPoint(from, relativePos);
            IProcessImage.Wire w = this.generateWire(f.x, f.y, t.x, t.y, false, isPass, desc);
            this.wires.add(w);
            for (int i = 0; i < points.length - 1; ++i) {
                f = points[i];
                t = points[i + 1];
                w = this.generateWire(f.x, f.y, t.x, t.y, false, isPass, null);
                this.wires.add(w);
            }
            f = points[points.length - 1];
            relativePos = WfProcessImage.absolutePoint2Relative(to, f);
            t = WfProcessImage.generateEndPoint(to, relativePos);
            w = this.generateWire(f.x, f.y, t.x, t.y, true, isPass, null);
            this.wires.add(w);
        }
    }

    private static Point absolutePoint2Relative(IProcessImage.Activity act, Point absolutePos) {
        return new Point(absolutePos.x - act.bound.x - act.bound.width / 2, absolutePos.y - act.bound.y - act.bound.height / 2);
    }

    private static Point relativePoint2Absolute(IProcessImage.Activity act, Point relativePos) {
        return new Point(act.bound.x + act.bound.width / 2 + relativePos.x, act.bound.y + act.bound.height / 2 + relativePos.y);
    }

    private void generateDirectWire(IProcessImage.Activity from, IProcessImage.Activity to, boolean isPass, String desc) {
        String key = to.actDefId + ":" + from.actDefId;
        IProcessImage.Wire wire = (IProcessImage.Wire)this.activityPairs.get(key);
        if (wire != null) {
            int y = wire.y2 - wire.y1;
            int x = wire.x2 - wire.x1;
            double angle = Math.atan2(y, x);
            if (angle > 1.5707963267948966) {
                angle -= Math.PI;
            } else if (angle < -1.5707963267948966) {
                angle += Math.PI;
            }
            int offsetX = -((int)Math.round(Math.cos(angle += 1.5707963267948966) * 10.0));
            int offsetY = -((int)Math.round(Math.sin(angle) * 10.0));
            x = (wire.x2 + wire.x1) / 2 + offsetX;
            y = (wire.y2 + wire.y1) / 2 + offsetY;
            IProcessImage.Wire w = this.generateWire(wire.x2, wire.y2, x, y, false, isPass, desc);
            this.wires.add(w);
            w = this.generateWire(x, y, wire.x1, wire.y1, true, isPass, null);
            this.wires.add(w);
        } else {
            int x = to.bound.x + to.bound.width / 2 - from.bound.x - from.bound.width / 2;
            int y = to.bound.y + to.bound.height / 2 - from.bound.y - from.bound.height / 2;
            Point p = new Point(x, y);
            Point f = WfProcessImage.generateEndPoint(from, p);
            p = new Point(-x, -y);
            Point t = WfProcessImage.generateEndPoint(to, p);
            IProcessImage.Wire w = this.generateWire(f.x, f.y, t.x, t.y, true, isPass, desc);
            this.wires.add(w);
            key = from.actDefId + ":" + to.actDefId;
            this.activityPairs.put(key, w);
        }
    }

    private IProcessImage.Wire generateWire(int x1, int y1, int x2, int y2, boolean hasArrow, boolean isPass, String label) {
        IProcessImage.Wire w = new IProcessImage.Wire();
        w.x1 = x1;
        w.x2 = x2;
        w.y1 = y1;
        w.y2 = y2;
        w.hasArrow = hasArrow;
        w.isPass = isPass;
        w.label = label;
        if (x1 < this.minX) {
            this.minX = x1;
        }
        if (x1 > this.maxX) {
            this.maxX = x1;
        }
        if (x2 < this.minX) {
            this.minX = x2;
        }
        if (x2 > this.maxX) {
            this.maxX = x2;
        }
        if (y1 < this.minY) {
            this.minY = y1;
        }
        if (y1 > this.maxY) {
            this.maxY = y1;
        }
        if (y2 < this.minY) {
            this.minY = y2;
        }
        if (y2 > this.maxY) {
            this.maxY = y2;
        }
        return w;
    }

    private static Point generateEndPoint(IProcessImage.Activity activity, Point relativePos) {
        int y;
        int x;
        int Y;
        int halfWidth = activity.bound.width / 2;
        int halfHeight = activity.bound.height / 2;
        int X = Math.abs(relativePos.x);
        if (X >= (Y = Math.abs(relativePos.y))) {
            x = relativePos.x >= 0 ? halfWidth : -halfWidth;
            y = Y + 1 > halfHeight ? 0 : relativePos.y;
        } else {
            x = X > halfWidth ? 0 : relativePos.x;
            y = relativePos.y >= 0 ? halfHeight : -halfHeight;
        }
        return new Point(activity.bound.x + halfWidth + x, activity.bound.y + halfHeight + y);
    }

    private static Point[] pathToPoints(String path) {
        if (path == null || path.length() == 0) {
            return new Point[0];
        }
        String[] array = path.split(";");
        Point[] points = new Point[array.length];
        for (int i = 0; i < points.length; ++i) {
            String[] temp = array[i].split(",|\\|");
            points[i] = new Point(Integer.parseInt(temp[0]), Integer.parseInt(temp[1]));
        }
        return points;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Graphics2D getGraphic() {
        return this.g;
    }

    public HashMap getActivities() {
        return this.activities;
    }

    public IProcessImage.Activity[] getActivities2() {
        return this.activities.values().toArray(new IProcessImage.Activity[0]);
    }

    public ActivityInstInfo[] getActivityInstInfos() {
        return this.actInstInfos;
    }

    public static void main(String[] args) throws Exception {
    }

    private static Font getFont() {
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = 0; i < fonts.length; ++i) {
            if (!"\u5b8b\u4f53".equals(fonts[i].getFontName())) continue;
            return fonts[i].deriveFont(12.0f);
        }
        String tmp = System.getProperty("java.security.auth.login.config");
        if (tmp == null) {
            return WfProcessImage.getDefaultFont();
        }
        int i = tmp.lastIndexOf("/");
        if (i < 0) {
            return WfProcessImage.getDefaultFont();
        }
        String path = tmp.substring(0, i) + "/simsun.ttc";
        File file = new File(path);
        if (!file.exists()) {
            return WfProcessImage.getDefaultFont();
        }
        try {
            Font font = Font.createFont(0, file);
            return font.deriveFont(12.0f);
        }
        catch (Exception e) {
            return WfProcessImage.getDefaultFont();
        }
    }

    private static Font getDefaultFont() {
        try {
            return new Font("\u5b8b\u4f53", 0, 12);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getPassedTransDefArray() throws WfException {
        String pair;
        ArrayList<String> transDefIdList = new ArrayList<String>();
        ArrayList<String> fromInstIds = new ArrayList<String>();
        ArrayList<String> toInstIds = new ArrayList<String>();
        HashMap<String, String> actInstMap = new HashMap<String, String>();
        for (int i = 0; i < this.actInstInfos.length; ++i) {
            int j;
            String[] to;
            int j2;
            ActivityInstInfo info = this.actInstInfos[i];
            String current = info.getActInstId();
            actInstMap.put(current, info.getActDefId());
            String[] from = info.getPreActInstList();
            if (from != null) {
                for (j2 = 0; j2 < from.length; ++j2) {
                    fromInstIds.add(from[j2]);
                    toInstIds.add(current);
                }
            }
            if ((from = info.getFromActInstList()) != null) {
                for (j2 = 0; j2 < from.length; ++j2) {
                    fromInstIds.add(from[j2]);
                    toInstIds.add(current);
                }
            }
            if ((to = info.getPostActInstList()) != null) {
                for (j = 0; j < to.length; ++j) {
                    fromInstIds.add(current);
                    toInstIds.add(to[j]);
                }
            }
            if ((to = info.getToActInstList()) == null) continue;
            for (j = 0; j < to.length; ++j) {
                fromInstIds.add(current);
                toInstIds.add(to[j]);
            }
        }
        HashSet<String> passedPairs = new HashSet<String>();
        for (int i = 0; i < fromInstIds.size(); ++i) {
            Object f = fromInstIds.get(i);
            Object t = toInstIds.get(i);
            pair = actInstMap.get(f) + "$" + actInstMap.get(t);
            passedPairs.add(pair);
        }
        TransitionCollection tc = this.processDef.getTransitions();
        for (int i = 0; i < tc.size(); ++i) {
            TransitionDef td = tc.get(i);
            pair = td.getFrom().getID() + "$" + td.getTo().getID();
            if (!passedPairs.contains(pair)) continue;
            transDefIdList.add(td.getID());
        }
        String[] rtnValue = new String[transDefIdList.size()];
        transDefIdList.toArray(rtnValue);
        return rtnValue;
    }
}

