/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.trans.ActivityDefPartialInfo;
import com.kingdee.bos.workflow.biz.trans.WfActivityTableData;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.monitor.ActivityUiInfo;
import com.kingdee.bos.workflow.monitor.IActivityTableUIFacade;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ActivityTableUIFacade
implements IActivityTableUIFacade {
    private final String resourceClass2 = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource";
    Context ctx;
    Locale l;
    ActivityInstInfo[] allActivityArrays;
    List activitiesUI;
    Map allActivityDefPartialInfos;
    Map allAssigments;
    ProcessInstInfo procInstInfo;

    public ActivityTableUIFacade(Context ctx) {
        this.ctx = ctx;
        this.l = ctx.getLocale();
    }

    @Override
    public HashMap getData4Init(String procInstId) throws Exception {
        HashMap<String, Object> res = new HashMap<String, Object>();
        this.getActivitys(procInstId);
        this.activitiesUI = new ArrayList();
        this.convettoUiObject(this.allActivityArrays);
        res.put("allActivityArrays", this.allActivityArrays);
        res.put("activitiesUI", this.activitiesUI);
        res.put("allActivityDefPartialInfos", this.allActivityDefPartialInfos);
        res.put("allAssigments", this.allAssigments);
        res.put("procInstInfo", this.procInstInfo);
        return res;
    }

    private void getActivitys(String procInstId) throws BOSException, WfException {
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        String processInstId = procInstId;
        this.procInstInfo = service.getProcessInstInfo(processInstId);
        WfActivityTableData data = service.getWfActivityTableDataByProcInstID(processInstId);
        this.allActivityArrays = data.getAllActivitys();
        this.allActivityDefPartialInfos = data.getAllActivityDefPartialInfos();
        this.allAssigments = data.getAllAssigments();
    }

    private String convertType(String type) {
        if (ActivityType.ROUTER.getName().equals(type)) {
            return ActivityType.ROUTER.getAlias(this.l);
        }
        if (ActivityType.SUBFLOW.getName().equals(type)) {
            return ActivityType.SUBFLOW.getAlias(this.l);
        }
        if (ActivityType.MANPOWER.getName().equals(type)) {
            return ActivityType.MANPOWER.getAlias(this.l);
        }
        if (ActivityType.TOOL.getName().equals(type)) {
            return ActivityType.TOOL.getAlias(this.l);
        }
        return type;
    }

    public void convettoUiObject(ActivityInstInfo[] activitys) throws Exception {
        int count = activitys.length;
        for (int i = 0; i < count; ++i) {
            ActivityDefPartialInfo activityDefPartialInfo = (ActivityDefPartialInfo)this.allActivityDefPartialInfos.get(activitys[i].getActDefId());
            ActivityUiInfo info = new ActivityUiInfo();
            ActivityInstInfo instInfo = activitys[i];
            instInfo.getActInstInfo().setDefaultLocale(this.l);
            info.setActivityName(StringUtils.cnulls((String)this.convertType(instInfo.getActInstInfo().getActDefName(this.l))));
            String[] prevInstanceIds = activitys[i].getPreActInstList();
            String prevText = this.getInstanceNameByIds(prevInstanceIds);
            info.setPreActInst(prevText);
            String[] nextInstanceIds = activitys[i].getPostActInstList();
            String nextText = this.getInstanceNameByIds(nextInstanceIds);
            info.setPostActInst(nextText);
            if (activityDefPartialInfo != null) {
                info.setActivityType(StringUtils.cnulls((String)this.convertType(activityDefPartialInfo.getActDefTypeName())));
            }
            info.setCreatedTime(activitys[i].getCreatedTime());
            info.setCompleteTime(activitys[i].getCompleteTime());
            long consumeTime = 0L;
            if (activitys[i].getCompleteTime() != null && activitys[i].getCreatedTime() != null) {
                consumeTime = activitys[i].getCompleteTime().getTime() - activitys[i].getCreatedTime().getTime();
            }
            info.setConsumeTime(this.longToTime(consumeTime));
            if (info.getActivityType() != null && info.getActivityType().equals(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"subProcess"))) {
                info.setProcInstId(activitys[i].getSubProcInstId());
            } else {
                info.setProcInstId(activitys[i].getProcInstId());
            }
            info.setActivityInstId(activitys[i].getActInstId());
            info.setActivityState(StringUtils.cnulls((String)this.convertState(activitys[i])));
            this.getPerformerListText(activityDefPartialInfo, activitys[i], this.allAssigments, info);
            this.activitiesUI.add(info);
        }
    }

    private String convertState(ActivityInstInfo activityInstInfo) throws BOSException {
        String state = activityInstInfo.getState();
        if (WfState.NOT_STARTED.getValue().equals(state)) {
            return WfState.NOT_STARTED.getAlias(this.l);
        }
        if (WfState.SUSPENDED.getValue().equals(state)) {
            return WfState.SUSPENDED.getAlias(this.l);
        }
        if (WfState.RUNNING.getValue().equals(state)) {
            return WfState.RUNNING.getAlias(this.l);
        }
        if (WfState.COMPLETED.getValue().equals(state)) {
            return WfState.COMPLETED.getAlias(this.l);
        }
        if (WfState.ABORTED.getValue().equals(state)) {
            return WfState.ABORTED.getAlias(this.l);
        }
        if (WfState.TERMINATED.getValue().equals(state)) {
            return WfState.TERMINATED.getAlias(this.l);
        }
        if (WfState.NOT_RUNNING.getValue().equals(state)) {
            return WfState.NOT_RUNNING.getAlias(this.l);
        }
        if (WfState.BLOCKED.getValue().equals(state)) {
            return WfState.SUSPENDED.getAlias(this.l);
        }
        if (WfState.ROLLBACKED.getValue().equals(state)) {
            return WfState.ROLLBACKED.getAlias(this.l);
        }
        return state;
    }

    private String longToTime(long time) {
        long hour = time / 3600000L;
        long left = time % 3600000L;
        long minite = left / 60000L;
        long second = (left %= 60000L) / 1000L;
        String retVal = this.formatLong(hour) + ":" + this.formatLong(minite) + ":" + this.formatLong(second);
        if (retVal.charAt(0) == '0') {
            retVal = retVal.substring(1);
        }
        return retVal;
    }

    private String formatLong(long m) {
        String retVal = Long.toString(m);
        if ((double)m < 10.0) {
            retVal = "0" + Long.toString(m);
        }
        return retVal;
    }

    protected void getPerformerListText(ActivityDefPartialInfo activityDefPartialInfo, ActivityInstInfo actInstInfo, Map allAssigments, ActivityUiInfo info) throws Exception {
        LinkedHashSet<String> empName = new LinkedHashSet<String>();
        LinkedHashSet<String> performerListText = new LinkedHashSet<String>();
        IUser uf = UserFactory.getLocalInstance((Context)this.ctx);
        if (allAssigments.get(actInstInfo.getActInstId()) != null) {
            LinkedHashSet assignments = new LinkedHashSet();
            Map map = (Map)allAssigments.get(actInstInfo.getActInstId());
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                assignments.add(map.get(it.next()));
            }
            AssignmentInfo[] assignInfoArray = assignments == null ? new AssignmentInfo[]{} : assignments.toArray(new AssignmentInfo[assignments.size()]);
            for (int i = 0; i < assignInfoArray.length; ++i) {
                String userId = assignInfoArray[i].getAssignInfo().getPersonUserID().toString();
                String oql = "select id,name, number, person.id, person.name where id='" + userId + "'";
                UserInfo user = (UserInfo)uf.getValue(oql);
                if (user == null) continue;
                performerListText.add(user.getNumber());
                if (user.getPerson() != null) {
                    empName.add(user.getPerson().getName(this.l));
                    continue;
                }
                empName.add(user.getName());
            }
        } else if (activityDefPartialInfo.isFirstActivity()) {
            String userId = this.procInstInfo.getInitiatorId();
            String oql = "select id, name,number, person.id, person.name where id='" + userId + "'";
            UserInfo user = (UserInfo)uf.getValue(oql);
            if (user != null) {
                performerListText.add(user.getNumber());
                if (user.getPerson() != null) {
                    empName.add(user.getPerson().getName(this.l));
                } else {
                    empName.add(user.getName());
                }
            }
        }
        info.setPerformer(StringUtils.arrayToString((Object[])empName.toArray(), (String)";"));
        info.setPerformerPerson(StringUtils.arrayToString((Object[])performerListText.toArray(), (String)";"));
    }

    private String getInstanceNameByIds(String[] instanceIds) {
        String name = "";
        Locale currentLocale = this.l;
        if (instanceIds != null) {
            for (String tmpId : instanceIds) {
                int n = this.allActivityArrays.length;
                for (int j = 0; j < n; ++j) {
                    if (!tmpId.equals(this.allActivityArrays[j].getActInstId())) continue;
                    name = name + "," + this.allActivityArrays[j].getActDefName(currentLocale);
                }
            }
        }
        if (name.length() > 0) {
            name = name.substring(1);
        }
        return name;
    }
}

