/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.JobService;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.monitor.app.AbstractAutoFixRecordControllerBean;
import com.kingdee.eas.base.job.JobDefCollection;
import com.kingdee.eas.base.job.JobDefFactory;
import com.kingdee.eas.base.job.app.JobServiceUIFacade;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoFixRecordControllerBean
extends AbstractAutoFixRecordControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.monitor.app.AutoFixRecordControllerBean");

    @Override
    public void _enableFixJob(Context ctx) throws BOSException {
        String pdefId = "b5a0a68d-7c1f-4113-97f4-c82246f9e028WFPRCDEF";
        String jobdefId = "b5a0a68d-7c1f-4113-97f4-c82246f9e028BGJOBDEF";
        JobDefCollection coll = JobDefFactory.getLocalInstance((Context)ctx).getCollection(" where jobdefid ='" + jobdefId + "'");
        if (coll.size() == 0) {
            ProcessDef process = this.getProcessDef(ctx, pdefId);
            JobServiceUIFacade facade = new JobServiceUIFacade(ctx);
            facade.release(process);
        } else {
            String triggerId = this.getTriggerId(ctx, jobdefId);
            if (triggerId != null) {
                JobService svc = new JobService(ctx);
                svc.enableTrigger(triggerId);
            }
        }
    }

    @Override
    public void _disableFixJob(Context ctx) throws BOSException {
        String jobdefId = "b5a0a68d-7c1f-4113-97f4-c82246f9e028BGJOBDEF";
        String triggerId = this.getTriggerId(ctx, jobdefId);
        if (triggerId != null) {
            JobService svc = new JobService(ctx);
            svc.disableTrigger(triggerId);
        }
    }

    @Override
    public boolean _isFixJobEnable(Context ctx) throws BOSException {
        String jobdefId = "b5a0a68d-7c1f-4113-97f4-c82246f9e028BGJOBDEF";
        String triggerId = this.getTriggerId(ctx, jobdefId);
        if (triggerId == null) {
            return false;
        }
        String sql = "select fisValid from t_job_trigger where fid=?";
        ArrayList list = SQL.executeQuery((Context)ctx, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{triggerId});
        if (list.size() > 0) {
            String isValid = (String)((Map)list.get(0)).get("fisvalid");
            return "Y".equals(isValid);
        }
        return false;
    }

    private ProcessDef getProcessDef(Context ctx, String pdefId) throws BOSException {
        String sql = "select FPROCESSXML from T_WFD_PROCESSDEF where FPROCESSID =? and fprocdeftype='BACKGROUNDJOB'";
        ArrayList list = SQL.executeQuery((Context)ctx, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{pdefId});
        if (list.size() > 0) {
            String fprocessxml = (String)((Map)list.get(0)).get("fprocessxml");
            return KpdlParser.parseKpdl((String)fprocessxml);
        }
        return null;
    }

    private String getTriggerId(Context ctx, String jobdefId) throws BOSException {
        String sql = "select fid from T_JOB_TRIGGER where FJOBDEFID =?";
        ArrayList list = SQL.executeQuery((Context)ctx, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{jobdefId});
        if (list.size() > 0) {
            String triggerId = (String)((Map)list.get(0)).get("fid");
            return triggerId;
        }
        return null;
    }
}

