/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.DynamicStateManager;
import com.kingdee.bos.dao.xml.impl.IProxyStateManager;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.monitor.BillDigestInfo;
import com.kingdee.bos.workflow.monitor.BillDigestSchemaInfo;
import com.kingdee.bos.workflow.monitor.EditConfigCollection;
import com.kingdee.bos.workflow.monitor.EditConfigInfo;
import com.kingdee.bos.workflow.monitor.SummaryInfo;
import com.kingdee.bos.workflow.monitor.SummaryItemInfo;
import com.kingdee.bos.workflow.monitor.ValueMappingCollection;
import com.kingdee.bos.workflow.monitor.ValueMappingInfo;
import com.kingdee.bos.workflow.monitor.app.SummaryCache;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BillDigestUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.monitor.util.BillDigestUtils");
    private static final String resName = "com.kingdee.bos.workflow.monitor.BillDigestResource";

    public static EntityObjectInfo loadEntity(Context ctx, String pk) {
        MetaDataPK mdpk;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity((IMetaDataPK)(mdpk = MetaDataPK.create((String)pk)));
        if (BillDigestUtils.isEmptyMD((AbstractMDValue)entity)) {
            logger.error((Object)("loadEntity by pk:" + pk + " Error "));
            return null;
        }
        return entity;
    }

    public static boolean isEmptyMD(AbstractMDValue amd) {
        if (amd == null) {
            return true;
        }
        IStateManager sm = amd.getStateManager();
        if (sm == null) {
            return true;
        }
        if (sm instanceof IProxyStateManager) {
            sm = ((IProxyStateManager)sm).getNoProxyDelegate();
        }
        return sm instanceof DynamicStateManager && ((DynamicStateManager)sm).isNull();
    }

    public static SummaryItemInfo createSummaryItem(BillDigestInfo digest, EntityObjectInfo entity) {
        PropertyInfo property;
        String group = digest.getPropertyGroup();
        String name = digest.getPropertyName();
        if (!StringUtils.isEmpty((String)group)) {
            entity = BillDigestUtils.loadEntry(entity, group);
        }
        if ((property = BillDigestUtils.getProperty(entity, name)) != null || digest.isCalculateField()) {
            SummaryItemInfo item = new SummaryItemInfo();
            item.setName(name);
            item.setGroup(digest.getPropertyGroup());
            item.setDigType(digest.getBillDigestType().getValue());
            item.setEditable(digest.isEditable());
            item.setShowFormate(digest.getShowFormate());
            item.setPrewNum(digest.getPreviewNum());
            item.setShowIfNull(digest.isShowIfNull());
            item.setUserDefine(digest.isCalculateField());
            String alias = digest.getAlias();
            item.setAlias(alias);
            item.setPreview(digest.isPreview());
            item.setDigType(digest.getBillDigestType().getValue());
            item.setFontColor(digest.getFontColor());
            item.setIsSortedItem(digest.isIsSortedItem());
            item.setCanSummary(digest.isCanSummary());
            if (property != null) {
                if (StringUtils.isEmpty((String)alias) || "null".equalsIgnoreCase(alias)) {
                    alias = property.getAlias();
                }
                item.setAlias(alias);
                if (property instanceof OwnPropertyInfo) {
                    DataType type2 = ((OwnPropertyInfo)property).getDataType();
                    if (DataType.ENUM.equals((Object)type2)) {
                        String ref = ((OwnPropertyInfo)property).getMetaDataRef();
                        if (!StringUtils.isEmpty((String)ref)) {
                            item.setProperty((OwnPropertyInfo)property);
                        }
                    } else if (DataType.BOOLEAN.equals((Object)type2) || DataType.FLOAT.equals((Object)type2) || DataType.DOUBLE.equals((Object)type2) || DataType.DECIMAL.equals((Object)type2) || DataType.DATE.equals((Object)type2) || DataType.TIME.equals((Object)type2) || DataType.TIMESTAMP.equals((Object)type2) || DataType.BOSUUID.equals((Object)type2)) {
                        item.setProperty((OwnPropertyInfo)property);
                    }
                }
            }
            item.getValueMapping().addCollection(digest.getValuemapping());
            item.getEditConfig().addCollection(digest.getEditConfig());
            item.getScript().addCollection(digest.getScript());
            return item;
        }
        return null;
    }

    public static EntityObjectInfo loadEntry(EntityObjectInfo parent, String entryName) {
        String[] split = StringUtils.split((String)entryName, (String)".");
        EntityObjectInfo entity = parent;
        for (int i = 0; i < split.length; ++i) {
            LinkPropertyInfo property = (LinkPropertyInfo)entity.getPropertyByName(split[i]);
            if (property == null) {
                logger.error((Object)("can't find property " + entryName + "in " + parent.getFullName()));
                continue;
            }
            entity = property.getRelationship().getSupplierObject();
            if (!BillDigestUtils.isEmptyMD((AbstractMDValue)entity)) continue;
            logger.error((Object)("can't find entry " + entryName + "in " + parent.getFullName()));
        }
        return entity;
    }

    public static PropertyInfo getProperty(EntityObjectInfo entity, String propertyName) {
        String[] split = StringUtils.split((String)propertyName, (String)".");
        if (split.length > 1) {
            for (int i = 0; i < split.length - 1; ++i) {
                LinkPropertyInfo property = (LinkPropertyInfo)entity.getPropertyByName(split[i]);
                if (property == null) {
                    logger.error((Object)("can't find property " + split[i] + "in " + entity.getFullName()));
                } else {
                    entity = property.getRelationship().getSupplierObject();
                }
                if (!BillDigestUtils.isEmptyMD((AbstractMDValue)entity)) continue;
                logger.error((Object)("can't find entity " + split[i] + "in " + entity.getFullName()));
            }
        }
        if (BillDigestUtils.isEmptyMD((AbstractMDValue)entity)) {
            return null;
        }
        return entity.getPropertyByName(split[split.length - 1]);
    }

    public static void createEntrys(SummaryInfo summary, IObjectCollection digestcols) {
        for (int i = 0; i < digestcols.size(); ++i) {
            BillDigestInfo digest = (BillDigestInfo)digestcols.getObject(i);
            if (!summary.getMetadataPK().equals(digest.getMetadataPK())) continue;
            BillDigestUtils.createEntry(summary, digest);
        }
    }

    public static void createEntry(SummaryInfo summary, BillDigestInfo digest) {
        if (StringUtils.isEmpty((String)digest.getPropertyName())) {
            if (StringUtils.isEmpty((String)digest.getPropertyGroup())) {
                String alias = digest.getAlias();
                summary.setAlias(alias);
                summary.setOABill(digest.isIsOABill());
                summary.setIsMobileApprove(digest.isIsMobileApprove());
                summary.setNeedValidate(digest.isNeedValidate());
                summary.setDigType(digest.getBillDigestType());
            } else {
                String group = digest.getPropertyGroup();
                String[] strings = StringUtils.split((String)group, (String)".");
                SummaryInfo parent = summary;
                for (String str : strings) {
                    String entryName = !StringUtils.isEmpty((String)parent.getName()) ? parent.getName() + "." + str : str;
                    SummaryInfo entry = parent.getEntry(entryName);
                    if (entry == null) {
                        entry = new SummaryInfo();
                        entry.setName(entryName);
                        parent.addEntry(entry);
                    }
                    parent = entry;
                }
                parent.setAlias(digest.getAlias());
                parent.setPreviewNum(digest.getPreviewNum());
                parent.setIndex(digest.getIndex());
                parent.setSortedType(digest.getSortedType());
            }
        }
    }

    public static void createEntry(Context ctx, EntityObjectInfo entity, String group, SummaryInfo summary) {
        EntityObjectInfo subEntity = BillDigestUtils.loadEntry(entity, group);
        if (subEntity != null) {
            BillDigestInfo digest = new BillDigestInfo();
            digest.setMetadataPK(entity.getFullName());
            digest.setPropertyGroup(group);
            digest.setAlias(subEntity.getAlias());
            BillDigestUtils.createEntry(summary, digest);
        }
    }

    public static void removeBillDigestSchemaCache(CoreBaseCollection cols) {
        for (int i = 0; i < cols.size(); ++i) {
            BillDigestSchemaInfo col = (BillDigestSchemaInfo)cols.get(i);
            if (col.getId() == null) continue;
            SummaryCache.removeFromCache(col.getId().toString() + "&" + col.getBillMetadataPk());
        }
    }

    public static String getDistributeSchemaID(Context ctx, String procDefId) throws BOSException {
        String querySql = "select FPROCDEFID,FBILLDIGESTSCHEMAID from T_WM_BILLDIGESTDITRIBUTR where FPROCDEFID='" + procDefId + "'";
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)querySql);
            String procDefid = null;
            while (rowset.next()) {
                procDefid = rowset.getString(2);
            }
            return procDefid;
        }
        catch (SQLException e) {
            logger.error((Object)"get distribute SchemaID by procDefId error", (Throwable)e);
            return null;
        }
    }

    public static String getDefaultSchemaId(Context ctx, String metadataPk) {
        String querySql = "select FID from T_WM_BILLDIGESTSCHEMA where FbillMetadataPk = '" + metadataPk + "' and FisDefault =1";
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)querySql);
            String schemaId = null;
            while (rowset.next()) {
                schemaId = rowset.getString(1);
            }
            return schemaId;
        }
        catch (SQLException e) {
            logger.error((Object)"get Default SchemaID  error", (Throwable)e);
            return null;
        }
        catch (BOSException e) {
            logger.error((Object)"get Default SchemaID  error", (Throwable)e);
            return null;
        }
    }

    public static String getMetadataPKByEntryMetadataPK(Context ctx, String entryMetadataPk) {
        String billMetadataPK = "";
        String querySql = "select distinct FBILLMETADATAPK from T_WM_BillDigestSchema where fid in (select FSCHEMAID from T_WM_BillDigestSchEntry where FENTRYMETADATAPK ='" + entryMetadataPk + "') ";
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)querySql);
            while (rowset.next()) {
                billMetadataPK = rowset.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"get Default SchemaID  error", (Throwable)e);
            return null;
        }
        catch (BOSException e) {
            logger.error((Object)"get Default SchemaID  error", (Throwable)e);
            return null;
        }
        return billMetadataPK;
    }

    public static String getProcDefByActDefId(String actInstId, Context ctx) throws BOSException {
        try {
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
            return service.getProcessInstInfoByAssign(actInstId).getProcDefId();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getActDefIDByAssignId(Context ctx, String assId) throws BOSException {
        if (assId == null) {
            return null;
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1  FACTDEFID from T_WFR_Assign where FASSIGNID = '" + assId + "'");
            sql.append("");
            DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            IRowSet RowSet2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (RowSet2.next()) {
                return RowSet2.getString("FACTDEFID");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u901a\u8fc7\u4efb\u52a1\u83b7\u53d6\u6d3b\u52a8\u5b9a\u4e49\u5931\u8d25", (Throwable)e);
            return null;
        }
        return null;
    }

    public static Object getValue(Context ctx, SummaryItemInfo item, IObjectValue parent) throws BOSException {
        String name = item.getName();
        String[] splits = StringUtils.split((String)name, (String)".");
        Object value = parent;
        for (String split : splits) {
            if (value instanceof IObjectValue) {
                value = value.get(split);
            }
            if (value == null) continue;
            value = BillDigestUtils.translateValue(ctx, item, value, item.getShowFormate());
        }
        if (value != null && value instanceof String) {
            value = ((String)value).replaceAll("\"", "&quot;");
        }
        return value;
    }

    private static Object translateValue(Context ctx, SummaryItemInfo item, Object value, String formater) {
        ValueMappingCollection mappings = item.getValueMapping();
        if (!mappings.isEmpty()) {
            for (int i = 0; i < mappings.size(); ++i) {
                ValueMappingInfo mapping = mappings.get(i);
                if (!value.toString().equals(mapping.getValue())) continue;
                return mapping.getAlias();
            }
        } else {
            OwnPropertyInfo property = item.getProperty();
            if (property != null) {
                DataType type2 = property.getDataType();
                if (DataType.BOOLEAN.equals((Object)type2)) {
                    value = BillDigestUtils.toBoolean(value);
                } else if (DataType.ENUM.equals((Object)type2)) {
                    BizEnumInfo type = property.getEnumType();
                    if (type == null) {
                        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                        type = loader.getEnum((IMetaDataPK)MetaDataPK.create((String)property.getMetaDataRef()));
                    }
                    if (type != null && type.isDynamic()) {
                        DynamicEnum de = DynamicEnum.getEnum((String)property.getMetaDataRef(), (Object)value);
                        value = de.getAlias();
                    } else {
                        value = BillDigestUtils.getEnumValue(type, property.getMetaDataRef(), value);
                    }
                } else if (DataType.FLOAT.equals((Object)type2) || DataType.DOUBLE.equals((Object)type2) || DataType.DECIMAL.equals((Object)type2)) {
                    value = BillDigestUtils.translateNumber(value, formater);
                } else if (DataType.DATE.equals((Object)type2) || DataType.TIME.equals((Object)type2) || DataType.TIMESTAMP.equals((Object)type2)) {
                    value = BillDigestUtils.translateTime(value, formater);
                }
            }
        }
        return value;
    }

    public static Object translateTime(Object obj, String formater) {
        if (obj instanceof Date && formater != null) {
            SimpleDateFormat df = new SimpleDateFormat(formater);
            try {
                return df.format((Date)obj);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return obj;
    }

    public static Object translateNumber(Object obj, String formater) {
        if (obj instanceof BigDecimal && formater != null) {
            DecimalFormat formatter = new DecimalFormat(formater);
            try {
                return formatter.format(obj);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return obj;
    }

    private static String toBoolean(Object value) {
        Boolean bv = Boolean.FALSE;
        if (value instanceof Integer) {
            bv = (Integer)value == 0 ? Boolean.TRUE : Boolean.FALSE;
        } else if (value instanceof String) {
            bv = Boolean.valueOf((String)value);
        } else if (value instanceof Boolean) {
            bv = (Boolean)value;
        }
        if (bv.booleanValue()) {
            return "\u662f";
        }
        return "\u5426";
    }

    private static Object getEnumValue(BizEnumInfo enumInfo, String refTypeInfo, Object value) {
        BizEnumValueType type = enumInfo.getDataType();
        Object result = null;
        try {
            Class<?> refEnum = Class.forName(refTypeInfo);
            Class[] paraTypes = null;
            Object[] args = null;
            if (type == BizEnumValueType.INTEGER) {
                paraTypes = new Class[]{Integer.TYPE};
                args = new Object[]{TypeConversionUtils.objToInteger((Object)value)};
            } else if (type == BizEnumValueType.STRING) {
                paraTypes = new Class[]{String.class};
                args = new Object[]{TypeConversionUtils.objToString((Object)value)};
            } else if (type == BizEnumValueType.FLOAT) {
                paraTypes = new Class[]{Float.TYPE};
                args = new Object[]{TypeConversionUtils.objToFFloat((Object)value)};
            } else if (type == BizEnumValueType.LONG) {
                paraTypes = new Class[]{Long.TYPE};
                args = new Object[]{TypeConversionUtils.objToLLong((Object)value)};
            } else if (type == BizEnumValueType.DOUBLE) {
                paraTypes = new Class[]{Double.TYPE};
                args = new Object[]{TypeConversionUtils.objToDDouble((Object)value)};
            }
            Method method = refEnum.getMethod("getEnum", paraTypes);
            result = method.invoke(null, args);
            if (result instanceof Enum) {
                result = ((Enum)result).getAlias();
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return result;
    }

    public static Boolean digestIsEditable(SummaryItemInfo item, String assignID) {
        if (StringUtils.isEmpty((String)assignID)) {
            return false;
        }
        EditConfigCollection collection = item.getEditConfig();
        if (collection.size() == 0 || collection == null) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            EditConfigInfo info = (EditConfigInfo)iterator.next();
            if (!assignID.equals(info.getActdefid())) continue;
            return true;
        }
        return false;
    }

    public static int getAttachmentCount(Context ctx, String billId) {
        if (StringUtils.isEmpty((String)billId)) {
            return 0;
        }
        int attCount = 0;
        int attCount1 = 0;
        try {
            StringBuffer sql = new StringBuffer("SELECT COUNT(*) AS attCount FROM T_BAS_Attachment att ");
            sql.append(" INNER JOIN T_BAS_BoAttchAsso baa ON att.FID = baa.FAttachmentID ");
            sql.append(" WHERE baa.FBoID = ?");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{billId});
            if (rowSet.next()) {
                attCount = rowSet.getInt("attCount");
            }
            try {
                StringBuffer sql1 = new StringBuffer("SELECT COUNT(*) AS attCount FROM T_EC_FileContent  ");
                sql1.append(" WHERE FBillID = ?");
                IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString(), (Object[])new String[]{billId});
                if (rowSet1.next()) {
                    attCount1 = rowSet1.getInt("attCount");
                }
            }
            catch (Exception e) {
                attCount1 = 0;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            attCount = -1;
        }
        return attCount + attCount1;
    }

    public static String getContentId(Context ctx, String billID) {
        BOSUuid bosuuid = BOSUuid.read((String)billID);
        BOSObjectType type = bosuuid.getType();
        String FTabelName = null;
        StringBuffer querySql = new StringBuffer("select top 1 FTableName from T_BAS_FormEntity where FBosType='");
        querySql.append(type).append("' and ");
        querySql.append(" FFormID  in (select fid from t_bas_form where FTemplateID");
        querySql.append("  in ('tqAoxLV0TguihBZ6eqU8bZp+rpI=','C/T4g3UCStmKrMRuH4ErO5p+rpI=')) ");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            while (rowset.next()) {
                FTabelName = rowset.getString("FTableName");
            }
            if (!StringUtils.isEmpty(FTabelName)) {
                String contendId = null;
                String sql = "select FDocContentId from " + FTabelName + " where FID='" + billID + "'";
                rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rowset.next()) {
                    contendId = rowset.getString("FDocContentId");
                }
                return contendId;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return null;
    }

    public static String getOldOaCount(Context ctx, String billID) {
        String fid = "";
        String SQL1 = "select fid  from T_CP_DocDispatch WHERE FID='" + billID + "'";
        String SQL2 = "select fid  from T_CP_DocReceive WHERE FID='" + billID + "'";
        String SQL3 = "select fid  from T_CP_Document WHERE FID='" + billID + "'";
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)SQL1.toString());
            while (rowset.next()) {
                fid = rowset.getString("fid");
            }
            if (!StringUtils.isEmpty((String)fid)) {
                return fid;
            }
            rowset = DbUtil.executeQuery((Context)ctx, (String)SQL2);
            while (rowset.next()) {
                fid = rowset.getString("fid");
            }
            if (!StringUtils.isEmpty((String)fid)) {
                return fid;
            }
            rowset = DbUtil.executeQuery((Context)ctx, (String)SQL3);
            while (rowset.next()) {
                fid = rowset.getString("fid");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return fid;
        }
        return fid;
    }

    public static String getIfEdit(Context ctx, String assignId) {
        String ifEdit = "false";
        try {
            String v;
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
            Map actmap = service.getActivityDefAndActivityInstInfo(assignId);
            ActivityDef def = (ActivityDef)actmap.get("ACTIVITYDEF");
            ExtendedAttributeDef ed = def.getActivityHeader().getExtendedAttributes().get("customUIStatus");
            if (ed != null && (v = ed.getValue()) != null && v.length() > 0 && "EDIT".equalsIgnoreCase(v)) {
                ifEdit = "true";
            }
            return ifEdit;
        }
        catch (BOSException e) {
            return ifEdit;
        }
    }

    public static String getRelativeName(SummaryInfo parent, SummaryInfo entry) {
        String pName = parent.getName();
        String eName = entry.getName();
        if (StringUtils.isEmpty((String)pName)) {
            return eName;
        }
        if (eName.startsWith(pName + ".")) {
            return eName.substring(pName.length() + 1);
        }
        return eName;
    }

    public static List<IObjectValue> getEntryValue(IObjectValue parent, String entryName) {
        String[] splits = StringUtils.split((String)entryName, (String)".");
        List<IObjectValue> list = new LinkedList<IObjectValue>();
        list.add(parent);
        for (int i = 0; i < splits.length; ++i) {
            list = BillDigestUtils.getObjects(list, splits[i]);
        }
        return list;
    }

    public static List<IObjectValue> getObjects(List<IObjectValue> parents, String key) {
        LinkedList<IObjectValue> values = new LinkedList<IObjectValue>();
        for (int i = 0; i < parents.size(); ++i) {
            IObjectValue parent = parents.get(i);
            Object object = parent.get(key);
            if (!(object instanceof IObjectCollection)) continue;
            IObjectCollection col = (IObjectCollection)object;
            for (int j = 0; j < col.size(); ++j) {
                values.add(col.getObject(j));
            }
        }
        return values;
    }

    public static List<SummaryItemInfo> getPreviewItems(SummaryInfo entry) {
        List<SummaryItemInfo> results = new ArrayList<SummaryItemInfo>();
        List<SummaryItemInfo> items = entry.getSummaryItems();
        for (SummaryItemInfo item : items) {
            if (!item.isPreview()) continue;
            results.add(item);
        }
        if (results.isEmpty() && (results = items).size() > 4) {
            results = results.subList(0, 4);
        }
        return results;
    }

    public static IObjectValue getEntryValue(IObjectValue parent, String entryName, String entryID) {
        List<IObjectValue> list = BillDigestUtils.getEntryValue(parent, entryName);
        for (int i = 0; i < list.size(); ++i) {
            IObjectValue value = list.get(i);
            if (value.get("id") == null || !value.get("id").toString().equals(entryID)) continue;
            return value;
        }
        return null;
    }

    public static NodeType getNodeType(DefaultKingdeeTreeNode obj) {
        TreeNode root = obj.getRoot();
        TreeNode parent = obj.getParent();
        if (root.equals(obj)) {
            return NodeType.ROOT;
        }
        Object userObj = obj.getUserObject();
        if (userObj instanceof SummaryItemInfo) {
            return NodeType.ITEM;
        }
        if (userObj instanceof SummaryInfo) {
            if (root.equals(parent)) {
                return NodeType.SCHEMA;
            }
            return NodeType.ENTRY;
        }
        return null;
    }

    public static List<String> getSchemIDByMetadataPk(Context ctx, String metadataPk) {
        ArrayList<String> schemaId = new ArrayList<String>();
        String querySql = "select a.fschemaid from (select distinct FMETADATAPK ,fschemaid  from T_WM_BillDigest ) a left outer JOIN T_WM_BillDigestSchema b on a.fschemaid = b.fid where a.fmetadatapk = '" + metadataPk + "'";
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            while (rowset.next()) {
                schemaId.add(rowset.getString(1));
            }
        }
        catch (BOSException ex) {
            logger.error((Object)"get billDigestschemaID error", (Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"get billDigestschemaID error", (Throwable)ex);
        }
        return schemaId;
    }

    public static boolean modifyProc(String procDefId, String metadataPK) {
        String sql = "select top 1 FBILLENTITY from T_WFR_Assign where FPROCDEFID = '" + procDefId + "' union select top 1 FBILLENTITY from T_WFR_AssignDetail where FPROCDEFID = '" + procDefId + "'";
        try {
            SQLExecutor se = new SQLExecutor(sql);
            IRowSet rowSet = se.executeSQL();
            String tempMetaDataPK = null;
            while (rowSet.next()) {
                tempMetaDataPK = rowSet.getString("FBILLENTITY");
            }
            return metadataPK != null && metadataPK.equals(tempMetaDataPK);
        }
        catch (BOSException e) {
            return false;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public static boolean checkProc(String procDefId, String metadataPK) throws Exception {
        IEnactmentService svc = EnactmentServiceFactory.createRemoteEnactService();
        BOSObjectType[] bostype = svc.getRelatedEntityTypes(procDefId);
        if (bostype != null && bostype.length > 0) {
            EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bostype[0]);
            String tempMetaDataPK = entityObjectInfo.getFullName();
            if (metadataPK != null && metadataPK.equals(tempMetaDataPK)) {
                return true;
            }
        }
        return false;
    }

    public static List getTableSelectRow(KDTable table) {
        LinkedList<Integer> indexList;
        block7: {
            int size;
            block6: {
                indexList = new LinkedList<Integer>();
                size = table.getSelectManager().size();
                if (size != 1) break block6;
                KDTSelectBlock sb = table.getSelectManager().get();
                if (sb.getMode() == 8) {
                    for (int i = 0; i < table.getRowCount(); ++i) {
                        indexList.add(new Integer(i));
                    }
                } else {
                    for (int i = sb.getTop(); i <= sb.getBottom(); ++i) {
                        indexList.add(new Integer(i));
                    }
                }
                break block7;
            }
            if (size <= 1) break block7;
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock sb = table.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    indexList.add(new Integer(j));
                }
            }
        }
        return indexList;
    }

    public static List getProcDefByProcDefId(Context ctx, List<String> procDefIds) {
        try {
            if (procDefIds == null || procDefIds.size() == 0) {
                return null;
            }
            ArrayList<ProcessDefInfo> procDefList = new ArrayList<ProcessDefInfo>();
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
            for (String procDefId : procDefIds) {
                ProcessDefInfo info = service.getProcessDefInfo(procDefId);
                procDefList.add(info);
            }
            return procDefList;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static SummaryInfo deepClone(SummaryInfo info) {
        SummaryInfo dc = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(info);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream bis = new ObjectInputStream(bais);
            dc = (SummaryInfo)bis.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return dc;
    }

    public static boolean isOABill(Context ctx, BOSObjectType BOSType) {
        String querySql = "select FID from T_BAS_FormEntity where FBosType='" + BOSType.toString() + "' and  FFormID  in (select fid from t_bas_form where FTemplateID  in ('tqAoxLV0TguihBZ6eqU8bZp+rpI=','C/T4g3UCStmKrMRuH4ErO5p+rpI=')) ";
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            if (rowset.next()) {
                return true;
            }
        }
        catch (BOSException e) {
            return false;
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    private static Locale getCurLocale() {
        try {
            return SysContext.getSysContext().getOriginLocale();
        }
        catch (Throwable e) {
            logger.error((Object)("Get Locale fail!" + e.getMessage()));
            return LocaleUtils.locale_zh_CN;
        }
    }

    public static String getResString(String key) {
        return ResourceBase.getString((String)resName, (String)key, (Locale)BillDigestUtils.getCurLocale());
    }

    public static enum NodeType {
        ROOT,
        SCHEMA,
        ENTRY,
        ITEM;

    }
}

