/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.statsa.syn;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.metas.SAProcInstFactory;
import com.kingdee.bos.workflow.metas.SAProcInstInfo;
import com.kingdee.bos.workflow.statsa.caldate.SAWorkCalendarUtil;
import com.kingdee.bos.workflow.statsa.service.SAProcessDATASyncMange;
import com.kingdee.bos.workflow.statsa.util.SAUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class SAProcinstDATASync {
    private Context ctx;
    private static Logger log = Logger.getLogger(SAProcinstDATASync.class);
    public static Set columnSet = null;
    public static ConcurrentHashMap<String, String> entityMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Integer> entityLogMap = new ConcurrentHashMap();

    public static Set getColumns(IRowSet rowSet) throws SQLException {
        if (columnSet == null) {
            HashSet<String> set = new HashSet<String>();
            int columns = rowSet.getMetaData().getColumnCount();
            for (int index = 1; index <= columns; ++index) {
                String columnName = rowSet.getMetaData().getColumnName(index);
                if (columnName.indexOf("_") > 0) {
                    columnName = columnName.substring(0, columnName.indexOf("_"));
                }
                set.add(columnName.toUpperCase());
            }
            columnSet = set;
        }
        return columnSet;
    }

    public SAProcinstDATASync(Context ctx) {
        this.ctx = ctx;
    }

    public SAProcInstInfo synData(IRowSet rowSet, String procInstId) throws BOSException {
        SAProcInstInfo tSAProcInstInfo = new SAProcInstInfo();
        try {
            SAUtil.setPropertyForRowSet(this.ctx, rowSet, SAProcinstDATASync.getColumns(rowSet), (CoreBaseInfo)tSAProcInstInfo, tSAProcInstInfo.getBOSType());
            tSAProcInstInfo.setId(BOSUuid.create((BOSObjectType)tSAProcInstInfo.getBOSType()));
            String orgId = this.getOrgIdByProcinstId(procInstId);
            if (orgId != null) {
                tSAProcInstInfo.setControlUnitID(BOSUuid.read((String)orgId));
            }
            String billId = this.getBillIdByProcinstId(procInstId);
            this.setBilltypeAndTypeName(billId, tSAProcInstInfo);
            BigDecimal executeTime = SAWorkCalendarUtil.calExecuteTime(this.ctx, tSAProcInstInfo.getCreatedTime(), tSAProcInstInfo.getComleteTime());
            tSAProcInstInfo.setExecuteTime(executeTime);
            SAProcInstFactory.getLocalInstance((Context)this.ctx).addnew(tSAProcInstInfo);
        }
        catch (Exception e) {
            throw new BOSException("\u540c\u6b65\u6d41\u7a0b\u5b9e\u4f8b\uff1a" + procInstId + "\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
        return tSAProcInstInfo;
    }

    private void setBilltypeAndTypeName(String billId, SAProcInstInfo tSAProcInstInfo) throws BOSException {
        String bostypeName;
        BOSObjectType type;
        BOSUuid id;
        block6: {
            if (StringUtils.isEmpty((String)billId)) {
                throw new BOSException("\u5355\u636eid\u4e3a\u7a7a");
            }
            id = BOSUuid.read((String)billId);
            type = id.getType();
            bostypeName = entityMap.get(type.toString());
            if (bostypeName == null) {
                try {
                    EntityObjectInfo entityinfo = SAUtil.getMetaDataLoader(this.ctx).getEntity(type);
                    if (entityinfo != null) {
                        bostypeName = entityinfo.getAlias(LocaleUtils.locale_L2);
                        entityMap.put(type.toString(), bostypeName);
                    }
                }
                catch (Exception e) {
                    bostypeName = "\u5176\u5b83\u7c7b\u578b\uff08\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u5e94\u5355\u636e\u540d\u79f0\uff09";
                    int times = 0;
                    if (entityLogMap.get(type.toString()) != null) {
                        times = entityLogMap.get(type.toString());
                    }
                    if (times > true) break block6;
                    log.error((Object)("\u5355\u636e:" + billId + "\u83b7\u53d6\u5143\u6570\u636e\u51fa\u9519"), (Throwable)e);
                    entityLogMap.put(type.toString(), ++times);
                }
            }
        }
        tSAProcInstInfo.setBillBostypeName(bostypeName);
        tSAProcInstInfo.setBillBostype(type.toString());
        tSAProcInstInfo.setBillId(id);
    }

    private boolean isMultiApprove(String billId) {
        BOSUuid id = BOSUuid.read((String)billId);
        BOSObjectType type = id.getType();
        return "63D30103".equals(type.toString()) || "C7CEA331".equals(type.toString());
    }

    private String getBillIdByProcinstId(String procInstId) throws BOSException {
        try {
            String sql = "select distinct frefid from T_WFR_ProcInstRef where fprocInstId= ? and ftype=1";
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{procInstId});
            while (rowSet.next()) {
                if (StringUtils.isEmpty((String)rowSet.getString(1)) || this.isMultiApprove(rowSet.getString(1))) continue;
                return rowSet.getString(1);
            }
            sql = "select distinct frefid from T_WFR_ProcInstRefHst where fprocInstId=? and ftype=1";
            rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{procInstId});
            while (rowSet.next()) {
                if (StringUtils.isEmpty((String)rowSet.getString(1)) || this.isMultiApprove(rowSet.getString(1))) continue;
                return rowSet.getString(1);
            }
            sql = "select distinct fbizobjid from t_wfr_assigndetail where fprocInstId=?";
            rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{procInstId});
            while (rowSet.next()) {
                if (StringUtils.isEmpty((String)rowSet.getString(1)) || this.isMultiApprove(rowSet.getString(1))) continue;
                return rowSet.getString(1);
            }
        }
        catch (Exception e) {
            throw new BOSException("\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid:" + procInstId + "\u83b7\u53d6\u5355\u636eid\u51fa\u9519", (Throwable)e);
        }
        throw new BOSException("\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid\uff1a" + procInstId + "\u6ca1\u6709\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u5355\u636eid");
    }

    private String getOrgIdByProcinstId(String procInstId) {
        block4: {
            try {
                String sql = "select frefid from T_WFR_ProcInstRef where fprocInstId='" + procInstId + "' and ftype=0";
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                while (rowSet.next()) {
                    if (StringUtils.isEmpty((String)rowSet.getString(1))) continue;
                    return rowSet.getString(1);
                }
                sql = "select frefid from T_WFR_ProcInstRefHst where fprocInstId='" + procInstId + "' and ftype=0";
                rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                while (rowSet.next()) {
                    if (StringUtils.isEmpty((String)rowSet.getString(1))) continue;
                    return rowSet.getString(1);
                }
            }
            catch (Exception e) {
                if (SAProcessDATASyncMange.logIsClose) break block4;
                log.error((Object)("\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid\u83b7\u53d6\u7ec4\u7ec7id\u51fa\u9519\uff1a" + procInstId), (Throwable)e);
            }
        }
        return null;
    }
}

