/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.microflow.parser;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.microflow.adapter.ScriptCondition;
import com.kingdee.bos.microflow.parser.ActivityParser;
import com.kingdee.bos.microflow.parser.Parsers;
import com.kingdee.bos.microflow.types.BOSUuidType;
import com.kingdee.bos.microflow.types.BizObjectType;
import com.kingdee.bos.microflow.types.ObjectValueType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.ConditionDef;
import com.kingdee.bos.workflow.define.ConditionType;
import com.kingdee.bos.workflow.define.DataFieldCollection;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.ExpressionCollection;
import com.kingdee.bos.workflow.define.ExpressionDef;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.JoinType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.SplitType;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.engine.adapter.ErrorTransitCondition;
import com.kingdee.bos.workflow.engine.adapter.WfProfileLogger;
import com.kingdee.bos.workflow.engine.core.IFlowParser;
import com.kingdee.cbos.process.vm.builder.FlowBuilder;
import com.kingdee.cbos.process.vm.builder.NodeBuilder;
import com.kingdee.cbos.process.vm.model.DataType;
import com.kingdee.cbos.process.vm.model.DataTypes;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.cbos.process.vm.model.Transition;
import com.kingdee.cbos.process.vm.plugin.Condition;
import com.kingdee.cbos.process.vm.runtime.ProfileLogger;
import com.kingdee.cbos.process.vm.utils.cache.SmartCache;
import java.util.HashMap;
import java.util.Locale;

public class MicroFlowParser
implements SmartCache.Loader<String, Flow>,
IFlowParser {
    private static Locale l = new Locale("L2");
    private WfEngine engine;

    public MicroFlowParser(WfEngine engine) {
        this.engine = engine;
        ProfileLogger.Ref.set((Object)new WfProfileLogger());
    }

    public Flow load(String id) {
        ProcessDef def;
        try {
            def = this.engine.getProcessDef(id);
        }
        catch (WfException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.parse(def);
    }

    public Flow parse(ProcessDef def) {
        FlowBuilder builder = FlowBuilder.newBuilder((String)def.getDocHash(), (String)def.getName());
        this.createVariables(def, builder);
        MicroFlowParser.createNodes(def, builder);
        MicroFlowParser.createTransitions(def, builder);
        this.setInputAndOutputVars(def, builder);
        return builder.end();
    }

    private void setInputAndOutputVars(ProcessDef def, FlowBuilder builder) {
        FormalParameterCollection parameters = def.getFormalParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            FormalParameterDef param = parameters.get(i);
            if (param.getMode().equals((Object)FormalParameterMode.OUT)) {
                builder.output(new String[]{param.getName()});
                continue;
            }
            builder.input(new String[]{param.getName()});
        }
    }

    private void createVariables(ProcessDef def, FlowBuilder builder) {
        DataFieldCollection dfc = def.getDataFields();
        for (int i = 0; i < dfc.size(); ++i) {
            DataFieldDef df = dfc.get(i);
            DataType type = this.getDataType(df);
            String name = df.getName();
            String id = df.getID();
            String initValue = type instanceof BizObjectType ? null : df.getInitValue();
            builder.variable(id, name, name, type, (Object)initValue);
        }
    }

    private DataType getDataType(DataFieldDef df) {
        Object type = DataTypes.VARIANT;
        if (df.getDataType() == BasicType.INTEGER) {
            type = DataTypes.INTEGER;
        } else if (df.getDataType() == BasicType.BOOLEAN) {
            type = DataTypes.BOOLEAN;
        } else if (df.getDataType() == BasicType.FLOAT) {
            type = DataTypes.DOUBLE;
        } else if (df.getDataType() == BasicType.BOID) {
            type = BOSUuidType.TYPE;
        } else if (df.getDataType() == BasicType.STRING) {
            type = DataTypes.STRING;
        } else if (df.getDataType() == BasicType.DATETIME) {
            type = DataTypes.DATETIME;
        } else if (df.getDataType() == BasicType.BIZOBJ) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.engine.context());
            String name = df.getInitValue();
            EntityObjectInfo entity = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)name));
            type = new BizObjectType(entity);
        } else if (df.getDataType() == BasicType.OBJECTVALUE) {
            type = ObjectValueType.TYPE;
        }
        if (df.isArray()) {
            type = DataTypes.ARRAY((DataType)type);
        }
        return type;
    }

    private static void createTransitions(ProcessDef def, FlowBuilder builder) {
        TransitionCollection transitions = def.getTransitions();
        for (int i = 0; i < transitions.size(); ++i) {
            TransitionDef trans = transitions.get(i);
            String id = trans.getID();
            String name = trans.getName(l);
            String from = trans.getFrom().getID();
            String to = trans.getTo().getID();
            ConditionDef condition = trans.getCondition();
            MicroFlowParser.createTransition(builder, trans, id, name, from, to, condition);
        }
    }

    private static void createTransition(FlowBuilder builder, TransitionDef trans, String id, String name, String from, String to, ConditionDef conditionDef) {
        if (conditionDef == null) {
            builder.transition(id, name, from, to, Condition.TRUE);
        } else {
            ConditionType type = conditionDef.getConditionType();
            if (type.equals((Object)ConditionType.DEFAULTEXCEPTION)) {
                builder.transition(id, name, Transition.Type.ERROR, from, to, null);
            } else if (type.equals((Object)ConditionType.OTHERWISE)) {
                builder.transition(id, name, from, to, null);
            } else if (type.equals((Object)ConditionType.CONDITION)) {
                Condition condition = MicroFlowParser.getCondition(trans, conditionDef);
                builder.transition(id, name, from, to, condition);
            } else if (type.equals((Object)ConditionType.EXCEPTION)) {
                builder.transition(id, name, Transition.Type.ERROR, from, to, (Condition)new ErrorTransitCondition(trans));
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static Condition getCondition(TransitionDef trans, ConditionDef conditionDef) {
        ExpressionCollection expressionCollection = conditionDef.getXpressionList();
        if (expressionCollection == null || expressionCollection.size() == 0) {
            return Condition.TRUE;
        }
        ExpressionDef express = expressionCollection.get(0);
        if (express == null || express.toString().trim().length() == 0) {
            return Condition.TRUE;
        }
        return new ScriptCondition(express.toString());
    }

    private static void createNodes(ProcessDef def, FlowBuilder builder) {
        ActivityCollection activities = def.getActivitys();
        HashMap<String, NodeBuilder> nodes = new HashMap<String, NodeBuilder>(activities.size() * 2);
        for (int i = 0; i < activities.size(); ++i) {
            ActivityDef act = activities.get(i);
            NodeBuilder node = builder.node(act.getID(), act.getName(l));
            MicroFlowParser.setSplitMode(act, node);
            MicroFlowParser.setMergeMode(act, node);
            MicroFlowParser.otherSettings(act, node);
            nodes.put(node.getNodeId(), node);
        }
    }

    private static void otherSettings(ActivityDef act, NodeBuilder node) {
        ActivityParser p = Parsers.getParser(act);
        if (p != null) {
            p.parse(act, node);
        }
    }

    private static void setMergeMode(ActivityDef act, NodeBuilder node) {
        JoinType type = act.getActivityHeader().getJoinType();
        if (type.equals((Object)JoinType.AND)) {
            node.join();
        } else if (type.equals((Object)JoinType.OR)) {
            node.synchronization();
        } else if (!type.equals((Object)JoinType.XOR)) {
            throw new UnsupportedOperationException();
        }
    }

    private static void setSplitMode(ActivityDef act, NodeBuilder node) {
        SplitType type = act.getActivityHeader().getSplitType();
        if (type.equals((Object)SplitType.AND)) {
            node.fork();
        } else if (type.equals((Object)SplitType.OR)) {
            node.multiChoice();
        } else if (type.equals((Object)SplitType.XOR)) {
            node.exclusiveChoice();
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

